/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.compress;

import java.io.Serializable;
import java.util.Set;
import java.util.function.LongFunction;
import org.agrona.collections.Long2ObjectHashMap;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.artery.ArterySettings;
import org.apache.pekko.remote.artery.InboundContext;
import org.apache.pekko.remote.artery.OutboundContext;
import org.apache.pekko.remote.artery.RemotingFlightRecorder;
import org.apache.pekko.remote.artery.compress.InboundActorRefCompression;
import org.apache.pekko.remote.artery.compress.InboundCompressions;
import org.apache.pekko.remote.artery.compress.InboundCompressionsImpl$;
import org.apache.pekko.remote.artery.compress.InboundManifestCompression;
import org.apache.pekko.remote.artery.compress.TopHeavyHitters;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.ccompat.package;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class InboundCompressionsImpl
implements InboundCompressions {
    public final InboundContext org$apache$pekko$remote$artery$compress$InboundCompressionsImpl$$inboundContext;
    public final ArterySettings.Compression org$apache$pekko$remote$artery$compress$InboundCompressionsImpl$$settings;
    private final RemotingFlightRecorder flightRecorder;
    private final Long2ObjectHashMap<InboundActorRefCompression> _actorRefsIns;
    public final LoggingAdapter org$apache$pekko$remote$artery$compress$InboundCompressionsImpl$$_inboundActorRefsLog;
    private final LongFunction<InboundActorRefCompression> createInboundActorRefsForOrigin;
    private final Long2ObjectHashMap<InboundManifestCompression> _classManifestsIns;
    public final LoggingAdapter org$apache$pekko$remote$artery$compress$InboundCompressionsImpl$$_inboundManifestLog;
    private final LongFunction<InboundManifestCompression> createInboundManifestsForOrigin;

    public static RemotingFlightRecorder $lessinit$greater$default$4() {
        return InboundCompressionsImpl$.MODULE$.$lessinit$greater$default$4();
    }

    public InboundCompressionsImpl(ActorSystem system, InboundContext inboundContext, ArterySettings.Compression settings, RemotingFlightRecorder flightRecorder) {
        this.org$apache$pekko$remote$artery$compress$InboundCompressionsImpl$$inboundContext = inboundContext;
        this.org$apache$pekko$remote$artery$compress$InboundCompressionsImpl$$settings = settings;
        this.flightRecorder = flightRecorder;
        this._actorRefsIns = new Long2ObjectHashMap();
        this.org$apache$pekko$remote$artery$compress$InboundCompressionsImpl$$_inboundActorRefsLog = Logging$.MODULE$.apply(system, InboundActorRefCompression.class, LogSource$.MODULE$.fromAnyClass());
        this.createInboundActorRefsForOrigin = new LongFunction<InboundActorRefCompression>(this){
            private final /* synthetic */ InboundCompressionsImpl $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public InboundActorRefCompression apply(long originUid) {
                TopHeavyHitters<ActorRef> actorRefHitters = new TopHeavyHitters<ActorRef>(this.$outer.org$apache$pekko$remote$artery$compress$InboundCompressionsImpl$$settings.ActorRefs().Max(), ClassTag$.MODULE$.apply(ActorRef.class));
                return new InboundActorRefCompression(this.$outer.org$apache$pekko$remote$artery$compress$InboundCompressionsImpl$$_inboundActorRefsLog, this.$outer.org$apache$pekko$remote$artery$compress$InboundCompressionsImpl$$settings, originUid, this.$outer.org$apache$pekko$remote$artery$compress$InboundCompressionsImpl$$inboundContext, actorRefHitters);
            }
        };
        this._classManifestsIns = new Long2ObjectHashMap();
        this.org$apache$pekko$remote$artery$compress$InboundCompressionsImpl$$_inboundManifestLog = Logging$.MODULE$.apply(system, InboundManifestCompression.class, LogSource$.MODULE$.fromAnyClass());
        this.createInboundManifestsForOrigin = new LongFunction<InboundManifestCompression>(this){
            private final /* synthetic */ InboundCompressionsImpl $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public InboundManifestCompression apply(long originUid) {
                TopHeavyHitters<String> manifestHitters = new TopHeavyHitters<String>(this.$outer.org$apache$pekko$remote$artery$compress$InboundCompressionsImpl$$settings.Manifests().Max(), ClassTag$.MODULE$.apply(String.class));
                return new InboundManifestCompression(this.$outer.org$apache$pekko$remote$artery$compress$InboundCompressionsImpl$$_inboundManifestLog, this.$outer.org$apache$pekko$remote$artery$compress$InboundCompressionsImpl$$settings, originUid, this.$outer.org$apache$pekko$remote$artery$compress$InboundCompressionsImpl$$inboundContext, manifestHitters);
            }
        };
    }

    private InboundActorRefCompression actorRefsIn(long originUid) {
        return (InboundActorRefCompression)this._actorRefsIns.computeIfAbsent(originUid, this.createInboundActorRefsForOrigin);
    }

    private InboundManifestCompression classManifestsIn(long originUid) {
        return (InboundManifestCompression)this._classManifestsIns.computeIfAbsent(originUid, this.createInboundManifestsForOrigin);
    }

    @Override
    public ActorRef decompressActorRef(long originUid, byte tableVersion, int idx) {
        return this.actorRefsIn(originUid).decompress(tableVersion, idx);
    }

    @Override
    public void hitActorRef(long originUid, Address address, ActorRef ref, int n) {
        this.actorRefsIn(originUid).increment(address, ref, Int$.MODULE$.int2long(n));
    }

    @Override
    public void confirmActorRefCompressionAdvertisement(long originUid, byte tableVersion) {
        InboundActorRefCompression inboundActorRefCompression = (InboundActorRefCompression)this._actorRefsIns.get(originUid);
        if (inboundActorRefCompression == null) {
            return;
        }
        InboundActorRefCompression a = inboundActorRefCompression;
        a.confirmAdvertisement(tableVersion, false);
    }

    @Override
    public void runNextActorRefAdvertisement() {
        Long2ObjectHashMap.ValueIterator vs = this._actorRefsIns.values().iterator();
        Vector remove = package$.MODULE$.Vector().empty();
        while (vs.hasNext()) {
            OutboundContext outboundContext;
            OutboundContext a;
            InboundActorRefCompression inbound = (InboundActorRefCompression)vs.next();
            OutboundContext outboundContext2 = this.org$apache$pekko$remote$artery$compress$InboundCompressionsImpl$$inboundContext.association(inbound.originUid());
            OutboundContext outboundContext3 = (OutboundContext)OptionVal.Some$.MODULE$.unapply((Object)outboundContext2);
            if (!OptionVal$.MODULE$.isEmpty$extension((Object)outboundContext3) && !(a = (outboundContext = (OutboundContext)OptionVal$.MODULE$.get$extension((Object)outboundContext3))).associationState().isQuarantined(inbound.originUid())) {
                this.flightRecorder.compressionActorRefAdvertisement(inbound.originUid());
                inbound.runNextTableAdvertisement();
                continue;
            }
            remove = (Vector)remove.$colon$plus((Object)BoxesRunTime.boxToLong((long)inbound.originUid()));
        }
        if (remove.nonEmpty()) {
            remove.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)originUid -> this.close(originUid));
            return;
        }
    }

    @Override
    public String decompressClassManifest(long originUid, byte tableVersion, int idx) {
        return this.classManifestsIn(originUid).decompress(tableVersion, idx);
    }

    @Override
    public void hitClassManifest(long originUid, Address address, String manifest, int n) {
        this.classManifestsIn(originUid).increment(address, manifest, Int$.MODULE$.int2long(n));
    }

    @Override
    public void confirmClassManifestCompressionAdvertisement(long originUid, byte tableVersion) {
        InboundManifestCompression inboundManifestCompression = (InboundManifestCompression)this._classManifestsIns.get(originUid);
        if (inboundManifestCompression == null) {
            return;
        }
        InboundManifestCompression a = inboundManifestCompression;
        a.confirmAdvertisement(tableVersion, false);
    }

    @Override
    public void runNextClassManifestAdvertisement() {
        Long2ObjectHashMap.ValueIterator vs = this._classManifestsIns.values().iterator();
        Vector remove = package$.MODULE$.Vector().empty();
        while (vs.hasNext()) {
            OutboundContext outboundContext;
            OutboundContext a;
            InboundManifestCompression inbound = (InboundManifestCompression)vs.next();
            OutboundContext outboundContext2 = this.org$apache$pekko$remote$artery$compress$InboundCompressionsImpl$$inboundContext.association(inbound.originUid());
            OutboundContext outboundContext3 = (OutboundContext)OptionVal.Some$.MODULE$.unapply((Object)outboundContext2);
            if (!OptionVal$.MODULE$.isEmpty$extension((Object)outboundContext3) && !(a = (outboundContext = (OutboundContext)OptionVal$.MODULE$.get$extension((Object)outboundContext3))).associationState().isQuarantined(inbound.originUid())) {
                this.flightRecorder.compressionClassManifestAdvertisement(inbound.originUid());
                inbound.runNextTableAdvertisement();
                continue;
            }
            remove = (Vector)remove.$colon$plus((Object)BoxesRunTime.boxToLong((long)inbound.originUid()));
        }
        if (remove.nonEmpty()) {
            remove.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)originUid -> this.close(originUid));
            return;
        }
    }

    @Override
    public scala.collection.immutable.Set<Object> currentOriginUids() {
        scala.collection.immutable.Set result = (scala.collection.immutable.Set)Predef$.MODULE$.Set().empty().$plus$plus((IterableOnce)package.JavaConverters$.MODULE$.SetHasAsScala((Set)this._actorRefsIns.keySet()).asScala().iterator()).$plus$plus((IterableOnce)package.JavaConverters$.MODULE$.SetHasAsScala((Set)this._classManifestsIns.keySet()).asScala().iterator());
        return (scala.collection.immutable.Set)result.map((Function1 & Serializable)_$1 -> _$1);
    }

    @Override
    public void close(long originUid) {
        this._actorRefsIns.remove(originUid);
        this._classManifestsIns.remove(originUid);
    }
}

