/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.compress;

import java.io.Serializable;
import org.apache.pekko.actor.Address;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.artery.ArterySettings;
import org.apache.pekko.remote.artery.InboundContext;
import org.apache.pekko.remote.artery.OutboundContext;
import org.apache.pekko.remote.artery.compress.CompressionTable;
import org.apache.pekko.remote.artery.compress.CompressionTable$;
import org.apache.pekko.remote.artery.compress.CountMinSketch;
import org.apache.pekko.remote.artery.compress.DecompressionTable;
import org.apache.pekko.remote.artery.compress.DecompressionTable$;
import org.apache.pekko.remote.artery.compress.InboundCompression$;
import org.apache.pekko.remote.artery.compress.InboundCompression$Tables$;
import org.apache.pekko.remote.artery.compress.TopHeavyHitters;
import org.apache.pekko.remote.artery.compress.UnknownCompressedIdException;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Byte$;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class InboundCompression<T> {
    private final LoggingAdapter log;
    private final ArterySettings.Compression settings;
    private final long originUid;
    private final InboundContext inboundContext;
    private final TopHeavyHitters heavyHitters;
    private Tables<T> tables;
    private volatile boolean alive;
    private int resendCount;
    private final int maxResendCount;
    private final CountMinSketch cms;

    public static int KeepOldTablesNumber() {
        return InboundCompression$.MODULE$.KeepOldTablesNumber();
    }

    public InboundCompression(LoggingAdapter log, ArterySettings.Compression settings, long originUid, InboundContext inboundContext, TopHeavyHitters<T> heavyHitters) {
        this.log = log;
        this.settings = settings;
        this.originUid = originUid;
        this.inboundContext = inboundContext;
        this.heavyHitters = heavyHitters;
        this.tables = InboundCompression$Tables$.MODULE$.empty();
        this.alive = true;
        this.resendCount = 0;
        this.maxResendCount = 3;
        this.cms = new CountMinSketch(16, 1024, (int)System.currentTimeMillis());
        log.debug("Initializing {} for originUid [{}]", (Object)Logging$.MODULE$.simpleName(this.getClass()), (Object)BoxesRunTime.boxToLong((long)originUid));
    }

    public LoggingAdapter log() {
        return this.log;
    }

    public ArterySettings.Compression settings() {
        return this.settings;
    }

    public long originUid() {
        return this.originUid;
    }

    public TopHeavyHitters<T> heavyHitters() {
        return this.heavyHitters;
    }

    public abstract Object decompress(byte var1, int var2);

    public final Object decompressInternal(byte incomingTableVersion, int idx, int attemptCounter) {
        byte activeVersion;
        Tables<T> current;
        while (true) {
            if (attemptCounter > 2) {
                throw new IllegalStateException(new StringBuilder(52).append("Unable to decompress ").append(idx).append(" from table ").append(incomingTableVersion).append(". Internal tables: ").append(this.tables).toString());
            }
            current = this.tables;
            activeVersion = current.activeTable().version();
            if (incomingTableVersion == DecompressionTable$.MODULE$.DisabledVersion()) {
                OptionVal$.MODULE$.None();
                return null;
            }
            DecompressionTable decompressionTable = current.selectTable(Byte$.MODULE$.byte2int(incomingTableVersion));
            DecompressionTable decompressionTable2 = (DecompressionTable)OptionVal.Some$.MODULE$.unapply((Object)decompressionTable);
            if (!OptionVal$.MODULE$.isEmpty$extension((Object)decompressionTable2)) {
                DecompressionTable decompressionTable3 = (DecompressionTable)OptionVal$.MODULE$.get$extension((Object)decompressionTable2);
                DecompressionTable selectedTable = decompressionTable3;
                Object value = selectedTable.get(idx);
                if (value != null) {
                    return OptionVal.Some$.MODULE$.apply(value);
                }
                throw new UnknownCompressedIdException(Int$.MODULE$.int2long(idx));
            }
            if (!InboundCompression.incomingVersionIsAdvertisementInProgress$1(current, incomingTableVersion)) break;
            this.log().debug("Received first value from originUid [{}] compressed using the advertised compression table, flipping to it (version: {})", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)current.nextTable().version()));
            this.confirmAdvertisement(incomingTableVersion, false);
            ++attemptCounter;
        }
        this.log().warning("Inbound message from originUid [{}] is using unknown compression table version. It may have been sent with compression table built for previous incarnation of this system. Versions activeTable: {}, nextTable: {}, incomingTable: {}", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)activeVersion), (Object)BoxesRunTime.boxToByte((byte)current.nextTable().version()), (Object)BoxesRunTime.boxToByte((byte)incomingTableVersion));
        OptionVal$.MODULE$.None();
        return null;
    }

    public final void confirmAdvertisement(byte tableVersion, boolean gaveUp) {
        Option<CompressionTable<T>> option = this.tables.advertisementInProgress();
        if (option instanceof Some) {
            CompressionTable compressionTable = (CompressionTable)((Some)option).value();
            CompressionTable inProgress = compressionTable;
            if (tableVersion == inProgress.version()) {
                this.tables = this.tables.startUsingNextTable();
                this.log().debug("{} compression table version [{}] for originUid [{}]", (Object)(gaveUp ? "Gave up" : "Confirmed"), (Object)BoxesRunTime.boxToByte((byte)tableVersion), (Object)BoxesRunTime.boxToLong((long)this.originUid()));
                return;
            }
            CompressionTable inProgress2 = compressionTable;
            if (tableVersion != inProgress2.version()) {
                this.log().debug("{} compression table version [{}] for originUid [{}] but other version in progress [{}]", (Object)(gaveUp ? "Gave up" : "Confirmed"), (Object)BoxesRunTime.boxToByte((byte)tableVersion), (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)inProgress2.version()));
                return;
            }
        }
    }

    public void increment(Address remoteAddress, T value, long n) {
        long count = this.cms.addObjectAndEstimateCount(value, n);
        this.addAndCheckIfheavyHitterDetected(value, count);
        this.alive = true;
    }

    private boolean addAndCheckIfheavyHitterDetected(T value, long count) {
        return this.heavyHitters().update(value, count);
    }

    public void runNextTableAdvertisement() {
        Option<CompressionTable<T>> option = this.tables.advertisementInProgress();
        if (None$.MODULE$.equals(option)) {
            OutboundContext outboundContext = this.inboundContext.association(this.originUid());
            OutboundContext outboundContext2 = (OutboundContext)OptionVal.Some$.MODULE$.unapply((Object)outboundContext);
            if (!OptionVal$.MODULE$.isEmpty$extension((Object)outboundContext2)) {
                OutboundContext outboundContext3;
                OutboundContext association = outboundContext3 = (OutboundContext)OptionVal$.MODULE$.get$extension((Object)outboundContext2);
                if (this.alive && association.isOrdinaryMessageStreamActive()) {
                    CompressionTable<T> table = this.prepareCompressionAdvertisement(this.tables.nextTable().version());
                    Tables<T> tables = this.tables;
                    DecompressionTable<T> decompressionTable = table.invert();
                    Some some = Some$.MODULE$.apply(table);
                    List<DecompressionTable<T>> list = tables.copy$default$1();
                    DecompressionTable<T> decompressionTable2 = tables.copy$default$2();
                    int n = tables.copy$default$5();
                    Tables<T> nextState = tables.copy(list, decompressionTable2, decompressionTable, (Option<CompressionTable<T>>)some, n);
                    this.tables = nextState;
                    this.alive = false;
                    this.resendCount = 0;
                    this.advertiseCompressionTable(association, table);
                    return;
                }
                if (association.isOrdinaryMessageStreamActive()) {
                    this.log().debug("{} for originUid [{}] not changed, no need to advertise same.", (Object)Logging$.MODULE$.simpleName(this.tables.activeTable()), (Object)BoxesRunTime.boxToLong((long)this.originUid()));
                    return;
                }
                return;
            }
            this.log().debug("No Association for originUid [{}] yet, unable to advertise compression table.", (Object)BoxesRunTime.boxToLong((long)this.originUid()));
            return;
        }
        if (option instanceof Some) {
            CompressionTable inProgress = (CompressionTable)((Some)option).value();
            ++this.resendCount;
            if (this.resendCount <= this.maxResendCount) {
                OutboundContext outboundContext = this.inboundContext.association(this.originUid());
                OutboundContext outboundContext4 = (OutboundContext)OptionVal.Some$.MODULE$.unapply((Object)outboundContext);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)outboundContext4)) {
                    OutboundContext outboundContext5;
                    OutboundContext association = outboundContext5 = (OutboundContext)OptionVal$.MODULE$.get$extension((Object)outboundContext4);
                    this.log().debug("Advertisement in progress for originUid [{}] version [{}], resending [{}:{}]", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)inProgress.version()), (Object)BoxesRunTime.boxToInteger((int)this.resendCount), (Object)BoxesRunTime.boxToInteger((int)this.maxResendCount));
                    this.advertiseCompressionTable(association, inProgress);
                    return;
                }
                return;
            }
            this.log().debug("Advertisement in progress for originUid [{}] version [{}] but no confirmation after retries.", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)inProgress.version()));
            this.confirmAdvertisement(inProgress.version(), true);
            return;
        }
        throw new MatchError(option);
    }

    public abstract void advertiseCompressionTable(OutboundContext var1, CompressionTable<T> var2);

    private CompressionTable<T> prepareCompressionAdvertisement(byte nextTableVersion) {
        Map<T, Object> mappings = this.buildTableForAdvertisement(this.heavyHitters().iterator());
        return CompressionTable$.MODULE$.apply(this.originUid(), nextTableVersion, mappings);
    }

    public Map<T, Object> buildTableForAdvertisement(Iterator<T> elements) {
        Builder mb = Predef$.MODULE$.Map().newBuilder();
        mb.$plus$plus$eq((IterableOnce)elements.zipWithIndex());
        return (Map)mb.result();
    }

    public String toString() {
        return new StringBuilder(34).append(Logging$.MODULE$.simpleName(this.getClass())).append("(countMinSketch: ").append(this.cms).append(", heavyHitters: ").append(this.heavyHitters()).append(")").toString();
    }

    private static final boolean incomingVersionIsAdvertisementInProgress$1(Tables current$1, byte incomingTableVersion) {
        return current$1.advertisementInProgress().isDefined() && incomingTableVersion == ((CompressionTable)current$1.advertisementInProgress().get()).version();
    }

    public static final class Tables<T>
    implements Product,
    Serializable {
        private final List oldTables;
        private final DecompressionTable activeTable;
        private final DecompressionTable nextTable;
        private final Option advertisementInProgress;
        private final int keepOldTables;

        public static <T> Tables<T> apply(List<DecompressionTable<T>> list, DecompressionTable<T> decompressionTable, DecompressionTable<T> decompressionTable2, Option<CompressionTable<T>> option, int n) {
            return InboundCompression$Tables$.MODULE$.apply(list, decompressionTable, decompressionTable2, option, n);
        }

        public static <T> Tables<T> empty() {
            return InboundCompression$Tables$.MODULE$.empty();
        }

        public static Tables<?> fromProduct(Product product) {
            return InboundCompression$Tables$.MODULE$.fromProduct(product);
        }

        public static <T> Tables<T> unapply(Tables<T> tables) {
            return InboundCompression$Tables$.MODULE$.unapply(tables);
        }

        public Tables(List<DecompressionTable<T>> oldTables, DecompressionTable<T> activeTable, DecompressionTable<T> nextTable, Option<CompressionTable<T>> advertisementInProgress, int keepOldTables) {
            this.oldTables = oldTables;
            this.activeTable = activeTable;
            this.nextTable = nextTable;
            this.advertisementInProgress = advertisementInProgress;
            this.keepOldTables = keepOldTables;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.oldTables()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.activeTable()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.nextTable()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.advertisementInProgress()));
            n = Statics.mix((int)n, (int)this.keepOldTables());
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Tables)) return false;
            Tables tables = (Tables)object;
            if (this.keepOldTables() != tables.keepOldTables()) return false;
            List<DecompressionTable<T>> list = this.oldTables();
            List<DecompressionTable<T>> list2 = tables.oldTables();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            DecompressionTable<T> decompressionTable = this.activeTable();
            DecompressionTable<T> decompressionTable2 = tables.activeTable();
            if (decompressionTable == null) {
                if (decompressionTable2 != null) {
                    return false;
                }
            } else if (!((Object)decompressionTable).equals(decompressionTable2)) return false;
            DecompressionTable<T> decompressionTable3 = this.nextTable();
            DecompressionTable<T> decompressionTable4 = tables.nextTable();
            if (decompressionTable3 == null) {
                if (decompressionTable4 != null) {
                    return false;
                }
            } else if (!((Object)decompressionTable3).equals(decompressionTable4)) return false;
            Option<CompressionTable<T>> option = this.advertisementInProgress();
            Option<CompressionTable<T>> option2 = tables.advertisementInProgress();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Tables;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Tables";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this._5());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "oldTables";
                }
                case 1: {
                    return "activeTable";
                }
                case 2: {
                    return "nextTable";
                }
                case 3: {
                    return "advertisementInProgress";
                }
                case 4: {
                    return "keepOldTables";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<DecompressionTable<T>> oldTables() {
            return this.oldTables;
        }

        public DecompressionTable<T> activeTable() {
            return this.activeTable;
        }

        public DecompressionTable<T> nextTable() {
            return this.nextTable;
        }

        public Option<CompressionTable<T>> advertisementInProgress() {
            return this.advertisementInProgress;
        }

        public int keepOldTables() {
            return this.keepOldTables;
        }

        public DecompressionTable selectTable(int version) {
            if (this.activeTable().version() == version) {
                return (DecompressionTable)OptionVal.Some$.MODULE$.apply(this.activeTable());
            }
            DecompressionTable found = this.find$1(version, this.oldTables());
            return found;
        }

        public Tables<T> startUsingNextTable() {
            DecompressionTable decompressionTable = DecompressionTable$.MODULE$.empty();
            byte by = this.incrementTableVersion$1(this.nextTable().version());
            long l = decompressionTable.copy$default$1();
            Object object = decompressionTable.copy$default$3();
            return InboundCompression$Tables$.MODULE$.apply(this.oldTables().$colon$colon(this.activeTable()).take(this.keepOldTables()), this.nextTable(), decompressionTable.copy(l, by, object), None$.MODULE$, this.keepOldTables());
        }

        public <T> Tables<T> copy(List<DecompressionTable<T>> oldTables, DecompressionTable<T> activeTable, DecompressionTable<T> nextTable, Option<CompressionTable<T>> advertisementInProgress, int keepOldTables) {
            return new Tables<T>(oldTables, activeTable, nextTable, advertisementInProgress, keepOldTables);
        }

        public <T> List<DecompressionTable<T>> copy$default$1() {
            return this.oldTables();
        }

        public <T> DecompressionTable<T> copy$default$2() {
            return this.activeTable();
        }

        public <T> DecompressionTable<T> copy$default$3() {
            return this.nextTable();
        }

        public <T> Option<CompressionTable<T>> copy$default$4() {
            return this.advertisementInProgress();
        }

        public int copy$default$5() {
            return this.keepOldTables();
        }

        public List<DecompressionTable<T>> _1() {
            return this.oldTables();
        }

        public DecompressionTable<T> _2() {
            return this.activeTable();
        }

        public DecompressionTable<T> _3() {
            return this.nextTable();
        }

        public Option<CompressionTable<T>> _4() {
            return this.advertisementInProgress();
        }

        public int _5() {
            return this.keepOldTables();
        }

        private final DecompressionTable find$1(int version$2, List tables) {
            List list;
            while (true) {
                list = tables;
                Nil$ nil$ = package$.MODULE$.Nil();
                List list2 = list;
                if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                    OptionVal$.MODULE$.None();
                    return null;
                }
                if (!(list instanceof .colon.colon)) break;
                .colon.colon colon2 = (.colon.colon)list;
                List list3 = colon2.next$access$1();
                DecompressionTable t = (DecompressionTable)colon2.head();
                List tail = list3;
                if (t.version() == version$2) {
                    return (DecompressionTable)OptionVal.Some$.MODULE$.apply((Object)t);
                }
                tables = tail;
            }
            throw new MatchError((Object)list);
        }

        private final byte incrementTableVersion$1(byte version) {
            if (version == 127) {
                return 0;
            }
            return (byte)(version + 1);
        }
    }
}

