/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.compress;

import java.io.Serializable;
import org.apache.pekko.remote.artery.compress.CompressionTable;
import org.apache.pekko.remote.artery.compress.CompressionTable$;
import org.apache.pekko.remote.artery.compress.DecompressionTable$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class DecompressionTable<T>
implements Product,
Serializable {
    private final long originUid;
    private final byte version;
    private final Object table;
    private final int length;

    public static byte DisabledVersion() {
        return DecompressionTable$.MODULE$.DisabledVersion();
    }

    public static <T> DecompressionTable<T> apply(long l, byte by, Object object) {
        return DecompressionTable$.MODULE$.apply(l, by, object);
    }

    public static <T> DecompressionTable<T> disabled() {
        return DecompressionTable$.MODULE$.disabled();
    }

    public static <T> DecompressionTable<T> empty() {
        return DecompressionTable$.MODULE$.empty();
    }

    public static DecompressionTable<?> fromProduct(Product product) {
        return DecompressionTable$.MODULE$.fromProduct(product);
    }

    public static <T> DecompressionTable<T> unapply(DecompressionTable<T> decompressionTable) {
        return DecompressionTable$.MODULE$.unapply(decompressionTable);
    }

    public DecompressionTable(long originUid, byte version, Object table) {
        this.originUid = originUid;
        this.version = version;
        this.table = table;
        this.length = ScalaRunTime$.MODULE$.array_length(table);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.originUid()));
        n = Statics.mix((int)n, (int)this.version());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.table()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DecompressionTable)) return false;
        DecompressionTable decompressionTable = (DecompressionTable)object;
        if (this.originUid() != decompressionTable.originUid()) return false;
        if (this.version() != decompressionTable.version()) return false;
        if (!BoxesRunTime.equals((Object)this.table(), (Object)decompressionTable.table())) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof DecompressionTable;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "DecompressionTable";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToLong((long)this._1());
            }
            case 1: {
                return BoxesRunTime.boxToByte((byte)this._2());
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "originUid";
            }
            case 1: {
                return "version";
            }
            case 2: {
                return "table";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public long originUid() {
        return this.originUid;
    }

    public byte version() {
        return this.version;
    }

    public Object table() {
        return this.table;
    }

    public T get(int idx) {
        if (idx >= this.length) {
            throw new IllegalArgumentException(new StringBuilder(43).append("Attempted decompression of unknown id: [").append(idx).append("]! ").append(new StringBuilder(54).append("Only ").append(this.length).append(" ids allocated in table version [").append(this.version()).append("] for origin [").append(this.originUid()).append("].").toString()).toString());
        }
        return (T)ScalaRunTime$.MODULE$.array_apply(this.table(), idx);
    }

    public CompressionTable<T> invert() {
        Object object = Predef$.MODULE$.genericArrayOps(this.table());
        return CompressionTable$.MODULE$.apply(this.originUid(), this.version(), Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public String toString() {
        Object object = Predef$.MODULE$.genericArrayOps(this.table());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
        return new StringBuilder(23).append("DecompressionTable(").append(this.originUid()).append(", ").append(this.version()).append(", ").append(new StringBuilder(6).append("Map(").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object t = tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return new StringBuilder(4).append(i).append(" -> ").append(t).toString();
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(String.class))).mkString(",")).append("))").toString()).toString();
    }

    public <T> DecompressionTable<T> copy(long originUid, byte version, Object table) {
        return new DecompressionTable<T>(originUid, version, table);
    }

    public long copy$default$1() {
        return this.originUid();
    }

    public byte copy$default$2() {
        return this.version();
    }

    public <T> Object copy$default$3() {
        return this.table();
    }

    public long _1() {
        return this.originUid();
    }

    public byte _2() {
        return this.version();
    }

    public Object _3() {
        return this.table();
    }
}

