/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.compress;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.agrona.collections.Object2IntHashMap;
import org.apache.pekko.remote.artery.compress.CompressionTable$;
import org.apache.pekko.remote.artery.compress.DecompressionTable;
import org.apache.pekko.remote.artery.compress.DecompressionTable$;
import org.apache.pekko.util.HashCode$;
import org.apache.pekko.util.ccompat.package;
import scala.;
import scala.$less$colon$less$;
import scala.Byte$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class CompressionTable<T> {
    private final long originUid;
    private final byte version;
    private final Object2IntHashMap _dictionary;

    public static Comparator<Tuple2<Object, Object>> CompareBy2ndValue() {
        return CompressionTable$.MODULE$.CompareBy2ndValue();
    }

    public static int NotCompressedId() {
        return CompressionTable$.MODULE$.NotCompressedId();
    }

    public static <T> CompressionTable<T> apply(long l, byte by, Map<T, Object> map) {
        return CompressionTable$.MODULE$.apply(l, by, map);
    }

    public static <T> Comparator<Tuple2<T, Object>> compareBy2ndValue() {
        return CompressionTable$.MODULE$.compareBy2ndValue();
    }

    public static <T> CompressionTable<T> empty() {
        return CompressionTable$.MODULE$.empty();
    }

    public CompressionTable(long originUid, byte version, Object2IntHashMap<T> _dictionary) {
        this.originUid = originUid;
        this.version = version;
        this._dictionary = _dictionary;
    }

    public long originUid() {
        return this.originUid;
    }

    public byte version() {
        return this.version;
    }

    private Object2IntHashMap<T> _dictionary() {
        return this._dictionary;
    }

    public Map<T, Object> dictionary() {
        return package.JavaConverters$.MODULE$.IteratorHasAsScala((Iterator)this._dictionary().entrySet().iterator()).asScala().map((Function1 & Serializable)entry -> {
            Object object = Predef$.MODULE$.ArrowAssoc(entry.getKey());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)BoxesRunTime.boxToInteger((int)((Integer)entry.getValue())));
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public int compress(T value) {
        return this._dictionary().getValue(value);
    }

    public DecompressionTable<T> invert() {
        int i;
        if (this._dictionary().isEmpty()) {
            DecompressionTable decompressionTable = DecompressionTable$.MODULE$.empty();
            return decompressionTable.copy(this.originUid(), this.version(), decompressionTable.copy$default$3());
        }
        Integer expectedGaplessSum = this._dictionary().size() * (this._dictionary().size() + 1) / 2;
        Predef$.MODULE$.require(BoxesRunTime.equals((Object)package.JavaConverters$.MODULE$.IteratorHasAsScala((Iterator)this._dictionary().values().iterator()).asScala().min(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())), (Object)BoxesRunTime.boxToInteger((int)0)), this::invert$$anonfun$1);
        Predef$.MODULE$.require(BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)package.JavaConverters$.MODULE$.IteratorHasAsScala((Iterator)this._dictionary().values().iterator()).asScala().map((Function1 & Serializable)_$1 -> _$1).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + this._dictionary().size())), (Object)expectedGaplessSum), this::invert$$anonfun$3);
        Tuple2[] tups = new Tuple2[this._dictionary().size()];
        Object[] ts = new Object[this._dictionary().size()];
        Object2IntHashMap.EntryIterator mit = this._dictionary().entrySet().iterator();
        for (i = 0; i < tups.length; ++i) {
            Map.Entry entry = mit.next();
            Object object = Predef$.MODULE$.ArrowAssoc(entry.getKey());
            tups[i] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)BoxesRunTime.boxToInteger((int)((Integer)entry.getValue())));
        }
        Arrays.sort(tups, CompressionTable$.MODULE$.compareBy2ndValue());
        for (i = 0; i < tups.length; ++i) {
            ScalaRunTime$.MODULE$.array_update((Object)ts, i, tups[i]._1());
        }
        return DecompressionTable$.MODULE$.apply(this.originUid(), this.version(), ts);
    }

    public String toString() {
        return new StringBuilder(20).append("CompressionTable(").append(this.originUid()).append(",").append(this.version()).append(",").append(this.dictionary()).append(")").toString();
    }

    public int hashCode() {
        int result = HashCode$.MODULE$.SEED();
        result = HashCode$.MODULE$.hash(result, this.originUid());
        result = HashCode$.MODULE$.hash(result, Byte$.MODULE$.byte2int(this.version()));
        result = HashCode$.MODULE$.hash(result, this._dictionary());
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof CompressionTable)) return false;
        CompressionTable other = (CompressionTable)object;
        if (this.originUid() != other.originUid()) return false;
        if (this.version() != other.version()) return false;
        Object2IntHashMap<T> object2IntHashMap = this._dictionary();
        Object2IntHashMap<T> object2IntHashMap2 = other._dictionary();
        if (object2IntHashMap != null) {
            if (!object2IntHashMap.equals(object2IntHashMap2)) return false;
            return true;
        }
        if (object2IntHashMap2 == null) return true;
        return false;
    }

    private final Object invert$$anonfun$1() {
        return new StringBuilder(78).append("Compression table should start allocating from 0, yet lowest allocated id was ").append(package.JavaConverters$.MODULE$.IteratorHasAsScala((Iterator)this._dictionary().values().iterator()).asScala().min(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).toString();
    }

    private final Object invert$$anonfun$3() {
        return new StringBuilder(149).append("Given compression map does not seem to be gap-less and starting from zero, which makes compressing it into an Array difficult, bailing out! Map was: ").append(this._dictionary()).toString();
    }
}

