/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayDeque;
import org.apache.pekko.Done;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Address;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.UniqueAddress;
import org.apache.pekko.remote.artery.ArteryMessage;
import org.apache.pekko.remote.artery.InboundEnvelope;
import org.apache.pekko.remote.artery.OutboundContext;
import org.apache.pekko.remote.artery.OutboundEnvelope;
import org.apache.pekko.remote.artery.OutboundHandshake;
import org.apache.pekko.remote.artery.Reply;
import org.apache.pekko.remote.artery.SystemMessageDelivery$Ack$;
import org.apache.pekko.remote.artery.SystemMessageDelivery$ClearSystemMessageDelivery$;
import org.apache.pekko.remote.artery.SystemMessageDelivery$Nack$;
import org.apache.pekko.remote.artery.SystemMessageDelivery$ResendTick$;
import org.apache.pekko.remote.artery.SystemMessageDelivery$SystemMessageEnvelope$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.StageLogging;
import org.apache.pekko.util.PrettyDuration;
import org.apache.pekko.util.PrettyDuration$;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NoStackTrace;

@InternalApi
public class SystemMessageDelivery
extends GraphStage<FlowShape<OutboundEnvelope, OutboundEnvelope>> {
    public final OutboundContext org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext;
    public final ActorRef org$apache$pekko$remote$artery$SystemMessageDelivery$$deadLetters;
    public final FiniteDuration org$apache$pekko$remote$artery$SystemMessageDelivery$$resendInterval;
    public final int org$apache$pekko$remote$artery$SystemMessageDelivery$$maxBufferSize;
    private final Inlet in;
    private final Outlet out;
    private final FlowShape shape;

    public SystemMessageDelivery(OutboundContext outboundContext, ActorRef deadLetters, FiniteDuration resendInterval, int maxBufferSize) {
        this.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext = outboundContext;
        this.org$apache$pekko$remote$artery$SystemMessageDelivery$$deadLetters = deadLetters;
        this.org$apache$pekko$remote$artery$SystemMessageDelivery$$resendInterval = resendInterval;
        this.org$apache$pekko$remote$artery$SystemMessageDelivery$$maxBufferSize = maxBufferSize;
        this.in = Inlet$.MODULE$.apply("SystemMessageDelivery.in");
        this.out = Outlet$.MODULE$.apply("SystemMessageDelivery.out");
        this.shape = FlowShape$.MODULE$.apply(this.in(), this.out());
    }

    public Inlet<OutboundEnvelope> in() {
        return this.in;
    }

    public Outlet<OutboundEnvelope> out() {
        return this.out;
    }

    public FlowShape<OutboundEnvelope, OutboundEnvelope> shape() {
        return this.shape;
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this){
            private LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log;
            private boolean replyObserverAttached;
            private long seqNo;
            private int incarnation;
            private final ArrayDeque unacknowledged;
            private ArrayDeque resending;
            private boolean stopping;
            private final long giveUpAfterNanos;
            private long ackTimestamp;
            private final AsyncCallback ackCallback;
            private final AsyncCallback nackCallback;
            private final /* synthetic */ SystemMessageDelivery $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                StageLogging.$init$((StageLogging)this);
                this.replyObserverAttached = false;
                this.seqNo = 0L;
                this.incarnation = $outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.associationState().incarnation();
                this.unacknowledged = new ArrayDeque<E>();
                this.resending = new ArrayDeque<E>();
                this.stopping = false;
                this.giveUpAfterNanos = $outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.settings().Advanced().GiveUpSystemMessageAfter().toNanos();
                this.ackTimestamp = System.nanoTime();
                this.ackCallback = this.getAsyncCallback((Function1)(JProcedure1 & Serializable)reply -> this.ack(reply.seqNo()));
                this.nackCallback = this.getAsyncCallback((Function1)(JProcedure1 & Serializable)reply -> {
                    if (reply.seqNo() <= this.seqNo) {
                        this.ack(reply.seqNo());
                        this.log().warning("Received negative acknowledgement of system message from [{}], highest acknowledged [{}]", (Object)$outer$1.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.remoteAddress(), (Object)BoxesRunTime.boxToLong((long)reply.seqNo()));
                        return;
                    }
                });
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            public LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log() {
                return this.org$apache$pekko$stream$stage$StageLogging$$_log;
            }

            public void org$apache$pekko$stream$stage$StageLogging$$_log_$eq(LoggingAdapter x$1) {
                this.org$apache$pekko$stream$stage$StageLogging$$_log = x$1;
            }

            private UniqueAddress localAddress() {
                return this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.localAddress();
            }

            private Address remoteAddress() {
                return this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.remoteAddress();
            }

            private String remoteAddressLogParam() {
                return this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.associationState().uniqueRemoteAddress().getOrElse(this::remoteAddressLogParam$$anonfun$1).toString();
            }

            public Class logSource() {
                return SystemMessageDelivery.class;
            }

            public void preStart() {
                AsyncCallback callback = this.getAsyncCallback((Function1)(JProcedure1 & Serializable)_$1 -> {
                    this.replyObserverAttached = true;
                    if (this.isAvailable(this.$outer.out())) {
                        this.pull(this.$outer.in());
                        return;
                    }
                });
                this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.controlSubject().attach(this).foreach((Function1)((JProcedure1 & Serializable)arg_0 -> SystemMessageDelivery.org$apache$pekko$remote$artery$SystemMessageDelivery$$anon$1$$_$preStart$$anonfun$1(callback, arg_0)), ExecutionContexts$.MODULE$.parasitic());
            }

            public void postStop() {
                int pendingCount = this.unacknowledged.size();
                this.sendUnacknowledgedToDeadLetters();
                this.unacknowledged.clear();
                if (pendingCount > 0) {
                    this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.quarantine(new StringBuilder(62).append("SystemMessageDelivery stopped with [").append(pendingCount).append("] pending system messages.").toString());
                }
                this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.controlSubject().detach(this);
            }

            public void onUpstreamFinish() {
                if (this.unacknowledged.isEmpty()) {
                    InHandler.onUpstreamFinish$((InHandler)this);
                    return;
                }
                this.stopping = true;
            }

            public void onTimer(Object timerKey) {
                Object object = timerKey;
                if (SystemMessageDelivery$ResendTick$.MODULE$.equals(object)) {
                    this.checkGiveUp();
                    if (this.resending.isEmpty() && !this.unacknowledged.isEmpty()) {
                        this.resending = this.unacknowledged.clone();
                        this.tryResend();
                    }
                    if (!this.unacknowledged.isEmpty()) {
                        this.scheduleOnce(SystemMessageDelivery$ResendTick$.MODULE$, this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$resendInterval);
                        return;
                    }
                    return;
                }
                Object other = object;
                throw new IllegalArgumentException(new StringBuilder(19).append("Unknown timer key: ").append(other).toString());
            }

            public void notify(InboundEnvelope inboundEnvelope) {
                Object object = inboundEnvelope.message();
                if (object instanceof Ack) {
                    Ack ack = (Ack)object;
                    Address address = ack.from().address();
                    Address address2 = this.remoteAddress();
                    if (!(address != null ? !address.equals(address2) : address2 != null)) {
                        this.ackCallback.invoke((Object)ack);
                        return;
                    }
                    return;
                }
                if (object instanceof Nack) {
                    Nack nack = (Nack)object;
                    Address address = nack.from().address();
                    Address address3 = this.remoteAddress();
                    if (!(address != null ? !address.equals(address3) : address3 != null)) {
                        this.nackCallback.invoke((Object)nack);
                        return;
                    }
                    return;
                }
            }

            public void controlSubjectCompleted(Try signal) {
                this.getAsyncCallback((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Try try_ = x$1;
                    if (try_ instanceof Success) {
                        this.completeStage();
                        return;
                    }
                    if (try_ instanceof Failure) {
                        Throwable cause = ((Failure)try_).exception();
                        this.failStage(cause);
                        return;
                    }
                    throw new MatchError((Object)try_);
                }).invoke((Object)signal);
            }

            private void ack(long n) {
                this.ackTimestamp = System.nanoTime();
                if (n <= this.seqNo) {
                    this.clearUnacknowledged(n);
                    return;
                }
            }

            private void clearUnacknowledged(long ackedSeqNo) {
                while (!this.unacknowledged.isEmpty() && ((SystemMessageEnvelope)((OutboundEnvelope)this.unacknowledged.peek()).message()).seqNo() <= ackedSeqNo) {
                    this.unacknowledged.removeFirst();
                    if (this.unacknowledged.isEmpty()) {
                        this.cancelTimer(this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$resendInterval);
                    }
                    if (!this.stopping || !this.unacknowledged.isEmpty()) continue;
                    this.completeStage();
                    return;
                }
            }

            private void tryResend() {
                if (this.isAvailable(this.$outer.out()) && !this.resending.isEmpty()) {
                    OutboundEnvelope env = (OutboundEnvelope)this.resending.poll();
                    if (this.log().isDebugEnabled()) {
                        Object object = env.message();
                        if (object instanceof SystemMessageEnvelope) {
                            SystemMessageEnvelope systemMessageEnvelope = SystemMessageDelivery$SystemMessageEnvelope$.MODULE$.unapply((SystemMessageEnvelope)object);
                            Object object2 = systemMessageEnvelope._1();
                            long l = systemMessageEnvelope._2();
                            UniqueAddress uniqueAddress = systemMessageEnvelope._3();
                            Object msg = object2;
                            long n = l;
                            this.log().debug("Resending system message [{}] [{}]", (Object)Logging$.MODULE$.simpleName(msg), (Object)BoxesRunTime.boxToLong((long)n));
                        } else {
                            this.log().debug("Resending control message [{}]", (Object)Logging$.MODULE$.simpleName(env.message()));
                        }
                    }
                    if (this.incarnation != this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.associationState().incarnation()) {
                        this.log().debug("Noticed new incarnation of [{}] from tryResend, clear state", (Object)this.remoteAddressLogParam());
                        this.clear();
                    }
                    this.pushCopy(env);
                    return;
                }
            }

            private void pushCopy(OutboundEnvelope outboundEnvelope) {
                this.push(this.$outer.out(), outboundEnvelope.copy());
            }

            public void onPush() {
                OutboundEnvelope outboundEnvelope = (OutboundEnvelope)this.grab(this.$outer.in());
                Object object = outboundEnvelope.message();
                if (object instanceof SystemMessage || object instanceof AckedDeliveryMessage) {
                    Object msg = object;
                    if (this.unacknowledged.size() < this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$maxBufferSize) {
                        if (this.seqNo == 0L) {
                            this.incarnation = this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.associationState().incarnation();
                        } else if (this.incarnation != this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.associationState().incarnation()) {
                            this.log().debug("Noticed new incarnation of [{}] from onPush, clear state", (Object)this.remoteAddressLogParam());
                            this.clear();
                        }
                        ++this.seqNo;
                        if (this.unacknowledged.isEmpty()) {
                            this.ackTimestamp = System.nanoTime();
                        } else {
                            this.checkGiveUp();
                        }
                        OutboundEnvelope sendEnvelope = outboundEnvelope.withMessage(SystemMessageDelivery$SystemMessageEnvelope$.MODULE$.apply(msg, this.seqNo, this.localAddress()));
                        this.unacknowledged.offer(sendEnvelope);
                        this.scheduleOnce(SystemMessageDelivery$ResendTick$.MODULE$, this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$resendInterval);
                        if (this.resending.isEmpty() && this.isAvailable(this.$outer.out())) {
                            this.pushCopy(sendEnvelope);
                            return;
                        }
                        this.resending.offer(sendEnvelope);
                        this.tryResend();
                        return;
                    }
                    this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.quarantine(new StringBuilder(48).append("System message delivery buffer overflow, size [").append(this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$maxBufferSize).append("]").toString());
                    this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$deadLetters.$bang((Object)outboundEnvelope, this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$deadLetters.$bang$default$2((Object)outboundEnvelope));
                    this.pull(this.$outer.in());
                    return;
                }
                if (object instanceof OutboundHandshake.HandshakeReq) {
                    if (this.isAvailable(this.$outer.out())) {
                        this.pushCopy(outboundEnvelope);
                        return;
                    }
                    return;
                }
                if (object instanceof ClearSystemMessageDelivery) {
                    ClearSystemMessageDelivery clearSystemMessageDelivery = SystemMessageDelivery$ClearSystemMessageDelivery$.MODULE$.unapply((ClearSystemMessageDelivery)object);
                    int n = clearSystemMessageDelivery._1();
                    int i = n;
                    if (i <= this.incarnation) {
                        this.log().debug("Clear system message delivery of [{}]", (Object)this.remoteAddressLogParam());
                        this.clear();
                    }
                    this.pull(this.$outer.in());
                    return;
                }
                if (this.resending.isEmpty() && this.isAvailable(this.$outer.out())) {
                    this.push(this.$outer.out(), outboundEnvelope);
                    return;
                }
                this.resending.offer(outboundEnvelope);
                this.tryResend();
            }

            private void checkGiveUp() {
                if (!this.unacknowledged.isEmpty() && System.nanoTime() - this.ackTimestamp > this.giveUpAfterNanos) {
                    throw new GaveUpSystemMessageException(new StringBuilder(43).append("Gave up sending system message to [").append(this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.remoteAddress()).append("] after ").append(new StringBuilder(1).append(PrettyDuration.PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.settings().Advanced().GiveUpSystemMessageAfter()))).append(".").toString()).toString());
                }
            }

            private void clear() {
                this.sendUnacknowledgedToDeadLetters();
                this.seqNo = 0L;
                this.incarnation = this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$outboundContext.associationState().incarnation();
                this.unacknowledged.clear();
                this.resending.clear();
                this.cancelTimer(this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$resendInterval);
            }

            private void sendUnacknowledgedToDeadLetters() {
                for (OutboundEnvelope outboundEnvelope : this.unacknowledged) {
                    this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$deadLetters.$bang((Object)outboundEnvelope, this.$outer.org$apache$pekko$remote$artery$SystemMessageDelivery$$deadLetters.$bang$default$2((Object)outboundEnvelope));
                }
            }

            public void onPull() {
                if (this.replyObserverAttached) {
                    if (this.resending.isEmpty() && !this.hasBeenPulled(this.$outer.in()) && !this.stopping) {
                        this.pull(this.$outer.in());
                        return;
                    }
                    this.tryResend();
                    return;
                }
            }

            private final Serializable remoteAddressLogParam$$anonfun$1() {
                return this.remoteAddress();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$1(org.apache.pekko.remote.artery.SystemMessageDelivery$Ack ), $init$$$anonfun$2(org.apache.pekko.remote.artery.SystemMessageDelivery org.apache.pekko.remote.artery.SystemMessageDelivery$Nack ), remoteAddressLogParam$$anonfun$1(), $anonfun$1(org.apache.pekko.Done ), org$apache$pekko$remote$artery$SystemMessageDelivery$$anon$1$$_$preStart$$anonfun$1(org.apache.pekko.stream.stage.AsyncCallback org.apache.pekko.Done ), controlSubjectCompleted$$anonfun$1(scala.util.Try )}, serializedLambda);
            }
        };
    }

    public static final /* synthetic */ void org$apache$pekko$remote$artery$SystemMessageDelivery$$anon$1$$_$preStart$$anonfun$1(AsyncCallback callback$1, Done t) {
        callback$1.invoke((Object)t);
    }

    public static final class Ack
    implements Reply,
    Product {
        private final long seqNo;
        private final UniqueAddress from;

        public static Ack apply(long l, UniqueAddress uniqueAddress) {
            return SystemMessageDelivery$Ack$.MODULE$.apply(l, uniqueAddress);
        }

        public static Ack fromProduct(Product product) {
            return SystemMessageDelivery$Ack$.MODULE$.fromProduct(product);
        }

        public static Ack unapply(Ack ack) {
            return SystemMessageDelivery$Ack$.MODULE$.unapply(ack);
        }

        public Ack(long seqNo, UniqueAddress from) {
            this.seqNo = seqNo;
            this.from = from;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.seqNo()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.from()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Ack)) return false;
            Ack ack = (Ack)object;
            if (this.seqNo() != ack.seqNo()) return false;
            UniqueAddress uniqueAddress = this.from();
            UniqueAddress uniqueAddress2 = ack.from();
            if (uniqueAddress != null) {
                if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                return true;
            }
            if (uniqueAddress2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Ack;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Ack";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToLong((long)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "seqNo";
            }
            if (1 == n2) {
                return "from";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long seqNo() {
            return this.seqNo;
        }

        public UniqueAddress from() {
            return this.from;
        }

        public Ack copy(long seqNo, UniqueAddress from) {
            return new Ack(seqNo, from);
        }

        public long copy$default$1() {
            return this.seqNo();
        }

        public UniqueAddress copy$default$2() {
            return this.from();
        }

        public long _1() {
            return this.seqNo();
        }

        public UniqueAddress _2() {
            return this.from();
        }
    }

    public static interface AckedDeliveryMessage {
    }

    public static final class ClearSystemMessageDelivery
    implements Product,
    Serializable {
        private final int incarnation;

        public static ClearSystemMessageDelivery apply(int n) {
            return SystemMessageDelivery$ClearSystemMessageDelivery$.MODULE$.apply(n);
        }

        public static ClearSystemMessageDelivery fromProduct(Product product) {
            return SystemMessageDelivery$ClearSystemMessageDelivery$.MODULE$.fromProduct(product);
        }

        public static ClearSystemMessageDelivery unapply(ClearSystemMessageDelivery clearSystemMessageDelivery) {
            return SystemMessageDelivery$ClearSystemMessageDelivery$.MODULE$.unapply(clearSystemMessageDelivery);
        }

        public ClearSystemMessageDelivery(int incarnation) {
            this.incarnation = incarnation;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.incarnation());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ClearSystemMessageDelivery)) return false;
            ClearSystemMessageDelivery clearSystemMessageDelivery = (ClearSystemMessageDelivery)object;
            if (this.incarnation() != clearSystemMessageDelivery.incarnation()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ClearSystemMessageDelivery;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ClearSystemMessageDelivery";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "incarnation";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int incarnation() {
            return this.incarnation;
        }

        public ClearSystemMessageDelivery copy(int incarnation) {
            return new ClearSystemMessageDelivery(incarnation);
        }

        public int copy$default$1() {
            return this.incarnation();
        }

        public int _1() {
            return this.incarnation();
        }
    }

    public static final class GaveUpSystemMessageException
    extends RuntimeException
    implements NoStackTrace {
        public GaveUpSystemMessageException(String msg) {
            super(msg);
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }
    }

    public static final class Nack
    implements Reply,
    Product {
        private final long seqNo;
        private final UniqueAddress from;

        public static Nack apply(long l, UniqueAddress uniqueAddress) {
            return SystemMessageDelivery$Nack$.MODULE$.apply(l, uniqueAddress);
        }

        public static Nack fromProduct(Product product) {
            return SystemMessageDelivery$Nack$.MODULE$.fromProduct(product);
        }

        public static Nack unapply(Nack nack) {
            return SystemMessageDelivery$Nack$.MODULE$.unapply(nack);
        }

        public Nack(long seqNo, UniqueAddress from) {
            this.seqNo = seqNo;
            this.from = from;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.seqNo()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.from()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Nack)) return false;
            Nack nack = (Nack)object;
            if (this.seqNo() != nack.seqNo()) return false;
            UniqueAddress uniqueAddress = this.from();
            UniqueAddress uniqueAddress2 = nack.from();
            if (uniqueAddress != null) {
                if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                return true;
            }
            if (uniqueAddress2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Nack;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Nack";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToLong((long)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "seqNo";
            }
            if (1 == n2) {
                return "from";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long seqNo() {
            return this.seqNo;
        }

        public UniqueAddress from() {
            return this.from;
        }

        public Nack copy(long seqNo, UniqueAddress from) {
            return new Nack(seqNo, from);
        }

        public long copy$default$1() {
            return this.seqNo();
        }

        public UniqueAddress copy$default$2() {
            return this.from();
        }

        public long _1() {
            return this.seqNo();
        }

        public UniqueAddress _2() {
            return this.from();
        }
    }

    public static final class SystemMessageEnvelope
    implements ArteryMessage,
    Product {
        private final Object message;
        private final long seqNo;
        private final UniqueAddress ackReplyTo;

        public static SystemMessageEnvelope apply(Object object, long l, UniqueAddress uniqueAddress) {
            return SystemMessageDelivery$SystemMessageEnvelope$.MODULE$.apply(object, l, uniqueAddress);
        }

        public static SystemMessageEnvelope fromProduct(Product product) {
            return SystemMessageDelivery$SystemMessageEnvelope$.MODULE$.fromProduct(product);
        }

        public static SystemMessageEnvelope unapply(SystemMessageEnvelope systemMessageEnvelope) {
            return SystemMessageDelivery$SystemMessageEnvelope$.MODULE$.unapply(systemMessageEnvelope);
        }

        public SystemMessageEnvelope(Object message, long seqNo, UniqueAddress ackReplyTo) {
            this.message = message;
            this.seqNo = seqNo;
            this.ackReplyTo = ackReplyTo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.message()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.seqNo()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.ackReplyTo()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SystemMessageEnvelope)) return false;
            SystemMessageEnvelope systemMessageEnvelope = (SystemMessageEnvelope)object;
            if (this.seqNo() != systemMessageEnvelope.seqNo()) return false;
            if (!BoxesRunTime.equals((Object)this.message(), (Object)systemMessageEnvelope.message())) return false;
            UniqueAddress uniqueAddress = this.ackReplyTo();
            UniqueAddress uniqueAddress2 = systemMessageEnvelope.ackReplyTo();
            if (uniqueAddress != null) {
                if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                return true;
            }
            if (uniqueAddress2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SystemMessageEnvelope;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "SystemMessageEnvelope";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "message";
                }
                case 1: {
                    return "seqNo";
                }
                case 2: {
                    return "ackReplyTo";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Object message() {
            return this.message;
        }

        public long seqNo() {
            return this.seqNo;
        }

        public UniqueAddress ackReplyTo() {
            return this.ackReplyTo;
        }

        public SystemMessageEnvelope copy(Object message, long seqNo, UniqueAddress ackReplyTo) {
            return new SystemMessageEnvelope(message, seqNo, ackReplyTo);
        }

        public Object copy$default$1() {
            return this.message();
        }

        public long copy$default$2() {
            return this.seqNo();
        }

        public UniqueAddress copy$default$3() {
            return this.ackReplyTo();
        }

        public Object _1() {
            return this.message();
        }

        public long _2() {
            return this.seqNo();
        }

        public UniqueAddress _3() {
            return this.ackReplyTo();
        }
    }
}

