/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.Address;
import org.apache.pekko.remote.artery.TestState;
import org.apache.pekko.remote.artery.TestState$;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter$Direction$Both$;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter$Direction$Receive$;
import org.apache.pekko.remote.transport.ThrottlerTransportAdapter$Direction$Send$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.ScalaRunTime$;

public class SharedTestState {
    private final AtomicReference<TestState> state = new AtomicReference<TestState>(TestState$.MODULE$.apply((Map<Address, Set<Address>>)Predef$.MODULE$.Map().empty(), (Option<Throwable>)None$.MODULE$));

    public boolean anyBlackholePresent() {
        return this.state.get().blackholes().nonEmpty();
    }

    public boolean isBlackhole(Address from, Address to) {
        Option option = this.state.get().blackholes().get((Object)from);
        if (option instanceof Some) {
            Set destinations = (Set)((Some)option).value();
            return destinations.apply((Object)to);
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    public void blackhole(Address a, Address b, ThrottlerTransportAdapter.Direction direction) {
        ThrottlerTransportAdapter.Direction direction2 = direction;
        if (ThrottlerTransportAdapter$Direction$Send$.MODULE$.equals(direction2)) {
            this.addBlackhole(a, b);
            return;
        }
        if (ThrottlerTransportAdapter$Direction$Receive$.MODULE$.equals(direction2)) {
            this.addBlackhole(b, a);
            return;
        }
        if (ThrottlerTransportAdapter$Direction$Both$.MODULE$.equals(direction2)) {
            this.addBlackhole(a, b);
            this.addBlackhole(b, a);
            return;
        }
        throw new MatchError((Object)direction2);
    }

    public final void failInboundStreamOnce(Throwable ex) {
        Some some;
        Map<Address, Set<Address>> map;
        TestState current;
        do {
            current = this.state.get();
            some = Some$.MODULE$.apply((Object)ex);
        } while (!this.state.compareAndSet(current, current.copy(map = current.copy$default$1(), (Option<Throwable>)some)));
    }

    public final Option<Throwable> getInboundFailureOnce() {
        None$ none$;
        Map<Address, Set<Address>> map;
        TestState current;
        do {
            current = this.state.get();
            none$ = None$.MODULE$;
        } while (!this.state.compareAndSet(current, current.copy(map = current.copy$default$1(), (Option<Throwable>)none$)));
        return current.failInboundStream();
    }

    private void addBlackhole(Address from, Address to) {
        TestState newState;
        TestState current;
        do {
            TestState testState;
            Option option;
            if ((option = (current = this.state.get()).blackholes().get((Object)from)) instanceof Some) {
                Set destinations = (Set)((Some)option).value();
                testState = current.copy((Map<Address, Set<Address>>)((Map)current.blackholes().updated((Object)from, (Object)destinations.$plus((Object)to))), current.copy$default$2());
            } else if (None$.MODULE$.equals(option)) {
                testState = current.copy((Map<Address, Set<Address>>)((Map)current.blackholes().updated((Object)from, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Address[]{to})))), current.copy$default$2());
            } else {
                throw new MatchError((Object)option);
            }
            newState = testState;
        } while (!this.state.compareAndSet(current, newState));
    }

    public void passThrough(Address a, Address b, ThrottlerTransportAdapter.Direction direction) {
        ThrottlerTransportAdapter.Direction direction2 = direction;
        if (ThrottlerTransportAdapter$Direction$Send$.MODULE$.equals(direction2)) {
            this.removeBlackhole(a, b);
            return;
        }
        if (ThrottlerTransportAdapter$Direction$Receive$.MODULE$.equals(direction2)) {
            this.removeBlackhole(b, a);
            return;
        }
        if (ThrottlerTransportAdapter$Direction$Both$.MODULE$.equals(direction2)) {
            this.removeBlackhole(a, b);
            this.removeBlackhole(b, a);
            return;
        }
        throw new MatchError((Object)direction2);
    }

    private void removeBlackhole(Address from, Address to) {
        TestState newState;
        TestState current;
        do {
            TestState testState;
            Option option;
            if ((option = (current = this.state.get()).blackholes().get((Object)from)) instanceof Some) {
                Set destinations = (Set)((Some)option).value();
                testState = current.copy((Map<Address, Set<Address>>)((Map)current.blackholes().updated((Object)from, (Object)destinations.$minus((Object)to))), current.copy$default$2());
            } else if (None$.MODULE$.equals(option)) {
                testState = current;
            } else {
                throw new MatchError((Object)option);
            }
            newState = testState;
        } while (!this.state.compareAndSet(current, newState));
    }
}

