/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.remote.artery.ByteFlag$;
import org.apache.pekko.remote.artery.EnvelopeBuffer;
import org.apache.pekko.remote.artery.InboundEnvelope;
import org.apache.pekko.remote.artery.ObjectPool;
import org.apache.pekko.remote.artery.OutboundContext;
import org.apache.pekko.remote.artery.ReusableInboundEnvelope$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;

public final class ReusableInboundEnvelope
implements InboundEnvelope {
    private InternalActorRef _recipient;
    private ActorRef _sender;
    private long _originUid;
    private OutboundContext _association;
    private int _serializer;
    private String _classManifest;
    private byte _flags;
    private int _lane;
    private Object _message;
    private EnvelopeBuffer _envelopeBuffer;

    public static ObjectPool<ReusableInboundEnvelope> createObjectPool(int n) {
        return ReusableInboundEnvelope$.MODULE$.createObjectPool(n);
    }

    public ReusableInboundEnvelope() {
        OptionVal$.MODULE$.None();
        this._recipient = null;
        OptionVal$.MODULE$.None();
        this._sender = null;
        this._originUid = 0L;
        OptionVal$.MODULE$.None();
        this._association = null;
        this._serializer = -1;
        this._classManifest = null;
        this._flags = 0;
        this._lane = 0;
        this._message = null;
        this._envelopeBuffer = null;
    }

    @Override
    public InternalActorRef recipient() {
        return this._recipient;
    }

    @Override
    public ActorRef sender() {
        return this._sender;
    }

    @Override
    public long originUid() {
        return this._originUid;
    }

    @Override
    public OutboundContext association() {
        return this._association;
    }

    @Override
    public int serializer() {
        return this._serializer;
    }

    @Override
    public String classManifest() {
        return this._classManifest;
    }

    @Override
    public Object message() {
        return this._message;
    }

    @Override
    public EnvelopeBuffer envelopeBuffer() {
        return this._envelopeBuffer;
    }

    @Override
    public byte flags() {
        return this._flags;
    }

    @Override
    public boolean flag(byte byteFlag) {
        return ByteFlag$.MODULE$.isEnabled$extension(byteFlag, this._flags);
    }

    @Override
    public int lane() {
        return this._lane;
    }

    @Override
    public InboundEnvelope withMessage(Object message) {
        this._message = message;
        return this;
    }

    @Override
    public InboundEnvelope releaseEnvelopeBuffer() {
        this._envelopeBuffer = null;
        return this;
    }

    @Override
    public InboundEnvelope withRecipient(InternalActorRef ref) {
        this._recipient = (InternalActorRef)OptionVal$.MODULE$.apply((Object)ref);
        return this;
    }

    public void clear() {
        OptionVal$.MODULE$.None();
        this._recipient = null;
        this._message = null;
        OptionVal$.MODULE$.None();
        this._sender = null;
        this._originUid = 0L;
        OptionVal$.MODULE$.None();
        this._association = null;
        this._lane = 0;
    }

    public InboundEnvelope init(InternalActorRef recipient, ActorRef sender, long originUid, int serializer, String classManifest, byte flags, EnvelopeBuffer envelopeBuffer, OutboundContext association, int lane) {
        this._recipient = recipient;
        this._sender = sender;
        this._originUid = originUid;
        this._serializer = serializer;
        this._classManifest = classManifest;
        this._flags = flags;
        this._envelopeBuffer = envelopeBuffer;
        this._association = association;
        this._lane = lane;
        return this;
    }

    public InboundEnvelope withEnvelopeBuffer(EnvelopeBuffer envelopeBuffer) {
        this._envelopeBuffer = envelopeBuffer;
        return this;
    }

    @Override
    public InboundEnvelope copyForLane(int lane) {
        EnvelopeBuffer buf = this.envelopeBuffer() == null ? null : this.envelopeBuffer().copy();
        ReusableInboundEnvelope env = new ReusableInboundEnvelope();
        return env.init(this.recipient(), this.sender(), this.originUid(), this.serializer(), this.classManifest(), this.flags(), buf, this.association(), lane).withMessage(this.message());
    }

    public String toString() {
        return new StringBuilder(25).append("InboundEnvelope(").append(new OptionVal((Object)this.recipient())).append(", ").append(this.message()).append(", ").append(new OptionVal((Object)this.sender())).append(", ").append(this.originUid()).append(", ").append(new OptionVal((Object)this.association())).append(")").toString();
    }
}

