/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.RemoteActorRef;
import org.apache.pekko.remote.artery.EnvelopeBuffer$;
import org.apache.pekko.remote.artery.InboundEnvelope;
import org.apache.pekko.remote.artery.OutboundEnvelope;
import org.apache.pekko.remote.artery.RemoteInstrument;
import org.apache.pekko.remote.artery.RemoteInstruments$;
import org.apache.pekko.util.OptionVal$;
import scala.;
import scala.$less$colon$less$;
import scala.Byte$;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Vector;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class RemoteInstruments {
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final Vector<RemoteInstrument> instruments;
    private final boolean serializationTimingEnabled;

    public static RemoteInstruments apply(ExtendedActorSystem extendedActorSystem) {
        return RemoteInstruments$.MODULE$.apply(extendedActorSystem);
    }

    public static int combineKeyLength(byte by, int n) {
        return RemoteInstruments$.MODULE$.combineKeyLength(by, n);
    }

    @InternalStableApi
    public static Vector<RemoteInstrument> create(ExtendedActorSystem extendedActorSystem, LoggingAdapter loggingAdapter) {
        return RemoteInstruments$.MODULE$.create(extendedActorSystem, loggingAdapter);
    }

    public static byte getKey(int n) {
        return RemoteInstruments$.MODULE$.getKey(n);
    }

    public static int getLength(int n) {
        return RemoteInstruments$.MODULE$.getLength(n);
    }

    public RemoteInstruments(ExtendedActorSystem system, LoggingAdapter log, Vector<RemoteInstrument> _instruments) {
        this.system = system;
        this.log = log;
        this.instruments = (Vector)_instruments.sortBy((Function1 & Serializable)_$1 -> _$1.identifier(), (Ordering)Ordering.Byte$.MODULE$);
        this.serializationTimingEnabled = this.instruments.exists((Function1 & Serializable)_$2 -> _$2.serializationTimingEnabled());
    }

    private ExtendedActorSystem system() {
        return this.system;
    }

    private LoggingAdapter log() {
        return this.log;
    }

    public RemoteInstruments(ExtendedActorSystem system, LoggingAdapter log) {
        this(system, log, RemoteInstruments$.MODULE$.create(system, log));
    }

    public RemoteInstruments(ExtendedActorSystem system) {
        this(system, Logging$.MODULE$.getLogger((ActorSystem)system, RemoteInstruments.class));
    }

    public void serialize(OutboundEnvelope outboundEnvelope, ByteBuffer buffer) {
        if (this.instruments.nonEmpty() && OptionVal$.MODULE$.isDefined$extension((Object)outboundEnvelope)) {
            int startPos = buffer.position();
            OutboundEnvelope oe = (OutboundEnvelope)OptionVal$.MODULE$.get$extension((Object)outboundEnvelope);
            try {
                buffer.putInt(0);
                int dataPos = buffer.position();
                for (int i = 0; i < this.instruments.length(); ++i) {
                    Object object;
                    int rewindPos = buffer.position();
                    RemoteInstrument instrument = (RemoteInstrument)this.instruments.apply(i);
                    try {
                        this.serializeInstrument(instrument, oe, buffer);
                        object = BoxedUnit.UNIT;
                        continue;
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable t = throwable3 = (Throwable)option.get();
                            this.log().debug("Skipping serialization of RemoteInstrument {} since it failed with {}", (Object)BoxesRunTime.boxToByte((byte)instrument.identifier()), (Object)t.getMessage());
                            object = buffer.position(rewindPos);
                            continue;
                        }
                        throw throwable;
                    }
                }
                int endPos = buffer.position();
                if (endPos == dataPos) {
                    buffer.position(startPos);
                } else {
                    buffer.putInt(startPos, endPos - dataPos);
                }
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable4 = throwable;
                if (throwable4 != null && !(option = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                    Throwable throwable5;
                    Throwable t = throwable5 = (Throwable)option.get();
                    this.log().debug("Skipping serialization of all RemoteInstruments due to unhandled failure {}", (Object)t);
                    buffer.position(startPos);
                }
                throw throwable;
            }
            return;
        }
    }

    private void serializeInstrument(RemoteInstrument instrument, OutboundEnvelope outboundEnvelope, ByteBuffer buffer) {
        int startPos = buffer.position();
        buffer.putInt(0);
        int dataPos = buffer.position();
        RemoteActorRef remoteActorRef = outboundEnvelope.recipient();
        ActorRef actorRef = outboundEnvelope.sender();
        instrument.remoteWriteMetadata((ActorRef)OptionVal$.MODULE$.orNull$extension((Object)remoteActorRef, (.less.colon.less)$less$colon$less$.MODULE$.refl()), outboundEnvelope.message(), (ActorRef)OptionVal$.MODULE$.orNull$extension((Object)actorRef, (.less.colon.less)$less$colon$less$.MODULE$.refl()), buffer);
        int endPos = buffer.position();
        if (endPos == dataPos) {
            buffer.position(startPos);
            return;
        }
        buffer.putInt(startPos, RemoteInstruments$.MODULE$.combineKeyLength(instrument.identifier(), endPos - dataPos));
    }

    public void deserialize(InboundEnvelope inboundEnvelope) {
        if (inboundEnvelope.flag(EnvelopeBuffer$.MODULE$.MetadataPresentFlag())) {
            inboundEnvelope.envelopeBuffer().byteBuffer().position(EnvelopeBuffer$.MODULE$.MetadataContainerAndLiteralSectionOffset());
            this.deserializeRaw(inboundEnvelope);
            return;
        }
    }

    public void deserializeRaw(InboundEnvelope inboundEnvelope) {
        block16: {
            ByteBuffer buffer = inboundEnvelope.envelopeBuffer().byteBuffer();
            int length = buffer.getInt();
            int endPos = buffer.position() + length;
            try {
                try {
                    if (this.instruments.nonEmpty()) {
                        int i = 0;
                        while (i < this.instruments.length() && buffer.position() < endPos) {
                            RemoteInstrument instrument = (RemoteInstrument)this.instruments.apply(i);
                            int startPos = buffer.position();
                            int keyAndLength = buffer.getInt();
                            int dataPos = buffer.position();
                            byte key = RemoteInstruments$.MODULE$.getKey(keyAndLength);
                            int length2 = RemoteInstruments$.MODULE$.getLength(keyAndLength);
                            int nextPos = dataPos + length2;
                            byte identifier = instrument.identifier();
                            if (key == identifier) {
                                try {
                                    this.deserializeInstrument(instrument, inboundEnvelope, buffer);
                                }
                                catch (Throwable throwable) {
                                    Option option;
                                    Throwable throwable2 = throwable;
                                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                        Throwable throwable3;
                                        Throwable t = throwable3 = (Throwable)option.get();
                                        this.log().debug("Skipping deserialization of RemoteInstrument {} since it failed with {}", (Object)BoxesRunTime.boxToByte((byte)instrument.identifier()), (Object)t.getMessage());
                                    }
                                    throw throwable;
                                }
                                ++i;
                            } else if (key > identifier) {
                                this.log().debug("Skipping local RemoteInstrument {} that has no matching data in the message", (Object)BoxesRunTime.boxToByte((byte)identifier));
                                nextPos = startPos;
                                ++i;
                            } else {
                                this.log().debug("Skipping serialized data in message for RemoteInstrument {} that has no local match", (Object)BoxesRunTime.boxToByte((byte)key));
                            }
                            buffer.position(nextPos);
                        }
                        break block16;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("Skipping serialized data in message for RemoteInstrument(s) {} that has no local match", (Object)this.remoteInstrumentIdIteratorRaw(buffer, endPos).mkString("[", ", ", "]"));
                    }
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable4 = throwable;
                    if (throwable4 != null && !(option = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                        Throwable throwable5;
                        Throwable t = throwable5 = (Throwable)option.get();
                        this.log().debug("Skipping further deserialization of remaining RemoteInstruments due to unhandled failure {}", (Object)t);
                        break block16;
                    }
                    throw throwable;
                }
            }
            finally {
                buffer.position(endPos);
            }
        }
    }

    private void deserializeInstrument(RemoteInstrument instrument, InboundEnvelope inboundEnvelope, ByteBuffer buffer) {
        InternalActorRef internalActorRef = inboundEnvelope.recipient();
        ActorRef actorRef = inboundEnvelope.sender();
        instrument.remoteReadMetadata((ActorRef)OptionVal$.MODULE$.orNull$extension((Object)internalActorRef, (.less.colon.less)$less$colon$less$.MODULE$.refl()), inboundEnvelope.message(), (ActorRef)OptionVal$.MODULE$.orNull$extension((Object)actorRef, (.less.colon.less)$less$colon$less$.MODULE$.refl()), buffer);
    }

    public void messageSent(OutboundEnvelope outboundEnvelope, int size, long time) {
        this.messageSent$1(outboundEnvelope, size, time, 0);
    }

    private void messageSentInstrument(RemoteInstrument instrument, OutboundEnvelope outboundEnvelope, int size, long time) {
        RemoteActorRef remoteActorRef = outboundEnvelope.recipient();
        ActorRef actorRef = outboundEnvelope.sender();
        instrument.remoteMessageSent((ActorRef)OptionVal$.MODULE$.orNull$extension((Object)remoteActorRef, (.less.colon.less)$less$colon$less$.MODULE$.refl()), outboundEnvelope.message(), (ActorRef)OptionVal$.MODULE$.orNull$extension((Object)actorRef, (.less.colon.less)$less$colon$less$.MODULE$.refl()), size, time);
    }

    public void messageReceived(InboundEnvelope inboundEnvelope, int size, long time) {
        this.messageRecieved$1(inboundEnvelope, size, time, 0);
    }

    private void messageReceivedInstrument(RemoteInstrument instrument, InboundEnvelope inboundEnvelope, int size, long time) {
        InternalActorRef internalActorRef = inboundEnvelope.recipient();
        ActorRef actorRef = inboundEnvelope.sender();
        instrument.remoteMessageReceived((ActorRef)OptionVal$.MODULE$.orNull$extension((Object)internalActorRef, (.less.colon.less)$less$colon$less$.MODULE$.refl()), inboundEnvelope.message(), (ActorRef)OptionVal$.MODULE$.orNull$extension((Object)actorRef, (.less.colon.less)$less$colon$less$.MODULE$.refl()), size, time);
    }

    private Iterator<Object> remoteInstrumentIdIteratorRaw(ByteBuffer buffer, int endPos) {
        return new Iterator<Object>(buffer, endPos){
            private final ByteBuffer buffer$1;
            private final int endPos$1;
            {
                this.buffer$1 = buffer$2;
                this.endPos$1 = endPos$2;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
            }

            public boolean hasNext() {
                return this.buffer$1.position() < this.endPos$1;
            }

            public int next() {
                int keyAndLength = this.buffer$1.getInt();
                this.buffer$1.position(this.buffer$1.position() + RemoteInstruments$.MODULE$.getLength(keyAndLength));
                return Byte$.MODULE$.byte2int(RemoteInstruments$.MODULE$.getKey(keyAndLength));
            }
        };
    }

    public boolean isEmpty() {
        return this.instruments.isEmpty();
    }

    public boolean nonEmpty() {
        return this.instruments.nonEmpty();
    }

    public boolean timeSerialization() {
        return this.serializationTimingEnabled;
    }

    private final void messageSent$1(OutboundEnvelope outboundEnvelope$1, int size$3, long time$1, int pos) {
        while (pos < this.instruments.length()) {
            RemoteInstrument instrument = (RemoteInstrument)this.instruments.apply(pos);
            try {
                this.messageSentInstrument(instrument, outboundEnvelope$1, size$3, time$1);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable t = throwable3 = (Throwable)option.get();
                    this.log().debug("Message sent in RemoteInstrument {} failed with {}", (Object)BoxesRunTime.boxToByte((byte)instrument.identifier()), (Object)t.getMessage());
                }
                throw throwable;
            }
            ++pos;
        }
    }

    private final void messageRecieved$1(InboundEnvelope inboundEnvelope$1, int size$4, long time$2, int pos) {
        while (pos < this.instruments.length()) {
            RemoteInstrument instrument = (RemoteInstrument)this.instruments.apply(pos);
            try {
                this.messageReceivedInstrument(instrument, inboundEnvelope$1, size$4, time$2);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable t = throwable3 = (Throwable)option.get();
                    this.log().debug("Message received in RemoteInstrument {} failed with {}", (Object)BoxesRunTime.boxToByte((byte)instrument.identifier()), (Object)t.getMessage());
                }
                throw throwable;
            }
            ++pos;
        }
    }
}

