/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import org.agrona.concurrent.ManyToManyConcurrentArrayQueue;
import scala.Function0;
import scala.Function1;
import scala.runtime.BoxedUnit;

public class ObjectPool<A> {
    private final Function0<A> create;
    private final Function1<A, BoxedUnit> clear;
    private final ManyToManyConcurrentArrayQueue<A> pool;

    public ObjectPool(int capacity, Function0<A> create, Function1<A, BoxedUnit> clear) {
        this.create = create;
        this.clear = clear;
        this.pool = new ManyToManyConcurrentArrayQueue(capacity);
    }

    public A acquire() {
        Object obj = this.pool.poll();
        if (obj == null) {
            return (A)this.create.apply();
        }
        return (A)obj;
    }

    public boolean release(A obj) {
        this.clear.apply(obj);
        return !this.pool.offer(obj);
    }
}

