/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.pekko.remote.artery.ImmutableLongMap$;
import org.apache.pekko.util.HashCode$;
import org.apache.pekko.util.OptionVal$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class ImmutableLongMap<A> {
    private final long[] keys;
    private final Object values;
    private final ClassTag<A> t;
    private final int size;

    public static <A> ImmutableLongMap<A> empty(ClassTag<A> classTag) {
        return ImmutableLongMap$.MODULE$.empty(classTag);
    }

    public ImmutableLongMap(long[] keys, Object values, ClassTag<A> t) {
        this.keys = keys;
        this.values = values;
        this.t = t;
        this.size = keys.length;
    }

    private long[] keys() {
        return this.keys;
    }

    private Object values() {
        return this.values;
    }

    public int size() {
        return this.size;
    }

    public Object get(long key) {
        int i = Arrays.binarySearch(this.keys(), key);
        if (i >= 0) {
            return OptionVal$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply(this.values(), i));
        }
        OptionVal$.MODULE$.None();
        return null;
    }

    public boolean contains(long key) {
        return Arrays.binarySearch(this.keys(), key) >= 0;
    }

    public ImmutableLongMap<A> updated(long key, A value) {
        if (this.size() == 0) {
            return new ImmutableLongMap<A>(new long[]{key}, Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{value}), this.t), this.t);
        }
        int i = Arrays.binarySearch(this.keys(), key);
        if (i >= 0) {
            Object newValues = Arrays$.MODULE$.newGenericArray(ScalaRunTime$.MODULE$.array_length(this.values()), this.t);
            System.arraycopy(this.values(), 0, newValues, 0, ScalaRunTime$.MODULE$.array_length(this.values()));
            ScalaRunTime$.MODULE$.array_update(newValues, i, value);
            return new ImmutableLongMap<A>(this.keys(), newValues, this.t);
        }
        int j = -(i + 1);
        long[] newKeys = new long[this.size() + 1];
        System.arraycopy(this.keys(), 0, newKeys, 0, j);
        newKeys[j] = key;
        System.arraycopy(this.keys(), j, newKeys, j + 1, this.keys().length - j);
        Object newValues = Arrays$.MODULE$.newGenericArray(this.size() + 1, this.t);
        System.arraycopy(this.values(), 0, newValues, 0, j);
        ScalaRunTime$.MODULE$.array_update(newValues, j, value);
        System.arraycopy(this.values(), j, newValues, j + 1, ScalaRunTime$.MODULE$.array_length(this.values()) - j);
        return new ImmutableLongMap<A>(newKeys, newValues, this.t);
    }

    public ImmutableLongMap<A> remove(long key) {
        int i = Arrays.binarySearch(this.keys(), key);
        if (i >= 0) {
            if (this.size() == 1) {
                return ImmutableLongMap$.MODULE$.empty(this.t);
            }
            long[] newKeys = new long[this.size() - 1];
            System.arraycopy(this.keys(), 0, newKeys, 0, i);
            System.arraycopy(this.keys(), i + 1, newKeys, i, this.keys().length - i - 1);
            Object newValues = Arrays$.MODULE$.newGenericArray(this.size() - 1, this.t);
            System.arraycopy(this.values(), 0, newValues, 0, i);
            System.arraycopy(this.values(), i + 1, newValues, i, ScalaRunTime$.MODULE$.array_length(this.values()) - i - 1);
            return new ImmutableLongMap<A>(newKeys, newValues, this.t);
        }
        return this;
    }

    public Iterator<Object> keysIterator() {
        Object object = Predef$.MODULE$.longArrayOps(this.keys());
        return ArrayOps$.MODULE$.iterator$extension(object);
    }

    public String toString() {
        return this.keysIterator().map((Function1 & Serializable)key -> this.toString$$anonfun$1(BoxesRunTime.unboxToLong((Object)key))).mkString("ImmutableLongMap(", ", ", ")");
    }

    public int hashCode() {
        int result = HashCode$.MODULE$.SEED();
        result = HashCode$.MODULE$.hash(result, (Object)this.keys());
        result = HashCode$.MODULE$.hash(result, this.values());
        return result;
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof ImmutableLongMap) {
            ImmutableLongMap other = (ImmutableLongMap)object;
            if (other == this) {
                return true;
            }
            if (this.size() != other.size()) {
                return false;
            }
            if (this.size() == 0 && other.size() == 0) {
                return true;
            }
            return this.check$1(other, 0);
        }
        return false;
    }

    private final /* synthetic */ String toString$$anonfun$1(long key) {
        Object object = this.get(key);
        return new StringBuilder(4).append(key).append(" -> ").append(OptionVal$.MODULE$.get$extension(object)).toString();
    }

    private final boolean check$1(ImmutableLongMap other$1, int i) {
        while (true) {
            if (i == this.size()) {
                return true;
            }
            if (this.keys()[i] != other$1.keys()[i] || !BoxesRunTime.equals((Object)ScalaRunTime$.MODULE$.array_apply(this.values(), i), (Object)ScalaRunTime$.MODULE$.array_apply(other$1.values(), i))) break;
            ++i;
        }
        return false;
    }
}

