/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.concurrent.UnsafeBuffer;
import org.apache.pekko.io.DirectByteBufferPool$;
import org.apache.pekko.remote.artery.ArteryTransport$;
import org.apache.pekko.remote.artery.EnvelopeBuffer$;
import org.apache.pekko.remote.artery.HeaderBuilder;
import org.apache.pekko.remote.artery.HeaderBuilderImpl;
import org.apache.pekko.remote.artery.OutboundEnvelope;
import org.apache.pekko.remote.artery.RemoteInstruments;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.Unsafe;
import scala.runtime.BoxedUnit;

public final class EnvelopeBuffer {
    private final ByteBuffer byteBuffer;
    private final UnsafeBuffer aeronBuffer;
    private char[] literalChars;
    private byte[] literalBytes;
    private int _streamId;

    public static int ActorRefCompressionTableVersionOffset() {
        return EnvelopeBuffer$.MODULE$.ActorRefCompressionTableVersionOffset();
    }

    public static int ClassManifestCompressionTableVersionOffset() {
        return EnvelopeBuffer$.MODULE$.ClassManifestCompressionTableVersionOffset();
    }

    public static int ClassManifestTagOffset() {
        return EnvelopeBuffer$.MODULE$.ClassManifestTagOffset();
    }

    public static int FlagsOffset() {
        return EnvelopeBuffer$.MODULE$.FlagsOffset();
    }

    public static int MetadataContainerAndLiteralSectionOffset() {
        return EnvelopeBuffer$.MODULE$.MetadataContainerAndLiteralSectionOffset();
    }

    public static byte MetadataPresentFlag() {
        return EnvelopeBuffer$.MODULE$.MetadataPresentFlag();
    }

    public static int RecipientActorRefTagOffset() {
        return EnvelopeBuffer$.MODULE$.RecipientActorRefTagOffset();
    }

    public static int SenderActorRefTagOffset() {
        return EnvelopeBuffer$.MODULE$.SenderActorRefTagOffset();
    }

    public static int SerializerOffset() {
        return EnvelopeBuffer$.MODULE$.SerializerOffset();
    }

    public static int TagTypeMask() {
        return EnvelopeBuffer$.MODULE$.TagTypeMask();
    }

    public static int TagValueMask() {
        return EnvelopeBuffer$.MODULE$.TagValueMask();
    }

    public static int UidOffset() {
        return EnvelopeBuffer$.MODULE$.UidOffset();
    }

    public static int VersionOffset() {
        return EnvelopeBuffer$.MODULE$.VersionOffset();
    }

    public EnvelopeBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.aeronBuffer = new UnsafeBuffer(byteBuffer);
        this.literalChars = new char[64];
        this.literalBytes = new byte[64];
        this._streamId = -1;
    }

    public ByteBuffer byteBuffer() {
        return this.byteBuffer;
    }

    public UnsafeBuffer aeronBuffer() {
        return this.aeronBuffer;
    }

    public int streamId() {
        if (this._streamId != -1) {
            return this._streamId;
        }
        throw new IllegalStateException("StreamId was not set");
    }

    public void setStreamId(int newStreamId) {
        this._streamId = newStreamId;
    }

    public void writeHeader(HeaderBuilder h) {
        this.writeHeader(h, null);
    }

    public void writeHeader(HeaderBuilder h, OutboundEnvelope oe) {
        Object object;
        Object object2;
        HeaderBuilderImpl header = (HeaderBuilderImpl)h;
        this.byteBuffer().clear();
        this.byteBuffer().put(EnvelopeBuffer$.MODULE$.VersionOffset(), header.version());
        this.byteBuffer().put(EnvelopeBuffer$.MODULE$.FlagsOffset(), header.flags());
        this.byteBuffer().put(EnvelopeBuffer$.MODULE$.ActorRefCompressionTableVersionOffset(), header.outboundActorRefCompression().version());
        this.byteBuffer().put(EnvelopeBuffer$.MODULE$.ClassManifestCompressionTableVersionOffset(), header.outboundClassManifestCompression().version());
        this.byteBuffer().putLong(EnvelopeBuffer$.MODULE$.UidOffset(), header.uid());
        this.byteBuffer().putInt(EnvelopeBuffer$.MODULE$.SerializerOffset(), header.serializer());
        this.byteBuffer().position(EnvelopeBuffer$.MODULE$.MetadataContainerAndLiteralSectionOffset());
        RemoteInstruments remoteInstruments = header._remoteInstruments();
        if (OptionVal$.MODULE$.isDefined$extension((Object)remoteInstruments)) {
            RemoteInstruments remoteInstruments2 = header._remoteInstruments();
            ((RemoteInstruments)OptionVal$.MODULE$.get$extension((Object)remoteInstruments2)).serialize((OutboundEnvelope)OptionVal$.MODULE$.apply((Object)oe), this.byteBuffer());
            if (this.byteBuffer().position() != EnvelopeBuffer$.MODULE$.MetadataContainerAndLiteralSectionOffset()) {
                header.setFlag(EnvelopeBuffer$.MODULE$.MetadataPresentFlag());
                this.byteBuffer().put(EnvelopeBuffer$.MODULE$.FlagsOffset(), header.flags());
            }
        }
        if (header._senderActorRefIdx() != -1) {
            object2 = this.byteBuffer().putInt(EnvelopeBuffer$.MODULE$.SenderActorRefTagOffset(), header._senderActorRefIdx() | EnvelopeBuffer$.MODULE$.TagTypeMask());
        } else {
            this.writeLiteral(EnvelopeBuffer$.MODULE$.SenderActorRefTagOffset(), header._senderActorRef());
            object2 = BoxedUnit.UNIT;
        }
        if (header._recipientActorRefIdx() != -1) {
            object = this.byteBuffer().putInt(EnvelopeBuffer$.MODULE$.RecipientActorRefTagOffset(), header._recipientActorRefIdx() | EnvelopeBuffer$.MODULE$.TagTypeMask());
        } else {
            this.writeLiteral(EnvelopeBuffer$.MODULE$.RecipientActorRefTagOffset(), header._recipientActorRef());
            object = BoxedUnit.UNIT;
        }
        if (header._manifestIdx() != -1) {
            this.byteBuffer().putInt(EnvelopeBuffer$.MODULE$.ClassManifestTagOffset(), header._manifestIdx() | EnvelopeBuffer$.MODULE$.TagTypeMask());
            return;
        }
        this.writeLiteral(EnvelopeBuffer$.MODULE$.ClassManifestTagOffset(), header._manifest());
    }

    public void parseHeader(HeaderBuilder h) {
        int senderTag;
        HeaderBuilderImpl header = (HeaderBuilderImpl)h;
        header.setVersion(this.byteBuffer().get(EnvelopeBuffer$.MODULE$.VersionOffset()));
        if (header.version() > ArteryTransport$.MODULE$.HighestVersion()) {
            throw new IllegalArgumentException(new StringBuilder(34).append("Incompatible protocol version [").append(header.version()).append("], ").append(new StringBuilder(41).append("highest known version for this node is [").append(ArteryTransport$.MODULE$.HighestVersion()).append("]").toString()).toString());
        }
        header.setFlags(this.byteBuffer().get(EnvelopeBuffer$.MODULE$.FlagsOffset()));
        header._inboundActorRefCompressionTableVersion_$eq(this.byteBuffer().get(EnvelopeBuffer$.MODULE$.ActorRefCompressionTableVersionOffset()));
        header._inboundClassManifestCompressionTableVersion_$eq(this.byteBuffer().get(EnvelopeBuffer$.MODULE$.ClassManifestCompressionTableVersionOffset()));
        header.setUid(this.byteBuffer().getLong(EnvelopeBuffer$.MODULE$.UidOffset()));
        header.setSerializer(this.byteBuffer().getInt(EnvelopeBuffer$.MODULE$.SerializerOffset()));
        this.byteBuffer().position(EnvelopeBuffer$.MODULE$.MetadataContainerAndLiteralSectionOffset());
        if (header.flag(EnvelopeBuffer$.MODULE$.MetadataPresentFlag())) {
            int totalMetadataLength = this.byteBuffer().getInt();
            this.byteBuffer().position(this.byteBuffer().position() + totalMetadataLength);
        }
        if (((senderTag = this.byteBuffer().getInt(EnvelopeBuffer$.MODULE$.SenderActorRefTagOffset())) & EnvelopeBuffer$.MODULE$.TagTypeMask()) != 0) {
            int idx = senderTag & EnvelopeBuffer$.MODULE$.TagValueMask();
            header._senderActorRef_$eq(null);
            header._senderActorRefIdx_$eq(idx);
        } else {
            header._senderActorRef_$eq(this.emptyAsNull(this.readLiteral()));
        }
        int recipientTag = this.byteBuffer().getInt(EnvelopeBuffer$.MODULE$.RecipientActorRefTagOffset());
        if ((recipientTag & EnvelopeBuffer$.MODULE$.TagTypeMask()) != 0) {
            int idx = recipientTag & EnvelopeBuffer$.MODULE$.TagValueMask();
            header._recipientActorRef_$eq(null);
            header._recipientActorRefIdx_$eq(idx);
        } else {
            header._recipientActorRef_$eq(this.emptyAsNull(this.readLiteral()));
        }
        int manifestTag = this.byteBuffer().getInt(EnvelopeBuffer$.MODULE$.ClassManifestTagOffset());
        if ((manifestTag & EnvelopeBuffer$.MODULE$.TagTypeMask()) != 0) {
            int idx = manifestTag & EnvelopeBuffer$.MODULE$.TagValueMask();
            header._manifest_$eq(null);
            header._manifestIdx_$eq(idx);
            return;
        }
        header._manifest_$eq(this.readLiteral());
    }

    private String emptyAsNull(String s) {
        String string = s;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return null;
        }
        return s;
    }

    private String readLiteral() {
        int length = this.byteBuffer().getShort();
        if (length == 0) {
            return "";
        }
        this.ensureLiteralCharsLength(length);
        char[] chars = this.literalChars;
        byte[] bytes = this.literalBytes;
        this.byteBuffer().get(bytes, 0, length);
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)bytes[i];
        }
        return String.valueOf(chars, 0, length);
    }

    private void writeLiteral(int tagOffset, String literal) {
        int length;
        int n = length = literal == null ? 0 : literal.length();
        if (length > 65535) {
            throw new IllegalArgumentException("Literals longer than 65535 cannot be encoded in the envelope");
        }
        this.byteBuffer().putInt(tagOffset, this.byteBuffer().position());
        this.byteBuffer().putShort((short)length);
        if (length > 0) {
            this.ensureLiteralCharsLength(length);
            byte[] bytes = this.literalBytes;
            Unsafe.copyUSAsciiStrToBytes((String)literal, (byte[])bytes);
            this.byteBuffer().put(bytes, 0, length);
            return;
        }
    }

    private void ensureLiteralCharsLength(int length) {
        if (length > this.literalChars.length) {
            this.literalChars = new char[length];
            this.literalBytes = new byte[length];
            return;
        }
    }

    public void tryCleanDirectByteBuffer() {
        DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(this.byteBuffer());
    }

    public EnvelopeBuffer copy() {
        int p = this.byteBuffer().position();
        this.byteBuffer().rewind();
        byte[] bytes = new byte[this.byteBuffer().remaining()];
        this.byteBuffer().get(bytes);
        ByteBuffer newByteBuffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        newByteBuffer.position(p);
        this.byteBuffer().position(p);
        return new EnvelopeBuffer(newByteBuffer);
    }
}

