/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.BufferOverflowException;
import org.apache.pekko.Done;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRef$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Dropped;
import org.apache.pekko.actor.Dropped$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.MessageSerializer$;
import org.apache.pekko.remote.OversizedPayloadException;
import org.apache.pekko.remote.RemoteActorRef;
import org.apache.pekko.remote.UniqueAddress;
import org.apache.pekko.remote.artery.ArteryMessage;
import org.apache.pekko.remote.artery.EnvelopeBuffer;
import org.apache.pekko.remote.artery.EnvelopeBufferPool;
import org.apache.pekko.remote.artery.HeaderBuilder;
import org.apache.pekko.remote.artery.HeaderBuilder$;
import org.apache.pekko.remote.artery.ObjectPool;
import org.apache.pekko.remote.artery.OutboundEnvelope;
import org.apache.pekko.remote.artery.RemoteInstruments;
import org.apache.pekko.remote.artery.RemoteInstruments$;
import org.apache.pekko.remote.artery.ReusableOutboundEnvelope;
import org.apache.pekko.remote.artery.SystemMessageDelivery;
import org.apache.pekko.remote.artery.compress.CompressionTable;
import org.apache.pekko.remote.artery.compress.CompressionTable$;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.StageLogging;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public class Encoder
extends GraphStageWithMaterializedValue<FlowShape<OutboundEnvelope, EnvelopeBuffer>, OutboundCompressionAccess> {
    public final UniqueAddress org$apache$pekko$remote$artery$Encoder$$uniqueLocalAddress;
    public final ExtendedActorSystem org$apache$pekko$remote$artery$Encoder$$system;
    public final ObjectPool<ReusableOutboundEnvelope> org$apache$pekko$remote$artery$Encoder$$outboundEnvelopePool;
    public final EnvelopeBufferPool org$apache$pekko$remote$artery$Encoder$$bufferPool;
    public final boolean org$apache$pekko$remote$artery$Encoder$$debugLogSend;
    public final byte org$apache$pekko$remote$artery$Encoder$$version;
    private final Inlet in;
    private final Outlet out;
    private final FlowShape shape;

    public Encoder(UniqueAddress uniqueLocalAddress, ExtendedActorSystem system, ObjectPool<ReusableOutboundEnvelope> outboundEnvelopePool, EnvelopeBufferPool bufferPool, int streamId, boolean debugLogSend, byte version) {
        this.org$apache$pekko$remote$artery$Encoder$$uniqueLocalAddress = uniqueLocalAddress;
        this.org$apache$pekko$remote$artery$Encoder$$system = system;
        this.org$apache$pekko$remote$artery$Encoder$$outboundEnvelopePool = outboundEnvelopePool;
        this.org$apache$pekko$remote$artery$Encoder$$bufferPool = bufferPool;
        this.org$apache$pekko$remote$artery$Encoder$$debugLogSend = debugLogSend;
        this.org$apache$pekko$remote$artery$Encoder$$version = version;
        this.in = Inlet$.MODULE$.apply("Artery.Encoder.in");
        this.out = Outlet$.MODULE$.apply("Artery.Encoder.out");
        this.shape = FlowShape$.MODULE$.apply(this.in(), this.out());
    }

    public Inlet<OutboundEnvelope> in() {
        return this.in;
    }

    public Outlet<EnvelopeBuffer> out() {
        return this.out;
    }

    public FlowShape<OutboundEnvelope, EnvelopeBuffer> shape() {
        return this.shape;
    }

    public Tuple2<GraphStageLogic, OutboundCompressionAccess> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
        InHandler logic = new InHandler(this){
            private LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log;
            private final HeaderBuilder headerBuilder;
            private Serialization _serialization;
            private final RemoteInstruments instruments;
            private final AsyncCallback changeActorRefCompressionCb;
            private final AsyncCallback changeClassManifestCompressionCb;
            private final AsyncCallback clearCompressionCb;
            private boolean debugLogSendEnabled;
            private final /* synthetic */ Encoder $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                StageLogging.$init$((StageLogging)this);
                this.headerBuilder = HeaderBuilder$.MODULE$.out();
                this.headerBuilder.setVersion($outer.org$apache$pekko$remote$artery$Encoder$$version);
                this.headerBuilder.setUid($outer.org$apache$pekko$remote$artery$Encoder$$uniqueLocalAddress.uid());
                OptionVal$.MODULE$.None();
                this._serialization = null;
                this.instruments = RemoteInstruments$.MODULE$.apply($outer.org$apache$pekko$remote$artery$Encoder$$system);
                this.changeActorRefCompressionCb = this.getAsyncCallback((Function1)(JProcedure1 & Serializable)table -> this.headerBuilder.setOutboundActorRefCompression((CompressionTable<ActorRef>)table));
                this.changeClassManifestCompressionCb = this.getAsyncCallback((Function1)(JProcedure1 & Serializable)table -> this.headerBuilder.setOutboundClassManifestCompression((CompressionTable<String>)table));
                this.clearCompressionCb = this.getAsyncCallback((Function1)(JProcedure1 & Serializable)_$1 -> {
                    this.headerBuilder.setOutboundActorRefCompression(CompressionTable$.MODULE$.empty());
                    this.headerBuilder.setOutboundClassManifestCompression(CompressionTable$.MODULE$.empty());
                });
                this.debugLogSendEnabled = false;
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            public LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log() {
                return this.org$apache$pekko$stream$stage$StageLogging$$_log;
            }

            public void org$apache$pekko$stream$stage$StageLogging$$_log_$eq(LoggingAdapter x$1) {
                this.org$apache$pekko$stream$stage$StageLogging$$_log = x$1;
            }

            private Serialization serialization() {
                Serialization serialization = this._serialization;
                Serialization serialization2 = (Serialization)OptionVal.Some$.MODULE$.unapply((Object)serialization);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)serialization2)) {
                    Serialization serialization3;
                    Serialization s = serialization3 = (Serialization)OptionVal$.MODULE$.get$extension((Object)serialization2);
                    return s;
                }
                Serialization s = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.$outer.org$apache$pekko$remote$artery$Encoder$$system);
                this._serialization = (Serialization)OptionVal.Some$.MODULE$.apply((Object)s);
                return s;
            }

            public Class logSource() {
                return Encoder.class;
            }

            public void preStart() {
                this.debugLogSendEnabled = this.$outer.org$apache$pekko$remote$artery$Encoder$$debugLogSend && this.log().isDebugEnabled();
            }

            public void onPush() {
                block19: {
                    OutboundEnvelope outboundEnvelope = (OutboundEnvelope)this.grab(this.$outer.in());
                    EnvelopeBuffer envelope = this.$outer.org$apache$pekko$remote$artery$Encoder$$bufferPool.acquire();
                    this.headerBuilder.resetMessageFields();
                    this.headerBuilder.useOutboundCompression(!(outboundEnvelope.message() instanceof ArteryMessage));
                    Serialization.Information oldInfo = (Serialization.Information)Serialization$.MODULE$.currentTransportInformation().value();
                    try {
                        try {
                            long startTime;
                            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serialization().serializationInformation());
                            RemoteActorRef remoteActorRef = outboundEnvelope.recipient();
                            RemoteActorRef remoteActorRef2 = (RemoteActorRef)OptionVal.Some$.MODULE$.unapply((Object)remoteActorRef);
                            if (!OptionVal$.MODULE$.isEmpty$extension((Object)remoteActorRef2)) {
                                RemoteActorRef remoteActorRef3;
                                RemoteActorRef r = remoteActorRef3 = (RemoteActorRef)OptionVal$.MODULE$.get$extension((Object)remoteActorRef2);
                                this.headerBuilder.setRecipientActorRef((ActorRef)r);
                            } else {
                                this.headerBuilder.setNoRecipient();
                            }
                            ActorRef actorRef = outboundEnvelope.sender();
                            ActorRef actorRef2 = (ActorRef)OptionVal.Some$.MODULE$.unapply((Object)actorRef);
                            if (!OptionVal$.MODULE$.isEmpty$extension((Object)actorRef2)) {
                                ActorRef actorRef3;
                                ActorRef s = actorRef3 = (ActorRef)OptionVal$.MODULE$.get$extension((Object)actorRef2);
                                this.headerBuilder.setSenderActorRef(s);
                            } else {
                                this.headerBuilder.setNoSender();
                            }
                            long l = startTime = this.instruments.timeSerialization() ? System.nanoTime() : 0L;
                            if (this.instruments.nonEmpty()) {
                                this.headerBuilder.setRemoteInstruments(this.instruments);
                            }
                            MessageSerializer$.MODULE$.serializeForArtery(this.serialization(), outboundEnvelope, this.headerBuilder, envelope);
                            if (this.instruments.nonEmpty()) {
                                long time = this.instruments.timeSerialization() ? System.nanoTime() - startTime : 0L;
                                this.instruments.messageSent(outboundEnvelope, envelope.byteBuffer().position(), time);
                            }
                            envelope.byteBuffer().flip();
                            if (this.debugLogSendEnabled) {
                                RemoteActorRef remoteActorRef4 = outboundEnvelope.recipient();
                                ActorRef actorRef4 = outboundEnvelope.sender();
                                this.log().debug("sending remote message [{}] to [{}] from [{}]", outboundEnvelope.message(), OptionVal$.MODULE$.getOrElse$extension((Object)remoteActorRef4, (Object)""), OptionVal$.MODULE$.getOrElse$extension((Object)actorRef4, (Object)""));
                            }
                            this.push(this.$outer.out(), envelope);
                        }
                        catch (Throwable throwable) {
                            Option option;
                            Throwable throwable2 = throwable;
                            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                Throwable throwable3;
                                Throwable e = throwable3 = (Throwable)option.get();
                                this.$outer.org$apache$pekko$remote$artery$Encoder$$bufferPool.release(envelope);
                                Object object = outboundEnvelope.message();
                                if (object instanceof SystemMessageDelivery.SystemMessageEnvelope) {
                                    this.log().error(e, "Failed to serialize system message [{}].", (Object)Logging$.MODULE$.messageClassName(outboundEnvelope.message()));
                                    throw e;
                                }
                                if (e instanceof BufferOverflowException) {
                                    Dropped dropped;
                                    String reasonText = new StringBuilder(37).append("Discarding oversized payload sent to ").append(new StringBuilder(20).append(new OptionVal((Object)outboundEnvelope.recipient())).append(": max allowed size ").append(envelope.byteBuffer().limit()).append(" ").toString()).append(new StringBuilder(23).append("bytes. Message type [").append(Logging$.MODULE$.messageClassName(outboundEnvelope.message())).append("].").toString()).toString();
                                    this.log().error((Throwable)((Object)new OversizedPayloadException(reasonText)), "Failed to serialize oversized message [{}].", (Object)Logging$.MODULE$.messageClassName(outboundEnvelope.message()));
                                    EventStream eventStream = this.$outer.org$apache$pekko$remote$artery$Encoder$$system.eventStream();
                                    ActorRef actorRef = outboundEnvelope.sender();
                                    ActorRef actorRef5 = (ActorRef)OptionVal.Some$.MODULE$.unapply((Object)actorRef);
                                    if (!OptionVal$.MODULE$.isEmpty$extension((Object)actorRef5)) {
                                        ActorRef actorRef6;
                                        ActorRef msgSender = actorRef6 = (ActorRef)OptionVal$.MODULE$.get$extension((Object)actorRef5);
                                        RemoteActorRef remoteActorRef = outboundEnvelope.recipient();
                                        dropped = Dropped$.MODULE$.apply(outboundEnvelope.message(), reasonText, msgSender, (ActorRef)OptionVal$.MODULE$.getOrElse$extension((Object)remoteActorRef, (Object)ActorRef$.MODULE$.noSender()));
                                    } else {
                                        RemoteActorRef remoteActorRef = outboundEnvelope.recipient();
                                        dropped = Dropped$.MODULE$.apply(outboundEnvelope.message(), reasonText, (ActorRef)OptionVal$.MODULE$.getOrElse$extension((Object)remoteActorRef, (Object)ActorRef$.MODULE$.noSender()));
                                    }
                                    eventStream.publish((Object)dropped);
                                    this.pull(this.$outer.in());
                                } else {
                                    this.log().error(e, "Failed to serialize message [{}].", (Object)Logging$.MODULE$.messageClassName(outboundEnvelope.message()));
                                    this.pull(this.$outer.in());
                                }
                                break block19;
                            }
                            throw throwable;
                        }
                    }
                    finally {
                        Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
                        OutboundEnvelope outboundEnvelope2 = outboundEnvelope;
                        if (outboundEnvelope2 instanceof ReusableOutboundEnvelope) {
                            ReusableOutboundEnvelope r = (ReusableOutboundEnvelope)outboundEnvelope2;
                            this.$outer.org$apache$pekko$remote$artery$Encoder$$outboundEnvelopePool.release(r);
                        }
                    }
                }
            }

            public void onPull() {
                this.pull(this.$outer.in());
            }

            public Future changeActorRefCompression(CompressionTable table) {
                return this.changeActorRefCompressionCb.invokeWithFeedback((Object)table);
            }

            public Future changeClassManifestCompression(CompressionTable table) {
                return this.changeClassManifestCompressionCb.invokeWithFeedback((Object)table);
            }

            public Future clearCompression() {
                return this.clearCompressionCb.invokeWithFeedback((Object)BoxedUnit.UNIT);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$1(org.apache.pekko.remote.artery.compress.CompressionTable ), $init$$$anonfun$2(org.apache.pekko.remote.artery.compress.CompressionTable ), $init$$$anonfun$3(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        };
        return Tuple2$.MODULE$.apply((Object)logic, (Object)logic);
    }

    public static interface OutboundCompressionAccess {
        public Future<Done> changeActorRefCompression(CompressionTable<ActorRef> var1);

        public Future<Done> changeClassManifestCompression(CompressionTable<String> var1);

        public Future<Done> clearCompression();
    }
}

