/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.MessageSerializer$;
import org.apache.pekko.remote.artery.EnvelopeBuffer;
import org.apache.pekko.remote.artery.EnvelopeBufferPool;
import org.apache.pekko.remote.artery.InboundContext;
import org.apache.pekko.remote.artery.InboundEnvelope;
import org.apache.pekko.remote.artery.OutboundContext;
import org.apache.pekko.remote.artery.RemoteInstruments;
import org.apache.pekko.remote.artery.RemoteInstruments$;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.StageLogging;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Option;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public class Deserializer
extends GraphStage<FlowShape<InboundEnvelope, InboundEnvelope>> {
    public final ExtendedActorSystem org$apache$pekko$remote$artery$Deserializer$$system;
    public final EnvelopeBufferPool org$apache$pekko$remote$artery$Deserializer$$bufferPool;
    private final Inlet in;
    private final Outlet out;
    private final FlowShape shape;

    public Deserializer(InboundContext inboundContext, ExtendedActorSystem system, EnvelopeBufferPool bufferPool) {
        this.org$apache$pekko$remote$artery$Deserializer$$system = system;
        this.org$apache$pekko$remote$artery$Deserializer$$bufferPool = bufferPool;
        this.in = Inlet$.MODULE$.apply("Artery.Deserializer.in");
        this.out = Outlet$.MODULE$.apply("Artery.Deserializer.out");
        this.shape = FlowShape$.MODULE$.apply(this.in(), this.out());
    }

    public Inlet<InboundEnvelope> in() {
        return this.in;
    }

    public Outlet<InboundEnvelope> out() {
        return this.out;
    }

    public FlowShape<InboundEnvelope, InboundEnvelope> shape() {
        return this.shape;
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this){
            private LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log;
            private final RemoteInstruments instruments;
            private Serialization _serialization;
            private final /* synthetic */ Deserializer $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                StageLogging.$init$((StageLogging)this);
                this.instruments = RemoteInstruments$.MODULE$.apply($outer.org$apache$pekko$remote$artery$Deserializer$$system);
                OptionVal$.MODULE$.None();
                this._serialization = null;
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            public LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log() {
                return this.org$apache$pekko$stream$stage$StageLogging$$_log;
            }

            public void org$apache$pekko$stream$stage$StageLogging$$_log_$eq(LoggingAdapter x$1) {
                this.org$apache$pekko$stream$stage$StageLogging$$_log = x$1;
            }

            private Serialization serialization() {
                Serialization serialization = this._serialization;
                Serialization serialization2 = (Serialization)OptionVal.Some$.MODULE$.unapply((Object)serialization);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)serialization2)) {
                    Serialization serialization3;
                    Serialization s = serialization3 = (Serialization)OptionVal$.MODULE$.get$extension((Object)serialization2);
                    return s;
                }
                Serialization s = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.$outer.org$apache$pekko$remote$artery$Deserializer$$system);
                this._serialization = (Serialization)OptionVal.Some$.MODULE$.apply((Object)s);
                return s;
            }

            public Class logSource() {
                return Deserializer.class;
            }

            public void onPush() {
                block9: {
                    InboundEnvelope envelope = (InboundEnvelope)this.grab(this.$outer.in());
                    try {
                        try {
                            long startTime = this.instruments.timeSerialization() ? System.nanoTime() : 0L;
                            Object deserializedMessage = MessageSerializer$.MODULE$.deserializeForArtery(this.$outer.org$apache$pekko$remote$artery$Deserializer$$system, envelope.originUid(), this.serialization(), envelope.serializer(), envelope.classManifest(), envelope.envelopeBuffer());
                            InboundEnvelope envelopeWithMessage = envelope.withMessage(deserializedMessage);
                            if (this.instruments.nonEmpty()) {
                                this.instruments.deserialize(envelopeWithMessage);
                                long time = this.instruments.timeSerialization() ? System.nanoTime() - startTime : 0L;
                                this.instruments.messageReceived(envelopeWithMessage, envelope.envelopeBuffer().byteBuffer().limit(), time);
                            }
                            this.push(this.$outer.out(), envelopeWithMessage);
                        }
                        catch (Throwable throwable) {
                            Option option;
                            Throwable throwable2 = throwable;
                            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                String string;
                                Throwable throwable3;
                                Throwable e = throwable3 = (Throwable)option.get();
                                OutboundContext outboundContext = envelope.association();
                                OutboundContext outboundContext2 = (OutboundContext)OptionVal.Some$.MODULE$.unapply((Object)outboundContext);
                                if (!OptionVal$.MODULE$.isEmpty$extension((Object)outboundContext2)) {
                                    OutboundContext outboundContext3;
                                    OutboundContext a = outboundContext3 = (OutboundContext)OptionVal$.MODULE$.get$extension((Object)outboundContext2);
                                    string = a.remoteAddress();
                                } else {
                                    string = "unknown";
                                }
                                String from = string;
                                this.log().error(e, "Failed to deserialize message from [{}] with serializer id [{}] and manifest [{}].", (Object)from, (Object)BoxesRunTime.boxToInteger((int)envelope.serializer()), (Object)envelope.classManifest());
                                this.pull(this.$outer.in());
                                break block9;
                            }
                            throw throwable;
                        }
                    }
                    finally {
                        EnvelopeBuffer buf = envelope.envelopeBuffer();
                        envelope.releaseEnvelopeBuffer();
                        this.$outer.org$apache$pekko$remote$artery$Deserializer$$bufferPool.release(buf);
                    }
                }
            }

            public void onPull() {
                this.pull(this.$outer.in());
            }
        };
    }
}

