/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery;

import java.io.Serializable;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.Done;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.EmptyLocalActorRef;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.RemoteActorRefProvider;
import org.apache.pekko.remote.UniqueAddress;
import org.apache.pekko.remote.artery.ActorRefResolveCacheWithAddress;
import org.apache.pekko.remote.artery.ArterySettings;
import org.apache.pekko.remote.artery.Decoder$AdvertiseActorRefsCompressionTable$;
import org.apache.pekko.remote.artery.Decoder$AdvertiseClassManifestsCompressionTable$;
import org.apache.pekko.remote.artery.Decoder$RetryResolveRemoteDeployedRecipient$;
import org.apache.pekko.remote.artery.Decoder$Tick$;
import org.apache.pekko.remote.artery.EnvelopeBuffer;
import org.apache.pekko.remote.artery.HeaderBuilder;
import org.apache.pekko.remote.artery.HeaderBuilder$;
import org.apache.pekko.remote.artery.InboundContext;
import org.apache.pekko.remote.artery.InboundEnvelope;
import org.apache.pekko.remote.artery.ObjectPool;
import org.apache.pekko.remote.artery.OutboundContext;
import org.apache.pekko.remote.artery.ReusableInboundEnvelope;
import org.apache.pekko.remote.artery.compress.CompressionProtocol;
import org.apache.pekko.remote.artery.compress.CompressionProtocol$ActorRefCompressionAdvertisementAck$;
import org.apache.pekko.remote.artery.compress.CompressionProtocol$ClassManifestCompressionAdvertisementAck$;
import org.apache.pekko.remote.artery.compress.InboundCompressions;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.stream.stage.StageLogging;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public class Decoder
extends GraphStageWithMaterializedValue<FlowShape<EnvelopeBuffer, InboundEnvelope>, InboundCompressionAccess> {
    public final InboundContext org$apache$pekko$remote$artery$Decoder$$inboundContext;
    public final ExtendedActorSystem org$apache$pekko$remote$artery$Decoder$$system;
    public final UniqueAddress org$apache$pekko$remote$artery$Decoder$$uniqueLocalAddress;
    public final ArterySettings org$apache$pekko$remote$artery$Decoder$$settings;
    public final InboundCompressions org$apache$pekko$remote$artery$Decoder$$inboundCompressions;
    public final ObjectPool<ReusableInboundEnvelope> org$apache$pekko$remote$artery$Decoder$$inEnvelopePool;
    private final Inlet in;
    private final Outlet out;
    private final FlowShape shape;

    public Decoder(InboundContext inboundContext, ExtendedActorSystem system, UniqueAddress uniqueLocalAddress, ArterySettings settings, InboundCompressions inboundCompressions, ObjectPool<ReusableInboundEnvelope> inEnvelopePool) {
        this.org$apache$pekko$remote$artery$Decoder$$inboundContext = inboundContext;
        this.org$apache$pekko$remote$artery$Decoder$$system = system;
        this.org$apache$pekko$remote$artery$Decoder$$uniqueLocalAddress = uniqueLocalAddress;
        this.org$apache$pekko$remote$artery$Decoder$$settings = settings;
        this.org$apache$pekko$remote$artery$Decoder$$inboundCompressions = inboundCompressions;
        this.org$apache$pekko$remote$artery$Decoder$$inEnvelopePool = inEnvelopePool;
        this.in = Inlet$.MODULE$.apply("Artery.Decoder.in");
        this.out = Outlet$.MODULE$.apply("Artery.Decoder.out");
        this.shape = FlowShape$.MODULE$.apply(this.in(), this.out());
    }

    public Inlet<EnvelopeBuffer> in() {
        return this.in;
    }

    public Outlet<InboundEnvelope> out() {
        return this.out;
    }

    public FlowShape<EnvelopeBuffer, InboundEnvelope> shape() {
        return this.shape;
    }

    public Tuple2<GraphStageLogic, InboundCompressionAccess> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
        InboundCompressionAccessImpl logic = new InboundCompressionAccessImpl(this){
            private AsyncCallback org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$closeCompressionForCb;
            private AsyncCallback org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$confirmActorRefCompressionAdvertisementCb;
            private AsyncCallback org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$confirmClassManifestCompressionAdvertisementCb;
            private AsyncCallback org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$runNextActorRefAdvertisementCb;
            private AsyncCallback org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$runNextClassManifestAdvertisementCb;
            private AsyncCallback org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$currentCompressionOriginUidsCb;
            private LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log;
            private final InboundCompressions compressions;
            private final HeaderBuilder headerBuilder;
            private final ActorRefResolveCacheWithAddress actorRefResolver;
            private final HashSet bannedRemoteDeployedActorRefs;
            private final FiniteDuration retryResolveRemoteDeployedRecipientInterval;
            private final int retryResolveRemoteDeployedRecipientAttempts;
            private long messageCount;
            private int heavyHitterMask;
            private final int adaptiveSamplingRateThreshold;
            private long tickTimestamp;
            private long tickMessageCount;
            private final /* synthetic */ Decoder $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                InboundCompressionAccessImpl.$init$(this);
                StageLogging.$init$((StageLogging)this);
                this.compressions = $outer.org$apache$pekko$remote$artery$Decoder$$inboundCompressions;
                this.headerBuilder = HeaderBuilder$.MODULE$.in(this.compressions());
                this.actorRefResolver = new ActorRefResolveCacheWithAddress((RemoteActorRefProvider)$outer.org$apache$pekko$remote$artery$Decoder$$system.provider(), $outer.org$apache$pekko$remote$artery$Decoder$$uniqueLocalAddress);
                this.bannedRemoteDeployedActorRefs = new HashSet<E>();
                this.retryResolveRemoteDeployedRecipientInterval = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(50)).millis();
                this.retryResolveRemoteDeployedRecipientAttempts = 20;
                this.messageCount = 0L;
                this.heavyHitterMask = 0;
                this.adaptiveSamplingRateThreshold = 1000;
                this.tickTimestamp = System.nanoTime();
                this.tickMessageCount = 0L;
                this.setHandlers($outer.in(), $outer.out(), this);
                Statics.releaseFence();
            }

            public AsyncCallback org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$closeCompressionForCb() {
                return this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$closeCompressionForCb;
            }

            public AsyncCallback org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$confirmActorRefCompressionAdvertisementCb() {
                return this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$confirmActorRefCompressionAdvertisementCb;
            }

            public AsyncCallback org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$confirmClassManifestCompressionAdvertisementCb() {
                return this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$confirmClassManifestCompressionAdvertisementCb;
            }

            public AsyncCallback org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$runNextActorRefAdvertisementCb() {
                return this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$runNextActorRefAdvertisementCb;
            }

            public AsyncCallback org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$runNextClassManifestAdvertisementCb() {
                return this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$runNextClassManifestAdvertisementCb;
            }

            public AsyncCallback org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$currentCompressionOriginUidsCb() {
                return this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$currentCompressionOriginUidsCb;
            }

            public void org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$_setter_$org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$closeCompressionForCb_$eq(AsyncCallback x$0) {
                this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$closeCompressionForCb = x$0;
            }

            public void org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$_setter_$org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$confirmActorRefCompressionAdvertisementCb_$eq(AsyncCallback x$0) {
                this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$confirmActorRefCompressionAdvertisementCb = x$0;
            }

            public void org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$_setter_$org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$confirmClassManifestCompressionAdvertisementCb_$eq(AsyncCallback x$0) {
                this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$confirmClassManifestCompressionAdvertisementCb = x$0;
            }

            public void org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$_setter_$org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$runNextActorRefAdvertisementCb_$eq(AsyncCallback x$0) {
                this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$runNextActorRefAdvertisementCb = x$0;
            }

            public void org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$_setter_$org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$runNextClassManifestAdvertisementCb_$eq(AsyncCallback x$0) {
                this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$runNextClassManifestAdvertisementCb = x$0;
            }

            public void org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$_setter_$org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$currentCompressionOriginUidsCb_$eq(AsyncCallback x$0) {
                this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$currentCompressionOriginUidsCb = x$0;
            }

            public LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log() {
                return this.org$apache$pekko$stream$stage$StageLogging$$_log;
            }

            public void org$apache$pekko$stream$stage$StageLogging$$_log_$eq(LoggingAdapter x$1) {
                this.org$apache$pekko$stream$stage$StageLogging$$_log = x$1;
            }

            public InboundCompressions compressions() {
                return this.compressions;
            }

            public Class logSource() {
                return Decoder.class;
            }

            public void preStart() {
                FiniteDuration tickDelay = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds();
                this.scheduleWithFixedDelay(Decoder$Tick$.MODULE$, tickDelay, tickDelay);
                if (this.$outer.org$apache$pekko$remote$artery$Decoder$$settings.Advanced().Compression().ActorRefs().Enabled()) {
                    FiniteDuration d = this.$outer.org$apache$pekko$remote$artery$Decoder$$settings.Advanced().Compression().ActorRefs().AdvertisementInterval();
                    this.scheduleWithFixedDelay(Decoder$AdvertiseActorRefsCompressionTable$.MODULE$, d, d);
                }
                if (this.$outer.org$apache$pekko$remote$artery$Decoder$$settings.Advanced().Compression().Manifests().Enabled()) {
                    FiniteDuration d = this.$outer.org$apache$pekko$remote$artery$Decoder$$settings.Advanced().Compression().Manifests().AdvertisementInterval();
                    this.scheduleWithFixedDelay(Decoder$AdvertiseClassManifestsCompressionTable$.MODULE$, d, d);
                    return;
                }
            }

            public void onPush() {
                try {
                    String string;
                    String string2;
                    String classManifestOpt;
                    String string3;
                    InternalActorRef internalActorRef;
                    InternalActorRef internalActorRef2;
                    ++this.messageCount;
                    EnvelopeBuffer envelope = (EnvelopeBuffer)this.grab(this.$outer.in());
                    this.headerBuilder.resetMessageFields();
                    envelope.parseHeader(this.headerBuilder);
                    long originUid = this.headerBuilder.uid();
                    OutboundContext association = this.$outer.org$apache$pekko$remote$artery$Decoder$$inboundContext.association(originUid);
                    try {
                        ActorRef actorRef = this.headerBuilder.recipientActorRef(originUid);
                        ActorRef actorRef2 = (ActorRef)OptionVal.Some$.MODULE$.unapply((Object)actorRef);
                        if (!OptionVal$.MODULE$.isEmpty$extension((Object)actorRef2)) {
                            ActorRef actorRef3;
                            ActorRef ref = actorRef3 = (ActorRef)OptionVal$.MODULE$.get$extension((Object)actorRef2);
                            internalActorRef2 = (InternalActorRef)OptionVal$.MODULE$.apply((Object)((InternalActorRef)ref));
                        } else {
                            String string4;
                            OptionVal$.MODULE$.None();
                            ActorRef actorRef4 = actorRef;
                            if (!(null != null ? !((Object)null).equals(actorRef4) : actorRef4 != null) && OptionVal$.MODULE$.isDefined$extension((Object)(string4 = this.headerBuilder.recipientActorRefPath()))) {
                                String string5 = this.headerBuilder.recipientActorRefPath();
                                internalActorRef2 = this.resolveRecipient((String)OptionVal$.MODULE$.get$extension((Object)string5));
                            } else {
                                OptionVal$.MODULE$.None();
                                internalActorRef2 = null;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Option option;
                        Throwable throwable3 = throwable;
                        if (throwable3 == null || (option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                            throw throwable;
                        }
                        Throwable e = throwable2 = (Throwable)option.get();
                        this.log().warning("Couldn't decompress sender from originUid [{}]. {}", (Object)BoxesRunTime.boxToLong((long)originUid), (Object)e);
                        OptionVal$.MODULE$.None();
                        internalActorRef2 = null;
                    }
                    InternalActorRef recipient = internalActorRef2;
                    try {
                        ActorRef actorRef = this.headerBuilder.senderActorRef(originUid);
                        ActorRef actorRef5 = (ActorRef)OptionVal.Some$.MODULE$.unapply((Object)actorRef);
                        if (!OptionVal$.MODULE$.isEmpty$extension((Object)actorRef5)) {
                            ActorRef actorRef6;
                            ActorRef ref = actorRef6 = (ActorRef)OptionVal$.MODULE$.get$extension((Object)actorRef5);
                            internalActorRef = (InternalActorRef)OptionVal$.MODULE$.apply((Object)((InternalActorRef)ref));
                        } else {
                            String string6;
                            OptionVal$.MODULE$.None();
                            ActorRef actorRef7 = actorRef;
                            if (!(null != null ? !((Object)null).equals(actorRef7) : actorRef7 != null) && OptionVal$.MODULE$.isDefined$extension((Object)(string6 = this.headerBuilder.senderActorRefPath()))) {
                                String string7 = this.headerBuilder.senderActorRefPath();
                                internalActorRef = (InternalActorRef)OptionVal$.MODULE$.apply(this.actorRefResolver.resolve((String)OptionVal$.MODULE$.get$extension((Object)string7)));
                            } else {
                                OptionVal$.MODULE$.None();
                                internalActorRef = null;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable throwable4;
                        Option option;
                        Throwable throwable5 = throwable;
                        if (throwable5 == null || (option = NonFatal$.MODULE$.unapply(throwable5)).isEmpty()) {
                            throw throwable;
                        }
                        Throwable e = throwable4 = (Throwable)option.get();
                        this.log().warning("Couldn't decompress sender from originUid [{}]. {}", (Object)BoxesRunTime.boxToLong((long)originUid), (Object)e);
                        OptionVal$.MODULE$.None();
                        internalActorRef = null;
                    }
                    InternalActorRef sender = internalActorRef;
                    try {
                        string3 = this.headerBuilder.manifest(originUid);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable6;
                        Option option;
                        Throwable throwable7 = throwable;
                        if (throwable7 == null || (option = NonFatal$.MODULE$.unapply(throwable7)).isEmpty()) {
                            throw throwable;
                        }
                        Throwable e = throwable6 = (Throwable)option.get();
                        this.log().warning("Couldn't decompress manifest from originUid [{}]. {}", (Object)BoxesRunTime.boxToLong((long)originUid), (Object)e);
                        OptionVal$.MODULE$.None();
                        string3 = classManifestOpt = null;
                    }
                    if (OptionVal$.MODULE$.isEmpty$extension((Object)recipient) && OptionVal$.MODULE$.isEmpty$extension((Object)(string2 = this.headerBuilder.recipientActorRefPath())) && !this.headerBuilder.isNoRecipient() || OptionVal$.MODULE$.isEmpty$extension((Object)sender) && OptionVal$.MODULE$.isEmpty$extension((Object)(string = this.headerBuilder.senderActorRefPath())) && !this.headerBuilder.isNoSender()) {
                        this.log().debug("Dropping message for unknown recipient/sender. It was probably sent from system [{}] with compression table [{}] built for previous incarnation of the destination system, or it was compressed with a table that has already been discarded in the destination system.", (Object)BoxesRunTime.boxToLong((long)originUid), (Object)BoxesRunTime.boxToByte((byte)this.headerBuilder.inboundActorRefCompressionTableVersion()));
                        this.pull(this.$outer.in());
                    } else if (OptionVal$.MODULE$.isEmpty$extension((Object)classManifestOpt)) {
                        this.log().debug("Dropping message with unknown manifest. It was probably sent from system [{}] with compression table [{}] built for previous incarnation of the destination system, or it was compressed with a table that has already been discarded in the destination system.", (Object)BoxesRunTime.boxToLong((long)originUid), (Object)BoxesRunTime.boxToByte((byte)this.headerBuilder.inboundActorRefCompressionTableVersion()));
                        this.pull(this.$outer.in());
                    } else {
                        String classManifest = (String)OptionVal$.MODULE$.get$extension((Object)classManifestOpt);
                        if ((this.messageCount & (long)this.heavyHitterMask) == 0L) {
                            OutboundContext outboundContext = association;
                            OutboundContext outboundContext2 = (OutboundContext)OptionVal.Some$.MODULE$.unapply((Object)outboundContext);
                            if (!OptionVal$.MODULE$.isEmpty$extension((Object)outboundContext2)) {
                                OutboundContext outboundContext3;
                                OutboundContext assoc = outboundContext3 = (OutboundContext)OptionVal$.MODULE$.get$extension((Object)outboundContext2);
                                Address remoteAddress = assoc.remoteAddress();
                                if (OptionVal$.MODULE$.isDefined$extension((Object)sender)) {
                                    this.compressions().hitActorRef(originUid, remoteAddress, (ActorRef)((InternalActorRef)OptionVal$.MODULE$.get$extension((Object)sender)), 1);
                                }
                                if (OptionVal$.MODULE$.isDefined$extension((Object)recipient)) {
                                    this.compressions().hitActorRef(originUid, remoteAddress, (ActorRef)((InternalActorRef)OptionVal$.MODULE$.get$extension((Object)recipient)), 1);
                                }
                                this.compressions().hitClassManifest(originUid, remoteAddress, classManifest, 1);
                            } else {
                                this.log().debug("Decoded message but unable to record hits for compression as no remoteAddress known. No association yet?");
                            }
                        }
                        InboundEnvelope decoded = this.$outer.org$apache$pekko$remote$artery$Decoder$$inEnvelopePool.acquire().init(recipient, (ActorRef)sender, originUid, this.headerBuilder.serializer(), classManifest, this.headerBuilder.flags(), envelope, association, 0);
                        if (OptionVal$.MODULE$.isEmpty$extension((Object)recipient) && !this.headerBuilder.isNoRecipient()) {
                            String string8 = this.headerBuilder.recipientActorRefPath();
                            String recipientActorRefPath = (String)OptionVal$.MODULE$.get$extension((Object)string8);
                            if (this.bannedRemoteDeployedActorRefs.contains(recipientActorRefPath)) {
                                String string9 = this.headerBuilder.recipientActorRefPath();
                                String string10 = (String)OptionVal.Some$.MODULE$.unapply((Object)string9);
                                if (!OptionVal$.MODULE$.isEmpty$extension((Object)string10)) {
                                    String string11 = (String)OptionVal$.MODULE$.get$extension((Object)string10);
                                    String path = string11;
                                    InternalActorRef ref = (InternalActorRef)this.actorRefResolver.getOrCompute(path);
                                    if (ref instanceof EmptyLocalActorRef) {
                                        this.log().warning("Message for banned (terminated, unresolved) remote deployed recipient [{}].", (Object)recipientActorRefPath);
                                    }
                                    this.push(this.$outer.out(), decoded.withRecipient(ref));
                                } else {
                                    this.log().warning("Dropping message for banned (terminated, unresolved) remote deployed recipient [{}].", (Object)recipientActorRefPath);
                                    this.pull(this.$outer.in());
                                }
                            } else {
                                this.scheduleOnce(Decoder$RetryResolveRemoteDeployedRecipient$.MODULE$.apply(this.retryResolveRemoteDeployedRecipientAttempts, recipientActorRefPath, decoded), this.retryResolveRemoteDeployedRecipientInterval);
                            }
                        } else {
                            this.push(this.$outer.out(), decoded);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable8 = throwable;
                    if (throwable8 != null && !(option = NonFatal$.MODULE$.unapply(throwable8)).isEmpty()) {
                        Throwable throwable9;
                        Throwable e = throwable9 = (Throwable)option.get();
                        this.log().warning("Dropping message due to: {}", (Object)e);
                        this.pull(this.$outer.in());
                    }
                    throw throwable;
                }
            }

            private InternalActorRef resolveRecipient(String path) {
                InternalActorRef internalActorRef = (InternalActorRef)this.actorRefResolver.getOrCompute(path);
                if (internalActorRef instanceof EmptyLocalActorRef) {
                    EmptyLocalActorRef empty = (EmptyLocalActorRef)internalActorRef;
                    Iterable pathElements = empty.path().elements();
                    if (pathElements.nonEmpty()) {
                        Object object = pathElements.head();
                        String string = "remote";
                        if (!(object != null ? !object.equals(string) : string != null)) {
                            OptionVal$.MODULE$.None();
                            return null;
                        }
                    }
                    return (InternalActorRef)OptionVal$.MODULE$.apply((Object)empty);
                }
                InternalActorRef ref = internalActorRef;
                return (InternalActorRef)OptionVal$.MODULE$.apply((Object)ref);
            }

            public void onPull() {
                this.pull(this.$outer.in());
            }

            public void onTimer(Object timerKey) {
                Object object = timerKey;
                if (Decoder$Tick$.MODULE$.equals(object)) {
                    long now = System.nanoTime();
                    long d = package$.MODULE$.max(1L, now - this.tickTimestamp);
                    long rate = (this.messageCount - this.tickMessageCount) * TimeUnit.SECONDS.toNanos(1L) / d;
                    int oldHeavyHitterMask = this.heavyHitterMask;
                    int n = rate < (long)this.adaptiveSamplingRateThreshold ? 0 : (rate < (long)(this.adaptiveSamplingRateThreshold * 10) ? 63 : (this.heavyHitterMask = rate < (long)(this.adaptiveSamplingRateThreshold * 100) ? 127 : 255));
                    if (oldHeavyHitterMask > 0 && this.heavyHitterMask == 0) {
                        this.log().debug("Turning off adaptive sampling of compression hit counting");
                    } else if (oldHeavyHitterMask != this.heavyHitterMask) {
                        this.log().debug("Turning on adaptive sampling ({}nth message) of compression hit counting", (Object)BoxesRunTime.boxToInteger((int)(this.heavyHitterMask + 1)));
                    }
                    this.tickMessageCount = this.messageCount;
                    this.tickTimestamp = now;
                    return;
                }
                if (Decoder$AdvertiseActorRefsCompressionTable$.MODULE$.equals(object)) {
                    this.compressions().runNextActorRefAdvertisement();
                    return;
                }
                if (Decoder$AdvertiseClassManifestsCompressionTable$.MODULE$.equals(object)) {
                    this.compressions().runNextClassManifestAdvertisement();
                    return;
                }
                if (object instanceof RetryResolveRemoteDeployedRecipient) {
                    RetryResolveRemoteDeployedRecipient retryResolveRemoteDeployedRecipient = Decoder$RetryResolveRemoteDeployedRecipient$.MODULE$.unapply((RetryResolveRemoteDeployedRecipient)object);
                    int n = retryResolveRemoteDeployedRecipient._1();
                    String string = retryResolveRemoteDeployedRecipient._2();
                    InboundEnvelope inboundEnvelope = retryResolveRemoteDeployedRecipient._3();
                    int attemptsLeft = n;
                    String recipientPath = string;
                    InboundEnvelope inboundEnvelope2 = inboundEnvelope;
                    InternalActorRef internalActorRef = this.resolveRecipient(recipientPath);
                    InternalActorRef internalActorRef2 = (InternalActorRef)OptionVal.Some$.MODULE$.unapply((Object)internalActorRef);
                    if (!OptionVal$.MODULE$.isEmpty$extension((Object)internalActorRef2)) {
                        InternalActorRef internalActorRef3;
                        InternalActorRef recipient = internalActorRef3 = (InternalActorRef)OptionVal$.MODULE$.get$extension((Object)internalActorRef2);
                        this.push(this.$outer.out(), inboundEnvelope2.withRecipient(recipient));
                        return;
                    }
                    if (attemptsLeft > 0) {
                        this.scheduleOnce(Decoder$RetryResolveRemoteDeployedRecipient$.MODULE$.apply(attemptsLeft - 1, recipientPath, inboundEnvelope2), this.retryResolveRemoteDeployedRecipientInterval);
                        return;
                    }
                    if (this.bannedRemoteDeployedActorRefs.size() >= 100) {
                        this.bannedRemoteDeployedActorRefs.clear();
                    }
                    this.bannedRemoteDeployedActorRefs.add(recipientPath);
                    InternalActorRef recipient = (InternalActorRef)this.actorRefResolver.getOrCompute(recipientPath);
                    this.push(this.$outer.out(), inboundEnvelope2.withRecipient(recipient));
                    return;
                }
                Object unknown = object;
                throw new IllegalArgumentException(new StringBuilder(19).append("Unknown timer key: ").append(unknown).toString());
            }
        };
        return Tuple2$.MODULE$.apply((Object)logic, (Object)logic);
    }

    public static interface InboundCompressionAccess {
        public Future<Done> confirmActorRefCompressionAdvertisementAck(CompressionProtocol.ActorRefCompressionAdvertisementAck var1);

        public Future<Done> confirmClassManifestCompressionAdvertisementAck(CompressionProtocol.ClassManifestCompressionAdvertisementAck var1);

        public Future<Done> closeCompressionFor(long var1);

        public void runNextActorRefAdvertisement();

        public void runNextClassManifestAdvertisement();

        public Future<Set<Object>> currentCompressionOriginUids();
    }

    public static interface InboundCompressionAccessImpl
    extends InboundCompressionAccess {
        public static void $init$(InboundCompressionAccessImpl $this) {
            $this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$_setter_$org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$closeCompressionForCb_$eq(((GraphStageLogic)$this).getAsyncCallback((Function1)(JFunction1.mcVJ.sp & Serializable)uid -> this.compressions().close(uid)));
            $this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$_setter_$org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$confirmActorRefCompressionAdvertisementCb_$eq(((GraphStageLogic)$this).getAsyncCallback((Function1)(JProcedure1 & Serializable)x$1 -> {
                CompressionProtocol.ActorRefCompressionAdvertisementAck actorRefCompressionAdvertisementAck = x$1;
                if (actorRefCompressionAdvertisementAck != null) {
                    CompressionProtocol.ActorRefCompressionAdvertisementAck actorRefCompressionAdvertisementAck2 = CompressionProtocol$ActorRefCompressionAdvertisementAck$.MODULE$.unapply(actorRefCompressionAdvertisementAck);
                    UniqueAddress uniqueAddress = actorRefCompressionAdvertisementAck2._1();
                    byte by = actorRefCompressionAdvertisementAck2._2();
                    UniqueAddress from = uniqueAddress;
                    byte tableVersion = by;
                    this.compressions().confirmActorRefCompressionAdvertisement(from.uid(), tableVersion);
                    return;
                }
                throw new MatchError((Object)actorRefCompressionAdvertisementAck);
            }));
            $this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$_setter_$org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$confirmClassManifestCompressionAdvertisementCb_$eq(((GraphStageLogic)$this).getAsyncCallback((Function1)(JProcedure1 & Serializable)x$1 -> {
                CompressionProtocol.ClassManifestCompressionAdvertisementAck classManifestCompressionAdvertisementAck = x$1;
                if (classManifestCompressionAdvertisementAck != null) {
                    CompressionProtocol.ClassManifestCompressionAdvertisementAck classManifestCompressionAdvertisementAck2 = CompressionProtocol$ClassManifestCompressionAdvertisementAck$.MODULE$.unapply(classManifestCompressionAdvertisementAck);
                    UniqueAddress uniqueAddress = classManifestCompressionAdvertisementAck2._1();
                    byte by = classManifestCompressionAdvertisementAck2._2();
                    UniqueAddress from = uniqueAddress;
                    byte tableVersion = by;
                    this.compressions().confirmClassManifestCompressionAdvertisement(from.uid(), tableVersion);
                    return;
                }
                throw new MatchError((Object)classManifestCompressionAdvertisementAck);
            }));
            $this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$_setter_$org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$runNextActorRefAdvertisementCb_$eq(((GraphStageLogic)$this).getAsyncCallback((Function1)(JProcedure1 & Serializable)_$2 -> this.compressions().runNextActorRefAdvertisement()));
            $this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$_setter_$org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$runNextClassManifestAdvertisementCb_$eq(((GraphStageLogic)$this).getAsyncCallback((Function1)(JProcedure1 & Serializable)_$3 -> this.compressions().runNextClassManifestAdvertisement()));
            $this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$_setter_$org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$currentCompressionOriginUidsCb_$eq(((GraphStageLogic)$this).getAsyncCallback((Function1)(JProcedure1 & Serializable)p -> p.success(this.compressions().currentOriginUids())));
        }

        public InboundCompressions compressions();

        public AsyncCallback<Object> org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$closeCompressionForCb();

        public void org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$_setter_$org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$closeCompressionForCb_$eq(AsyncCallback var1);

        public AsyncCallback<CompressionProtocol.ActorRefCompressionAdvertisementAck> org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$confirmActorRefCompressionAdvertisementCb();

        public void org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$_setter_$org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$confirmActorRefCompressionAdvertisementCb_$eq(AsyncCallback var1);

        public AsyncCallback<CompressionProtocol.ClassManifestCompressionAdvertisementAck> org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$confirmClassManifestCompressionAdvertisementCb();

        public void org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$_setter_$org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$confirmClassManifestCompressionAdvertisementCb_$eq(AsyncCallback var1);

        public AsyncCallback<BoxedUnit> org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$runNextActorRefAdvertisementCb();

        public void org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$_setter_$org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$runNextActorRefAdvertisementCb_$eq(AsyncCallback var1);

        public AsyncCallback<BoxedUnit> org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$runNextClassManifestAdvertisementCb();

        public void org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$_setter_$org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$runNextClassManifestAdvertisementCb_$eq(AsyncCallback var1);

        public AsyncCallback<Promise<Set<Object>>> org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$currentCompressionOriginUidsCb();

        public void org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$_setter_$org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$currentCompressionOriginUidsCb_$eq(AsyncCallback var1);

        public static Future closeCompressionFor$(InboundCompressionAccessImpl $this, long originUid) {
            return $this.closeCompressionFor(originUid);
        }

        @Override
        default public Future<Done> closeCompressionFor(long originUid) {
            return this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$closeCompressionForCb().invokeWithFeedback((Object)BoxesRunTime.boxToLong((long)originUid));
        }

        public static Future confirmActorRefCompressionAdvertisementAck$(InboundCompressionAccessImpl $this, CompressionProtocol.ActorRefCompressionAdvertisementAck ack) {
            return $this.confirmActorRefCompressionAdvertisementAck(ack);
        }

        @Override
        default public Future<Done> confirmActorRefCompressionAdvertisementAck(CompressionProtocol.ActorRefCompressionAdvertisementAck ack) {
            return this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$confirmActorRefCompressionAdvertisementCb().invokeWithFeedback((Object)ack);
        }

        public static Future confirmClassManifestCompressionAdvertisementAck$(InboundCompressionAccessImpl $this, CompressionProtocol.ClassManifestCompressionAdvertisementAck ack) {
            return $this.confirmClassManifestCompressionAdvertisementAck(ack);
        }

        @Override
        default public Future<Done> confirmClassManifestCompressionAdvertisementAck(CompressionProtocol.ClassManifestCompressionAdvertisementAck ack) {
            return this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$confirmClassManifestCompressionAdvertisementCb().invokeWithFeedback((Object)ack);
        }

        public static void runNextActorRefAdvertisement$(InboundCompressionAccessImpl $this) {
            $this.runNextActorRefAdvertisement();
        }

        @Override
        default public void runNextActorRefAdvertisement() {
            this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$runNextActorRefAdvertisementCb().invoke((Object)BoxedUnit.UNIT);
        }

        public static void runNextClassManifestAdvertisement$(InboundCompressionAccessImpl $this) {
            $this.runNextClassManifestAdvertisement();
        }

        @Override
        default public void runNextClassManifestAdvertisement() {
            this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$runNextClassManifestAdvertisementCb().invoke((Object)BoxedUnit.UNIT);
        }

        public static Future currentCompressionOriginUids$(InboundCompressionAccessImpl $this) {
            return $this.currentCompressionOriginUids();
        }

        @Override
        default public Future<Set<Object>> currentCompressionOriginUids() {
            Promise p = Promise$.MODULE$.apply();
            this.org$apache$pekko$remote$artery$Decoder$InboundCompressionAccessImpl$$currentCompressionOriginUidsCb().invoke((Object)p);
            return p.future();
        }
    }

    public static final class RetryResolveRemoteDeployedRecipient
    implements Product,
    Serializable {
        private final int attemptsLeft;
        private final String recipientPath;
        private final InboundEnvelope inboundEnvelope;

        public static RetryResolveRemoteDeployedRecipient apply(int n, String string, InboundEnvelope inboundEnvelope) {
            return Decoder$RetryResolveRemoteDeployedRecipient$.MODULE$.apply(n, string, inboundEnvelope);
        }

        public static RetryResolveRemoteDeployedRecipient fromProduct(Product product) {
            return Decoder$RetryResolveRemoteDeployedRecipient$.MODULE$.fromProduct(product);
        }

        public static RetryResolveRemoteDeployedRecipient unapply(RetryResolveRemoteDeployedRecipient retryResolveRemoteDeployedRecipient) {
            return Decoder$RetryResolveRemoteDeployedRecipient$.MODULE$.unapply(retryResolveRemoteDeployedRecipient);
        }

        public RetryResolveRemoteDeployedRecipient(int attemptsLeft, String recipientPath, InboundEnvelope inboundEnvelope) {
            this.attemptsLeft = attemptsLeft;
            this.recipientPath = recipientPath;
            this.inboundEnvelope = inboundEnvelope;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.attemptsLeft());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.recipientPath()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.inboundEnvelope()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RetryResolveRemoteDeployedRecipient)) return false;
            RetryResolveRemoteDeployedRecipient retryResolveRemoteDeployedRecipient = (RetryResolveRemoteDeployedRecipient)object;
            if (this.attemptsLeft() != retryResolveRemoteDeployedRecipient.attemptsLeft()) return false;
            String string = this.recipientPath();
            String string2 = retryResolveRemoteDeployedRecipient.recipientPath();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            InboundEnvelope inboundEnvelope = this.inboundEnvelope();
            InboundEnvelope inboundEnvelope2 = retryResolveRemoteDeployedRecipient.inboundEnvelope();
            if (inboundEnvelope == null) {
                if (inboundEnvelope2 == null) return true;
                return false;
            } else {
                if (!inboundEnvelope.equals(inboundEnvelope2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RetryResolveRemoteDeployedRecipient;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "RetryResolveRemoteDeployedRecipient";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "attemptsLeft";
                }
                case 1: {
                    return "recipientPath";
                }
                case 2: {
                    return "inboundEnvelope";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int attemptsLeft() {
            return this.attemptsLeft;
        }

        public String recipientPath() {
            return this.recipientPath;
        }

        public InboundEnvelope inboundEnvelope() {
            return this.inboundEnvelope;
        }

        public RetryResolveRemoteDeployedRecipient copy(int attemptsLeft, String recipientPath, InboundEnvelope inboundEnvelope) {
            return new RetryResolveRemoteDeployedRecipient(attemptsLeft, recipientPath, inboundEnvelope);
        }

        public int copy$default$1() {
            return this.attemptsLeft();
        }

        public String copy$default$2() {
            return this.recipientPath();
        }

        public InboundEnvelope copy$default$3() {
            return this.inboundEnvelope();
        }

        public int _1() {
            return this.attemptsLeft();
        }

        public String _2() {
            return this.recipientPath();
        }

        public InboundEnvelope _3() {
            return this.inboundEnvelope();
        }
    }
}

