/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.OneForOneStrategy$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.Ack;
import org.apache.pekko.remote.AckedSendBuffer;
import org.apache.pekko.remote.AckedSendBuffer$;
import org.apache.pekko.remote.AssociationProblem;
import org.apache.pekko.remote.EndpointManager;
import org.apache.pekko.remote.EndpointManager$Link$;
import org.apache.pekko.remote.EndpointManager$Send$;
import org.apache.pekko.remote.EndpointWriter;
import org.apache.pekko.remote.EndpointWriter$;
import org.apache.pekko.remote.EndpointWriter$FlushAndStop$;
import org.apache.pekko.remote.EndpointWriter$StopReading$;
import org.apache.pekko.remote.EndpointWriter$StoppedReading$;
import org.apache.pekko.remote.HopelessAssociation;
import org.apache.pekko.remote.RARP;
import org.apache.pekko.remote.RARP$;
import org.apache.pekko.remote.ReliableDeliverySupervisor$;
import org.apache.pekko.remote.ReliableDeliverySupervisor$AttemptSysMsgRedelivery$;
import org.apache.pekko.remote.ReliableDeliverySupervisor$GotUid$;
import org.apache.pekko.remote.ReliableDeliverySupervisor$Idle$;
import org.apache.pekko.remote.ReliableDeliverySupervisor$IsIdle$;
import org.apache.pekko.remote.ReliableDeliverySupervisor$TooLongIdle$;
import org.apache.pekko.remote.ReliableDeliverySupervisor$Ungate$;
import org.apache.pekko.remote.RemoteActorRef;
import org.apache.pekko.remote.RemoteSettings;
import org.apache.pekko.remote.SeqNo;
import org.apache.pekko.remote.SeqNo$;
import org.apache.pekko.remote.transport.PekkoPduCodec;
import org.apache.pekko.remote.transport.PekkoPduProtobufCodec$;
import org.apache.pekko.remote.transport.PekkoProtocolHandle;
import org.apache.pekko.remote.transport.PekkoProtocolTransport;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public class ReliableDeliverySupervisor
implements Actor,
ActorLogging {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private final Address localAddress;
    private final Address remoteAddress;
    private final Option refuseUid;
    private final PekkoProtocolTransport transport;
    private final RemoteSettings settings;
    private final PekkoPduCodec codec;
    private final ConcurrentHashMap receiveBuffers;
    private final Cancellable autoResendTimer;
    private final SupervisorStrategy supervisorStrategy;
    private Option currentHandle;
    private AckedSendBuffer resendBuffer;
    private long seqCounter;
    private ActorRef writer;
    private Option uid;
    private Option bailoutAt;
    private Option maxSilenceTimer;
    private boolean uidConfirmed;

    public static Props props(Option<PekkoProtocolHandle> option, Address address, Address address2, Option<Object> option2, PekkoProtocolTransport pekkoProtocolTransport, RemoteSettings remoteSettings, PekkoPduCodec pekkoPduCodec, ConcurrentHashMap<EndpointManager.Link, EndpointManager.ResendState> concurrentHashMap) {
        return ReliableDeliverySupervisor$.MODULE$.props(option, address, address2, option2, pekkoProtocolTransport, remoteSettings, pekkoPduCodec, concurrentHashMap);
    }

    /*
     * Unable to fully structure code
     */
    public ReliableDeliverySupervisor(Option<PekkoProtocolHandle> handleOrActive, Address localAddress, Address remoteAddress, Option<Object> refuseUid, PekkoProtocolTransport transport, RemoteSettings settings, PekkoPduCodec codec, ConcurrentHashMap<EndpointManager.Link, EndpointManager.ResendState> receiveBuffers) {
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.refuseUid = refuseUid;
        this.transport = transport;
        this.settings = settings;
        this.codec = codec;
        this.receiveBuffers = receiveBuffers;
        super();
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.autoResendTimer = this.context().system().scheduler().scheduleWithFixedDelay(settings.SysResendTimeout(), settings.SysResendTimeout(), this.self(), (Object)ReliableDeliverySupervisor$AttemptSysMsgRedelivery$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.supervisorStrategy = OneForOneStrategy$.MODULE$.apply(OneForOneStrategy$.MODULE$.$lessinit$greater$default$1(), OneForOneStrategy$.MODULE$.$lessinit$greater$default$2(), false, (PartialFunction)new Serializable(this){
            private final /* synthetic */ ReliableDeliverySupervisor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Option option;
                Throwable throwable = x;
                if (throwable instanceof AssociationProblem) {
                    return true;
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable e = throwable2 = (Throwable)option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option option;
                Throwable throwable = x;
                if (throwable instanceof AssociationProblem) {
                    return SupervisorStrategy.Escalate$.MODULE$;
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2 = (Throwable)option.get();
                    Throwable e = throwable2;
                    String causedBy = e.getCause() == null ? "" : new StringBuilder(13).append("Caused by: [").append(e.getCause().getMessage()).append("]").toString();
                    this.$outer.log().warning("Association with remote system [{}] has failed, address is now gated for [{}] ms. Reason: [{}] {}", (Object)this.$outer.remoteAddress(), (Object)BoxesRunTime.boxToLong((long)this.$outer.settings().RetryGateClosedFor().toMillis()), (Object)e.getMessage(), (Object)causedBy);
                    this.$outer.uidConfirmed_$eq(false);
                    if ((this.$outer.resendBuffer().nacked().nonEmpty() || this.$outer.resendBuffer().nonAcked().nonEmpty()) && this.$outer.bailoutAt().isEmpty()) {
                        this.$outer.bailoutAt_$eq((Option<Deadline>)Some$.MODULE$.apply((Object)Deadline$.MODULE$.now().$plus(this.$outer.settings().InitialSysMsgDeliveryTimeout())));
                    }
                    this.$outer.context().become(this.$outer.gated(false, false));
                    this.$outer.currentHandle_$eq((Option<PekkoProtocolHandle>)None$.MODULE$);
                    this.$outer.context().parent().$bang((Object)EndpointWriter$StoppedReading$.MODULE$.apply(this.$outer.self()), this.$outer.self());
                    return SupervisorStrategy.Stop$.MODULE$;
                }
                return function1.apply((Object)x);
            }
        });
        this.currentHandle = handleOrActive;
        this.reset();
        this.writer = this.org$apache$pekko$remote$ReliableDeliverySupervisor$$createWriter();
        this.uid = handleOrActive.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $init$$$anonfun$1(org.apache.pekko.remote.transport.PekkoProtocolHandle ), (Lorg/apache/pekko/remote/transport/PekkoProtocolHandle;)I)());
        this.bailoutAt = None$.MODULE$;
        this.maxSilenceTimer = None$.MODULE$;
        if (!this.uid().isDefined()) ** GOTO lbl-1000
        v0 = this.uid();
        var9_9 = refuseUid;
        if (v0 == null ? var9_9 != null : v0.equals(var9_9) == false) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = this.uidConfirmed = false;
        }
        if (this.uid().isDefined()) {
            v2 = this.uid();
            var10_10 = refuseUid;
            if (!(v2 != null ? v2.equals(var10_10) == false : var10_10 != null)) {
                throw new HopelessAssociation(localAddress, remoteAddress, this.uid(), new IllegalStateException(new StringBuilder(81).append("The remote system [").append(remoteAddress).append("] has a UID [").append(this.uid().get()).append("] that has been quarantined. Association aborted.").toString()));
            }
        }
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public Address localAddress() {
        return this.localAddress;
    }

    public Address remoteAddress() {
        return this.remoteAddress;
    }

    public Option<Object> refuseUid() {
        return this.refuseUid;
    }

    public PekkoProtocolTransport transport() {
        return this.transport;
    }

    public RemoteSettings settings() {
        return this.settings;
    }

    public PekkoPduCodec codec() {
        return this.codec;
    }

    public ConcurrentHashMap<EndpointManager.Link, EndpointManager.ResendState> receiveBuffers() {
        return this.receiveBuffers;
    }

    public Cancellable autoResendTimer() {
        return this.autoResendTimer;
    }

    public SupervisorStrategy supervisorStrategy() {
        return this.supervisorStrategy;
    }

    public Option<PekkoProtocolHandle> currentHandle() {
        return this.currentHandle;
    }

    public void currentHandle_$eq(Option<PekkoProtocolHandle> x$1) {
        this.currentHandle = x$1;
    }

    public AckedSendBuffer<EndpointManager.Send> resendBuffer() {
        return this.resendBuffer;
    }

    public void resendBuffer_$eq(AckedSendBuffer<EndpointManager.Send> x$1) {
        this.resendBuffer = x$1;
    }

    public long seqCounter() {
        return this.seqCounter;
    }

    public void seqCounter_$eq(long x$1) {
        this.seqCounter = x$1;
    }

    public void reset() {
        this.resendBuffer_$eq(new AckedSendBuffer<EndpointManager.Send>(this.settings().SysMsgBufferSize(), (IndexedSeq<EndpointManager.Send>)AckedSendBuffer$.MODULE$.$lessinit$greater$default$2(), (IndexedSeq<EndpointManager.Send>)AckedSendBuffer$.MODULE$.$lessinit$greater$default$3(), AckedSendBuffer$.MODULE$.$lessinit$greater$default$4()));
        this.seqCounter_$eq(0L);
        this.bailoutAt_$eq((Option<Deadline>)None$.MODULE$);
    }

    public SeqNo nextSeq() {
        long tmp = this.seqCounter();
        this.seqCounter_$eq(this.seqCounter() + 1L);
        return SeqNo$.MODULE$.apply(tmp);
    }

    public ActorRef writer() {
        return this.writer;
    }

    public void writer_$eq(ActorRef x$1) {
        this.writer = x$1;
    }

    public Option<Object> uid() {
        return this.uid;
    }

    public void uid_$eq(Option<Object> x$1) {
        this.uid = x$1;
    }

    public Option<Deadline> bailoutAt() {
        return this.bailoutAt;
    }

    public void bailoutAt_$eq(Option<Deadline> x$1) {
        this.bailoutAt = x$1;
    }

    public Option<Cancellable> maxSilenceTimer() {
        return this.maxSilenceTimer;
    }

    public void maxSilenceTimer_$eq(Option<Cancellable> x$1) {
        this.maxSilenceTimer = x$1;
    }

    public boolean uidConfirmed() {
        return this.uidConfirmed;
    }

    public void uidConfirmed_$eq(boolean x$1) {
        this.uidConfirmed = x$1;
    }

    public void postStop() {
        ((IterableOnceOps)this.resendBuffer().nacked().$plus$plus(this.resendBuffer().nonAcked())).foreach((Function1)(JProcedure1 & Serializable)s -> {
            None$ none$ = None$.MODULE$;
            Object object = s.copy$default$1();
            ActorRef actorRef = s.copy$default$2();
            RemoteActorRef remoteActorRef = s.copy$default$3();
            this.context().system().deadLetters().$bang((Object)s.copy(object, actorRef, remoteActorRef, (Option<SeqNo>)none$), this.self());
        });
        this.receiveBuffers().remove(EndpointManager$Link$.MODULE$.apply(this.localAddress(), this.remoteAddress()));
        this.autoResendTimer().cancel();
        this.maxSilenceTimer().foreach((Function1 & Serializable)_$4 -> _$4.cancel());
    }

    public void postRestart(Throwable reason) {
        throw new IllegalStateException("BUG: ReliableDeliverySupervisor has been attempted to be restarted. This must not happen.");
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ ReliableDeliverySupervisor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (EndpointWriter$FlushAndStop$.MODULE$.equals(object)) {
                    return true;
                }
                if (ReliableDeliverySupervisor$IsIdle$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof EndpointManager.Send) {
                    EndpointManager.Send s = (EndpointManager.Send)object;
                    return true;
                }
                if (object instanceof Ack) {
                    Ack ack = (Ack)object;
                    return true;
                }
                if (ReliableDeliverySupervisor$AttemptSysMsgRedelivery$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    return true;
                }
                if (object instanceof GotUid) {
                    GotUid gotUid = (GotUid)object;
                    GotUid gotUid2 = ReliableDeliverySupervisor$GotUid$.MODULE$.unapply(gotUid);
                    int n = gotUid2._1();
                    Address address = gotUid2._2();
                    int receivedUid = n;
                    GotUid g = gotUid;
                    return true;
                }
                if (object instanceof EndpointWriter.StopReading) {
                    EndpointWriter.StopReading s = (EndpointWriter.StopReading)object;
                    return true;
                }
                return ReliableDeliverySupervisor$Ungate$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (EndpointWriter$FlushAndStop$.MODULE$.equals(object)) {
                    this.$outer.org$apache$pekko$remote$ReliableDeliverySupervisor$$resendAll();
                    this.$outer.writer().$bang((Object)EndpointWriter$FlushAndStop$.MODULE$, this.$outer.self());
                    this.$outer.context().become(this.$outer.flushWait());
                    return BoxedUnit.UNIT;
                }
                if (ReliableDeliverySupervisor$IsIdle$.MODULE$.equals(object)) {
                    return BoxedUnit.UNIT;
                }
                if (object instanceof EndpointManager.Send) {
                    EndpointManager.Send s = (EndpointManager.Send)object;
                    this.$outer.org$apache$pekko$remote$ReliableDeliverySupervisor$$handleSend(s);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Ack) {
                    Ack ack = (Ack)object;
                    if (this.$outer.uidConfirmed()) {
                        try {
                            this.$outer.resendBuffer_$eq(this.$outer.resendBuffer().acknowledge(ack));
                        }
                        catch (Throwable throwable) {
                            Option option;
                            Throwable throwable2 = throwable;
                            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                Throwable throwable3;
                                Throwable e = throwable3 = (Throwable)option.get();
                                throw new HopelessAssociation(this.$outer.localAddress(), this.$outer.remoteAddress(), this.$outer.uid(), new IllegalStateException(new StringBuilder(50).append("Error encountered while processing system message ").append(new StringBuilder(30).append("acknowledgement buffer: ").append(this.$outer.resendBuffer()).append(" ack: ").append(ack).toString()).toString(), e));
                            }
                            throw throwable;
                        }
                        this.$outer.org$apache$pekko$remote$ReliableDeliverySupervisor$$resendNacked();
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (ReliableDeliverySupervisor$AttemptSysMsgRedelivery$.MODULE$.equals(object)) {
                    if (this.$outer.uidConfirmed()) {
                        this.$outer.org$apache$pekko$remote$ReliableDeliverySupervisor$$resendAll();
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    this.$outer.currentHandle_$eq((Option<PekkoProtocolHandle>)None$.MODULE$);
                    this.$outer.context().parent().$bang((Object)EndpointWriter$StoppedReading$.MODULE$.apply(this.$outer.self()), this.$outer.self());
                    if (this.$outer.resendBuffer().nonAcked().nonEmpty() || this.$outer.resendBuffer().nacked().nonEmpty()) {
                        this.$outer.context().system().scheduler().scheduleOnce(this.$outer.settings().SysResendTimeout(), this.$outer.self(), (Object)ReliableDeliverySupervisor$AttemptSysMsgRedelivery$.MODULE$, (ExecutionContext)this.$outer.context().dispatcher(), this.$outer.self());
                    }
                    this.$outer.org$apache$pekko$remote$ReliableDeliverySupervisor$$goToIdle();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof GotUid) {
                    GotUid gotUid = (GotUid)object;
                    GotUid gotUid2 = ReliableDeliverySupervisor$GotUid$.MODULE$.unapply(gotUid);
                    int n = gotUid2._1();
                    Address address = gotUid2._2();
                    int receivedUid = n;
                    GotUid g = gotUid;
                    this.$outer.bailoutAt_$eq((Option<Deadline>)None$.MODULE$);
                    this.$outer.context().parent().$bang((Object)g, this.$outer.self());
                    this.$outer.uidConfirmed_$eq(true);
                    if (this.$outer.uid().exists((Function1)((JFunction1.mcZI.sp & Serializable)arg_0 -> ReliableDeliverySupervisor.org$apache$pekko$remote$ReliableDeliverySupervisor$$anon$2$$_$applyOrElse$$anonfun$1(receivedUid, arg_0)))) {
                        this.$outer.reset();
                    }
                    this.$outer.uid_$eq((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)receivedUid)));
                    this.$outer.org$apache$pekko$remote$ReliableDeliverySupervisor$$resendAll();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof EndpointWriter.StopReading) {
                    EndpointWriter.StopReading s = (EndpointWriter.StopReading)object;
                    this.$outer.writer().forward((Object)s, this.$outer.context());
                    return BoxedUnit.UNIT;
                }
                if (ReliableDeliverySupervisor$Ungate$.MODULE$.equals(object)) {
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$remote$ReliableDeliverySupervisor$$anon$2$$_$applyOrElse$$anonfun$1(int int )}, serializedLambda);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> gated(boolean writerTerminated, boolean earlyUngateRequested) {
        return new Serializable(writerTerminated, earlyUngateRequested, this){
            private final boolean writerTerminated$1;
            private final boolean earlyUngateRequested$1;
            private final /* synthetic */ ReliableDeliverySupervisor $outer;
            {
                this.writerTerminated$1 = writerTerminated$2;
                this.earlyUngateRequested$1 = earlyUngateRequested$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    if (!this.writerTerminated$1) {
                        return true;
                    }
                }
                if (ReliableDeliverySupervisor$IsIdle$.MODULE$.equals(object)) {
                    return true;
                }
                if (ReliableDeliverySupervisor$Ungate$.MODULE$.equals(object)) {
                    return true;
                }
                if (ReliableDeliverySupervisor$AttemptSysMsgRedelivery$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof EndpointManager.Send) {
                    EndpointManager.Send send = (EndpointManager.Send)object;
                    EndpointManager.Send send2 = EndpointManager$Send$.MODULE$.unapply(send);
                    Object object2 = send2._1();
                    ActorRef actorRef = send2._2();
                    RemoteActorRef remoteActorRef = send2._3();
                    Option<SeqNo> option = send2._4();
                    if (object2 instanceof SystemMessage) {
                        EndpointManager.Send s = send;
                        return true;
                    }
                    EndpointManager.Send s = send;
                    return true;
                }
                if (EndpointWriter$FlushAndStop$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof EndpointWriter.StopReading) {
                    EndpointWriter.StopReading stopReading = EndpointWriter$StopReading$.MODULE$.unapply((EndpointWriter.StopReading)object);
                    ActorRef actorRef = stopReading._1();
                    ActorRef actorRef2 = stopReading._2();
                    ActorRef w = actorRef;
                    ActorRef replyTo = actorRef2;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    if (!this.writerTerminated$1) {
                        BoxedUnit boxedUnit;
                        if (this.earlyUngateRequested$1) {
                            this.$outer.self().$bang((Object)ReliableDeliverySupervisor$Ungate$.MODULE$, this.$outer.self());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = this.$outer.context().system().scheduler().scheduleOnce(this.$outer.settings().RetryGateClosedFor(), this.$outer.self(), (Object)ReliableDeliverySupervisor$Ungate$.MODULE$, (ExecutionContext)this.$outer.context().dispatcher(), this.$outer.self());
                        }
                        this.$outer.context().become(this.$outer.gated(true, this.earlyUngateRequested$1));
                        return BoxedUnit.UNIT;
                    }
                }
                if (ReliableDeliverySupervisor$IsIdle$.MODULE$.equals(object)) {
                    this.$outer.sender().$bang((Object)ReliableDeliverySupervisor$Idle$.MODULE$, this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (ReliableDeliverySupervisor$Ungate$.MODULE$.equals(object)) {
                    if (!this.writerTerminated$1) {
                        this.$outer.context().become(this.$outer.gated(false, true));
                        return BoxedUnit.UNIT;
                    }
                    if (this.$outer.resendBuffer().nonAcked().nonEmpty() || this.$outer.resendBuffer().nacked().nonEmpty()) {
                        if (this.$outer.bailoutAt().exists(ReliableDeliverySupervisor::org$apache$pekko$remote$ReliableDeliverySupervisor$$anon$3$$_$applyOrElse$$anonfun$2)) {
                            throw new HopelessAssociation(this.$outer.localAddress(), this.$outer.remoteAddress(), this.$outer.uid(), new TimeoutException("Delivery of system messages timed out and they were dropped."));
                        }
                        this.$outer.writer_$eq(this.$outer.org$apache$pekko$remote$ReliableDeliverySupervisor$$createWriter());
                        this.$outer.org$apache$pekko$remote$ReliableDeliverySupervisor$$goToActive();
                        return BoxedUnit.UNIT;
                    }
                    this.$outer.org$apache$pekko$remote$ReliableDeliverySupervisor$$goToIdle();
                    return BoxedUnit.UNIT;
                }
                if (ReliableDeliverySupervisor$AttemptSysMsgRedelivery$.MODULE$.equals(object)) {
                    return BoxedUnit.UNIT;
                }
                if (object instanceof EndpointManager.Send) {
                    EndpointManager.Send send = (EndpointManager.Send)object;
                    EndpointManager.Send send2 = EndpointManager$Send$.MODULE$.unapply(send);
                    Object object2 = send2._1();
                    ActorRef actorRef = send2._2();
                    RemoteActorRef remoteActorRef = send2._3();
                    Option<SeqNo> option = send2._4();
                    if (object2 instanceof SystemMessage) {
                        EndpointManager.Send s = send;
                        Some some = Some$.MODULE$.apply((Object)this.$outer.nextSeq());
                        Object object3 = s.copy$default$1();
                        ActorRef actorRef2 = s.copy$default$2();
                        RemoteActorRef remoteActorRef2 = s.copy$default$3();
                        this.$outer.org$apache$pekko$remote$ReliableDeliverySupervisor$$tryBuffer(s.copy(object3, actorRef2, remoteActorRef2, (Option<SeqNo>)some));
                        return BoxedUnit.UNIT;
                    }
                    EndpointManager.Send s = send;
                    this.$outer.context().system().deadLetters().$bang((Object)s, this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (EndpointWriter$FlushAndStop$.MODULE$.equals(object)) {
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof EndpointWriter.StopReading) {
                    EndpointWriter.StopReading stopReading = EndpointWriter$StopReading$.MODULE$.unapply((EndpointWriter.StopReading)object);
                    ActorRef actorRef = stopReading._1();
                    ActorRef actorRef3 = stopReading._2();
                    ActorRef w = actorRef;
                    ActorRef replyTo = actorRef3;
                    replyTo.$bang((Object)EndpointWriter$StoppedReading$.MODULE$.apply(w), this.$outer.self());
                    this.$outer.sender().$bang((Object)EndpointWriter$StoppedReading$.MODULE$.apply(w), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$remote$ReliableDeliverySupervisor$$anon$3$$_$applyOrElse$$anonfun$2(scala.concurrent.duration.Deadline )}, serializedLambda);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> idle() {
        return new Serializable(this){
            private final /* synthetic */ ReliableDeliverySupervisor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (ReliableDeliverySupervisor$IsIdle$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof EndpointManager.Send) {
                    EndpointManager.Send s = (EndpointManager.Send)object;
                    return true;
                }
                if (ReliableDeliverySupervisor$AttemptSysMsgRedelivery$.MODULE$.equals(object)) {
                    return true;
                }
                if (ReliableDeliverySupervisor$TooLongIdle$.MODULE$.equals(object)) {
                    return true;
                }
                if (EndpointWriter$FlushAndStop$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof EndpointWriter.StopReading) {
                    EndpointWriter.StopReading stopReading = EndpointWriter$StopReading$.MODULE$.unapply((EndpointWriter.StopReading)object);
                    ActorRef actorRef = stopReading._1();
                    ActorRef actorRef2 = stopReading._2();
                    ActorRef w = actorRef;
                    ActorRef replyTo = actorRef2;
                    return true;
                }
                return ReliableDeliverySupervisor$Ungate$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (ReliableDeliverySupervisor$IsIdle$.MODULE$.equals(object)) {
                    this.$outer.sender().$bang((Object)ReliableDeliverySupervisor$Idle$.MODULE$, this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof EndpointManager.Send) {
                    EndpointManager.Send s = (EndpointManager.Send)object;
                    this.$outer.writer_$eq(this.$outer.org$apache$pekko$remote$ReliableDeliverySupervisor$$createWriter());
                    this.$outer.org$apache$pekko$remote$ReliableDeliverySupervisor$$handleSend(s);
                    this.$outer.org$apache$pekko$remote$ReliableDeliverySupervisor$$goToActive();
                    return BoxedUnit.UNIT;
                }
                if (ReliableDeliverySupervisor$AttemptSysMsgRedelivery$.MODULE$.equals(object)) {
                    if (this.$outer.resendBuffer().nacked().nonEmpty() || this.$outer.resendBuffer().nonAcked().nonEmpty()) {
                        this.$outer.writer_$eq(this.$outer.org$apache$pekko$remote$ReliableDeliverySupervisor$$createWriter());
                        this.$outer.org$apache$pekko$remote$ReliableDeliverySupervisor$$goToActive();
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (ReliableDeliverySupervisor$TooLongIdle$.MODULE$.equals(object)) {
                    throw new HopelessAssociation(this.$outer.localAddress(), this.$outer.remoteAddress(), this.$outer.uid(), new TimeoutException(new StringBuilder(44).append("Remote system has been silent for too long. ").append(new StringBuilder(12).append("(more than ").append(this.$outer.settings().QuarantineSilentSystemTimeout().toCoarsest()).append(")").toString()).toString()));
                }
                if (EndpointWriter$FlushAndStop$.MODULE$.equals(object)) {
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof EndpointWriter.StopReading) {
                    EndpointWriter.StopReading stopReading = EndpointWriter$StopReading$.MODULE$.unapply((EndpointWriter.StopReading)object);
                    ActorRef actorRef = stopReading._1();
                    ActorRef actorRef2 = stopReading._2();
                    ActorRef w = actorRef;
                    ActorRef replyTo = actorRef2;
                    replyTo.$bang((Object)EndpointWriter$StoppedReading$.MODULE$.apply(w), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (ReliableDeliverySupervisor$Ungate$.MODULE$.equals(object)) {
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public void org$apache$pekko$remote$ReliableDeliverySupervisor$$goToIdle() {
        if (this.maxSilenceTimer().isEmpty() && this.settings().QuarantineSilentSystemTimeout().$greater((Object)Duration$.MODULE$.Zero())) {
            try {
                this.maxSilenceTimer_$eq((Option<Cancellable>)Some$.MODULE$.apply((Object)this.context().system().scheduler().scheduleOnce(this.settings().QuarantineSilentSystemTimeout(), this.self(), (Object)ReliableDeliverySupervisor$TooLongIdle$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self())));
            }
            catch (IllegalArgumentException e) {
                this.log().warning(new StringBuilder(84).append("Too long quarantine-after-silence configuration value, idle timer is not scheduled. ").append(e.getMessage()).toString());
            }
        }
        this.context().become(this.idle());
    }

    public void org$apache$pekko$remote$ReliableDeliverySupervisor$$goToActive() {
        this.maxSilenceTimer().foreach((Function1 & Serializable)_$7 -> _$7.cancel());
        this.maxSilenceTimer_$eq((Option<Cancellable>)None$.MODULE$);
        this.context().become(this.receive());
    }

    public PartialFunction<Object, BoxedUnit> flushWait() {
        return new Serializable(this){
            private final /* synthetic */ ReliableDeliverySupervisor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (ReliableDeliverySupervisor$IsIdle$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    return true;
                }
                return true;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (ReliableDeliverySupervisor$IsIdle$.MODULE$.equals(object)) {
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    this.$outer.resendBuffer_$eq(new AckedSendBuffer<EndpointManager.Send>(0, (IndexedSeq<EndpointManager.Send>)AckedSendBuffer$.MODULE$.$lessinit$greater$default$2(), (IndexedSeq<EndpointManager.Send>)AckedSendBuffer$.MODULE$.$lessinit$greater$default$3(), AckedSendBuffer$.MODULE$.$lessinit$greater$default$4()));
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
        };
    }

    public void org$apache$pekko$remote$ReliableDeliverySupervisor$$handleSend(EndpointManager.Send send) {
        if (send.message() instanceof SystemMessage) {
            Some some = Some$.MODULE$.apply((Object)this.nextSeq());
            Object object = send.copy$default$1();
            ActorRef actorRef = send.copy$default$2();
            RemoteActorRef remoteActorRef = send.copy$default$3();
            EndpointManager.Send sequencedSend = send.copy(object, actorRef, remoteActorRef, (Option<SeqNo>)some);
            this.org$apache$pekko$remote$ReliableDeliverySupervisor$$tryBuffer(sequencedSend);
            if (this.uidConfirmed() && this.resendBuffer().nonAcked().length() <= this.settings().SysResendLimit()) {
                this.writer().$bang((Object)sequencedSend, this.self());
                return;
            }
            return;
        }
        this.writer().$bang((Object)send, this.self());
    }

    public void org$apache$pekko$remote$ReliableDeliverySupervisor$$resendNacked() {
        this.resendBuffer().nacked().foreach((Function1)(JProcedure1 & Serializable)_$8 -> this.writer().$bang(_$8, this.self()));
    }

    public void org$apache$pekko$remote$ReliableDeliverySupervisor$$resendAll() {
        this.org$apache$pekko$remote$ReliableDeliverySupervisor$$resendNacked();
        ((IterableOnceOps)this.resendBuffer().nonAcked().take(this.settings().SysResendLimit())).foreach((Function1)(JProcedure1 & Serializable)_$9 -> this.writer().$bang(_$9, this.self()));
    }

    public void org$apache$pekko$remote$ReliableDeliverySupervisor$$tryBuffer(EndpointManager.Send s) {
        try {
            this.resendBuffer_$eq(this.resendBuffer().buffer(s));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                throw new HopelessAssociation(this.localAddress(), this.remoteAddress(), this.uid(), e);
            }
            throw throwable;
        }
    }

    public ActorRef org$apache$pekko$remote$ReliableDeliverySupervisor$$createWriter() {
        return this.context().watch(this.context().actorOf(((RARP)RARP$.MODULE$.apply(this.context().system())).configureDispatcher(EndpointWriter$.MODULE$.props(this.currentHandle(), this.localAddress(), this.remoteAddress(), this.refuseUid(), this.transport(), this.settings(), PekkoPduProtobufCodec$.MODULE$, this.receiveBuffers(), (Option<ActorRef>)Some$.MODULE$.apply((Object)this.self()))).withDeploy(Deploy$.MODULE$.local()), "endpointWriter"));
    }

    private static final /* synthetic */ int $init$$$anonfun$1(PekkoProtocolHandle _$3) {
        return _$3.handshakeInfo().uid();
    }

    public static final /* synthetic */ boolean org$apache$pekko$remote$ReliableDeliverySupervisor$$anon$2$$_$applyOrElse$$anonfun$1(int receivedUid$1, int _$5) {
        return _$5 != receivedUid$1;
    }

    public static final /* synthetic */ boolean org$apache$pekko$remote$ReliableDeliverySupervisor$$anon$3$$_$applyOrElse$$anonfun$2(Deadline _$6) {
        return _$6.isOverdue();
    }

    public static final class GotUid
    implements Product,
    Serializable {
        private final int uid;
        private final Address remoteAddres;

        public static GotUid apply(int n, Address address) {
            return ReliableDeliverySupervisor$GotUid$.MODULE$.apply(n, address);
        }

        public static GotUid fromProduct(Product product) {
            return ReliableDeliverySupervisor$GotUid$.MODULE$.fromProduct(product);
        }

        public static GotUid unapply(GotUid gotUid) {
            return ReliableDeliverySupervisor$GotUid$.MODULE$.unapply(gotUid);
        }

        public GotUid(int uid, Address remoteAddres) {
            this.uid = uid;
            this.remoteAddres = remoteAddres;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.uid());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.remoteAddres()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GotUid)) return false;
            GotUid gotUid = (GotUid)object;
            if (this.uid() != gotUid.uid()) return false;
            Address address = this.remoteAddres();
            Address address2 = gotUid.remoteAddres();
            if (address != null) {
                if (!address.equals(address2)) return false;
                return true;
            }
            if (address2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof GotUid;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "GotUid";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "uid";
            }
            if (1 == n2) {
                return "remoteAddres";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int uid() {
            return this.uid;
        }

        public Address remoteAddres() {
            return this.remoteAddres;
        }

        public GotUid copy(int uid, Address remoteAddres) {
            return new GotUid(uid, remoteAddres);
        }

        public int copy$default$1() {
            return this.uid();
        }

        public Address copy$default$2() {
            return this.remoteAddres();
        }

        public int _1() {
            return this.uid();
        }

        public Address _2() {
            return this.remoteAddres();
        }
    }
}

