/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.event.Logging;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.RemotingLifecycleEvent;

public class EventPublisher {
    private final ActorSystem system;
    private final LoggingAdapter log;
    private final int logLevel;

    public EventPublisher(ActorSystem system, LoggingAdapter log, int logLevel) {
        this.system = system;
        this.log = log;
        this.logLevel = logLevel;
    }

    public void notifyListeners(RemotingLifecycleEvent message) {
        this.system.eventStream().publish((Object)message);
        if (Logging.LogLevel$.MODULE$.$less$eq$extension(message.logLevel(), this.logLevel)) {
            this.log.log(message.logLevel(), "{}", (Object)message);
            return;
        }
    }
}

