/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.management.cluster.bootstrap.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.LocalDateTime;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Status;
import org.apache.pekko.actor.TimerSchedulerImpl;
import org.apache.pekko.actor.Timers;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.discovery.Lookup;
import org.apache.pekko.discovery.Lookup$;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.event.DiagnosticMarkerBusLoggingAdapter;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.management.cluster.bootstrap.BootstrapLogMarker$;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrapSettings;
import org.apache.pekko.management.cluster.bootstrap.JoinDecider;
import org.apache.pekko.management.cluster.bootstrap.JoinDecision;
import org.apache.pekko.management.cluster.bootstrap.JoinOtherSeedNodes;
import org.apache.pekko.management.cluster.bootstrap.JoinOtherSeedNodes$;
import org.apache.pekko.management.cluster.bootstrap.JoinSelf$;
import org.apache.pekko.management.cluster.bootstrap.KeepProbing$;
import org.apache.pekko.management.cluster.bootstrap.SeedNodesInformation;
import org.apache.pekko.management.cluster.bootstrap.SeedNodesObservation;
import org.apache.pekko.management.cluster.bootstrap.internal.BootstrapCoordinator;
import org.apache.pekko.management.cluster.bootstrap.internal.BootstrapCoordinator$;
import org.apache.pekko.management.cluster.bootstrap.internal.BootstrapCoordinator$DecideTick$;
import org.apache.pekko.management.cluster.bootstrap.internal.BootstrapCoordinator$DiscoverTick$;
import org.apache.pekko.management.cluster.bootstrap.internal.BootstrapCoordinator$Protocol$InitiateBootstrapping$;
import org.apache.pekko.management.cluster.bootstrap.internal.BootstrapCoordinator$Protocol$ObtainedHttpSeedNodesObservation$;
import org.apache.pekko.management.cluster.bootstrap.internal.BootstrapCoordinator$Protocol$ProbingFailed$;
import org.apache.pekko.management.cluster.bootstrap.internal.BootstrapCoordinator$ServiceContactsObservation$;
import org.apache.pekko.management.cluster.bootstrap.internal.HttpContactPointBootstrap$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Try$;

@InternalApi
public class BootstrapCoordinator
implements Actor,
Timers {
    private ActorContext context;
    private ActorRef self;
    private TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers;
    public final ServiceDiscovery org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$discovery;
    public final JoinDecider org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$joinDecider;
    public final ClusterBootstrapSettings org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$settings;
    private final ExecutionContext ec;
    public final DiagnosticMarkerBusLoggingAdapter org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$log;
    public final Cluster org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$cluster;
    private final String DiscoverTimerKey;
    private final String DecideTimerKey;
    public final Lookup org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$lookup;
    public Option<ServiceContactsObservation> org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$lastContactsObservation;
    public Map<ServiceDiscovery.ResolvedTarget, SeedNodesObservation> org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$seedNodesObservations;
    public boolean org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$decisionInProgress;
    private int discoveryFailedBackoffCounter;

    public static Props props(ServiceDiscovery serviceDiscovery, JoinDecider joinDecider, ClusterBootstrapSettings clusterBootstrapSettings) {
        return BootstrapCoordinator$.MODULE$.props(serviceDiscovery, joinDecider, clusterBootstrapSettings);
    }

    public static scala.collection.immutable.Iterable<ServiceDiscovery.ResolvedTarget> selectHosts(Lookup lookup, int n, boolean bl, Seq<ServiceDiscovery.ResolvedTarget> seq) {
        return BootstrapCoordinator$.MODULE$.selectHosts(lookup, n, bl, seq);
    }

    public BootstrapCoordinator(ServiceDiscovery discovery, JoinDecider joinDecider, ClusterBootstrapSettings settings) {
        this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$discovery = discovery;
        this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$joinDecider = joinDecider;
        this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$settings = settings;
        Actor.$init$((Actor)this);
        Timers.$init$((Timers)this);
        this.ec = this.context().dispatcher();
        this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$log = Logging$.MODULE$.withMarker((Actor)this);
        this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.DiscoverTimerKey = "resolve-key";
        this.DecideTimerKey = "decide-key";
        this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$lookup = Lookup$.MODULE$.apply(settings.contactPointDiscovery().effectiveName(this.context().system()), settings.contactPointDiscovery().portName(), settings.contactPointDiscovery().protocol());
        this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$lastContactsObservation = None$.MODULE$;
        this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$seedNodesObservations = Predef$.MODULE$.Map().empty();
        this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$decisionInProgress = false;
        this.discoveryFailedBackoffCounter = 0;
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers() {
        return this.org$apache$pekko$actor$Timers$$_timers;
    }

    public void org$apache$pekko$actor$Timers$_setter_$org$apache$pekko$actor$Timers$$_timers_$eq(TimerSchedulerImpl x$0) {
        this.org$apache$pekko$actor$Timers$$_timers = x$0;
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPreRestart(Throwable reason, Option message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, (Option)message);
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundReceive(PartialFunction receive, Object msg) {
        Actor.aroundReceive$((Actor)this, (PartialFunction)receive, (Object)msg);
    }

    public void startPeriodicDecisionTimer() {
        this.timers().startTimerWithFixedDelay((Object)this.DecideTimerKey, (Object)BootstrapCoordinator$DecideTick$.MODULE$, this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$settings.contactPoint().probeInterval());
    }

    public void resetDiscoveryInterval() {
        this.discoveryFailedBackoffCounter = 0;
    }

    public void backoffDiscoveryInterval() {
        ++this.discoveryFailedBackoffCounter;
    }

    public FiniteDuration backedOffInterval(int restartCount, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor) {
        double rnd = 1.0 + ThreadLocalRandom.current().nextDouble() * randomFactor;
        Duration calculatedDuration = (Duration)Try$.MODULE$.apply(() -> BootstrapCoordinator.$anonfun$1(maxBackoff, minBackoff, restartCount, rnd)).getOrElse(() -> BootstrapCoordinator.$anonfun$2(maxBackoff));
        Duration duration = calculatedDuration;
        if (duration instanceof FiniteDuration) {
            FiniteDuration f = (FiniteDuration)duration;
            return f;
        }
        return maxBackoff;
    }

    public void startSingleDiscoveryTimer() {
        FiniteDuration interval = this.backedOffInterval(this.discoveryFailedBackoffCounter, this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$settings.contactPointDiscovery().interval(), this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$settings.contactPointDiscovery().exponentialBackoffMax(), this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$settings.contactPointDiscovery().exponentialBackoffRandomFactor());
        this.timers().startSingleTimer((Object)this.DiscoverTimerKey, (Object)BootstrapCoordinator$DiscoverTick$.MODULE$, interval);
    }

    public void preStart() {
        this.startSingleDiscoveryTimer();
        this.startPeriodicDecisionTimer();
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ BootstrapCoordinator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Protocol.InitiateBootstrapping) {
                    Uri uri;
                    Protocol.InitiateBootstrapping initiateBootstrapping = BootstrapCoordinator$Protocol$InitiateBootstrapping$.MODULE$.unapply((Protocol.InitiateBootstrapping)object);
                    Uri selfContactPoint = uri = initiateBootstrapping._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Protocol.InitiateBootstrapping) {
                    Uri uri;
                    Protocol.InitiateBootstrapping initiateBootstrapping = BootstrapCoordinator$Protocol$InitiateBootstrapping$.MODULE$.unapply((Protocol.InitiateBootstrapping)object);
                    Uri selfContactPoint = uri = initiateBootstrapping._1();
                    this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$log.info(BootstrapLogMarker$.MODULE$.init(), "Locating service members. Using discovery [{}], join decider [{}], scheme [{}]", (Object)this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$discovery.getClass().getName(), (Object)this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$joinDecider.getClass().getName(), (Object)selfContactPoint.scheme());
                    this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$discoverContactPoints();
                    this.$outer.context().become(this.$outer.bootstrapping(this.$outer.sender(), selfContactPoint.scheme()));
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> bootstrapping(ActorRef replyTo, String selfContactPointScheme) {
        return new Serializable(selfContactPointScheme, this){
            private final String selfContactPointScheme$1;
            private final /* synthetic */ BootstrapCoordinator $outer;
            {
                this.selfContactPointScheme$1 = selfContactPointScheme$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Option option;
                Object object = x;
                if (BootstrapCoordinator$DiscoverTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof ServiceDiscovery.Resolved && !(option = ServiceDiscovery.Resolved$.MODULE$.unapply((ServiceDiscovery.Resolved)object)).isEmpty()) {
                    Tuple2 tuple2 = (Tuple2)option.get();
                    Seq contactPoints = (Seq)tuple2._2();
                    return true;
                }
                if (object instanceof Status.Failure) {
                    Status.Failure ex = (Status.Failure)object;
                    return true;
                }
                if (object instanceof Protocol.ObtainedHttpSeedNodesObservation) {
                    Protocol.ObtainedHttpSeedNodesObservation obtainedHttpSeedNodesObservation = BootstrapCoordinator$Protocol$ObtainedHttpSeedNodesObservation$.MODULE$.unapply((Protocol.ObtainedHttpSeedNodesObservation)object);
                    LocalDateTime localDateTime = obtainedHttpSeedNodesObservation._1();
                    ServiceDiscovery.ResolvedTarget resolvedTarget = obtainedHttpSeedNodesObservation._2();
                    Address address = obtainedHttpSeedNodesObservation._3();
                    Set<Address> set = obtainedHttpSeedNodesObservation._4();
                    LocalDateTime observedAt = localDateTime;
                    ServiceDiscovery.ResolvedTarget contactPoint = resolvedTarget;
                    Address infoFromAddress = address;
                    Set<Address> observedSeedNodes = set;
                    return true;
                }
                if (BootstrapCoordinator$DecideTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof JoinDecision) {
                    JoinDecision d = (JoinDecision)object;
                    return true;
                }
                if (object instanceof Protocol.ProbingFailed) {
                    Protocol.ProbingFailed probingFailed = BootstrapCoordinator$Protocol$ProbingFailed$.MODULE$.unapply((Protocol.ProbingFailed)object);
                    ServiceDiscovery.ResolvedTarget resolvedTarget = probingFailed._1();
                    Throwable throwable = probingFailed._2();
                    ServiceDiscovery.ResolvedTarget contactPoint = resolvedTarget;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Option option;
                Object object = x;
                if (BootstrapCoordinator$DiscoverTick$.MODULE$.equals(object)) {
                    this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$discoverContactPoints();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ServiceDiscovery.Resolved && !(option = ServiceDiscovery.Resolved$.MODULE$.unapply((ServiceDiscovery.Resolved)object)).isEmpty()) {
                    Tuple2 tuple2 = (Tuple2)option.get();
                    Seq contactPoints = (Seq)tuple2._2();
                    scala.collection.immutable.Iterable<ServiceDiscovery.ResolvedTarget> filteredContactPoints = BootstrapCoordinator$.MODULE$.selectHosts(this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$lookup, this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$settings.contactPoint().fallbackPort(), this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$settings.contactPoint().filterOnFallbackPort(), (Seq<ServiceDiscovery.ResolvedTarget>)contactPoints);
                    this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$log.info(BootstrapLogMarker$.MODULE$.resolved(this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$formatContactPoints((Iterable<ServiceDiscovery.ResolvedTarget>)filteredContactPoints)), "Located service members based on: [{}]: [{}], filtered to [{}]", (Object)this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$lookup, (Object)contactPoints.mkString(", "), (Object)this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$formatContactPoints((Iterable<ServiceDiscovery.ResolvedTarget>)filteredContactPoints).mkString(", "));
                    this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$onContactPointsResolved((Iterable<ServiceDiscovery.ResolvedTarget>)filteredContactPoints, this.selfContactPointScheme$1);
                    this.$outer.resetDiscoveryInterval();
                    this.$outer.startSingleDiscoveryTimer();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Status.Failure) {
                    Status.Failure ex = (Status.Failure)object;
                    this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$log.warning(BootstrapLogMarker$.MODULE$.resolveFailed(), "Resolve attempt failed! Cause: {}", (Object)ex.cause());
                    this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$lastContactsObservation = None$.MODULE$;
                    this.$outer.backoffDiscoveryInterval();
                    this.$outer.startSingleDiscoveryTimer();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Protocol.ObtainedHttpSeedNodesObservation) {
                    Protocol.ObtainedHttpSeedNodesObservation obtainedHttpSeedNodesObservation = BootstrapCoordinator$Protocol$ObtainedHttpSeedNodesObservation$.MODULE$.unapply((Protocol.ObtainedHttpSeedNodesObservation)object);
                    LocalDateTime localDateTime = obtainedHttpSeedNodesObservation._1();
                    ServiceDiscovery.ResolvedTarget resolvedTarget = obtainedHttpSeedNodesObservation._2();
                    Address address = obtainedHttpSeedNodesObservation._3();
                    Set<Address> set = obtainedHttpSeedNodesObservation._4();
                    LocalDateTime observedAt = localDateTime;
                    ServiceDiscovery.ResolvedTarget contactPoint = resolvedTarget;
                    Address infoFromAddress = address;
                    Set<Address> observedSeedNodes = set;
                    this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$lastContactsObservation.foreach((Function1)(JProcedure1 & Serializable)contacts -> {
                        if (contacts.observedContactPoints().contains((Object)contactPoint)) {
                            this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$log.info(BootstrapLogMarker$.MODULE$.seedNodes(observedSeedNodes), "Contact point [{}] returned [{}] seed-nodes [{}]", (Object)infoFromAddress, (Object)BoxesRunTime.boxToInteger((int)observedSeedNodes.size()), (Object)observedSeedNodes.mkString(", "));
                            this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$seedNodesObservations = (Map)this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$seedNodesObservations.updated((Object)contactPoint, (Object)new SeedNodesObservation(observedAt, contactPoint, infoFromAddress, observedSeedNodes));
                        }
                        if (observedSeedNodes.nonEmpty()) {
                            this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$decide();
                            return;
                        }
                    });
                    return BoxedUnit.UNIT;
                }
                if (BootstrapCoordinator$DecideTick$.MODULE$.equals(object)) {
                    this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$decide();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof JoinDecision) {
                    JoinDecision d = (JoinDecision)object;
                    this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$decisionInProgress = false;
                    JoinDecision joinDecision = d;
                    if (!KeepProbing$.MODULE$.equals(joinDecision)) {
                        if (joinDecision instanceof JoinOtherSeedNodes) {
                            JoinOtherSeedNodes joinOtherSeedNodes = JoinOtherSeedNodes$.MODULE$.unapply((JoinOtherSeedNodes)joinDecision);
                            Set<Address> set = joinOtherSeedNodes._1();
                            Set<Address> seedNodes = set;
                            if (seedNodes.nonEmpty()) {
                                this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$log.info(BootstrapLogMarker$.MODULE$.join(seedNodes), "Joining [{}] to existing cluster [{}]", (Object)this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$cluster.selfAddress(), (Object)seedNodes.mkString(", "));
                                List seedNodesList = seedNodes.$minus((Object)this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$cluster.selfAddress()).toList();
                                this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$cluster.joinSeedNodes((Seq)seedNodesList);
                                this.$outer.context().stop(this.$outer.self());
                            }
                        } else if (JoinSelf$.MODULE$.equals(joinDecision)) {
                            this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$log.info(BootstrapLogMarker$.MODULE$.joinSelf(), "Initiating new cluster, self-joining [{}]. Other nodes are expected to locate this cluster via continued contact-point probing.", (Object)this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$cluster.selfAddress());
                            this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$cluster.join(this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$cluster.selfAddress());
                            this.$outer.context().stop(this.$outer.self());
                        } else {
                            throw new MatchError((Object)joinDecision);
                        }
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Protocol.ProbingFailed) {
                    Protocol.ProbingFailed probingFailed = BootstrapCoordinator$Protocol$ProbingFailed$.MODULE$.unapply((Protocol.ProbingFailed)object);
                    ServiceDiscovery.ResolvedTarget resolvedTarget = probingFailed._1();
                    Throwable throwable = probingFailed._2();
                    ServiceDiscovery.ResolvedTarget contactPoint = resolvedTarget;
                    this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$lastContactsObservation.foreach((Function1)(JProcedure1 & Serializable)contacts -> {
                        if (contacts.observedContactPoints().contains((Object)contactPoint)) {
                            this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$log.info(BootstrapLogMarker$.MODULE$.seedNodesProbingFailed(this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$formatContactPoints((Iterable<ServiceDiscovery.ResolvedTarget>)contacts.observedContactPoints())), "Received signal that probing has failed, scheduling contact point probing again");
                            return;
                        }
                    });
                    this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$seedNodesObservations = (Map)this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$seedNodesObservations.$minus((Object)contactPoint);
                    this.$outer.startSingleDiscoveryTimer();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(org.apache.pekko.discovery.ServiceDiscovery$ResolvedTarget scala.collection.immutable.Set org.apache.pekko.actor.Address java.time.LocalDateTime org.apache.pekko.management.cluster.bootstrap.internal.BootstrapCoordinator$ServiceContactsObservation ), applyOrElse$$anonfun$2(org.apache.pekko.discovery.ServiceDiscovery$ResolvedTarget org.apache.pekko.management.cluster.bootstrap.internal.BootstrapCoordinator$ServiceContactsObservation )}, serializedLambda);
            }
        };
    }

    public Iterable<String> org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$formatContactPoints(Iterable<ServiceDiscovery.ResolvedTarget> filteredContactPoints) {
        return (Iterable)filteredContactPoints.map((Function1 & Serializable)r -> new StringBuilder(1).append(r.host()).append(":").append(r.port().getOrElse(BootstrapCoordinator::formatContactPoints$$anonfun$1$$anonfun$1)).toString());
    }

    public void org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$discoverContactPoints() {
        this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$log.info("Looking up [{}]", (Object)this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$lookup);
        org.apache.pekko.pattern.package$.MODULE$.pipe(this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$discovery.lookup(this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$lookup, this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$settings.contactPointDiscovery().resolveTimeout()), this.ec).pipeTo(this.self(), this.self());
    }

    public void org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$onContactPointsResolved(Iterable<ServiceDiscovery.ResolvedTarget> contactPoints, String selfContactPointScheme) {
        ServiceContactsObservation newObservation = BootstrapCoordinator$ServiceContactsObservation$.MODULE$.apply(this.timeNow(), (Set<ServiceDiscovery.ResolvedTarget>)contactPoints.toSet());
        Option<ServiceContactsObservation> option = this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$lastContactsObservation;
        if (option instanceof Some) {
            ServiceContactsObservation contacts = (ServiceContactsObservation)((Some)option).value();
            this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$lastContactsObservation = Some$.MODULE$.apply((Object)contacts.sameOrChanged(newObservation));
        } else if (None$.MODULE$.equals(option)) {
            this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$lastContactsObservation = Some$.MODULE$.apply((Object)newObservation);
        } else {
            throw new MatchError(option);
        }
        this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$seedNodesObservations = (Map)this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$seedNodesObservations.filterNot((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ServiceDiscovery.ResolvedTarget contactPoint = (ServiceDiscovery.ResolvedTarget)tuple2._1();
                return !newObservation.observedContactPoints().contains((Object)contactPoint);
            }
            throw new MatchError((Object)tuple2);
        });
        newObservation.observedContactPoints().foreach((Function1 & Serializable)_$4 -> this.ensureProbing(selfContactPointScheme, (ServiceDiscovery.ResolvedTarget)_$4));
    }

    public Option<ActorRef> ensureProbing(String selfContactPointScheme, ServiceDiscovery.ResolvedTarget contactPoint) {
        boolean wasAboutToProbeSelfAddress;
        int targetPort = BoxesRunTime.unboxToInt((Object)contactPoint.port().getOrElse(this::$anonfun$3));
        Uri rawBaseUri = Uri$.MODULE$.apply(selfContactPointScheme, Uri.Authority$.MODULE$.apply(Uri.Host$.MODULE$.apply(contactPoint.host(), Uri.Host$.MODULE$.apply$default$2(), Uri.Host$.MODULE$.apply$default$3()), targetPort, Uri.Authority$.MODULE$.$lessinit$greater$default$3()), Uri$.MODULE$.apply$default$3(), Uri$.MODULE$.apply$default$4(), Uri$.MODULE$.apply$default$5());
        Uri baseUri = (Uri)this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$settings.managementBasePath().fold(() -> BootstrapCoordinator.$anonfun$4(rawBaseUri), (Function1 & Serializable)prefix -> rawBaseUri.withPath(Uri.Path$.MODULE$.apply(new StringBuilder(1).append("/").append((String)prefix).toString(), Uri.Path$.MODULE$.apply$default$2())));
        String childActorName = HttpContactPointBootstrap$.MODULE$.name(baseUri.authority().host(), baseUri.authority().port());
        this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$log.debug(new StringBuilder(24).append("Ensuring probing actor: ").append(childActorName).toString());
        String string = baseUri.authority().host().address();
        Object object = this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$cluster.selfAddress().host().getOrElse(BootstrapCoordinator::$anonfun$6);
        boolean bl = !(string != null ? !string.equals(object) : object != null) && baseUri.authority().port() == BoxesRunTime.unboxToInt((Object)this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$cluster.selfAddress().port().getOrElse(BootstrapCoordinator::$anonfun$7)) ? true : (wasAboutToProbeSelfAddress = false);
        if (wasAboutToProbeSelfAddress) {
            this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$log.warning("Misconfiguration detected! Attempted to start probing a contact-point which address [{}] matches our local remoting address [{}]. Avoiding probing this address. Consider double checking your service discovery and port configurations.", (Object)baseUri, (Object)this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$cluster.selfAddress());
            return None$.MODULE$;
        }
        Option option = this.context().child(childActorName);
        if (option instanceof Some) {
            ActorRef contactPointProbingChild = (ActorRef)((Some)option).value();
            return Some$.MODULE$.apply((Object)contactPointProbingChild);
        }
        if (None$.MODULE$.equals(option)) {
            Props props = HttpContactPointBootstrap$.MODULE$.props(this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$settings, contactPoint, baseUri);
            return Some$.MODULE$.apply((Object)this.context().actorOf(props, childActorName));
        }
        throw new MatchError((Object)option);
    }

    public void org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$decide() {
        if (this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$decisionInProgress) {
            this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$log.debug("Previous decision still in progress");
            return;
        }
        this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$lastContactsObservation.foreach((Function1)(JProcedure1 & Serializable)contacts -> {
            LocalDateTime currentTime = this.timeNow();
            Set seedObservations = this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$seedNodesObservations.valuesIterator().filterNot((Function1 & Serializable)obs -> this.isObsolete$1(currentTime, (SeedNodesObservation)obs)).toSet();
            SeedNodesInformation info = new SeedNodesInformation(currentTime, contacts.observedAt(), contacts.observedContactPoints(), (Set<SeedNodesObservation>)seedObservations);
            this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$decisionInProgress = true;
            this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$joinDecider.decide(info).recover((PartialFunction)new Serializable(this){
                private final /* synthetic */ BootstrapCoordinator $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable;
                    Throwable e = throwable = x;
                    this.$outer.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$log.error(e, "Join decision failed: {}", (Object)e);
                    return KeepProbing$.MODULE$;
                }
            }, this.ec).foreach((Function1)(JProcedure1 & Serializable)_$5 -> this.self().$bang(_$5, this.self()), this.ec);
        });
    }

    public LocalDateTime timeNow() {
        return LocalDateTime.now();
    }

    private static final Duration $anonfun$1(FiniteDuration maxBackoff$1, FiniteDuration minBackoff$1, int restartCount$1, double rnd$1) {
        return maxBackoff$1.min(minBackoff$1.$times(package$.MODULE$.pow(2.0, Int$.MODULE$.int2double(restartCount$1)))).$times(rnd$1);
    }

    private static final Duration $anonfun$2(FiniteDuration maxBackoff$2) {
        return maxBackoff$2;
    }

    private static final Object formatContactPoints$$anonfun$1$$anonfun$1() {
        return "0";
    }

    private final int $anonfun$3() {
        return this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$settings.contactPoint().fallbackPort();
    }

    private static final Uri $anonfun$4(Uri rawBaseUri$1) {
        return rawBaseUri$1;
    }

    private static final String $anonfun$6() {
        return "---";
    }

    private static final int $anonfun$7() {
        return -1;
    }

    private final boolean isObsolete$1(LocalDateTime currentTime$1, SeedNodesObservation obs) {
        return java.time.Duration.between(obs.observedAt(), currentTime$1).toMillis() > this.org$apache$pekko$management$cluster$bootstrap$internal$BootstrapCoordinator$$settings.contactPoint().probingFailureTimeout().toMillis();
    }

    public static final class ServiceContactsObservation
    implements Product,
    Serializable {
        private final LocalDateTime observedAt;
        private final Set observedContactPoints;

        public static ServiceContactsObservation apply(LocalDateTime localDateTime, Set<ServiceDiscovery.ResolvedTarget> set) {
            return BootstrapCoordinator$ServiceContactsObservation$.MODULE$.apply(localDateTime, set);
        }

        public static ServiceContactsObservation fromProduct(Product product) {
            return BootstrapCoordinator$ServiceContactsObservation$.MODULE$.fromProduct(product);
        }

        public static ServiceContactsObservation unapply(ServiceContactsObservation serviceContactsObservation) {
            return BootstrapCoordinator$ServiceContactsObservation$.MODULE$.unapply(serviceContactsObservation);
        }

        public ServiceContactsObservation(LocalDateTime observedAt, Set<ServiceDiscovery.ResolvedTarget> observedContactPoints) {
            this.observedAt = observedAt;
            this.observedContactPoints = observedContactPoints;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ServiceContactsObservation)) return false;
            ServiceContactsObservation serviceContactsObservation = (ServiceContactsObservation)object;
            LocalDateTime localDateTime = this.observedAt();
            LocalDateTime localDateTime2 = serviceContactsObservation.observedAt();
            if (localDateTime == null) {
                if (localDateTime2 != null) {
                    return false;
                }
            } else if (!((Object)localDateTime).equals(localDateTime2)) return false;
            Set<ServiceDiscovery.ResolvedTarget> set = this.observedContactPoints();
            Set<ServiceDiscovery.ResolvedTarget> set2 = serviceContactsObservation.observedContactPoints();
            if (set == null) {
                if (set2 == null) return true;
                return false;
            } else {
                if (!set.equals(set2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ServiceContactsObservation;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ServiceContactsObservation";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "observedAt";
            }
            if (1 == n2) {
                return "observedContactPoints";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public LocalDateTime observedAt() {
            return this.observedAt;
        }

        public Set<ServiceDiscovery.ResolvedTarget> observedContactPoints() {
            return this.observedContactPoints;
        }

        public boolean membersChanged(ServiceContactsObservation other) {
            Set<ServiceDiscovery.ResolvedTarget> set = this.observedContactPoints();
            Set<ServiceDiscovery.ResolvedTarget> set2 = other.observedContactPoints();
            return set == null ? set2 != null : !set.equals(set2);
        }

        public ServiceContactsObservation sameOrChanged(ServiceContactsObservation other) {
            if (this.membersChanged(other)) {
                return other;
            }
            return this;
        }

        public ServiceContactsObservation copy(LocalDateTime observedAt, Set<ServiceDiscovery.ResolvedTarget> observedContactPoints) {
            return new ServiceContactsObservation(observedAt, observedContactPoints);
        }

        public LocalDateTime copy$default$1() {
            return this.observedAt();
        }

        public Set<ServiceDiscovery.ResolvedTarget> copy$default$2() {
            return this.observedContactPoints();
        }

        public LocalDateTime _1() {
            return this.observedAt();
        }

        public Set<ServiceDiscovery.ResolvedTarget> _2() {
            return this.observedContactPoints();
        }
    }
}

