/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.management.cluster.bootstrap;

import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.management.cluster.bootstrap.BootstrapLogMarker$;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrap;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrap$;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrapSettings;
import org.apache.pekko.management.cluster.bootstrap.JoinDecider;
import org.apache.pekko.management.cluster.bootstrap.SeedNodesInformation;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxesRunTime;

@InternalApi
public abstract class SelfAwareJoinDecider
implements JoinDecider {
    private final ActorSystem system;
    private final MarkerLoggingAdapter log;

    public SelfAwareJoinDecider(ActorSystem system, ClusterBootstrapSettings settings) {
        this.system = system;
        this.log = Logging$.MODULE$.withMarker(system, this.getClass(), LogSource$.MODULE$.fromClass());
    }

    public MarkerLoggingAdapter log() {
        return this.log;
    }

    public String contactPointString(Tuple2<String, Object> contactPoint) {
        return contactPoint.productIterator().mkString(":");
    }

    public String contactPointString(ServiceDiscovery.ResolvedTarget contactPoint) {
        return new StringBuilder(1).append(contactPoint.host()).append(":").append(contactPoint.port().getOrElse(SelfAwareJoinDecider::contactPointString$$anonfun$1)).toString();
    }

    public Tuple2<String, Object> selfContactPoint() {
        return (Tuple2)Await$.MODULE$.result((Awaitable)((ClusterBootstrap)ClusterBootstrap$.MODULE$.apply(this.system)).selfContactPoint().map((Function1 & Serializable)uri -> Tuple2$.MODULE$.apply((Object)uri.authority().host().toString(), (Object)BoxesRunTime.boxToInteger((int)uri.authority().port())), (ExecutionContext)this.system.dispatcher()), (Duration)Duration$.MODULE$.Inf());
    }

    public boolean canJoinSelf(ServiceDiscovery.ResolvedTarget target, SeedNodesInformation info) {
        Tuple2<String, Object> self = this.selfContactPoint();
        if (this.matchesSelf(target, self)) {
            return true;
        }
        if (!info.contactPoints().exists((Function1 & Serializable)_$1 -> this.matchesSelf((ServiceDiscovery.ResolvedTarget)_$1, self))) {
            this.log().warning(BootstrapLogMarker$.MODULE$.inProgress((Set<String>)((Set)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))), info.allSeedNodes()), "Self contact point [{}] not found in targets {}", (Object)this.contactPointString(this.selfContactPoint()), (Object)info.contactPoints().mkString(", "));
        }
        return false;
    }

    public boolean matchesSelf(ServiceDiscovery.ResolvedTarget target, Tuple2<String, Object> contactPoint) {
        Tuple2<String, Object> tuple2 = contactPoint;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String host = (String)tuple2._1();
        int port = BoxesRunTime.unboxToInt((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
        String host2 = (String)tuple22._1();
        int port2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
        Option option = target.port();
        if (None$.MODULE$.equals(option)) {
            return this.hostMatches(host2, target);
        }
        if (option instanceof Some) {
            int lowestPort = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            return this.hostMatches(host2, target) && port2 == lowestPort;
        }
        throw new MatchError((Object)option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hostMatches(String host, ServiceDiscovery.ResolvedTarget target) {
        String hostWithoutBracket = host.replaceAll("[\\[\\]]", "");
        String string = host;
        String string2 = target.host();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = hostWithoutBracket;
        String string4 = target.host();
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        if (!target.address().map((Function1 & Serializable)_$2 -> _$2.getHostAddress()).contains((Object)hostWithoutBracket)) return false;
        return true;
    }

    private static final Object contactPointString$$anonfun$1() {
        return "0";
    }
}

