/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.management.cluster.bootstrap;

import java.io.Serializable;
import java.time.Duration;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.management.cluster.bootstrap.BootstrapLogMarker$;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrapSettings;
import org.apache.pekko.management.cluster.bootstrap.JoinDecision;
import org.apache.pekko.management.cluster.bootstrap.JoinOtherSeedNodes$;
import org.apache.pekko.management.cluster.bootstrap.JoinSelf$;
import org.apache.pekko.management.cluster.bootstrap.KeepProbing$;
import org.apache.pekko.management.cluster.bootstrap.SeedNodesInformation;
import org.apache.pekko.management.cluster.bootstrap.SelfAwareJoinDecider;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.LinearSeqOps;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;

public class LowestAddressJoinDecider
extends SelfAwareJoinDecider {
    private final ClusterBootstrapSettings settings;

    public LowestAddressJoinDecider(ActorSystem system, ClusterBootstrapSettings settings) {
        this.settings = settings;
        super(system, settings);
    }

    @Override
    public Future<JoinDecision> decide(SeedNodesInformation info) {
        Set contactPointsWithoutSeedNodesObservations;
        if (info.hasSeedNodes()) {
            Set<Address> seeds = this.joinOtherSeedNodes(info);
            if (seeds.isEmpty()) {
                return KeepProbing$.MODULE$.asCompletedFuture();
            }
            return JoinOtherSeedNodes$.MODULE$.apply(seeds).asCompletedFuture();
        }
        if (!this.hasEnoughContactPoints(info)) {
            this.log().info(BootstrapLogMarker$.MODULE$.inProgress((Set<String>)((Set)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))), info.allSeedNodes()), "Discovered [{}] contact points, confirmed [{}], which is less than the required [{}], retrying", (Object)BoxesRunTime.boxToInteger((int)info.contactPoints().size()), (Object)BoxesRunTime.boxToInteger((int)info.seedNodesObservations().size()), (Object)BoxesRunTime.boxToInteger((int)this.settings.contactPointDiscovery().requiredContactPointsNr()));
            return KeepProbing$.MODULE$.asCompletedFuture();
        }
        if (!this.isPastStableMargin(info)) {
            this.log().debug(BootstrapLogMarker$.MODULE$.inProgress((Set<String>)((Set)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))), info.allSeedNodes()), "Contact points observations have changed more recently than the stable-margin [{}], changed at [{}], not joining myself. This process will be retried.", (Object)this.settings.contactPointDiscovery().stableMargin(), (Object)info.contactPointsChangedAt());
            return KeepProbing$.MODULE$.asCompletedFuture();
        }
        Set set = contactPointsWithoutSeedNodesObservations = this.isConfirmedCommunicationWithAllContactPointsRequired(info) ? (Set)info.contactPoints().$minus$minus((IterableOnce)info.seedNodesObservations().map((Function1 & Serializable)_$1 -> _$1.contactPoint())) : Predef$.MODULE$.Set().empty();
        if (contactPointsWithoutSeedNodesObservations.isEmpty()) {
            Option<ServiceDiscovery.ResolvedTarget> lowestAddress = this.lowestAddressContactPoint(info);
            boolean isJoinSelfAble = lowestAddress.exists((Function1 & Serializable)_$2 -> this.canJoinSelf((ServiceDiscovery.ResolvedTarget)_$2, info));
            if (isJoinSelfAble && this.settings.newClusterEnabled()) {
                return JoinSelf$.MODULE$.asCompletedFuture();
            }
            if (this.settings.newClusterEnabled()) {
                if (this.log().isInfoEnabled()) {
                    this.log().info(BootstrapLogMarker$.MODULE$.inProgress((Set<String>)((Set)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))), info.allSeedNodes()), "Exceeded stable margins without locating seed-nodes, however this node {} is NOT the lowest address out of the discovered endpoints in this deployment, thus NOT joining self. Expecting node [{}] (out of [{}]) to perform the self-join and initiate the cluster.", (Object)this.contactPointString(this.selfContactPoint()), lowestAddress.map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint)).getOrElse(LowestAddressJoinDecider::decide$$anonfun$5), (Object)((IterableOnceOps)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))).mkString(", "));
                }
            } else if (this.log().isWarningEnabled()) {
                this.log().warning(BootstrapLogMarker$.MODULE$.inProgress((Set<String>)((Set)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))), info.allSeedNodes()), "Exceeded stable margins without locating seed-nodes, however this node {} is configured with new-cluster-enabled=off, thus NOT joining self. Expecting existing cluster or node [{}] (out of [{}]) to perform the self-join and initiate the cluster.", (Object)this.contactPointString(this.selfContactPoint()), lowestAddress.map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint)).getOrElse(LowestAddressJoinDecider::decide$$anonfun$9), (Object)((IterableOnceOps)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))).mkString(", "));
            }
            return KeepProbing$.MODULE$.asCompletedFuture();
        }
        if (this.log().isInfoEnabled()) {
            this.log().info(BootstrapLogMarker$.MODULE$.inProgress((Set<String>)((Set)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))), info.allSeedNodes()), "Exceeded stable margins but missing seed node information from some contact points [{}] (out of [{}])", (Object)((IterableOnceOps)contactPointsWithoutSeedNodesObservations.map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))).mkString(", "), (Object)((IterableOnceOps)info.contactPoints().map((Function1 & Serializable)contactPoint -> this.contactPointString((ServiceDiscovery.ResolvedTarget)contactPoint))).mkString(", "));
        }
        return KeepProbing$.MODULE$.asCompletedFuture();
    }

    public Set<Address> joinOtherSeedNodes(SeedNodesInformation info) {
        return (Set)info.allSeedNodes().take(5);
    }

    public boolean hasEnoughContactPoints(SeedNodesInformation info) {
        return info.seedNodesObservations().size() >= this.settings.contactPointDiscovery().requiredContactPointsNr();
    }

    public boolean isPastStableMargin(SeedNodesInformation info) {
        Duration contactPointsChanged = Duration.between(info.contactPointsChangedAt(), info.currentTime());
        return contactPointsChanged.toMillis() >= this.settings.contactPointDiscovery().stableMargin().toMillis();
    }

    public boolean isConfirmedCommunicationWithAllContactPointsRequired(SeedNodesInformation info) {
        return this.settings.contactPointDiscovery().contactWithAllContactPoints();
    }

    public Option<ServiceDiscovery.ResolvedTarget> lowestAddressContactPoint(SeedNodesInformation info) {
        return ((LinearSeqOps)info.seedNodesObservations().toList().map((Function1 & Serializable)_$3 -> _$3.contactPoint()).sorted(ServiceDiscovery.ResolvedTarget$.MODULE$.addressOrdering())).headOption();
    }

    private static final String decide$$anonfun$5() {
        return "";
    }

    private static final String decide$$anonfun$9() {
        return "";
    }
}

