/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.management.cluster.bootstrap;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.Props;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.discovery.Discovery$;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrap;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrap$;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrap$Internal$Initializing$;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrap$Internal$NotRunning$;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrapSettings;
import org.apache.pekko.management.cluster.bootstrap.ClusterBootstrapSettings$;
import org.apache.pekko.management.cluster.bootstrap.JoinDecider;
import org.apache.pekko.management.cluster.bootstrap.contactpoint.HttpClusterBootstrapRoutes;
import org.apache.pekko.management.cluster.bootstrap.internal.BootstrapCoordinator;
import org.apache.pekko.management.cluster.bootstrap.internal.BootstrapCoordinator$;
import org.apache.pekko.management.cluster.bootstrap.internal.BootstrapCoordinator$Protocol$InitiateBootstrapping$;
import org.apache.pekko.management.scaladsl.ManagementRouteProvider;
import org.apache.pekko.management.scaladsl.ManagementRouteProviderSettings;
import org.apache.pekko.management.scaladsl.PekkoManagement;
import org.apache.pekko.management.scaladsl.PekkoManagement$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public final class ClusterBootstrap
implements ManagementRouteProvider {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ClusterBootstrap.class.getDeclaredField("discovery$lzy1"));
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final AtomicReference<Internal.BootstrapStep> bootstrapStep;
    private final ClusterBootstrapSettings settings;
    private volatile Object discovery$lzy1;
    private final JoinDecider joinDecider;
    private final Promise<Uri> _selfContactPointUri;

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterBootstrap$.MODULE$.apply(classicActorSystemProvider);
    }

    public static ClusterBootstrap createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterBootstrap$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterBootstrap get(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.get(actorSystem);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return ClusterBootstrap$.MODULE$.get(actorSystem);
    }

    public static ClusterBootstrap get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterBootstrap$.MODULE$.get(classicActorSystemProvider);
    }

    public static /* synthetic */ Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterBootstrap$.MODULE$.get(classicActorSystemProvider);
    }

    public static ClusterBootstrap$ lookup() {
        return ClusterBootstrap$.MODULE$.lookup();
    }

    public ClusterBootstrap(ExtendedActorSystem system) {
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, ClusterBootstrap.class, LogSource$.MODULE$.fromAnyClass());
        this.bootstrapStep = new AtomicReference<ClusterBootstrap$Internal$NotRunning$>(ClusterBootstrap$Internal$NotRunning$.MODULE$);
        this.settings = ClusterBootstrapSettings$.MODULE$.apply(system.settings().config(), this.log);
        this.joinDecider = (JoinDecider)system.dynamicAccess().createInstanceFor(this.settings().joinDecider().implClass(), (Seq)new .colon.colon((Object)Tuple2$.MODULE$.apply(ActorSystem.class, (Object)system), (List)new .colon.colon((Object)Tuple2$.MODULE$.apply(ClusterBootstrapSettings.class, (Object)this.settings()), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(JoinDecider.class)).get();
        this._selfContactPointUri = Promise$.MODULE$.apply();
        boolean autostart = system.settings().config().getStringList("pekko.extensions").contains(ClusterBootstrap.class.getName());
        if (autostart) {
            this.log.info("ClusterBootstrap loaded through 'pekko.extensions' auto starting management and bootstrap.");
            Future$.MODULE$.apply((Function0 & Serializable)() -> {
                this.$init$$$anonfun$1(system);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)system.dispatcher());
        }
    }

    public ClusterBootstrapSettings settings() {
        return this.settings;
    }

    public ServiceDiscovery discovery() {
        Object object = this.discovery$lzy1;
        if (object instanceof ServiceDiscovery) {
            return (ServiceDiscovery)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ServiceDiscovery)this.discovery$lzyINIT1();
    }

    private Object discovery$lzyINIT1() {
        Object object;
        block9: {
            while (true) {
                if ((object = this.discovery$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ServiceDiscovery serviceDiscovery = null;
                    try {
                        ServiceDiscovery serviceDiscovery2;
                        String string = this.settings().contactPointDiscovery().discoveryMethod();
                        if ("pekko.discovery".equals(string)) {
                            ServiceDiscovery discovery = Discovery$.MODULE$.apply((ActorSystem)this.system).discovery();
                            this.log.info("Bootstrap using default `pekko.discovery` method: {}", (Object)Logging$.MODULE$.simpleName((Object)discovery));
                            serviceDiscovery2 = discovery;
                        } else {
                            String otherDiscoveryMechanism = string;
                            this.log.info("Bootstrap using `pekko.discovery` method: {}", (Object)otherDiscoveryMechanism);
                            serviceDiscovery2 = serviceDiscovery = Discovery$.MODULE$.apply((ActorSystem)this.system).loadServiceDiscovery(otherDiscoveryMechanism);
                        }
                        object2 = serviceDiscovery == null ? LazyVals.NullValue$.MODULE$ : serviceDiscovery;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.discovery$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.discovery$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return serviceDiscovery;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block9;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<RequestContext, Future<RouteResult>> routes(ManagementRouteProviderSettings routeProviderSettings) {
        this.log.info(new StringBuilder(34).append("Using self contact point address: ").append(routeProviderSettings.selfBaseUri()).toString());
        this.setSelfContactPoint(routeProviderSettings.selfBaseUri());
        return new HttpClusterBootstrapRoutes(this.settings()).routes();
    }

    public void start() {
        if (((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().nonEmpty()) {
            this.log.warning("Application is configured with specific `pekko.cluster.seed-nodes`: {}, bailing out of the bootstrap process! If you want to use the automatic bootstrap mechanism, make sure to NOT set explicit seed nodes in the configuration. This node will attempt to join the configured seed nodes.", (Object)((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).settings().SeedNodes().mkString("[", ", ", "]"));
            return;
        }
        if (this.bootstrapStep.compareAndSet(ClusterBootstrap$Internal$NotRunning$.MODULE$, ClusterBootstrap$Internal$Initializing$.MODULE$)) {
            this.log.info("Initiating bootstrap procedure using {} method...", (Object)this.settings().contactPointDiscovery().discoveryMethod());
            this.ensureSelfContactPoint();
            Props bootstrapProps = BootstrapCoordinator$.MODULE$.props(this.discovery(), this.joinDecider, this.settings());
            ActorRef bootstrap = this.system.systemActorOf(bootstrapProps, "bootstrapCoordinator");
            this.selfContactPoint().foreach((Function1)(JProcedure1 & Serializable)uri -> {
                BootstrapCoordinator.Protocol.InitiateBootstrapping initiateBootstrapping = BootstrapCoordinator$Protocol$InitiateBootstrapping$.MODULE$.apply((Uri)uri);
                bootstrap.$bang((Object)initiateBootstrapping, bootstrap.$bang$default$2((Object)initiateBootstrapping));
            }, (ExecutionContext)this.system.dispatcher());
            return;
        }
        this.log.warning("Bootstrap already initiated, yet start() method was called again. Ignoring.");
    }

    @InternalApi
    public void ensureSelfContactPoint() {
        this.system.scheduler().scheduleOnce(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds(), (Function0 & Serializable)() -> {
            this.ensureSelfContactPoint$$anonfun$1();
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.system.dispatcher());
    }

    @InternalApi
    public void setSelfContactPoint(Uri baseUri) {
        this._selfContactPointUri.success((Object)baseUri);
    }

    @InternalApi
    public Future<Uri> selfContactPoint() {
        return this._selfContactPointUri.future();
    }

    private final void autostartFailed$1(ExtendedActorSystem system$2, Throwable ex) {
        this.log.error(ex, "Failed to autostart cluster bootstrap, terminating system");
        system$2.terminate();
    }

    private final void $init$$$anonfun$1(ExtendedActorSystem system$1) {
        try {
            ((PekkoManagement)PekkoManagement$.MODULE$.apply((ActorSystem)system$1)).start().failed().foreach((Function1)(JProcedure1 & Serializable)ex -> this.autostartFailed$1(system$1, (Throwable)ex), (ExecutionContext)system$1.dispatcher());
            ((ClusterBootstrap)ClusterBootstrap$.MODULE$.apply((ActorSystem)system$1)).start();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex2 = throwable3 = (Throwable)option.get();
                this.autostartFailed$1(system$1, ex2);
            }
            throw throwable;
        }
    }

    private final void ensureSelfContactPoint$$anonfun$1() {
        if (!this.selfContactPoint().isCompleted()) {
            this._selfContactPointUri.failure((Throwable)new TimeoutException("Awaiting Bootstrap.selfContactPoint timed out."));
            this.log.error("'Bootstrap.selfContactPoint' was NOT set, but is required for the bootstrap to work if binding bootstrap routes manually and not via pekko-management.");
            return;
        }
    }
}

