/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.testkit;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystem$;
import org.apache.pekko.http.scaladsl.client.RequestBuilding;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.HttpCharset;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.headers.Host;
import org.apache.pekko.http.scaladsl.model.headers.Sec;
import org.apache.pekko.http.scaladsl.model.headers.Sec$minusWebSocket$minusProtocol$;
import org.apache.pekko.http.scaladsl.model.headers.Upgrade;
import org.apache.pekko.http.scaladsl.server.Rejection;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.settings.ServerSettings;
import org.apache.pekko.http.scaladsl.testkit.MarshallingTestUtils;
import org.apache.pekko.http.scaladsl.testkit.RouteTest$;
import org.apache.pekko.http.scaladsl.testkit.RouteTest$DefaultHostInfo$;
import org.apache.pekko.http.scaladsl.testkit.RouteTest$TildeArrow$;
import org.apache.pekko.http.scaladsl.testkit.RouteTest$TildeBangArrow$;
import org.apache.pekko.http.scaladsl.testkit.RouteTestResultComponent;
import org.apache.pekko.http.scaladsl.testkit.WSTestRequestBuilding;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshal$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller;
import org.apache.pekko.http.scaladsl.util.FastFuture;
import org.apache.pekko.http.scaladsl.util.FastFuture$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.SystemMaterializer;
import org.apache.pekko.stream.SystemMaterializer$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.testkit.TestKit$;
import org.apache.pekko.util.ConstantFun$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.DynamicVariable;

public interface RouteTest
extends RequestBuilding,
WSTestRequestBuilding,
RouteTestResultComponent,
MarshallingTestUtils {
    public static Future<HttpResponse> runRouteClientServer(HttpRequest httpRequest, Function1<RequestContext, Future<RouteResult>> function1, ServerSettings serverSettings, ActorSystem actorSystem) {
        return RouteTest$.MODULE$.runRouteClientServer(httpRequest, function1, serverSettings, actorSystem);
    }

    public static void $init$(RouteTest $this) {
        $this.org$apache$pekko$http$scaladsl$testkit$RouteTest$_setter_$system_$eq($this.createActorSystem());
        $this.org$apache$pekko$http$scaladsl$testkit$RouteTest$_setter_$materializer_$eq(((SystemMaterializer)SystemMaterializer$.MODULE$.apply($this.system())).materializer());
        $this.org$apache$pekko$http$scaladsl$testkit$RouteTest$_setter_$org$apache$pekko$http$scaladsl$testkit$RouteTest$$dynRR_$eq(new DynamicVariable(null));
    }

    public static ActorSystem createActorSystem$(RouteTest $this) {
        return $this.createActorSystem();
    }

    default public ActorSystem createActorSystem() {
        return ActorSystem$.MODULE$.apply(this.actorSystemNameFrom(this.getClass()), this.testConfig());
    }

    public static String actorSystemNameFrom$(RouteTest $this, Class clazz) {
        return $this.actorSystemNameFrom(clazz);
    }

    default public String actorSystemNameFrom(Class<?> clazz) {
        return StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(clazz.getName().replace('.', '-').replace('_', '-')), (Function1 & Serializable)_$1 -> RouteTest.actorSystemNameFrom$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1)));
    }

    public static String testConfigSource$(RouteTest $this) {
        return $this.testConfigSource();
    }

    default public String testConfigSource() {
        return "";
    }

    public static Config testConfig$(RouteTest $this) {
        return $this.testConfig();
    }

    @Override
    default public Config testConfig() {
        String source = this.testConfigSource();
        Config config = source.isEmpty() ? ConfigFactory.empty() : ConfigFactory.parseString((String)source);
        return config.withFallback((ConfigMergeable)ConfigFactory.load());
    }

    public ActorSystem system();

    public void org$apache$pekko$http$scaladsl$testkit$RouteTest$_setter_$system_$eq(ActorSystem var1);

    public static ExecutionContextExecutor executor$(RouteTest $this) {
        return $this.executor();
    }

    default public ExecutionContextExecutor executor() {
        return this.system().dispatcher();
    }

    public Materializer materializer();

    public void org$apache$pekko$http$scaladsl$testkit$RouteTest$_setter_$materializer_$eq(Materializer var1);

    public static void cleanUp$(RouteTest $this) {
        $this.cleanUp();
    }

    default public void cleanUp() {
        TestKit$.MODULE$.shutdownActorSystem(this.system(), TestKit$.MODULE$.shutdownActorSystem$default$2(), TestKit$.MODULE$.shutdownActorSystem$default$3());
    }

    public DynamicVariable<RouteTestResultComponent.RouteTestResult> org$apache$pekko$http$scaladsl$testkit$RouteTest$$dynRR();

    public void org$apache$pekko$http$scaladsl$testkit$RouteTest$_setter_$org$apache$pekko$http$scaladsl$testkit$RouteTest$$dynRR_$eq(DynamicVariable var1);

    private RouteTestResultComponent.RouteTestResult result() {
        if (this.org$apache$pekko$http$scaladsl$testkit$RouteTest$$dynRR().value() != null) {
            return (RouteTestResultComponent.RouteTestResult)this.org$apache$pekko$http$scaladsl$testkit$RouteTest$$dynRR().value();
        }
        throw scala.sys.package$.MODULE$.error("This value is only available inside of a `check` construct!");
    }

    public static Function1 check$(RouteTest $this, Function0 body) {
        return $this.check(body);
    }

    default public <T> Function1<RouteTestResultComponent.RouteTestResult, T> check(Function0<T> body) {
        return (Function1 & Serializable)result -> this.org$apache$pekko$http$scaladsl$testkit$RouteTest$$dynRR().withValue((Object)result.awaitResult(), body);
    }

    private Object responseSafe() {
        if (this.org$apache$pekko$http$scaladsl$testkit$RouteTest$$dynRR().value() != null) {
            return ((RouteTestResultComponent.RouteTestResult)this.org$apache$pekko$http$scaladsl$testkit$RouteTest$$dynRR().value()).response();
        }
        return "<not available anymore>";
    }

    public static boolean handled$(RouteTest $this) {
        return $this.handled();
    }

    default public boolean handled() {
        return this.result().handled();
    }

    public static HttpResponse response$(RouteTest $this) {
        return $this.response();
    }

    default public HttpResponse response() {
        return this.result().response();
    }

    public static HttpEntity responseEntity$(RouteTest $this) {
        return $this.responseEntity();
    }

    default public HttpEntity responseEntity() {
        return this.result().entity();
    }

    private HttpResponse rawResponse() {
        return this.result().rawResponse();
    }

    public static Seq chunks$(RouteTest $this) {
        return $this.chunks();
    }

    default public Seq<HttpEntity.ChunkStreamPart> chunks() {
        return this.result().chunks();
    }

    public static Source chunksStream$(RouteTest $this) {
        return $this.chunksStream();
    }

    default public Source<HttpEntity.ChunkStreamPart, Object> chunksStream() {
        return this.result().chunksStream();
    }

    public static Object entityAs$(RouteTest $this, Unmarshaller evidence$1, ClassTag evidence$2, Duration timeout) {
        return $this.entityAs(evidence$1, evidence$2, timeout);
    }

    default public <T> T entityAs(Unmarshaller<HttpEntity, T> evidence$1, ClassTag<T> evidence$2, Duration timeout) {
        Future future = FastFuture$.MODULE$.EnhancedFuture(Unmarshal$.MODULE$.apply((Object)this.responseEntity()).to(evidence$1, (ExecutionContext)this.executor(), this.materializer()));
        Future future2 = new FastFuture(FastFuture.EnhancedFuture$.MODULE$.fast$extension(future)).future();
        return (T)Await$.MODULE$.result((Awaitable)FastFuture$.MODULE$.recover$extension(future2, (PartialFunction)new Serializable(evidence$2, this){
            private final ClassTag evidence$2$3;
            private final /* synthetic */ RouteTest $outer;
            {
                this.evidence$2$3 = evidence$2$5;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable error = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable error = throwable = x;
                throw this.$outer.failTest(this.$outer.org$apache$pekko$http$scaladsl$testkit$RouteTest$$_$msg$1(this.evidence$2$3, error));
            }
        }, (ExecutionContext)this.executor()), timeout);
    }

    public static Duration entityAs$default$3$(RouteTest $this) {
        return $this.entityAs$default$3();
    }

    default public <T> Duration entityAs$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second();
    }

    public static Object responseAs$(RouteTest $this, Unmarshaller evidence$1, ClassTag evidence$2, Duration timeout) {
        return $this.responseAs(evidence$1, evidence$2, timeout);
    }

    default public <T> T responseAs(Unmarshaller<HttpResponse, T> evidence$1, ClassTag<T> evidence$2, Duration timeout) {
        Future future = FastFuture$.MODULE$.EnhancedFuture(Unmarshal$.MODULE$.apply((Object)this.response()).to(evidence$1, (ExecutionContext)this.executor(), this.materializer()));
        Future future2 = new FastFuture(FastFuture.EnhancedFuture$.MODULE$.fast$extension(future)).future();
        return (T)Await$.MODULE$.result((Awaitable)FastFuture$.MODULE$.recover$extension(future2, (PartialFunction)new Serializable(evidence$2, this){
            private final ClassTag evidence$2$4;
            private final /* synthetic */ RouteTest $outer;
            {
                this.evidence$2$4 = evidence$2$6;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable error = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable error = throwable = x;
                throw this.$outer.failTest(this.$outer.org$apache$pekko$http$scaladsl$testkit$RouteTest$$_$msg$2(this.evidence$2$4, error));
            }
        }, (ExecutionContext)this.executor()), timeout);
    }

    public static Duration responseAs$default$3$(RouteTest $this) {
        return $this.responseAs$default$3();
    }

    default public <T> Duration responseAs$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second();
    }

    public static ContentType contentType$(RouteTest $this) {
        return $this.contentType();
    }

    default public ContentType contentType() {
        return this.rawResponse().entity().contentType();
    }

    public static MediaType mediaType$(RouteTest $this) {
        return $this.mediaType();
    }

    default public MediaType mediaType() {
        return this.contentType().mediaType();
    }

    public static Option charsetOption$(RouteTest $this) {
        return $this.charsetOption();
    }

    default public Option<HttpCharset> charsetOption() {
        return this.contentType().charsetOption();
    }

    public static HttpCharset charset$(RouteTest $this) {
        return $this.charset();
    }

    default public HttpCharset charset() {
        return (HttpCharset)this.charsetOption().getOrElse(RouteTest::charset$$anonfun$1);
    }

    public static Seq headers$(RouteTest $this) {
        return $this.headers();
    }

    default public Seq<HttpHeader> headers() {
        return this.rawResponse().headers();
    }

    public static Option header$(RouteTest $this, ClassTag evidence$1) {
        return $this.header(evidence$1);
    }

    default public <T extends HttpHeader> Option<T> header(ClassTag<T> evidence$1) {
        return this.rawResponse().header((ClassTag)Predef$.MODULE$.implicitly(evidence$1));
    }

    public static Option header$(RouteTest $this, String name) {
        return $this.header(name);
    }

    default public Option<HttpHeader> header(String name) {
        return this.rawResponse().headers().find((Function1 & Serializable)_$2 -> _$2.is(name.toLowerCase()));
    }

    public static StatusCode status$(RouteTest $this) {
        return $this.status();
    }

    default public StatusCode status() {
        return this.rawResponse().status();
    }

    public static String closingExtension$(RouteTest $this) {
        return $this.closingExtension();
    }

    default public String closingExtension() {
        HttpEntity.ChunkStreamPart chunkStreamPart;
        Option option = this.chunks().lastOption();
        if (option instanceof Some && (chunkStreamPart = (HttpEntity.ChunkStreamPart)((Some)option).value()) instanceof HttpEntity.LastChunk) {
            HttpEntity.LastChunk lastChunk = HttpEntity.LastChunk$.MODULE$.unapply((HttpEntity.LastChunk)chunkStreamPart);
            String string = lastChunk._1();
            Seq seq = lastChunk._2();
            String extension = string;
            return extension;
        }
        return "";
    }

    public static Seq trailer$(RouteTest $this) {
        return $this.trailer();
    }

    default public Seq<HttpHeader> trailer() {
        HttpEntity.ChunkStreamPart chunkStreamPart;
        Option option = this.chunks().lastOption();
        if (option instanceof Some && (chunkStreamPart = (HttpEntity.ChunkStreamPart)((Some)option).value()) instanceof HttpEntity.LastChunk) {
            Seq seq;
            HttpEntity.LastChunk lastChunk = HttpEntity.LastChunk$.MODULE$.unapply((HttpEntity.LastChunk)chunkStreamPart);
            String string = lastChunk._1();
            Seq trailer = seq = lastChunk._2();
            return trailer;
        }
        return package$.MODULE$.Nil();
    }

    public static Seq rejections$(RouteTest $this) {
        return $this.rejections();
    }

    default public Seq<Rejection> rejections() {
        return this.result().rejections();
    }

    public static Rejection rejection$(RouteTest $this) {
        return $this.rejection();
    }

    default public Rejection rejection() {
        Seq<Rejection> r = this.rejections();
        if (r.size() == 1) {
            return (Rejection)r.head();
        }
        throw this.failTest(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Expected a single rejection but got %s (%s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)r.size()), r})));
    }

    public static boolean isWebSocketUpgrade$(RouteTest $this) {
        return $this.isWebSocketUpgrade();
    }

    default public boolean isWebSocketUpgrade() {
        StatusCode statusCode = this.status();
        StatusCodes.Informational informational = StatusCodes$.MODULE$.SwitchingProtocols();
        return !(statusCode != null ? !statusCode.equals(informational) : informational != null) && this.header(ClassTag$.MODULE$.apply(Upgrade.class)).exists((Function1 & Serializable)_$3 -> _$3.hasWebSocket());
    }

    public static void expectWebSocketUpgradeWithProtocol$(RouteTest $this, Function1 body) {
        $this.expectWebSocketUpgradeWithProtocol((Function1<String, BoxedUnit>)body);
    }

    default public void expectWebSocketUpgradeWithProtocol(Function1<String, BoxedUnit> body) {
        SeqOps seqOps;
        Sec.minusWebSocket.minusProtocol minusProtocol2;
        Seq seq;
        Sec.minusWebSocket.minusProtocol minusProtocol3;
        if (!this.isWebSocketUpgrade()) {
            throw this.failTest("Response was no WebSocket Upgrade response");
        }
        Option option = this.header(ClassTag$.MODULE$.apply(Sec.minusWebSocket.minusProtocol.class));
        if (option instanceof Some && (minusProtocol3 = (Sec.minusWebSocket.minusProtocol)((Some)option).value()) != null && (seq = (minusProtocol2 = Sec$minusWebSocket$minusProtocol$.MODULE$.unapply(minusProtocol3))._1()) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq), 1) == 0) {
            String string;
            String protocol = string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
            body.apply((Object)protocol);
            return;
        }
        throw this.failTest("No WebSocket protocol found in response.");
    }

    public static Function1 runRoute$(RouteTest $this) {
        return $this.runRoute();
    }

    default public Function1<RouteTestResultComponent.RouteTestResult, RouteTestResultComponent.RouteTestResult> runRoute() {
        return ConstantFun$.MODULE$.scalaIdentityFunction();
    }

    public static WithTransformation2 WithTransformation2$(RouteTest $this, HttpRequest request) {
        return $this.WithTransformation2(request);
    }

    default public WithTransformation2 WithTransformation2(HttpRequest request) {
        return new WithTransformation2(this, request);
    }

    public static RouteTest$DefaultHostInfo$ DefaultHostInfo$(RouteTest $this) {
        return $this.DefaultHostInfo();
    }

    default public RouteTest$DefaultHostInfo$ DefaultHostInfo() {
        return new RouteTest$DefaultHostInfo$(this);
    }

    public static RouteTest$TildeArrow$ TildeArrow$(RouteTest $this) {
        return $this.TildeArrow();
    }

    default public RouteTest$TildeArrow$ TildeArrow() {
        return new RouteTest$TildeArrow$(this);
    }

    public static RouteTest$TildeBangArrow$ TildeBangArrow$(RouteTest $this) {
        return $this.TildeBangArrow();
    }

    default public RouteTest$TildeBangArrow$ TildeBangArrow() {
        return new RouteTest$TildeBangArrow$(this);
    }

    private static /* synthetic */ boolean actorSystemNameFrom$$anonfun$1(char _$1) {
        return _$1 != '$';
    }

    public static String org$apache$pekko$http$scaladsl$testkit$RouteTest$$_$msg$1$(RouteTest $this, ClassTag evidence$2$1, Throwable e) {
        return $this.org$apache$pekko$http$scaladsl$testkit$RouteTest$$_$msg$1(evidence$2$1, e);
    }

    default public String org$apache$pekko$http$scaladsl$testkit$RouteTest$$_$msg$1(ClassTag evidence$2$1, Throwable e) {
        return new StringBuilder(80).append("Could not unmarshal entity to type '").append(Predef$.MODULE$.implicitly((Object)evidence$2$1)).append("' for `entityAs` assertion: ").append(e).append("\n\nResponse was: ").append(this.responseSafe()).toString();
    }

    public static String org$apache$pekko$http$scaladsl$testkit$RouteTest$$_$msg$2$(RouteTest $this, ClassTag evidence$2$2, Throwable e) {
        return $this.org$apache$pekko$http$scaladsl$testkit$RouteTest$$_$msg$2(evidence$2$2, e);
    }

    default public String org$apache$pekko$http$scaladsl$testkit$RouteTest$$_$msg$2(ClassTag evidence$2$2, Throwable e) {
        return new StringBuilder(84).append("Could not unmarshal response to type '").append(Predef$.MODULE$.implicitly((Object)evidence$2$2)).append("' for `responseAs` assertion: ").append(e).append("\n\nResponse was: ").append(this.responseSafe()).toString();
    }

    private static HttpCharset charset$$anonfun$1() {
        throw scala.sys.package$.MODULE$.error("Binary entity does not have charset");
    }

    public static Function1 org$apache$pekko$http$scaladsl$testkit$RouteTest$$anon$3$$_$_$$anonfun$1(Function1 route$1) {
        return route$1;
    }

    public static /* synthetic */ void org$apache$pekko$http$scaladsl$testkit$RouteTest$$anon$3$$_$apply$$anonfun$1(RouteTestResultComponent.RouteTestResult routeTestResult$1, RouteResult rr) {
        routeTestResult$1.handleResult(rr);
    }

    public class DefaultHostInfo
    implements Product,
    Serializable {
        private final Host host;
        private final boolean securedConnection;
        private final /* synthetic */ RouteTest $outer;

        public DefaultHostInfo(RouteTest $outer, Host host, boolean securedConnection) {
            this.host = host;
            this.securedConnection = securedConnection;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.host()));
            n = Statics.mix((int)n, (int)(this.securedConnection() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DefaultHostInfo)) return false;
            if (((DefaultHostInfo)object).org$apache$pekko$http$scaladsl$testkit$RouteTest$DefaultHostInfo$$$outer() != this.$outer) return false;
            DefaultHostInfo defaultHostInfo = (DefaultHostInfo)object;
            if (this.securedConnection() != defaultHostInfo.securedConnection()) return false;
            Host host = this.host();
            Host host2 = defaultHostInfo.host();
            if (host == null) {
                if (host2 != null) {
                    return false;
                }
            } else if (!host.equals(host2)) return false;
            if (!defaultHostInfo.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DefaultHostInfo;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DefaultHostInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "host";
            }
            if (1 == n2) {
                return "securedConnection";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Host host() {
            return this.host;
        }

        public boolean securedConnection() {
            return this.securedConnection;
        }

        public DefaultHostInfo copy(Host host, boolean securedConnection) {
            return new DefaultHostInfo(this.$outer, host, securedConnection);
        }

        public Host copy$default$1() {
            return this.host();
        }

        public boolean copy$default$2() {
            return this.securedConnection();
        }

        public Host _1() {
            return this.host();
        }

        public boolean _2() {
            return this.securedConnection();
        }

        public final /* synthetic */ RouteTest org$apache$pekko$http$scaladsl$testkit$RouteTest$DefaultHostInfo$$$outer() {
            return this.$outer;
        }
    }

    public abstract class TildeArrow<A, B> {
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RouteTest$TildeArrow$.class.getDeclaredField("InjectIntoRequestTransformer$lzy1"));

        public TildeArrow() {
            if (RouteTest.this == null) {
                throw new NullPointerException();
            }
        }

        public abstract Object apply(HttpRequest var1, Function1<A, B> var2);

        public final /* synthetic */ RouteTest org$apache$pekko$http$scaladsl$testkit$RouteTest$TildeArrow$$$outer() {
            return RouteTest.this;
        }
    }

    public abstract class TildeBangArrow<A, B> {
        public TildeBangArrow() {
            if (RouteTest.this == null) {
                throw new NullPointerException();
            }
        }

        public abstract Object apply(HttpRequest var1, Function1<A, B> var2);

        public final /* synthetic */ RouteTest org$apache$pekko$http$scaladsl$testkit$RouteTest$TildeBangArrow$$$outer() {
            return RouteTest.this;
        }
    }

    public class WithTransformation2 {
        private final HttpRequest request;
        private final /* synthetic */ RouteTest $outer;

        public WithTransformation2(RouteTest $outer, HttpRequest request) {
            this.request = request;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public <A, B> Object $tilde$greater(Function1<A, B> f, TildeArrow<A, B> ta) {
            return ta.apply(this.request, f);
        }

        public <A, B> Object $tilde$bang$greater(Function1<A, B> f, TildeBangArrow<A, B> tba) {
            return tba.apply(this.request, f);
        }

        public final /* synthetic */ RouteTest org$apache$pekko$http$scaladsl$testkit$RouteTest$WithTransformation2$$$outer() {
            return this.$outer;
        }
    }
}

