/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.testkit;

import com.typesafe.config.Config;
import java.io.Serializable;
import org.apache.pekko.http.impl.util.EnhancedConfig$;
import org.apache.pekko.http.impl.util.package$;
import org.apache.pekko.http.scaladsl.marshalling.Marshal$;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.MediaRange;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.headers.Accept;
import org.apache.pekko.http.scaladsl.model.headers.Accept$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshal$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller;
import org.apache.pekko.stream.Materializer;
import scala.Function1;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.util.Try;

public interface MarshallingTestUtils {
    public Config testConfig();

    public static FiniteDuration marshallingTimeout$(MarshallingTestUtils $this) {
        return $this.marshallingTimeout();
    }

    default public FiniteDuration marshallingTimeout() {
        return EnhancedConfig$.MODULE$.getFiniteDuration$extension(package$.MODULE$.enhanceConfig(this.testConfig()), "pekko.http.testkit.marshalling.timeout");
    }

    public static HttpEntity.Strict marshal$(MarshallingTestUtils $this, Object value, Marshaller evidence$1, ExecutionContext ec, Materializer mat) {
        return $this.marshal(value, evidence$1, ec, mat);
    }

    default public <T> HttpEntity.Strict marshal(T value, Marshaller<T, RequestEntity> evidence$1, ExecutionContext ec, Materializer mat) {
        return (HttpEntity.Strict)Await$.MODULE$.result((Awaitable)Marshal$.MODULE$.apply(value).to(evidence$1, ec).flatMap((Function1 & Serializable)_$1 -> _$1.toStrict(this.marshallingTimeout(), mat), ec), (Duration)package.IntMult$.MODULE$.$times$extension(scala.concurrent.duration.package$.MODULE$.IntMult(2), this.marshallingTimeout()));
    }

    public static HttpResponse marshalToResponseForRequestAccepting$(MarshallingTestUtils $this, Object value, Seq mediaRanges, Marshaller evidence$1, ExecutionContext ec) {
        return $this.marshalToResponseForRequestAccepting(value, (Seq<MediaRange>)mediaRanges, evidence$1, ec);
    }

    default public <T> HttpResponse marshalToResponseForRequestAccepting(T value, Seq<MediaRange> mediaRanges, Marshaller<T, HttpResponse> evidence$1, ExecutionContext ec) {
        Accept accept = Accept$.MODULE$.apply((Seq)mediaRanges.toList());
        List list = scala.package$.MODULE$.Nil().$colon$colon((Object)accept);
        HttpMethod httpMethod = HttpRequest$.MODULE$.apply$default$1();
        Uri uri = HttpRequest$.MODULE$.apply$default$2();
        RequestEntity requestEntity = HttpRequest$.MODULE$.apply$default$4();
        HttpProtocol httpProtocol = HttpRequest$.MODULE$.apply$default$5();
        return this.marshalToResponse(value, HttpRequest$.MODULE$.apply(httpMethod, uri, (Seq)list, requestEntity, httpProtocol), evidence$1, ec);
    }

    public static HttpResponse marshalToResponse$(MarshallingTestUtils $this, Object value, HttpRequest request, Marshaller evidence$1, ExecutionContext ec) {
        return $this.marshalToResponse(value, request, evidence$1, ec);
    }

    default public <T> HttpResponse marshalToResponse(T value, HttpRequest request, Marshaller<T, HttpResponse> evidence$1, ExecutionContext ec) {
        return (HttpResponse)Await$.MODULE$.result((Awaitable)Marshal$.MODULE$.apply(value).toResponseFor(request, evidence$1, ec), (Duration)this.marshallingTimeout());
    }

    public static HttpRequest marshalToResponse$default$2$(MarshallingTestUtils $this) {
        return $this.marshalToResponse$default$2();
    }

    default public <T> HttpRequest marshalToResponse$default$2() {
        return HttpRequest$.MODULE$.apply(HttpRequest$.MODULE$.apply$default$1(), HttpRequest$.MODULE$.apply$default$2(), HttpRequest$.MODULE$.apply$default$3(), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5());
    }

    public static Object unmarshalValue$(MarshallingTestUtils $this, HttpEntity entity, Unmarshaller evidence$1, ExecutionContext ec, Materializer mat) {
        return $this.unmarshalValue(entity, evidence$1, ec, mat);
    }

    default public <T> T unmarshalValue(HttpEntity entity, Unmarshaller<HttpEntity, T> evidence$1, ExecutionContext ec, Materializer mat) {
        return (T)this.unmarshal(entity, evidence$1, ec, mat).get();
    }

    public static Try unmarshal$(MarshallingTestUtils $this, HttpEntity entity, Unmarshaller evidence$1, ExecutionContext ec, Materializer mat) {
        return $this.unmarshal(entity, evidence$1, ec, mat);
    }

    default public <T> Try<T> unmarshal(HttpEntity entity, Unmarshaller<HttpEntity, T> evidence$1, ExecutionContext ec, Materializer mat) {
        Future fut = Unmarshal$.MODULE$.apply((Object)entity).to(evidence$1, ec, mat);
        Await$.MODULE$.ready((Awaitable)fut, (Duration)this.marshallingTimeout());
        return (Try)fut.value().get();
    }
}

