/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.javadsl.testkit;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystem$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.SystemMaterializer$;
import org.junit.rules.ExternalResource;
import scala.Predef$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;

public class ActorSystemResource
extends ExternalResource {
    private final String name;
    private final Config additionalConfig;
    private ActorSystem _system;

    public ActorSystemResource(String name, Config additionalConfig) {
        this.name = name;
        this.additionalConfig = additionalConfig;
        this._system = null;
    }

    public Config config() {
        return this.additionalConfig.withFallback((ConfigMergeable)ConfigFactory.load());
    }

    public ActorSystem createSystem() {
        return ActorSystem$.MODULE$.apply(this.name, this.config());
    }

    public ActorSystem system() {
        return this._system;
    }

    public Materializer materializer() {
        return SystemMaterializer$.MODULE$.get(this.system()).materializer();
    }

    public void before() {
        Predef$.MODULE$.require(this._system == null);
        this._system = this.createSystem();
    }

    public void after() {
        Await$.MODULE$.result((Awaitable)this._system.terminate(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
        this._system = null;
    }
}

