/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.caching;

import com.github.benmanes.caffeine.cache.AsyncCache;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.caching.LfuCache$;
import org.apache.pekko.http.caching.javadsl.CachingSettings;
import org.apache.pekko.http.caching.scaladsl.Cache;
import org.apache.pekko.util.FutureConverters;
import org.apache.pekko.util.FutureConverters$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;

@InternalApi
public class LfuCache<K, V>
extends Cache<K, V> {
    private final AsyncCache store;

    public static <K, V> org.apache.pekko.http.caching.javadsl.Cache<K, V> create(ActorSystem actorSystem) {
        return LfuCache$.MODULE$.create(actorSystem);
    }

    public static <K, V> org.apache.pekko.http.caching.javadsl.Cache<K, V> create(CachingSettings cachingSettings) {
        return LfuCache$.MODULE$.create(cachingSettings);
    }

    public static <K, V> BiFunction<K, Executor, CompletableFuture<V>> toJavaMappingFunction(Function0<Future<V>> function0) {
        return LfuCache$.MODULE$.toJavaMappingFunction(function0);
    }

    public static <K, V> BiFunction<K, Executor, CompletableFuture<V>> toJavaMappingFunction(Function1<K, Future<V>> function1) {
        return LfuCache$.MODULE$.toJavaMappingFunction(function1);
    }

    public LfuCache(AsyncCache<K, V> store) {
        this.store = store;
    }

    public AsyncCache<K, V> store() {
        return this.store;
    }

    @Override
    public Option<Future<V>> get(K key) {
        return Option$.MODULE$.apply((Object)this.store().getIfPresent(key)).map((Function1 & Serializable)_$4 -> {
            CompletionStage completionStage = FutureConverters$.MODULE$.CompletionStageOps((CompletionStage)_$4);
            return FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(completionStage);
        });
    }

    @Override
    public Future<V> apply(K key, Function0<Future<V>> genValue) {
        CompletionStage completionStage = FutureConverters$.MODULE$.CompletionStageOps((CompletionStage)this.store().get(key, LfuCache$.MODULE$.toJavaMappingFunction(genValue)));
        return FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(completionStage);
    }

    @Override
    public Future<V> put(K key, Future<V> mayBeValue, ExecutionContext ex) {
        Option previouslyCacheValue = Option$.MODULE$.apply((Object)this.store().getIfPresent(key));
        Option option = previouslyCacheValue;
        if (None$.MODULE$.equals(option)) {
            Future future = FutureConverters$.MODULE$.FutureOps(mayBeValue);
            this.store().put(key, FutureConverters.FutureOps$.MODULE$.asJava$extension(future).toCompletableFuture());
            return mayBeValue;
        }
        return mayBeValue.map((Function1 & Serializable)value -> {
            Future future = FutureConverters$.MODULE$.FutureOps(Future$.MODULE$.successful(value));
            this.store().put(key, FutureConverters.FutureOps$.MODULE$.asJava$extension(future).toCompletableFuture());
            return value;
        }, ex);
    }

    @Override
    public Future<V> getOrLoad(K key, Function1<K, Future<V>> loadValue) {
        CompletionStage completionStage = FutureConverters$.MODULE$.CompletionStageOps((CompletionStage)this.store().get(key, LfuCache$.MODULE$.toJavaMappingFunction(loadValue)));
        return FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(completionStage);
    }

    @Override
    public void remove(K key) {
        this.store().synchronous().invalidate(key);
    }

    @Override
    public void clear() {
        this.store().synchronous().invalidateAll();
    }

    @Override
    public Set<K> keys() {
        return ((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(this.store().synchronous().asMap().keySet()).asScala()).toSet();
    }

    @Override
    public int size() {
        return this.store().synchronous().asMap().size();
    }
}

