/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class HiveSchemaConverter {
    public static MessageType convert(List<String> columnNames, List<TypeInfo> columnTypes) {
        MessageType schema = new MessageType("hive_schema", HiveSchemaConverter.convertTypes(columnNames, columnTypes));
        return schema;
    }

    private static Type[] convertTypes(List<String> columnNames, List<TypeInfo> columnTypes) {
        if (columnNames.size() != columnTypes.size()) {
            throw new IllegalStateException("Mismatched Hive columns and types. Hive columns names found : " + columnNames + " . And Hive types found : " + columnTypes);
        }
        Type[] types = new Type[columnNames.size()];
        for (int i = 0; i < columnNames.size(); ++i) {
            types[i] = HiveSchemaConverter.convertType(columnNames.get(i), columnTypes.get(i));
        }
        return types;
    }

    private static Type convertType(String name, TypeInfo typeInfo) {
        return HiveSchemaConverter.convertType(name, typeInfo, Type.Repetition.OPTIONAL);
    }

    private static Type convertType(String name, TypeInfo typeInfo, Type.Repetition repetition) {
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE)) {
            if (typeInfo.equals((Object)TypeInfoFactory.stringTypeInfo)) {
                return new PrimitiveType(repetition, PrimitiveType.PrimitiveTypeName.BINARY, name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.intTypeInfo) || typeInfo.equals((Object)TypeInfoFactory.shortTypeInfo) || typeInfo.equals((Object)TypeInfoFactory.byteTypeInfo)) {
                return new PrimitiveType(repetition, PrimitiveType.PrimitiveTypeName.INT32, name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.longTypeInfo)) {
                return new PrimitiveType(repetition, PrimitiveType.PrimitiveTypeName.INT64, name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.doubleTypeInfo)) {
                return new PrimitiveType(repetition, PrimitiveType.PrimitiveTypeName.DOUBLE, name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.floatTypeInfo)) {
                return new PrimitiveType(repetition, PrimitiveType.PrimitiveTypeName.FLOAT, name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.booleanTypeInfo)) {
                return new PrimitiveType(repetition, PrimitiveType.PrimitiveTypeName.BOOLEAN, name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.binaryTypeInfo)) {
                throw new UnsupportedOperationException("Binary type not implemented");
            }
            if (typeInfo.equals((Object)TypeInfoFactory.timestampTypeInfo)) {
                throw new UnsupportedOperationException("Timestamp type not implemented");
            }
            if (typeInfo.equals((Object)TypeInfoFactory.voidTypeInfo)) {
                throw new UnsupportedOperationException("Void type not implemented");
            }
            if (typeInfo.equals((Object)TypeInfoFactory.unknownTypeInfo)) {
                throw new UnsupportedOperationException("Unknown type not implemented");
            }
            throw new IllegalArgumentException("Unknown type: " + typeInfo);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            return HiveSchemaConverter.convertArrayType(name, (ListTypeInfo)typeInfo);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.STRUCT)) {
            return HiveSchemaConverter.convertStructType(name, (StructTypeInfo)typeInfo);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.MAP)) {
            return HiveSchemaConverter.convertMapType(name, (MapTypeInfo)typeInfo);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.UNION)) {
            throw new UnsupportedOperationException("Union type not implemented");
        }
        throw new IllegalArgumentException("Unknown type: " + typeInfo);
    }

    private static GroupType convertArrayType(String name, ListTypeInfo typeInfo) {
        TypeInfo subType = typeInfo.getListElementTypeInfo();
        return HiveSchemaConverter.listWrapper(name, OriginalType.LIST, new GroupType(Type.Repetition.REPEATED, ParquetHiveSerDe.ARRAY.toString(), new Type[]{HiveSchemaConverter.convertType("array_element", subType)}));
    }

    private static GroupType convertStructType(String name, StructTypeInfo typeInfo) {
        ArrayList columnNames = typeInfo.getAllStructFieldNames();
        ArrayList columnTypes = typeInfo.getAllStructFieldTypeInfos();
        return new GroupType(Type.Repetition.OPTIONAL, name, HiveSchemaConverter.convertTypes(columnNames, columnTypes));
    }

    private static GroupType convertMapType(String name, MapTypeInfo typeInfo) {
        Type keyType = HiveSchemaConverter.convertType(ParquetHiveSerDe.MAP_KEY.toString(), typeInfo.getMapKeyTypeInfo(), Type.Repetition.REQUIRED);
        Type valueType = HiveSchemaConverter.convertType(ParquetHiveSerDe.MAP_VALUE.toString(), typeInfo.getMapValueTypeInfo());
        return ConversionPatterns.mapType((Type.Repetition)Type.Repetition.OPTIONAL, (String)name, (Type)keyType, (Type)valueType);
    }

    private static GroupType listWrapper(String name, OriginalType originalType, GroupType groupType) {
        return new GroupType(Type.Repetition.OPTIONAL, name, originalType, new Type[]{groupType});
    }
}

