/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001]1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\t)\u0002+Y5n_:\u001c\u0016p\u001d;f[R\u000b'\r\\3UKN$(B\u0001\u0003\u0006\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\r\u001d\tQa\u001d9be.T!\u0001C\u0005\u0002\rA\f\u0017.\\8o\u0015\tQ1\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0019\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0004\t\u0003!Ei\u0011!B\u0005\u0003%\u0015\u00111\u0003U1j[>t7\u000b]1sWR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"A\u0002")
public class PaimonSystemTableTest
extends PaimonSparkTestBase {
    public PaimonSystemTableTest() {
        this.test("system table: sort tags table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING)\n                 |USING PAIMON\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES(1, 'a')");
            this.spark().sql("CALL paimon.sys.create_tag(table => 'test.T', tag => '2024-10-02')");
            this.spark().sql("CALL paimon.sys.create_tag(table => 'test.T', tag => '2024-10-01')");
            this.spark().sql("CALL paimon.sys.create_tag(table => 'test.T', tag => '2024-10-04')");
            this.spark().sql("CALL paimon.sys.create_tag(table => 'test.T', tag => '2024-10-03')");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2024-10-01"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2024-10-02"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2024-10-03"}));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2024-10-04"}));
            this.checkAnswer((Function0 & java.io.Serializable & Serializable)() -> this.spark().sql("select tag_name from `T$tags`"), (Seq)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
        }, new Position("PaimonSystemTableTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
        this.test("system table: sort partitions table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (a INT, b STRING,dt STRING,hh STRING)\n                 |PARTITIONED BY (dt, hh)\n                 |TBLPROPERTIES ('primary-key'='a,dt,hh', 'bucket' = '3')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES(1, 'a', '2024-10-10', '01')");
            this.spark().sql("INSERT INTO T VALUES(3, 'c', '2024-10-10', '23')");
            this.spark().sql("INSERT INTO T VALUES(2, 'b', '2024-10-10', '12')");
            this.spark().sql("INSERT INTO T VALUES(5, 'f', '2024-10-09', '02')");
            this.spark().sql("INSERT INTO T VALUES(4, 'd', '2024-10-09', '01')");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5)}));
            this.checkAnswer((Function0 & java.io.Serializable & Serializable)() -> this.spark().sql("select count(*) from `T$partitions`"), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"[2024-10-09, 01]"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"[2024-10-09, 02]"}));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"[2024-10-10, 01]"}));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"[2024-10-10, 12]"}));
            Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"[2024-10-10, 23]"}));
            this.checkAnswer((Function0 & java.io.Serializable & Serializable)() -> this.spark().sql("select partition from `T$partitions`"), (Seq)Nil$.MODULE$.$colon$colon((Object)row6).$colon$colon((Object)row5).$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2));
        }, new Position("PaimonSystemTableTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("system table: sort buckets table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (a INT, b STRING,dt STRING,hh STRING)\n                 |PARTITIONED BY (dt, hh)\n                 |TBLPROPERTIES ('primary-key'='a,dt,hh', 'bucket' = '3')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES(1, 'a', '2024-10-10', '01')");
            this.spark().sql("INSERT INTO T VALUES(2, 'b', '2024-10-10', '01')");
            this.spark().sql("INSERT INTO T VALUES(3, 'c', '2024-10-10', '01')");
            this.spark().sql("INSERT INTO T VALUES(4, 'd', '2024-10-10', '01')");
            this.spark().sql("INSERT INTO T VALUES(5, 'f', '2024-10-10', '01')");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
            this.checkAnswer((Function0 & java.io.Serializable & Serializable)() -> this.spark().sql("select count(*) from `T$partitions`"), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"[2024-10-10, 01]", BoxesRunTime.boxToInteger((int)0)}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"[2024-10-10, 01]", BoxesRunTime.boxToInteger((int)1)}));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"[2024-10-10, 01]", BoxesRunTime.boxToInteger((int)2)}));
            this.checkAnswer((Function0 & java.io.Serializable & Serializable)() -> this.spark().sql("select partition,bucket from `T$buckets`"), (Seq)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2));
        }, new Position("PaimonSystemTableTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("system table: binlog table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE T (a INT, b INT)\n          |TBLPROPERTIES ('primary-key'='a', 'changelog-producer' = 'lookup', 'bucket' = '2')\n          |")).stripMargin());
            this.sql().apply((Object)"INSERT INTO T VALUES (1, 2)");
            this.sql().apply((Object)"INSERT INTO T VALUES (1, 3)");
            this.sql().apply((Object)"INSERT INTO T VALUES (2, 2)");
            this.checkAnswer((Function0 & java.io.Serializable & Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM `T$binlog`"), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"+I", new int[]{1}, new int[]{3}})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"+I", new int[]{2}, new int[]{2}})), (List)Nil$.MODULE$)));
        }, new Position("PaimonSystemTableTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
    }
}

