/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.paimon.fs.Path;
import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.Split;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t3Aa\u0001\u0003\u0001\u001f!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00053\ty\u0001+Y5n_:\fV/\u001a:z)\u0016\u001cHO\u0003\u0002\u0006\r\u0005\u00191/\u001d7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\u0001\u0018-[7p]*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0004\n\u0005M1!a\u0005)bS6|gn\u00159be.$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001\u0017!\t9\u0002!D\u0001\u0005\u0003-9W\r^!mY\u001aKG.Z:\u0015\tiYS\u0006\u000f\t\u00047y\u0001S\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0005BcB\u0001\u0012'!\t\u0019C$D\u0001%\u0015\t)c\"\u0001\u0004=e>|GOP\u0005\u0003Oq\ta\u0001\u0015:fI\u00164\u0017BA\u0015+\u0005\u0019\u0019FO]5oO*\u0011q\u0005\b\u0005\u0006Y\t\u0001\r\u0001I\u0001\ni\u0006\u0014G.\u001a(b[\u0016DQA\f\u0002A\u0002=\n!\u0002]1si&$\u0018n\u001c8t!\r\u0001T\u0007\t\b\u0003cMr!a\t\u001a\n\u0003uI!\u0001\u000e\u000f\u0002\u000fA\f7m[1hK&\u0011ag\u000e\u0002\u0004'\u0016\f(B\u0001\u001b\u001d\u0011\u0015I$\u00011\u0001;\u0003=\u0001\u0018M\u001d;ji&|gNR5mi\u0016\u0014\b\u0003B\u001eAA\u0001j\u0011\u0001\u0010\u0006\u0003{y\nA!\u001e;jY*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005\ri\u0015\r\u001d")
public class PaimonQueryTest
extends PaimonSparkTestBase {
    private String[] getAllFiles(String tableName, Seq<String> partitions, Map<String, String> partitionFilter) {
        FileStoreTable paimonTable = this.loadTable(tableName);
        Path location = paimonTable.location();
        Buffer files = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(paimonTable.newSnapshotReader().withPartitionFilter(partitionFilter).read().splits()).asScala()).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Split, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                DataSplit dataSplit;
                A1 A1 = x1;
                Object object = A1 instanceof DataSplit ? (dataSplit = (DataSplit)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Split x1) {
                Split split = x1;
                boolean bl = split instanceof DataSplit;
                return bl;
            }
        }, Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)ds -> {
            String string;
            if (partitions.isEmpty()) {
                string = new StringBuilder(8).append(location).append("/bucket-").append(ds.bucket()).toString();
            } else {
                String partitionPath = ((TraversableOnce)((TraversableLike)partitions.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String pt = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    String string = new StringBuilder(1).append(pt).append("=").append(ds.partition().getString(index)).toString();
                    return string;
                }, Seq$.MODULE$.canBuildFrom())).mkString("/");
                string = new StringBuilder(9).append(location).append("/").append(partitionPath).append("/bucket-").append(ds.bucket()).toString();
            }
            String prefix = string;
            return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ds.dataFiles()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(1).append(prefix).append("/").append(f.fileName()).toString(), Buffer$.MODULE$.canBuildFrom());
        }, Buffer$.MODULE$.canBuildFrom());
        return (String[])((TraversableOnce)files.sorted((Ordering)Ordering.String$.MODULE$)).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public static final /* synthetic */ void $anonfun$new$1(PaimonQueryTest $this, String fileFormat) {
        $this.bucketModes().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)bucketMode -> $this.test(new StringBuilder(45).append("Query metadata columns: file.format=").append(fileFormat).append(", bucket=").append(bucketMode).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(166).append("\n                   |CREATE TABLE T (id INT, name STRING)\n                   |TBLPROPERTIES ('primary-key' = 'id', 'file.format'='").append(fileFormat).append("', 'bucket'='").append(bucketMode).append("')\n                   |").toString())).stripMargin());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                          |INSERT INTO T\n                          |VALUES (1, 'x1'), (2, 'x3'), (3, 'x3'), (4, 'x4'), (5, 'x5')\n                          |")).stripMargin());
            String location = $this.loadTable("T").location().toUri().toString();
            Dataset res = $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(385).append("\n                   |SELECT SUM(cnt)\n                   |FROM (\n                   |  SELECT __paimon_file_path AS path, count(1) AS cnt, count(distinct __paimon_row_index) AS dc\n                   |  FROM T\n                   |  GROUP BY __paimon_file_path\n                   |)\n                   |WHERE startswith(path, '").append(location).append("') and endswith(path, '.").append(fileFormat).append("') and cnt == dc\n                   |").toString())).stripMargin());
            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> res, Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5)})));
        }), new Position("PaimonQueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38)));
    }

    public static final /* synthetic */ void $anonfun$new$12(PaimonQueryTest $this, String fileFormat) {
        $this.bucketModes().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)bucketMode -> $this.test(new StringBuilder(46).append("Query input_file_name(): file.format=").append(fileFormat).append(", bucket=").append(bucketMode).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String bucketProp = bucketMode != -1 ? new StringBuilder(35).append(", 'bucket-key'='id', 'bucket' = '").append(bucketMode).append("' ").toString() : "";
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(156).append("\n                           |CREATE TABLE T (id INT, name STRING)\n                           |TBLPROPERTIES ('file.format'='").append(fileFormat).append("' ").append(bucketProp).append(")\n                           |").toString())).stripMargin());
            String location = $this.loadTable("T").location().toUri().toString();
            $this.spark().sql("INSERT INTO T VALUES (1, 'x1'), (3, 'x3')");
            Dataset res1 = $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(348).append("\n                                      |SELECT *,\n                                      |startswith(input_file_name(), '").append(location).append("') AS start,\n                                      |endswith(input_file_name(), '.").append(fileFormat).append("') AS end\n                                      |FROM T\n                                      |ORdER BY id\n                                      |").toString())).stripMargin());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "x1", BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)true)}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "x3", BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)true)}));
            $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> res1, (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
            $this.spark().sql("INSERT INTO T VALUES (2, 'x2'), (4, 'x4'), (6, 'x6')");
            String[] res2 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql("SELECT input_file_name() FROM T").distinct().as($this.testImplicits().newStringEncoder()).collect())).sorted((Ordering)Ordering.String$.MODULE$);
            String[] allDataFiles = $this.getAllFiles("T", (Seq<String>)((Seq)Nil$.MODULE$), null);
            Assertions.assertTrue((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])res2)).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])allDataFiles)));
        }), new Position("PaimonQueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118)));
    }

    public static final /* synthetic */ void $anonfun$new$17(PaimonQueryTest $this, String fileFormat) {
        $this.bucketModes().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)bucketMode -> $this.test(new StringBuilder(68).append("Query input_file_name() for partitioned table: file.format=").append(fileFormat).append(", bucket=").append(bucketMode).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkSession _spark = $this.spark();
            String bucketProp = bucketMode != -1 ? new StringBuilder(35).append(", 'bucket-key'='id', 'bucket' = '").append(bucketMode).append("' ").toString() : "";
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(215).append("\n                           |CREATE TABLE T (id INT, name STRING, pt STRING)\n                           |PARTITIONED BY (pt)\n                           |TBLPROPERTIES ('file.format'='").append(fileFormat).append("' ").append(bucketProp).append(")\n                           |").toString())).stripMargin());
                String location = $this.loadTable("T").location().toUri().toString();
                $this.spark().sql("INSERT INTO T VALUES (1, 'x1', '2024'), (3, 'x3', '2024')");
                Dataset res1 = $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(359).append("\n                                      |SELECT id, name, pt,\n                                      |startswith(input_file_name(), '").append(location).append("') AS start,\n                                      |endswith(input_file_name(), '.").append(fileFormat).append("') AS end\n                                      |FROM T\n                                      |ORdER BY id\n                                      |").toString())).stripMargin());
                Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "x1", "2024", BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)true)}));
                Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "x3", "2024", BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)true)}));
                $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> res1, (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
                $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                          |INSERT INTO T\n                          |VALUES (2, 'x2', '2025'), (4, 'x4', '2025'), (6, 'x6', '2026')\n                          |")).stripMargin());
                String[] res2 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql("SELECT input_file_name() FROM T WHERE pt='2026'").distinct().as(_spark.implicits().newStringEncoder()).collect())).sorted((Ordering)Ordering.String$.MODULE$);
                HashMap<String, String> partitionFilter = new HashMap<String, String>();
                partitionFilter.put("pt", "2026");
                String[] partialDataFiles = $this.getAllFiles("T", (Seq<String>)((Seq)new .colon.colon((Object)"pt", (List)Nil$.MODULE$)), partitionFilter);
                Assertions.assertTrue((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])res2)).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])partialDataFiles)));
                String[] res3 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql("SELECT input_file_name() FROM T").distinct().as(_spark.implicits().newStringEncoder()).collect())).sorted((Ordering)Ordering.String$.MODULE$);
                String[] allDataFiles = $this.getAllFiles("T", (Seq<String>)((Seq)new .colon.colon((Object)"pt", (List)Nil$.MODULE$)), null);
                Assertions.assertTrue((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])res3)).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])allDataFiles)));
            });
        }, new Position("PaimonQueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162)));
    }

    public static final /* synthetic */ void $anonfun$new$24(PaimonQueryTest $this, boolean hasPk$1, String fileFormat) {
        $this.bucketModes().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)bucketMode -> {
            String key = hasPk$1 ? "primary-key" : "bucket-key";
            String props = bucketMode != -1 ? new StringBuilder(27).append(", '").append(key).append("'='name', 'bucket' = '").append(bucketMode).append("' ").toString() : "";
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"students"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(800).append("\n                         |CREATE TABLE students (\n                         |  name STRING,\n                         |  course STRUCT<course_name: STRING, grade: DOUBLE>,\n                         |  teacher STRUCT<name: STRING, address: STRUCT<street: STRING, city: STRING>>,\n                         |  m MAP<STRING, STRUCT<s:STRING, i INT, d: DOUBLE>>,\n                         |  l ARRAY<STRUCT<s:STRING, i INT, d: DOUBLE>>,\n                         |  s STRUCT<s1: STRING, s2: MAP<STRING, STRUCT<s:STRING, i INT, a: ARRAY<STRUCT<s:STRING, i INT, d: DOUBLE>>>>>,\n                         |  m2 MAP<STRUCT<s:STRING, i INT, d: DOUBLE>, STRUCT<s:STRING, i INT, d: DOUBLE>>\n                         |) USING paimon\n                         |TBLPROPERTIES ('file.format'='").append(fileFormat).append("' ").append(props).append(")\n                         |").toString())).stripMargin());
                $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n                         |INSERT INTO students VALUES (\n                         |  'Alice',\n                         |  STRUCT('Math', 85.0),\n                         |  STRUCT('John', STRUCT('Street 1', 'City 1')),\n                         |  MAP('k1', STRUCT('s1', 1, 1.0), 'k2', STRUCT('s11', 11, 11.0)),\n                         |  ARRAY(STRUCT('s1', 1, 1.0), STRUCT('s11', 11, 11.0)),\n                         |  STRUCT('a', MAP('k1', STRUCT('s1', 1, ARRAY(STRUCT('s1', 1, 1.0))), 'k3', STRUCT('s11', 11, ARRAY(STRUCT('s11', 11, 11.0))))),\n                         |  MAP(STRUCT('k1', 1, 1.0), STRUCT('s1', 1, 1.0), STRUCT('k2', 1, 1.0), STRUCT('s11', 11, 11.0)))\n                         |")).stripMargin());
                $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n                       |INSERT INTO students VALUES (\n                       |  'Bob',\n                       |  STRUCT('Biology', 92.0),\n                       |  STRUCT('Jane', STRUCT('Street 2', 'City 2')),\n                       |  MAP('k2', STRUCT('s2', 2, 2.0)),\n                       |  ARRAY(STRUCT('s2', 2, 2.0), STRUCT('s22', 22, 22.0)),\n                       |  STRUCT('b', MAP('k2', STRUCT('s22', 22, ARRAY(STRUCT('s22', 22, 22.0))))),\n                       |  MAP(STRUCT('k2', 2, 2.0), STRUCT('s22', 22, 22.0)))\n                       |")).stripMargin());
                $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n                         |INSERT INTO students VALUES (\n                         |  'Cathy',\n                         |  STRUCT('History', 95.0),\n                         |  STRUCT('Jane', STRUCT('Street 3', 'City 3')),\n                         |  MAP('k1', STRUCT('s3', 3, 3.0), 'k2', STRUCT('s33', 33, 33.0)),\n                         |  ARRAY(STRUCT('s3', 3, 3.0)),\n                         |  STRUCT('c', MAP('k1', STRUCT('s3', 3, ARRAY(STRUCT('s3', 3, 3.0))), 'k2', STRUCT('s33', 33, ARRAY(STRUCT('s33', 33, 33.0))))),\n                         |  MAP(STRUCT('k1', 3, 3.0), STRUCT('s3', 3, 3.0), STRUCT('k2', 3, 3.0), STRUCT('s33', 33, 33.0)))\n                         |")).stripMargin());
                $this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.ansi.enabled"), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n                             |SELECT\n                             |  course.grade, name, teacher.address, course.course_name,\n                             |  m['k1'].d, m['k1'].s,\n                             |  l[1].d, l[1].s,\n                             |  s.s2['k2'].a[0].i,\n                             |  map_keys(m2).i\n                             |FROM students ORDER BY name\n                             |")).stripMargin()), (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)85.0), "Alice", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Street 1", "City 1"})), "Math", BoxesRunTime.boxToDouble((double)1.0), "s1", BoxesRunTime.boxToDouble((double)11.0), "s11", null, Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 1}))})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)92.0), "Bob", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Street 2", "City 2"})), "Biology", null, null, BoxesRunTime.boxToDouble((double)22.0), "s22", BoxesRunTime.boxToInteger((int)22), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}))})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)95.0), "Cathy", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Street 3", "City 3"})), "History", BoxesRunTime.boxToDouble((double)3.0), "s3", null, null, BoxesRunTime.boxToInteger((int)33), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 3}))})), (List)Nil$.MODULE$)))));
            });
        });
    }

    public static final /* synthetic */ void $anonfun$new$23(PaimonQueryTest $this, boolean hasPk) {
        $this.fileFormats().foreach((Function1 & Serializable & scala.Serializable)fileFormat -> {
            PaimonQueryTest.$anonfun$new$24($this, hasPk, fileFormat);
            return BoxedUnit.UNIT;
        });
    }

    public PaimonQueryTest() {
        this.fileFormats().foreach((Function1 & Serializable & scala.Serializable)fileFormat -> {
            PaimonQueryTest.$anonfun$new$1(this, fileFormat);
            return BoxedUnit.UNIT;
        });
        this.test("Query metadata columns for bucket", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE T (c1 INT, c2 STRING) TBLPROPERTIES ('bucket-key'='c1', 'bucket'='3')\n          |")).stripMargin());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                  |INSERT INTO T\n                  |VALUES (1, 'x1'), (2, 'x3'), (3, 'x3'), (4, 'x4'), (5, 'x5'), (6, 'x6')\n                  |")).stripMargin());
            Dataset res = this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                            |SELECT __paimon_partition, __paimon_bucket FROM T\n                            |GROUP BY __paimon_partition, __paimon_bucket\n                            |ORDER BY __paimon_partition, __paimon_bucket\n                            |")).stripMargin());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Nil$.MODULE$), BoxesRunTime.boxToInteger((int)0)}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Nil$.MODULE$), BoxesRunTime.boxToInteger((int)1)}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Nil$.MODULE$), BoxesRunTime.boxToInteger((int)2)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> res, (Seq)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
        }), new Position("PaimonQueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("Query metadata columns for partition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                  |CREATE TABLE T (c1 INT) PARTITIONED BY(p1 INT, p2 String)\n                  |")).stripMargin());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                  |INSERT INTO T\n                  |VALUES (1, 1, 'x1'), (2, 1, 'x2'), (3, 2, 'x1'), (4, 2, 'x2'), (5, 3, 'x3')\n                  |")).stripMargin());
            Dataset res = this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                            |SELECT __paimon_partition, __paimon_bucket FROM T\n                            |GROUP BY __paimon_partition, __paimon_bucket\n                            |ORDER BY __paimon_partition, __paimon_bucket\n                            |")).stripMargin());
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "x1"})), BoxesRunTime.boxToInteger((int)0)}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "x2"})), BoxesRunTime.boxToInteger((int)0)}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "x1"})), BoxesRunTime.boxToInteger((int)0)}));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "x2"})), BoxesRunTime.boxToInteger((int)0)}));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "x3"})), BoxesRunTime.boxToInteger((int)0)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> res, (Seq)Nil$.MODULE$.$colon$colon((Object)row5).$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
        }), new Position("PaimonQueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.fileFormats().foreach((Function1 & Serializable & scala.Serializable)fileFormat -> {
            PaimonQueryTest.$anonfun$new$12(this, fileFormat);
            return BoxedUnit.UNIT;
        });
        this.fileFormats().foreach((Function1 & Serializable & scala.Serializable)fileFormat -> {
            PaimonQueryTest.$anonfun$new$17(this, fileFormat);
            return BoxedUnit.UNIT;
        });
        this.test("Paimon Query: query nested cols", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withPk().foreach((Function1 & Serializable & scala.Serializable)hasPk -> {
            PaimonQueryTest.$anonfun$new$23(this, BoxesRunTime.unboxToBoolean((Object)hasPk));
            return BoxedUnit.UNIT;
        }), new Position("PaimonQueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
        this.test("Paimon Query: query nested array cols", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n            |CREATE TABLE t (\n            | id INT,\n            | array_array ARRAY<ARRAY<INT>>,\n            | array_map ARRAY<MAP<STRING, STRING>>,\n            | array_struct ARRAY<STRUCT<s1: INT, s2: STRING>>\n            |)\n            |")).stripMargin());
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n            |INSERT INTO t VALUES (\n            | 1,\n            | array(array(1, 3)),\n            | array(map('k1', 'v1'), map('k2', 'v2')),\n            | array(struct(1, 's1'), struct(2, 's2'))\n            |)\n            |")).stripMargin());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n               |SELECT\n               |  array_array[0][1],\n               |  array_map[0]['k1'],\n               |  array_struct[1].s2\n               |FROM t\n               |")).stripMargin()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "v1", "s2"})));
        }), new Position("PaimonQueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
    }
}

