/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import java.io.Serializable;
import org.apache.paimon.spark.PaimonScan;
import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.paimon.spark.SparkTable;
import org.apache.paimon.spark.sql.PaimonPushDownTest$;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.Split;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsPushDownLimit;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.junit.jupiter.api.Assertions;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001a3AAB\u0004\u0001%!)q\u0003\u0001C\u00011!)1\u0004\u0001C\u00059!9a\u0007AI\u0001\n\u00139\u0004\"\u0002\"\u0001\t\u0013\u0019\u0005\"B%\u0001\t\u0013Q%A\u0005)bS6|g\u000eU;tQ\u0012{wO\u001c+fgRT!\u0001C\u0005\u0002\u0007M\fHN\u0003\u0002\u000b\u0017\u0005)1\u000f]1sW*\u0011A\"D\u0001\u0007a\u0006LWn\u001c8\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\u0002\u0001'\t\u00011\u0003\u0005\u0002\u0015+5\t\u0011\"\u0003\u0002\u0017\u0013\t\u0019\u0002+Y5n_:\u001c\u0006/\u0019:l)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011aB\u0001\u000fO\u0016$8kY1o\u0005VLG\u000eZ3s)\tir\u0005\u0005\u0002\u001fK5\tqD\u0003\u0002!C\u0005!!/Z1e\u0015\t\u00113%A\u0005d_:tWm\u0019;pe*\u0011\u0001\u0002\n\u0006\u0003\u00155I!AJ\u0010\u0003\u0017M\u001b\u0017M\u001c\"vS2$WM\u001d\u0005\bQ\t\u0001\n\u00111\u0001*\u0003%!\u0018M\u00197f\u001d\u0006lW\r\u0005\u0002+g9\u00111&\r\t\u0003Y=j\u0011!\f\u0006\u0003]E\ta\u0001\u0010:p_Rt$\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz\u0013A\u0002)sK\u0012,g-\u0003\u00025k\t11\u000b\u001e:j]\u001eT!AM\u0018\u00021\u001d,GoU2b]\n+\u0018\u000e\u001c3fe\u0012\"WMZ1vYR$\u0013'F\u00019U\tI\u0013hK\u0001;!\tY\u0004)D\u0001=\u0015\tid(A\u0005v]\u000eDWmY6fI*\u0011qhL\u0001\u000bC:tw\u000e^1uS>t\u0017BA!=\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0012G\",7m\u001b$jYR,'/\u0012=jgR\u001cHC\u0001#I!\t)e)D\u00010\u0013\t9uFA\u0004C_>dW-\u00198\t\u000b!!\u0001\u0019A\u0015\u00021\rDWmY6FcV\fG\u000eV8GS2$XM]#ySN$8\u000f\u0006\u0003E\u00172s\u0005\"\u0002\u0005\u0006\u0001\u0004I\u0003\"B'\u0006\u0001\u0004I\u0013\u0001\u00028b[\u0016DQaT\u0003A\u0002A\u000bQA^1mk\u0016\u0004\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003+\u000e\n\u0001bY1uC2L8\u000f^\u0005\u0003/J\u0013q\u0001T5uKJ\fG\u000e")
public class PaimonPushDownTest
extends PaimonSparkTestBase {
    private ScanBuilder getScanBuilder(String tableName) {
        return new SparkTable((Table)this.loadTable(tableName)).newScanBuilder(CaseInsensitiveStringMap.empty());
    }

    private String getScanBuilder$default$1() {
        return "T";
    }

    private boolean checkFilterExists(String sql) {
        return this.spark().sql(sql).queryExecution().optimizedPlan().exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PaimonPushDownTest.$anonfun$checkFilterExists$1(x0$1)));
    }

    private boolean checkEqualToFilterExists(String sql, String name, Literal value) {
        return this.spark().sql(sql).queryExecution().optimizedPlan().exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PaimonPushDownTest.$anonfun$checkEqualToFilterExists$1(name, value, x0$1)));
    }

    public static final /* synthetic */ void $anonfun$new$14(Split splits) {
        Assertions.assertTrue((boolean)((DataSplit)splits).rawConvertible());
    }

    public static final /* synthetic */ boolean $anonfun$new$15(Split split) {
        return ((DataSplit)split).rawConvertible();
    }

    public static final /* synthetic */ void $anonfun$new$16(Split splits) {
        Assertions.assertFalse((boolean)((DataSplit)splits).rawConvertible());
    }

    public static final /* synthetic */ void $anonfun$new$18(PaimonPushDownTest $this, boolean deletionVectorsEnabled) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)primaryKeyTable -> {
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Split[] withoutLimit;
                $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(258).append("\n                     |CREATE TABLE T (id INT)\n                     |TBLPROPERTIES (\n                     | 'deletion-vectors.enabled' = ").append(deletionVectorsEnabled$1).append(",\n                     | '").append((Object)(primaryKeyTable ? "primary-key" : "bucket-key")).append("' = 'id',\n                     | 'bucket' = '10'\n                     |)\n                     |").toString())).stripMargin());
                $this.sql().apply((Object)"INSERT INTO T SELECT id FROM range (1, 50000)");
                $this.sql().apply((Object)"DELETE FROM T WHERE id % 13 = 0");
                Split[] $org_scalatest_assert_macro_left = withoutLimit = ((PaimonScan)$this.getScanBuilder($this.getScanBuilder$default$1()).build()).getOriginSplits();
                int $org_scalatest_assert_macro_right = 10;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PaimonPushDownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
                SupportsPushDownLimit scanBuilder = (SupportsPushDownLimit)$this.getScanBuilder($this.getScanBuilder$default$1());
                scanBuilder.pushLimit(1);
                Split[] withLimit = ((PaimonScan)scanBuilder.build()).getOriginSplits();
                if (deletionVectorsEnabled$1 || !primaryKeyTable) {
                    Split[] $org_scalatest_assert_macro_left2 = withLimit;
                    int $org_scalatest_assert_macro_right2 = 1;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PaimonPushDownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
                } else {
                    Split[] $org_scalatest_assert_macro_left3 = withLimit;
                    int $org_scalatest_assert_macro_right3 = 10;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PaimonPushDownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkFilterExists$1(LogicalPlan x0$1) {
        Filter filter;
        LogicalPlan logicalPlan = x0$1;
        boolean bl = logicalPlan instanceof Filter && (filter = (Filter)logicalPlan).condition() != null;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$checkEqualToFilterExists$2(String name$1, Literal value$1, Expression x0$2) {
        Expression expression = x0$2;
        if (!(expression instanceof EqualTo)) return false;
        EqualTo equalTo = (EqualTo)expression;
        Expression a = equalTo.left();
        Expression r = equalTo.right();
        if (!(a instanceof AttributeReference)) return false;
        AttributeReference attributeReference = (AttributeReference)a;
        if (!(r instanceof Literal)) return false;
        Literal literal = (Literal)r;
        if (!attributeReference.name().equals(name$1)) return false;
        if (!literal.equals((Object)value$1)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkEqualToFilterExists$1(String name$1, Literal value$1, LogicalPlan x0$1) {
        boolean bl;
        Filter filter;
        Expression c;
        LogicalPlan logicalPlan = x0$1;
        if (logicalPlan instanceof Filter && (c = (filter = (Filter)logicalPlan).condition()) != null) {
            Expression expression = c;
            bl = expression.exists((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)PaimonPushDownTest.$anonfun$checkEqualToFilterExists$2(name$1, value$1, x0$2)));
        } else {
            bl = false;
        }
        return bl;
    }

    public PaimonPushDownTest() {
        this.test("Paimon push down: apply partition filter push down with non-partitioned table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, name STRING, pt STRING)\n                 |TBLPROPERTIES ('primary-key'='id, pt', 'bucket'='2')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, 'a', 'p1'), (2, 'b', 'p1'), (3, 'c', 'p2')");
            String q = "SELECT * FROM T WHERE pt = 'p1'";
            Assertions.assertTrue((boolean)this.checkEqualToFilterExists(q, "pt", Literal$.MODULE$.apply((Object)"p1")));
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "p1"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", "p1"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(q), (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
        }, new Position("PaimonPushDownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("Paimon push down: apply partition filter push down with partitioned table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, name STRING, pt STRING)\n                 |TBLPROPERTIES ('primary-key'='id, pt', 'bucket'='2')\n                 |PARTITIONED BY (pt)\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, 'a', 'p1'), (2, 'b', 'p1'), (3, 'c', 'p2'), (4, 'd', 'p3')");
            ObjectRef q = ObjectRef.create((Object)"SELECT * FROM T WHERE id = '1'");
            Assertions.assertTrue((boolean)this.checkFilterExists((String)q.elem));
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "p1"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql((String)q$2.elem), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
            q.elem = "SELECT * FROM T WHERE id = '1' or pt = 'p1'";
            Assertions.assertTrue((boolean)this.checkEqualToFilterExists((String)q.elem, "pt", Literal$.MODULE$.apply((Object)"p1")));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "p1"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", "p1"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql((String)q$2.elem), (Seq)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2));
            q.elem = "SELECT * FROM T WHERE pt = 'p1'";
            Assertions.assertFalse((boolean)this.checkFilterExists((String)q.elem));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "p1"}));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", "p1"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql((String)q$2.elem), (Seq)Nil$.MODULE$.$colon$colon((Object)row5).$colon$colon((Object)row4));
            q.elem = "SELECT * FROM T WHERE id = '1' and pt = 'p1'";
            Assertions.assertFalse((boolean)this.checkEqualToFilterExists((String)q.elem, "pt", Literal$.MODULE$.apply((Object)"p1")));
            Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "p1"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql((String)q$2.elem), (Seq)Nil$.MODULE$.$colon$colon((Object)row6));
            q.elem = "SELECT * FROM T WHERE pt < 'p3'";
            Assertions.assertFalse((boolean)this.checkFilterExists((String)q.elem));
            Row row7 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "p1"}));
            Row row8 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", "p1"}));
            Row row9 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", "p2"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql((String)q$2.elem), (Seq)Nil$.MODULE$.$colon$colon((Object)row9).$colon$colon((Object)row8).$colon$colon((Object)row7));
        }, new Position("PaimonPushDownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.test("Paimon pushDown: limit for append-only tables with deletion vector", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dv_test"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE dv_test (c1 INT, c2 STRING)\n          |TBLPROPERTIES ('deletion-vectors.enabled' = 'true', 'source.split.target-size' = '1')\n          |")).stripMargin());
            this.spark().sql("insert into table dv_test values(1, 'a'),(2, 'b'),(3, 'c')");
            long $org_scalatest_assert_macro_left = this.spark().sql("select * from dv_test limit 2").count();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PaimonPushDownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            this.spark().sql("delete from dv_test where c1 = 1");
            long $org_scalatest_assert_macro_left2 = this.spark().sql("select * from dv_test limit 2").count();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PaimonPushDownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        }), new Position("PaimonPushDownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        this.test("Paimon pushDown: limit for append-only tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (a INT, b STRING, c STRING)\n                 |PARTITIONED BY (c)\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, 'a', '11'), (2, 'b', '11')");
            this.spark().sql("INSERT INTO T VALUES (3, 'c', '22'), (4, 'd', '22')");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "11"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", "11"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", "22"}));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "d", "22"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT * FROM T ORDER BY a"), (Seq)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            ScanBuilder scanBuilder = this.getScanBuilder(this.getScanBuilder$default$1());
            Assertions.assertTrue((boolean)(scanBuilder instanceof SupportsPushDownLimit));
            Split[] dataSplitsWithoutLimit = ((PaimonScan)scanBuilder.build()).getOriginSplits();
            Assertions.assertTrue((dataSplitsWithoutLimit.length >= 2 ? 1 : 0) != 0);
            Assertions.assertFalse((boolean)((SupportsPushDownLimit)scanBuilder).pushLimit(1));
            Split[] dataSplitsWithLimit = ((PaimonScan)scanBuilder.build()).getOriginSplits();
            Assertions.assertEquals((int)1, (int)dataSplitsWithLimit.length);
            Assertions.assertEquals((long)1L, (long)this.spark().sql("SELECT * FROM T LIMIT 1").count());
        }, new Position("PaimonPushDownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("Paimon pushDown: limit for primary key table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (a INT, b STRING, c STRING)\n                 |TBLPROPERTIES ('primary-key'='a')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, 'a', '11'), (2, 'b', '22')");
            this.spark().sql("INSERT INTO T VALUES (3, 'c', '11'), (4, 'd', '22')");
            ScanBuilder scanBuilder = this.getScanBuilder(this.getScanBuilder$default$1());
            Assertions.assertTrue((boolean)(scanBuilder instanceof SupportsPushDownLimit));
            Split[] dataSplitsWithoutLimit = ((PaimonScan)scanBuilder.build()).getOriginSplits();
            Assertions.assertEquals((int)4, (int)dataSplitsWithoutLimit.length);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataSplitsWithoutLimit)).foreach((Function1 & Serializable & scala.Serializable)splits -> {
                PaimonPushDownTest.$anonfun$new$14(splits);
                return BoxedUnit.UNIT;
            });
            Assertions.assertFalse((boolean)((SupportsPushDownLimit)scanBuilder).pushLimit(1));
            Split[] dataSplitsWithLimit = ((PaimonScan)scanBuilder.build()).getOriginSplits();
            Assertions.assertEquals((int)1, (int)dataSplitsWithLimit.length);
            Assertions.assertEquals((long)1L, (long)this.spark().sql("SELECT * FROM T LIMIT 1").count());
            Assertions.assertFalse((boolean)((SupportsPushDownLimit)scanBuilder).pushLimit(2));
            Split[] dataSplitsWithLimit1 = ((PaimonScan)scanBuilder.build()).getOriginSplits();
            Assertions.assertEquals((int)2, (int)dataSplitsWithLimit1.length);
            Assertions.assertEquals((long)2L, (long)this.spark().sql("SELECT * FROM T LIMIT 2").count());
            this.spark().sql("INSERT INTO T VALUES (1, 'a2', '11'), (2, 'b2', '22')");
            ScanBuilder scanBuilder2 = this.getScanBuilder(this.getScanBuilder$default$1());
            Split[] dataSplitsWithoutLimit2 = ((PaimonScan)scanBuilder2.build()).getOriginSplits();
            Assertions.assertEquals((int)4, (int)dataSplitsWithoutLimit2.length);
            Assertions.assertEquals((int)2, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataSplitsWithoutLimit2)).count((Function1 & Serializable & scala.Serializable)split -> BoxesRunTime.boxToBoolean((boolean)PaimonPushDownTest.$anonfun$new$15(split))));
            Assertions.assertFalse((boolean)((SupportsPushDownLimit)scanBuilder2).pushLimit(2));
            Split[] dataSplitsWithLimit2 = ((PaimonScan)scanBuilder2.build()).getOriginSplits();
            Assertions.assertEquals((int)2, (int)dataSplitsWithLimit2.length);
            Assertions.assertEquals((long)2L, (long)this.spark().sql("SELECT * FROM T LIMIT 2").count());
            Assertions.assertFalse((boolean)((SupportsPushDownLimit)scanBuilder2).pushLimit(3));
            Split[] dataSplitsWithLimit22 = ((PaimonScan)scanBuilder2.build()).getOriginSplits();
            Assertions.assertEquals((int)4, (int)dataSplitsWithLimit22.length);
            Assertions.assertEquals((long)3L, (long)this.spark().sql("SELECT * FROM T LIMIT 3").count());
            this.spark().sql("INSERT INTO T VALUES (3, 'c', '11'), (4, 'd', '22')");
            ScanBuilder scanBuilder3 = this.getScanBuilder(this.getScanBuilder$default$1());
            Split[] dataSplitsWithoutLimit3 = ((PaimonScan)scanBuilder3.build()).getOriginSplits();
            Assertions.assertEquals((int)4, (int)dataSplitsWithoutLimit3.length);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataSplitsWithoutLimit3)).foreach((Function1 & Serializable & scala.Serializable)splits -> {
                PaimonPushDownTest.$anonfun$new$16(splits);
                return BoxedUnit.UNIT;
            });
            Assertions.assertFalse((boolean)((SupportsPushDownLimit)scanBuilder3).pushLimit(1));
            Split[] dataSplitsWithLimit3 = ((PaimonScan)scanBuilder3.build()).getOriginSplits();
            Assertions.assertEquals((int)4, (int)dataSplitsWithLimit3.length);
            Assertions.assertEquals((long)1L, (long)this.spark().sql("SELECT * FROM T LIMIT 1").count());
        }, new Position("PaimonPushDownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("Paimon pushDown: limit for table with deletion vector", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)deletionVectorsEnabled -> {
            PaimonPushDownTest.$anonfun$new$18(this, BoxesRunTime.unboxToBoolean((Object)deletionVectorsEnabled));
            return BoxedUnit.UNIT;
        }), new Position("PaimonPushDownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        this.test("Paimon pushDown: runtime filter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"source", "t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(PaimonPushDownTest.class.getClassLoader());
            public final class Org_apache_paimon_spark_sql_PaimonPushDownTest$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_paimon_spark_sql_PaimonPushDownTest$$typecreator6$1(PaimonPushDownTest $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)"x1", (Object)"2023"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)"x2", (Object)"2023"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)5L), (Object)"x5", (Object)"2025"), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)6L), (Object)"x6", (Object)"2026"), (List)Nil$.MODULE$)))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_paimon_spark_sql_PaimonPushDownTest$$typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "pt"})).createOrReplaceTempView("source");
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                  |CREATE TABLE t (id INT, name STRING, pt STRING) PARTITIONED BY (pt)\n                  |")).stripMargin());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n          |INSERT INTO t VALUES (1, \"a\", \"2023\"), (3, \"c\", \"2023\"), (5, \"e\", \"2025\"), (7, \"g\", \"2027\")\n          |")).stripMargin());
            Dataset df1 = this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                            |SELECT t.id, t.name, source.b FROM source join t\n                            |ON source.pt = t.pt AND source.pt = '2023'\n                            |ORDER BY t.id, source.b\n                            |")).stripMargin());
            QueryExecution qe1 = df1.queryExecution();
            Assertions.assertFalse((boolean)qe1.analyzed().containsPattern(TreePattern$.MODULE$.DYNAMIC_PRUNING_SUBQUERY()));
            Assertions.assertTrue((boolean)qe1.optimizedPlan().containsPattern(TreePattern$.MODULE$.DYNAMIC_PRUNING_SUBQUERY()));
            Assertions.assertTrue((boolean)qe1.sparkPlan().containsPattern(TreePattern$.MODULE$.DYNAMIC_PRUNING_SUBQUERY()));
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "x1"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "x2"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", "x1"}));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", "x2"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df1, (Seq)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            Dataset df2 = this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                            |SELECT t.*, source.b FROM source join t\n                            |ON source.a = t.id AND source.pt = t.pt AND source.a > 3\n                            |")).stripMargin());
            QueryExecution qe2 = df1.queryExecution();
            Assertions.assertFalse((boolean)qe2.analyzed().containsPattern(TreePattern$.MODULE$.DYNAMIC_PRUNING_SUBQUERY()));
            Assertions.assertTrue((boolean)qe2.optimizedPlan().containsPattern(TreePattern$.MODULE$.DYNAMIC_PRUNING_SUBQUERY()));
            Assertions.assertTrue((boolean)qe2.sparkPlan().containsPattern(TreePattern$.MODULE$.DYNAMIC_PRUNING_SUBQUERY()));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "e", "2025", "x5"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df2, (Seq)Nil$.MODULE$.$colon$colon((Object)row5));
        }), new Position("PaimonPushDownTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
    }
}

