/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import java.io.Serializable;
import org.apache.paimon.spark.PaimonMetrics$;
import org.apache.paimon.spark.PaimonScan;
import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.spark.executor.OutputMetrics;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.junit.jupiter.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001m2Aa\u0001\u0003\u0001\u001f!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013\t\u0001\u0002+Y5n_:lU\r\u001e:jGR+7\u000f\u001e\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0001/Y5n_:T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\t\"#D\u0001\u0007\u0013\t\u0019bAA\nQC&lwN\\*qCJ\\G+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002-A\u0011q\u0003A\u0007\u0002\t\u00051Q.\u001a;sS\u000e$2A\u0007\u0011/!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0011auN\\4\t\u000b\u0005\u0012\u0001\u0019\u0001\u0012\u0002\u000f5,GO]5dgB\u00191dI\u0013\n\u0005\u0011b\"!B!se\u0006L\bC\u0001\u0014-\u001b\u00059#B\u0001\r)\u0015\tI#&A\u0005d_:tWm\u0019;pe*\u0011Qa\u000b\u0006\u0003\u000f)I!!L\u0014\u0003!\r+8\u000f^8n)\u0006\u001c8.T3ue&\u001c\u0007\"B\u0018\u0003\u0001\u0004\u0001\u0014\u0001\u00028b[\u0016\u0004\"!\r\u001d\u000f\u0005I2\u0004CA\u001a\u001d\u001b\u0005!$BA\u001b\u000f\u0003\u0019a$o\\8u}%\u0011q\u0007H\u0001\u0007!J,G-\u001a4\n\u0005eR$AB*ue&twM\u0003\u000289\u0001")
public class PaimonMetricTest
extends PaimonSparkTestBase {
    public long metric(CustomTaskMetric[] metrics, String name) {
        return ((CustomTaskMetric)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metrics)).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PaimonMetricTest.$anonfun$metric$1(name, x$1))).get()).value();
    }

    private final void checkMetrics$1(String s, long skippedTableFiles, long resultedTableFiles) {
        PaimonScan scan = this.getPaimonScan(s);
        scan.lazyInputPartitions();
        CustomTaskMetric[] metrics = scan.reportDriverMetrics();
        Assertions.assertEquals((long)skippedTableFiles, (long)this.metric(metrics, PaimonMetrics$.MODULE$.SKIPPED_TABLE_FILES()));
        Assertions.assertEquals((long)resultedTableFiles, (long)this.metric(metrics, PaimonMetrics$.MODULE$.RESULTED_TABLE_FILES()));
    }

    public static final /* synthetic */ boolean $anonfun$metric$1(String name$1, CustomTaskMetric x$1) {
        String string = x$1.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public PaimonMetricTest() {
        this.test("Paimon Metric: scan driver metric", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.gteqSpark3_4()) {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n             |CREATE TABLE T (id INT, name STRING, pt STRING)\n             |TBLPROPERTIES ('bucket'='1', 'bucket-key'='id', 'write-only'='true')\n             |PARTITIONED BY (pt)\n             |")).stripMargin());
                this.sql().apply((Object)"INSERT INTO T VALUES (1, 'a', 'p1'), (2, 'b', 'p2')");
                this.sql().apply((Object)"INSERT INTO T VALUES (3, 'c', 'p2'), (4, 'c', 'p3')");
                this.sql().apply((Object)"INSERT INTO T VALUES (5, 'd', 'p2')");
                this.checkMetrics$1("SELECT * FROM T", 0L, 5L);
                this.checkMetrics$1("SELECT * FROM T WHERE pt = 'p2'", 2L, 3L);
                this.sql().apply((Object)"DELETE FROM T WHERE pt = 'p1'");
                this.checkMetrics$1("SELECT * FROM T", 0L, 4L);
                this.sql().apply((Object)"CALL sys.compact(table => 'T', partitions => 'pt=\"p2\"')");
                this.checkMetrics$1("SELECT * FROM T", 0L, 2L);
                this.checkMetrics$1("SELECT * FROM T WHERE pt = 'p2'", 1L, 1L);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("PaimonMetricTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        this.test("Paimon Metric: report output metric", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE T (id int)");
            LongRef recordsWritten = LongRef.create((long)0L);
            LongRef bytesWritten = LongRef.create((long)0L);
            SparkListener listener = new SparkListener(null, recordsWritten, bytesWritten){
                private final LongRef recordsWritten$1;
                private final LongRef bytesWritten$1;

                public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
                    OutputMetrics outputMetrics = taskEnd.taskMetrics().outputMetrics();
                    this.recordsWritten$1.elem += outputMetrics.recordsWritten();
                    this.bytesWritten$1.elem += outputMetrics.bytesWritten();
                }
                {
                    this.recordsWritten$1 = recordsWritten$1;
                    this.bytesWritten$1 = bytesWritten$1;
                }
            };
            try {
                this.spark().sparkContext().addSparkListener((SparkListenerInterface)listener);
                this.sql().apply((Object)"INSERT INTO T VALUES 1, 2, 3");
            }
            finally {
                this.spark().sparkContext().removeSparkListener((SparkListenerInterface)listener);
            }
            Assertions.assertEquals((long)3L, (long)recordsWritten.elem);
            Assertions.assertTrue((bytesWritten.elem > 0L ? 1 : 0) != 0);
        }, new Position("PaimonMetricTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
    }
}

