/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import java.io.Serializable;
import java.util.Objects;
import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.junit.jupiter.api.Assertions;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001=2Qa\u0001\u0003\u0002\u0002=AQ\u0001\u0006\u0001\u0005\u0002UAQ\u0001\u0007\u0001\u0005\u0002e\u0011Q\u0003R3tGJL'-\u001a+bE2,G+Z:u\u0005\u0006\u001cXM\u0003\u0002\u0006\r\u0005\u00191/\u001d7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\u0001\u0018-[7p]*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0004\n\u0005M1!a\u0005)bS6|gn\u00159be.$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001\u0017!\t9\u0002!D\u0001\u0005\u0003Y\u0019\u0007.Z2l)\u0006\u0014G.Z\"p[6,g\u000e^#rk\u0006dGc\u0001\u000e![A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t!QK\\5u\u0011\u0015\t#\u00011\u0001#\u0003%!\u0018M\u00197f\u001d\u0006lW\r\u0005\u0002$U9\u0011A\u0005\u000b\t\u0003Kqi\u0011A\n\u0006\u0003O9\ta\u0001\u0010:p_Rt\u0014BA\u0015\u001d\u0003\u0019\u0001&/\u001a3fM&\u00111\u0006\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%b\u0002\"\u0002\u0018\u0003\u0001\u0004\u0011\u0013aB2p[6,g\u000e\u001e")
public abstract class DescribeTableTestBase
extends PaimonSparkTestBase {
    public void checkTableCommentEqual(String tableName, String comment) {
        Nil$ nil$;
        Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(24).append("DESCRIBE TABLE EXTENDED ").append(tableName).toString()).filter("col_name = 'Comment'").select("col_name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"data_type"}));
        if (comment == null) {
            nil$ = Nil$.MODULE$;
        } else {
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment", comment}));
            nil$ = Nil$.MODULE$.$colon$colon((Object)row);
        }
        this.checkAnswer(intersect, (Seq)nil$);
        Assertions.assertTrue((boolean)Objects.equals(comment, this.loadTable(tableName).schema().comment()));
    }

    public DescribeTableTestBase() {
        this.test("Paimon show: show table extended", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String testDB = "test_show";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(3).append(this.dbName0()).append(".s1").toString()}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql("CREATE TABLE s1 (id INT)");
                this.withDatabase((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testDB}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    this.spark().sql(new StringBuilder(16).append("CREATE DATABASE ").append(testDB).toString());
                    this.spark().sql(new StringBuilder(4).append("USE ").append(testDB).toString());
                    this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s2", "s3"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        String error2;
                        String error1;
                        this.spark().sql("CREATE TABLE s2 (id INT, pt STRING) PARTITIONED BY (pt)");
                        this.spark().sql("CREATE TABLE s3 (id INT, pt1 STRING, pt2 STRING) PARTITIONED BY (pt1, pt2)");
                        this.spark().sql("INSERT INTO s2 VALUES (1, '2024'), (2, '2024'), (3, '2025'), (4, '2026')");
                        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                      |INSERT INTO s3\n                      |VALUES\n                      |(1, '2024', '11'), (2, '2024', '12'), (3, '2025', '11'), (4, '2025', '12')\n                      |")).stripMargin());
                        this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> ((Dataset)this.sql().apply((Object)new StringBuilder(32).append("SHOW TABLE EXTENDED IN ").append(this.dbName0()).append(" LIKE '*'").toString())).select("namespace", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tableName", "isTemporary"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"test", "s1", BoxesRunTime.boxToBoolean((boolean)false)})));
                        Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testDB, "s2", BoxesRunTime.boxToBoolean((boolean)false)}));
                        Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testDB, "s3", BoxesRunTime.boxToBoolean((boolean)false)}));
                        this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> ((Dataset)this.sql().apply((Object)new StringBuilder(32).append("SHOW TABLE EXTENDED IN ").append(testDB).append(" LIKE '*'").toString())).select("namespace", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tableName", "isTemporary"})), (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
                        Dataset res1 = this.spark().sql(new StringBuilder(33).append("SHOW TABLE EXTENDED IN ").append(testDB).append(" LIKE 's2'").toString()).select("information", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                        Assertions.assertEquals((long)1L, (long)res1.count());
                        Map information1 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])res1.collect())).head()).getString(0).split("\n"))).map((Function1 & Serializable & scala.Serializable)line -> {
                            String[] kv = line.split(": ", 2);
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)kv[0]), (Object)kv[1]);
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                        Assertions.assertEquals((Object)information1.apply((Object)"Catalog"), (Object)"paimon");
                        Assertions.assertEquals((Object)information1.apply((Object)"Namespace"), (Object)testDB);
                        Assertions.assertEquals((Object)information1.apply((Object)"Table"), (Object)"s2");
                        Assertions.assertEquals((Object)information1.apply((Object)"Provider"), (Object)"paimon");
                        Assertions.assertEquals((Object)information1.apply((Object)"Location"), (Object)this.loadTable(testDB, "s2").location().toString());
                        String $org_scalatest_assert_macro_left = error1 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(54).append("SHOW TABLE EXTENDED IN ").append(testDB).append(" LIKE 's2' PARTITION(pt='2022')").toString()), ClassTag$.MODULE$.apply(Exception.class), new Position("DescribeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82))).getMessage();
                        String $org_scalatest_assert_macro_right = "PARTITIONS_NOT_FOUND";
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DescribeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
                        String $org_scalatest_assert_macro_left2 = error2 = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(55).append("SHOW TABLE EXTENDED IN ").append(testDB).append(" LIKE 's3' PARTITION(pt1='2024')").toString()), ClassTag$.MODULE$.apply(Exception.class), new Position("DescribeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87))).getMessage();
                        String $org_scalatest_assert_macro_right2 = "Partition spec is invalid";
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DescribeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
                        Dataset res2 = this.spark().sql(new StringBuilder(67).append("SHOW TABLE EXTENDED IN ").append(testDB).append(" LIKE 's3' PARTITION(pt1 = '2024', pt2 = 11)").toString());
                        this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> res2.select("namespace", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tableName", "isTemporary"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testDB, "s3", BoxesRunTime.boxToBoolean((boolean)false)})));
                        Assertions.assertTrue((boolean)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])res2.select("information", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).head()).getString(0).contains("Partition Values"));
                    });
                });
            });
        }, new Position("DescribeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        this.test("Paimon describe: describe table comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String comment = "test comment";
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(196).append("\n                 |CREATE TABLE T (\n                 |  id INT COMMENT 'id comment',\n                 |  name STRING,\n                 |  dt STRING)\n                 |COMMENT '").append(comment).append("'\n                 |").toString())).stripMargin());
            this.checkTableCommentEqual("T", comment);
            comment = "new comment";
            this.spark().sql(new StringBuilder(48).append("ALTER TABLE T SET TBLPROPERTIES ('comment' = '").append(comment).append("')").toString());
            this.checkTableCommentEqual("T", comment);
            comment = "  ";
            this.spark().sql(new StringBuilder(48).append("ALTER TABLE T SET TBLPROPERTIES ('comment' = '").append(comment).append("')").toString());
            this.checkTableCommentEqual("T", comment);
            comment = "";
            this.spark().sql(new StringBuilder(48).append("ALTER TABLE T SET TBLPROPERTIES ('comment' = '").append(comment).append("')").toString());
            this.checkTableCommentEqual("T", comment);
            this.spark().sql("ALTER TABLE T UNSET TBLPROPERTIES ('comment')");
            this.checkTableCommentEqual("T", null);
            comment = "new comment";
            this.spark().sql(new StringBuilder(48).append("ALTER TABLE T SET TBLPROPERTIES ('comment' = '").append(comment).append("')").toString());
            this.checkTableCommentEqual("T", comment);
        }, new Position("DescribeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("Paimon describe: describe table with no comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (\n                 |  id INT COMMENT 'id comment',\n                 |  name STRING,\n                 |  dt STRING)\n                 |")).stripMargin());
            this.checkTableCommentEqual("T", null);
        }, new Position("DescribeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
    }
}

