/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import java.io.Serializable;
import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.SortExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanHelper;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeLike;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001y2Aa\u0001\u0003\u0001\u001f!)a\u0004\u0001C\u0001?!)!\u0005\u0001C\u0005G\t1\")^2lKR,G\rV1cY\u0016\fV/\u001a:z)\u0016\u001cHO\u0003\u0002\u0006\r\u0005\u00191/\u001d7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\u0001\u0018-[7p]*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0015!\t\t\"#D\u0001\u0007\u0013\t\u0019bAA\nQC&lwN\\*qCJ\\G+Z:u\u0005\u0006\u001cX\r\u0005\u0002\u001695\taC\u0003\u0002\u00181\u0005A\u0011\rZ1qi&4XM\u0003\u0002\u001a5\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000bmQ!a\u0002\u0006\n\u0005u1\"aF!eCB$\u0018N^3Ta\u0006\u00148\u000e\u00157b]\"+G\u000e]3s\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\"\u00015\tA!\u0001\u000edQ\u0016\u001c7.\u00118to\u0016\u0014\u0018I\u001c3TQV4g\r\\3T_J$8\u000f\u0006\u0003%U]b\u0004CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#\u0001B+oSRDQa\u000b\u0002A\u00021\nQ!];fef\u0004\"!\f\u001b\u000f\u00059\u0012\u0004CA\u0018'\u001b\u0005\u0001$BA\u0019\u000f\u0003\u0019a$o\\8u}%\u00111GJ\u0001\u0007!J,G-\u001a4\n\u0005U2$AB*ue&twM\u0003\u00024M!)\u0001H\u0001a\u0001s\u0005Ya.^7TQV4g\r\\3t!\t)#(\u0003\u0002<M\t\u0019\u0011J\u001c;\t\u000bu\u0012\u0001\u0019A\u001d\u0002\u00119,XnU8siN\u0004")
public class BucketedTableQueryTest
extends PaimonSparkTestBase
implements AdaptiveSparkPlanHelper {
    public Option<SparkPlan> find(SparkPlan p, Function1<SparkPlan, Object> f) {
        return AdaptiveSparkPlanHelper.find$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public void foreach(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreach$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public void foreachUp(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreachUp$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public <A> Seq<A> mapPlans(SparkPlan p, Function1<SparkPlan, A> f) {
        return AdaptiveSparkPlanHelper.mapPlans$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public <A> Seq<A> flatMap(SparkPlan p, Function1<SparkPlan, TraversableOnce<A>> f) {
        return AdaptiveSparkPlanHelper.flatMap$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public <B> Seq<B> collect(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collect$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, pf);
    }

    public Seq<SparkPlan> collectLeaves(SparkPlan p) {
        return AdaptiveSparkPlanHelper.collectLeaves$((AdaptiveSparkPlanHelper)this, (SparkPlan)p);
    }

    public <B> Option<B> collectFirst(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collectFirst$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, pf);
    }

    public <B> Seq<B> collectWithSubqueries(SparkPlan p, PartialFunction<SparkPlan, B> f) {
        return AdaptiveSparkPlanHelper.collectWithSubqueries$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public Seq<SparkPlan> subqueriesAll(SparkPlan p) {
        return AdaptiveSparkPlanHelper.subqueriesAll$((AdaptiveSparkPlanHelper)this, (SparkPlan)p);
    }

    public Seq<SparkPlan> allChildren(SparkPlan p) {
        return AdaptiveSparkPlanHelper.allChildren$((AdaptiveSparkPlanHelper)this, (SparkPlan)p);
    }

    public SparkPlan stripAQEPlan(SparkPlan p) {
        return AdaptiveSparkPlanHelper.stripAQEPlan$((AdaptiveSparkPlanHelper)this, (SparkPlan)p);
    }

    private void checkAnswerAndShuffleSorts(String query, int numShuffles, int numSorts) {
        ObjectRef expectedResult = ObjectRef.create(null);
        this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.sources.v2.bucketing.enabled"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.autoBroadcastJoinThreshold"), (Object)"-1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            expectedResult$1.elem = (Row[])this.spark().sql(query).collect();
        });
        this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.sources.v2.bucketing.enabled"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.autoBroadcastJoinThreshold"), (Object)"-1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                Dataset df = this.spark().sql(query);
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Row[])expectedResult$1.elem))).toSeq());
                Seq $org_scalatest_assert_macro_left = this.collect(df.queryExecution().executedPlan(), (PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        ShuffleExchangeLike shuffleExchangeLike;
                        A1 A1 = x1;
                        Object object = A1 instanceof ShuffleExchangeLike ? (shuffleExchangeLike = (ShuffleExchangeLike)A1) : function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(SparkPlan x1) {
                        SparkPlan sparkPlan = x1;
                        boolean bl = sparkPlan instanceof ShuffleExchangeLike;
                        return bl;
                    }
                });
                int $org_scalatest_assert_macro_right = numShuffles;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BucketedTableQueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
                if (!this.gteqSpark3_4()) break block0;
                Seq $org_scalatest_assert_macro_left2 = this.collect(df.queryExecution().executedPlan(), (PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        SortExec sortExec;
                        A1 A1 = x2;
                        Object object = A1 instanceof SortExec ? (sortExec = (SortExec)A1) : function1.apply(x2);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(SparkPlan x2) {
                        SparkPlan sparkPlan = x2;
                        boolean bl = sparkPlan instanceof SortExec;
                        return bl;
                    }
                });
                int $org_scalatest_assert_macro_right2 = numSorts;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BucketedTableQueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            }
        });
    }

    public static final /* synthetic */ Dataset $anonfun$new$11(BucketedTableQueryTest $this, int i) {
        return $this.spark().sql(new StringBuilder(49).append("INSERT INTO t VALUES (").append(i).append(", 'x1'), (").append(i).append(", 'x3'), (").append(i).append(", 'x3')").toString());
    }

    public BucketedTableQueryTest() {
        AdaptiveSparkPlanHelper.$init$((AdaptiveSparkPlanHelper)this);
        this.test("Query on a bucketed table - join - positive case", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.gteqSpark3_3(), "BucketedTableQueryTest.this.gteqSpark3_3", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BucketedTableQueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2", "t3", "t4", "t5", "t6"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql("CREATE TABLE t1 (id INT, c STRING) TBLPROPERTIES ('primary-key' = 'id', 'bucket'='10')");
                this.spark().sql("INSERT INTO t1 VALUES (1, 'x1'), (2, 'x3'), (3, 'x3'), (4, 'x4'), (5, 'x5')");
                this.spark().sql("CREATE TABLE t2 (id INT, c STRING) TBLPROPERTIES ('primary-key' = 'id', 'bucket'='10')");
                this.spark().sql("INSERT INTO t2 VALUES (1, 'x1'), (2, 'x3'), (3, 'x3'), (4, 'x4'), (5, 'x5')");
                this.checkAnswerAndShuffleSorts("SELECT * FROM t1 JOIN t2 on t1.id = t2.id", 0, 0);
                this.spark().sql("CREATE TABLE t3 (id2 INT, c STRING) TBLPROPERTIES ('primary-key' = 'id2', 'bucket'='10')");
                this.spark().sql("INSERT INTO t3 VALUES (1, 'x1'), (2, 'x3'), (3, 'x3'), (4, 'x4'), (5, 'x5')");
                this.checkAnswerAndShuffleSorts("SELECT * FROM t1 JOIN t3 on t1.id = t3.id2", 0, 0);
                this.spark().sql("CREATE TABLE t4 (id INT, c STRING) TBLPROPERTIES ('bucket-key' = 'id', 'bucket'='10')");
                this.spark().sql("INSERT INTO t4 VALUES (1, 'x1'), (2, 'x3'), (3, 'x3'), (4, 'x4'), (5, 'x5')");
                this.checkAnswerAndShuffleSorts("SELECT * FROM t1 JOIN t4 on t1.id = t4.id", 0, 1);
                this.spark().sql("CREATE TABLE t5 (id INT, c STRING) TBLPROPERTIES ('primary-key' = 'id,c', 'bucket-key' = 'id', 'bucket'='10')");
                this.spark().sql("INSERT INTO t5 VALUES (1, 'x1'), (2, 'x3'), (3, 'x3'), (4, 'x4'), (5, 'x5')");
                this.checkAnswerAndShuffleSorts("SELECT * FROM t1 JOIN t5 on t1.id = t5.id", 0, 0);
                this.spark().sql("CREATE TABLE t6 (id INT, data STRING, year STRING) PARTITIONED BY (year) TBLPROPERTIES ('primary-key' = 'id,year', 'bucket'='10')");
                this.spark().sql("INSERT INTO t6 VALUES (1, 'x1', '2020'), (2, 'x3', '2020'), (3, 'x3', '2021'), (4, 'x4', '2021'), (5, 'x5', '2021')");
                this.checkAnswerAndShuffleSorts("SELECT * FROM t1 JOIN t6 on t1.id = t6.id", 0, 0);
            });
        }, new Position("BucketedTableQueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("Query on a bucketed table - join - negative case", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.gteqSpark3_3(), "BucketedTableQueryTest.this.gteqSpark3_3", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BucketedTableQueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "t2", "t3", "t4", "t5", "t6", "t7"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql("CREATE TABLE t1 (id INT, c STRING) TBLPROPERTIES ('primary-key' = 'id', 'bucket'='10')");
                this.spark().sql("INSERT INTO t1 VALUES (1, 'x1'), (2, 'x3'), (3, 'x3'), (4, 'x4'), (5, 'x5')");
                this.spark().sql("CREATE TABLE t2 (id INT, c STRING) TBLPROPERTIES ('primary-key' = 'id')");
                this.spark().sql("INSERT INTO t2 VALUES (1, 'x1'), (2, 'x3'), (3, 'x3'), (4, 'x4'), (5, 'x5')");
                this.checkAnswerAndShuffleSorts("SELECT * FROM t1 JOIN t2 on t1.id = t2.id", 2, 2);
                this.spark().sql("CREATE TABLE t3 (id INT, c STRING) TBLPROPERTIES ('primary-key' = 'id', 'bucket'='2')");
                this.spark().sql("INSERT INTO t3 VALUES (1, 'x1'), (2, 'x3'), (3, 'x3'), (4, 'x4'), (5, 'x5')");
                this.checkAnswerAndShuffleSorts("SELECT * FROM t1 JOIN t3 on t1.id = t3.id", 2, 2);
                this.spark().sql("CREATE TABLE t4 (id STRING, c STRING) TBLPROPERTIES ('primary-key' = 'id', 'bucket'='10')");
                this.spark().sql("INSERT INTO t4 VALUES (1, 'x1'), (2, 'x3'), (3, 'x3'), (4, 'x4'), (5, 'x5')");
                this.checkAnswerAndShuffleSorts("SELECT * FROM t1 JOIN t4 on t1.id = t4.id", 2, 2);
                this.spark().sql("CREATE TABLE t5 (id INT, c STRING) TBLPROPERTIES ('primary-key' = 'id', 'bucket'='10')");
                this.spark().sql("INSERT INTO t5 VALUES (1, 'x1')");
                if (this.gteqSpark4_0()) {
                    this.checkAnswerAndShuffleSorts("SELECT * FROM t1 JOIN t5 on t1.id = t5.id", 0, 0);
                } else {
                    this.checkAnswerAndShuffleSorts("SELECT * FROM t1 JOIN t5 on t1.id = t5.id", 2, 2);
                }
                this.spark().sql("CREATE TABLE t6 (id1 INT, id2 INT, c STRING) TBLPROPERTIES ('bucket-key' = 'id1,id2', 'bucket'='10')");
                this.spark().sql("INSERT INTO t6 VALUES (1, 1, 'x1'), (2, 2, 'x3'), (3, 3, 'x3'), (4, 4, 'x4'), (5, 5, 'x5')");
                this.checkAnswerAndShuffleSorts("SELECT * FROM t1 JOIN t6 on t1.id = t6.id1", 2, 2);
                this.spark().sql("CREATE TABLE t7 (id1 INT, id2 STRING, year STRING) PARTITIONED BY (year) TBLPROPERTIES ('primary-key' = 'id1,id2,year', 'bucket'='10')");
                this.spark().sql("INSERT INTO t7 VALUES (1, 'x1', '2020'), (2, 'x3', '2020'), (3, 'x3', '2021'), (4, 'x4', '2021'), (5, 'x5', '2021')");
                this.checkAnswerAndShuffleSorts("SELECT * FROM t1 JOIN t7 on t1.id = t7.id1", 2, 2);
            });
        }, new Position("BucketedTableQueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("Query on a bucketed table - other operators", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.gteqSpark3_3(), "BucketedTableQueryTest.this.gteqSpark3_3", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BucketedTableQueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql("CREATE TABLE t1 (id INT, c STRING) TBLPROPERTIES ('primary-key' = 'id', 'bucket'='10')");
                this.spark().sql("INSERT INTO t1 VALUES (1, 'x1'), (2, 'x3'), (3, 'x3'), (4, 'x4'), (5, 'x5')");
                this.checkAnswerAndShuffleSorts("SELECT id, count(*) FROM t1 GROUP BY id", 0, 0);
                this.checkAnswerAndShuffleSorts("SELECT id, max(c) FROM t1 GROUP BY id", 0, 0);
                this.checkAnswerAndShuffleSorts("SELECT c, count(*) FROM t1 GROUP BY c", 1, 0);
                this.checkAnswerAndShuffleSorts("SELECT c, max(c) FROM t1 GROUP BY c", 1, 2);
                this.checkAnswerAndShuffleSorts("select max(c) OVER (PARTITION BY id ORDER BY c) from t1", 0, 1);
                this.checkAnswerAndShuffleSorts("select max(c) OVER (PARTITION BY id ORDER BY id) from t1", 0, 1);
                this.checkAnswerAndShuffleSorts("select sum(id) OVER (PARTITION BY c ORDER BY id) from t1", 1, 1);
                this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.requireAllClusterKeysForDistribution"), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnswerAndShuffleSorts("SELECT id, c, count(*) FROM t1 GROUP BY id, c", 0, 0));
                this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.requireAllClusterKeysForDistribution"), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnswerAndShuffleSorts("SELECT id, c, count(*) FROM t1 GROUP BY id, c", 1, 0));
            });
        }, new Position("BucketedTableQueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        this.test("Report scan output ordering - rawConvertible", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.gteqSpark3_3(), "BucketedTableQueryTest.this.gteqSpark3_3", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BucketedTableQueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql("CREATE TABLE t (id INT, c STRING) TBLPROPERTIES ('primary-key' = 'id', 'bucket'='2', 'deletion-vectors.enabled'='true')");
                this.spark().sql("INSERT INTO t VALUES (1, 'x1'), (2, 'x3')");
                this.checkAnswerAndShuffleSorts("SELECT id, max(c) FROM t GROUP BY id", 0, 0);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 20).foreach((Function1 & Serializable & scala.Serializable)i -> BucketedTableQueryTest.$anonfun$new$11(this, BoxesRunTime.unboxToInt((Object)i)));
                this.checkAnswerAndShuffleSorts("SELECT id, max(c) FROM t GROUP BY id", 0, 1);
            });
        }, new Position("BucketedTableQueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
    }
}

