/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.paimon.stats.ColStats;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanRelation;
import org.assertj.core.api.Assertions;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.ScalaNumericAnyConversions;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001!3Q\u0001B\u0003\u0002\u0002AAQ!\u0006\u0001\u0005\u0002YAQ!\u0007\u0001\u0005\u0012iAQA\f\u0001\u0005\u0012=\u0012A#\u00118bYfTX\rV1cY\u0016$Vm\u001d;CCN,'B\u0001\u0004\b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0011%\tQa\u001d9be.T!AC\u0006\u0002\rA\f\u0017.\\8o\u0015\taQ\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Mi\u0011aB\u0005\u0003)\u001d\u00111\u0003U1j[>t7\u000b]1sWR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"A\u0003\u0002\u001dM$\u0018\r^:GS2,7i\\;oiR\u00191$I\u0015\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\u0007%sG\u000fC\u0003#\u0005\u0001\u00071%A\u0007uC\ndW\rT8dCRLwN\u001c\t\u0003I\u001dj\u0011!\n\u0006\u0003M%\t!AZ:\n\u0005!*#\u0001\u0002)bi\"DQA\u000b\u0002A\u0002-\naAZ5mK&{\u0005C\u0001\u0013-\u0013\tiSE\u0001\u0004GS2,\u0017jT\u0001\u0011O\u0016$8kY1o'R\fG/[:uS\u000e$\"\u0001\r\u001f\u0011\u0005ERT\"\u0001\u001a\u000b\u0005M\"\u0014a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003kY\nQ\u0001\u001d7b]NT!a\u000e\u001d\u0002\u0011\r\fG/\u00197zgRT!AB\u001d\u000b\u0005!Y\u0011BA\u001e3\u0005)\u0019F/\u0019;jgRL7m\u001d\u0005\u0006\r\r\u0001\r!\u0010\t\u0003}\u0015s!aP\"\u0011\u0005\u0001kR\"A!\u000b\u0005\t{\u0011A\u0002\u001fs_>$h(\u0003\u0002E;\u00051\u0001K]3eK\u001aL!AR$\u0003\rM#(/\u001b8h\u0015\t!U\u0004")
public abstract class AnalyzeTableTestBase
extends PaimonSparkTestBase {
    public int statsFileCount(Path tableLocation, FileIO fileIO) {
        return fileIO.listStatus(new Path(tableLocation, "statistics")).length;
    }

    public org.apache.spark.sql.catalyst.plans.logical.Statistics getScanStatistic(String sql) {
        DataSourceV2ScanRelation relation = (DataSourceV2ScanRelation)this.spark().sql(sql).queryExecution().optimizedPlan().collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                DataSourceV2ScanRelation dataSourceV2ScanRelation;
                A1 A1 = x1;
                Object object = A1 instanceof DataSourceV2ScanRelation ? (dataSourceV2ScanRelation = (DataSourceV2ScanRelation)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                return bl;
            }
        }).get();
        return relation.computeStats();
    }

    private final long checkStatistics$1() {
        Bool bool;
        org.apache.spark.sql.catalyst.plans.logical.Statistics wholeSize2 = this.getScanStatistic("SELECT * FROM T");
        long $org_scalatest_assert_macro_left = ((ScalaNumericAnyConversions)wholeSize2.rowCount().get()).toLong();
        int $org_scalatest_assert_macro_right = 3;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
        long $org_scalatest_assert_macro_left2 = wholeSize2.sizeInBytes().toLong();
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
        org.apache.spark.sql.catalyst.plans.logical.Statistics wholeSizeWithMetadata = this.getScanStatistic("SELECT *, __paimon_file_path FROM T");
        long $org_scalatest_assert_macro_left3 = ((ScalaNumericAnyConversions)wholeSizeWithMetadata.rowCount().get()).toLong();
        int $org_scalatest_assert_macro_right3 = 3;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
        long $org_scalatest_assert_macro_left4 = wholeSizeWithMetadata.sizeInBytes().toLong();
        long $org_scalatest_assert_macro_right4 = wholeSize2.sizeInBytes().toLong() + 60L;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 508));
        org.apache.spark.sql.catalyst.plans.logical.Statistics oneColSize = this.getScanStatistic("SELECT c3 FROM T");
        org.apache.spark.sql.catalyst.plans.logical.Statistics threeColSize = this.getScanStatistic("SELECT c1, c2, c3 FROM T");
        org.apache.spark.sql.catalyst.plans.logical.Statistics longMetadataSize = this.getScanStatistic("SELECT __paimon_row_index FROM T");
        long $org_scalatest_assert_macro_left5 = ((ScalaNumericAnyConversions)oneColSize.rowCount().get()).toLong();
        int $org_scalatest_assert_macro_right5 = 3;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == (long)$org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513));
        long $org_scalatest_assert_macro_left6 = ((ScalaNumericAnyConversions)threeColSize.rowCount().get()).toLong();
        int $org_scalatest_assert_macro_right6 = 3;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == (long)$org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
        long $org_scalatest_assert_macro_left7 = ((ScalaNumericAnyConversions)longMetadataSize.rowCount().get()).toLong();
        int $org_scalatest_assert_macro_right7 = 3;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == (long)$org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
        BigInt $org_scalatest_assert_macro_left8 = longMetadataSize.sizeInBytes();
        int $org_scalatest_assert_macro_right8 = 24;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left8, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
        BigInt $org_scalatest_assert_macro_left9 = oneColSize.sizeInBytes();
        BigInt $org_scalatest_assert_macro_right9 = BigInt$.MODULE$.int2bigInt(0);
        Bool $org_scalatest_assert_macro_left10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, ">", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$greater((Object)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
        if ($org_scalatest_assert_macro_left10.value()) {
            BigInt $org_scalatest_assert_macro_left11 = oneColSize.sizeInBytes();
            BigInt $org_scalatest_assert_macro_right10 = wholeSize2.sizeInBytes();
            bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "<", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left11.$less((Object)$org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
        } else {
            bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
        }
        Bool $org_scalatest_assert_macro_right11 = bool;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "&&", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left10.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right11), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517));
        BigInt $org_scalatest_assert_macro_left12 = threeColSize.sizeInBytes();
        BigInt $org_scalatest_assert_macro_right12 = wholeSize2.sizeInBytes();
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "<", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$less((Object)$org_scalatest_assert_macro_right12), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 518));
        BigInt $org_scalatest_assert_macro_left13 = threeColSize.sizeInBytes();
        BigInt $org_scalatest_assert_macro_right13 = oneColSize.sizeInBytes();
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, ">", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$greater((Object)$org_scalatest_assert_macro_right13), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
        return wholeSize2.sizeInBytes().toLong();
    }

    public AnalyzeTableTestBase() {
        this.test("Paimon analyze: analyze table only", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING, i INT, l LONG)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a', 1, 1)");
            this.spark().sql("INSERT INTO T VALUES ('2', 'aaa', 1, 2)");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS");
            Statistics stats = (Statistics)this.loadTable("T").statistics().get();
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)stats.mergedRecordCount().getAsLong());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.mergedRecordSize().isPresent());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.colStats().isEmpty());
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("Paimon analyze: test statistic system table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING, i INT, l LONG)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a', 1, 1)");
            this.spark().sql("INSERT INTO T VALUES ('2', 'aaa', 1, 2)");
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.spark().sql("select * from `T$statistics`").count());
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS");
            Dataset df = this.spark().sql("select snapshot_id, schema_id, mergedRecordCount, colstat from `T$statistics`");
            org.junit.jupiter.api.Assertions.assertEquals((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.collect())).size(), (int)1);
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT snapshot_id, schema_id, mergedRecordCount, colstat from `T$statistics`"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)2), "{ }"})));
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("Paimon analyze: test statistic system table with snapshot", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING, i INT, l LONG)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a', 1, 1)");
            this.spark().sql("INSERT INTO T VALUES ('2', 'aaa', 1, 2)");
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.spark().sql("select * from `T$statistics`").count());
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS");
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.scan.timestamp-millis"), (Object)Long.toString(System.currentTimeMillis()))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT snapshot_id, schema_id, mergedRecordCount, colstat FROM `T$statistics`"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)2), "{ }"}))));
            this.spark().sql("INSERT INTO T VALUES ('3', 'b', 2, 1)");
            this.spark().sql("INSERT INTO T VALUES ('4', 'bbb', 3, 2)");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS");
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.scan.timestamp-millis"), (Object)Long.toString(System.currentTimeMillis()))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT snapshot_id, schema_id, mergedRecordCount, colstat FROM `T$statistics`"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)4), "{ }"}))));
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CALL paimon.sys.create_tag(table => 'test.T', tag => 'test_tag5', snapshot => 5)"), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CALL paimon.sys.create_tag(table => 'test.T', tag => 'test_tag6', snapshot => 6)"), (Seq)Nil$.MODULE$.$colon$colon((Object)row2));
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.scan.tag-name"), (Object)"test_tag5")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT snapshot_id, schema_id, mergedRecordCount, colstat FROM `T$statistics`"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)2), "{ }"}))));
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.scan.tag-name"), (Object)"test_tag6")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT snapshot_id, schema_id, mergedRecordCount, colstat FROM `T$statistics`"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)4), "{ }"}))));
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.scan.snapshot-id"), (Object)"3")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT snapshot_id, schema_id, mergedRecordCount, colstat FROM `T$statistics`"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)2), "{ }"}))));
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.scan.snapshot-id"), (Object)"4")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT snapshot_id, schema_id, mergedRecordCount, colstat FROM `T$statistics`"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)2), "{ }"}))));
            this.withSparkSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.paimon.scan.snapshot-id"), (Object)"6")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT snapshot_id, schema_id, mergedRecordCount, colstat FROM `T$statistics`"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)4), "{ }"}))));
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.test("Paimon analyze: analyze table without snapshot", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE T (id STRING, name STRING)");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR ALL COLUMNS");
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.spark().sql("select * from `T$statistics`").count());
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        this.test("Paimon analyze: analyze no scan", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE T (id STRING, name STRING)");
            return Assertions.assertThatThrownBy(() -> this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS NOSCAN")).hasMessageContaining("NOSCAN is ineffective with paimon");
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("Paimon analyze: analyze table partition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE T (id STRING, name STRING, pt STRING) PARTITIONED BY (id, pt) ");
            return Assertions.assertThatThrownBy(() -> this.spark().sql("ANALYZE TABLE T PARTITION (pt = '1') COMPUTE STATISTICS")).hasMessageContaining("Analyze table partition is not supported");
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("Paimon analyze: analyze all supported cols", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (id STRING, name STRING, byte_col BYTE, short_col SHORT, int_col INT, long_col LONG,\n         |float_col FLOAT, double_col DOUBLE, decimal_col DECIMAL(10, 5), boolean_col BOOLEAN, date_col DATE,\n         |timestamp_col TIMESTAMP, binary BINARY, char_col CHAR(20), varchar_col VARCHAR(20))\n         |USING PAIMON\n         |TBLPROPERTIES ('primary-key'='id')\n         |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a', 1, 1, 1, 1, 1.0, 1.0, 12.12345, true, cast('2020-01-01' as date), cast('2020-01-01 00:00:00' as timestamp), binary('example binary1'), 'a', 'a')");
            this.spark().sql("INSERT INTO T VALUES ('2', 'aaa', 1, null, 1, 1, 1.0, 1.0, 12.12345, true, cast('2020-01-02' as date), cast('2020-01-02 00:00:00' as timestamp), binary('example binary1'), 'aaa', 'aaa')");
            this.spark().sql("INSERT INTO T VALUES ('3', 'bbbb', 2, 1, 1, 1, 1.0, 1.0, 22.12345, true, cast('2020-01-02' as date), cast('2020-01-02 00:00:00' as timestamp), null, 'bbbb', 'bbbb')");
            this.spark().sql("INSERT INTO T VALUES ('4', 'bbbbbbbb', 2, 2, 2, 2, 2.0, 2.0, 22.12345, false, cast('2020-01-01' as date), cast('2020-01-01 00:00:00' as timestamp), binary('example binary2'), 'bbbbbbbb', 'bbbbbbbb')");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR ALL COLUMNS");
            Statistics stats = (Statistics)this.loadTable("T").statistics().get();
            org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)stats.mergedRecordCount().getAsLong());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.mergedRecordSize().isPresent());
            Map colStats = stats.colStats();
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)0, (Long)Predef$.MODULE$.long2Long(4L), null, null, (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(1L)), colStats.get("id"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)1, (Long)Predef$.MODULE$.long2Long(4L), null, null, (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(4L), (Long)Predef$.MODULE$.long2Long(8L)), colStats.get("name"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)2, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Predef$.MODULE$.byte2Byte((byte)1), (Comparable)Predef$.MODULE$.byte2Byte((byte)2), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(1L)), colStats.get("byte_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)3, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Predef$.MODULE$.short2Short((short)1), (Comparable)Predef$.MODULE$.short2Short((short)2), (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(2L), (Long)Predef$.MODULE$.long2Long(2L)), colStats.get("short_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)4, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Predef$.MODULE$.int2Integer(1), (Comparable)Predef$.MODULE$.int2Integer(2), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(4L), (Long)Predef$.MODULE$.long2Long(4L)), colStats.get("int_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)5, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Predef$.MODULE$.long2Long(1L), (Comparable)Predef$.MODULE$.long2Long(2L), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(8L), (Long)Predef$.MODULE$.long2Long(8L)), colStats.get("long_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)6, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Predef$.MODULE$.float2Float(1.0f), (Comparable)Predef$.MODULE$.float2Float(2.0f), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(4L), (Long)Predef$.MODULE$.long2Long(4L)), colStats.get("float_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)7, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Predef$.MODULE$.double2Double(1.0), (Comparable)Predef$.MODULE$.double2Double(2.0), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(8L), (Long)Predef$.MODULE$.long2Long(8L)), colStats.get("double_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)8, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Decimal.fromBigDecimal((BigDecimal)new BigDecimal("12.12345"), (int)10, (int)5), (Comparable)Decimal.fromBigDecimal((BigDecimal)new BigDecimal("22.12345"), (int)10, (int)5), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(8L), (Long)Predef$.MODULE$.long2Long(8L)), colStats.get("decimal_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)9, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Predef$.MODULE$.boolean2Boolean(false), (Comparable)Predef$.MODULE$.boolean2Boolean(true), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(1L)), colStats.get("boolean_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)10, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Predef$.MODULE$.int2Integer(18262), (Comparable)Predef$.MODULE$.int2Integer(18263), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(4L), (Long)Predef$.MODULE$.long2Long(4L)), colStats.get("date_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)11, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)DateTimeUtils.parseTimestampData((String)"2020-01-01 00:00:00", (int)0), (Comparable)DateTimeUtils.parseTimestampData((String)"2020-01-02 00:00:00", (int)0), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(8L), (Long)Predef$.MODULE$.long2Long(8L)), colStats.get("timestamp_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)12, (Long)Predef$.MODULE$.long2Long(2L), null, null, (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(15L), (Long)Predef$.MODULE$.long2Long(15L)), colStats.get("binary"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)13, (Long)Predef$.MODULE$.long2Long(4L), null, null, (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(20L), (Long)Predef$.MODULE$.long2Long(20L)), colStats.get("char_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)14, (Long)Predef$.MODULE$.long2Long(4L), null, null, (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(4L), (Long)Predef$.MODULE$.long2Long(8L)), colStats.get("varchar_col"));
            this.spark().sql("INSERT INTO T VALUES ('5', 'bbbbbbbbbbbbbbbb', 3, 3, 3, 3, 3.0, 3.0, 32.12345, false, cast('2020-01-03' as date), cast('2020-01-03 00:00:00' as timestamp), binary('binary3'), 'bbbbbbbbbbbbbbbb', 'bbbbbbbbbbbbbbbb')");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR ALL COLUMNS");
            stats = (Statistics)this.loadTable("T").statistics().get();
            org.junit.jupiter.api.Assertions.assertEquals((long)5L, (long)stats.mergedRecordCount().getAsLong());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.mergedRecordSize().isPresent());
            colStats = stats.colStats();
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)0, (Long)Predef$.MODULE$.long2Long(5L), null, null, (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(1L)), colStats.get("id"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)1, (Long)Predef$.MODULE$.long2Long(5L), null, null, (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(7L), (Long)Predef$.MODULE$.long2Long(16L)), colStats.get("name"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)2, (Long)Predef$.MODULE$.long2Long(3L), (Comparable)Predef$.MODULE$.byte2Byte((byte)1), (Comparable)Predef$.MODULE$.byte2Byte((byte)3), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(1L)), colStats.get("byte_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)3, (Long)Predef$.MODULE$.long2Long(3L), (Comparable)Predef$.MODULE$.short2Short((short)1), (Comparable)Predef$.MODULE$.short2Short((short)3), (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(2L), (Long)Predef$.MODULE$.long2Long(2L)), colStats.get("short_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)4, (Long)Predef$.MODULE$.long2Long(3L), (Comparable)Predef$.MODULE$.int2Integer(1), (Comparable)Predef$.MODULE$.int2Integer(3), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(4L), (Long)Predef$.MODULE$.long2Long(4L)), colStats.get("int_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)5, (Long)Predef$.MODULE$.long2Long(3L), (Comparable)Predef$.MODULE$.long2Long(1L), (Comparable)Predef$.MODULE$.long2Long(3L), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(8L), (Long)Predef$.MODULE$.long2Long(8L)), colStats.get("long_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)6, (Long)Predef$.MODULE$.long2Long(3L), (Comparable)Predef$.MODULE$.float2Float(1.0f), (Comparable)Predef$.MODULE$.float2Float(3.0f), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(4L), (Long)Predef$.MODULE$.long2Long(4L)), colStats.get("float_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)7, (Long)Predef$.MODULE$.long2Long(3L), (Comparable)Predef$.MODULE$.double2Double(1.0), (Comparable)Predef$.MODULE$.double2Double(3.0), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(8L), (Long)Predef$.MODULE$.long2Long(8L)), colStats.get("double_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)8, (Long)Predef$.MODULE$.long2Long(3L), (Comparable)Decimal.fromBigDecimal((BigDecimal)new BigDecimal("12.12345"), (int)10, (int)5), (Comparable)Decimal.fromBigDecimal((BigDecimal)new BigDecimal("32.12345"), (int)10, (int)5), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(8L), (Long)Predef$.MODULE$.long2Long(8L)), colStats.get("decimal_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)9, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Predef$.MODULE$.boolean2Boolean(false), (Comparable)Predef$.MODULE$.boolean2Boolean(true), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(1L)), colStats.get("boolean_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)10, (Long)Predef$.MODULE$.long2Long(3L), (Comparable)Predef$.MODULE$.int2Integer(18262), (Comparable)Predef$.MODULE$.int2Integer(18264), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(4L), (Long)Predef$.MODULE$.long2Long(4L)), colStats.get("date_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)11, (Long)Predef$.MODULE$.long2Long(3L), (Comparable)DateTimeUtils.parseTimestampData((String)"2020-01-01 00:00:00", (int)0), (Comparable)DateTimeUtils.parseTimestampData((String)"2020-01-03 00:00:00", (int)0), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(8L), (Long)Predef$.MODULE$.long2Long(8L)), colStats.get("timestamp_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)12, (Long)Predef$.MODULE$.long2Long(3L), null, null, (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(13L), (Long)Predef$.MODULE$.long2Long(15L)), colStats.get("binary"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)13, (Long)Predef$.MODULE$.long2Long(5L), null, null, (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(20L), (Long)Predef$.MODULE$.long2Long(20L)), colStats.get("char_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)14, (Long)Predef$.MODULE$.long2Long(5L), null, null, (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(7L), (Long)Predef$.MODULE$.long2Long(16L)), colStats.get("varchar_col"));
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        this.test("Paimon analyze: analyze unsupported cols", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (id STRING, m MAP<INT, STRING>, l ARRAY<INT>, s STRUCT<i:INT, s:STRING>)\n         |USING PAIMON\n         |TBLPROPERTIES ('primary-key'='id')\n         |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', map(1, 'a'), array(1), struct(1, 'a'))");
            Assertions.assertThatThrownBy(() -> this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR COLUMNS m")).hasMessageContaining("not supported");
            Assertions.assertThatThrownBy(() -> this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR COLUMNS l")).hasMessageContaining("not supported");
            return Assertions.assertThatThrownBy(() -> this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR COLUMNS s")).hasMessageContaining("not supported");
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
        this.test("Paimon analyze: analyze non-exist cols", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING, i INT, l LONG)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            return Assertions.assertThatThrownBy(() -> this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR COLUMNS fake_col")).hasMessageContaining("not found");
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
        this.test("Paimon analyze: analyze specialized cols", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING, i INT, l LONG)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a', 1, 1)");
            this.spark().sql("INSERT INTO T VALUES ('2', 'aaa', 1, 2)");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR COLUMNS name, i");
            Map colStats = ((Statistics)this.loadTable("T").statistics().get()).colStats();
            org.junit.jupiter.api.Assertions.assertEquals(null, colStats.get("id"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)1, (Long)Predef$.MODULE$.long2Long(2L), null, null, (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(2L), (Long)Predef$.MODULE$.long2Long(3L)), colStats.get("name"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)2, (Long)Predef$.MODULE$.long2Long(1L), (Comparable)Predef$.MODULE$.int2Integer(1), (Comparable)Predef$.MODULE$.int2Integer(1), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(4L), (Long)Predef$.MODULE$.long2Long(4L)), colStats.get("i"));
            org.junit.jupiter.api.Assertions.assertEquals(null, colStats.get("l"));
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "a", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "aaa", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT * from T ORDER BY id"), (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
        this.test("Paimon analyze: statistics expire and clean", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            FileStoreTable table = this.loadTable("T");
            Path tableLocation = table.location();
            FileIO fileIO = table.fileIO();
            this.spark().sql("INSERT INTO T VALUES ('1', 'a')");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS");
            this.spark().sql("INSERT INTO T VALUES ('2', 'b')");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS");
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.statsFileCount(tableLocation, fileIO));
            this.spark().sql("CALL sys.expire_snapshots(table => 'test.T', retain_max => 1)");
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.statsFileCount(tableLocation, fileIO));
            Path orphanStats = new Path(tableLocation, "statistics/stats-orphan-0");
            fileIO.tryToWriteAtomic(orphanStats, "x");
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.statsFileCount(tableLocation, fileIO));
            Thread.sleep(1001L);
            String older_than = DateTimeUtils.formatLocalDateTime((LocalDateTime)DateTimeUtils.toLocalDateTime((long)System.currentTimeMillis()), (int)3);
            this.spark().sql(new StringBuilder(60).append("CALL sys.remove_orphan_files(table => 'T', older_than => '").append(older_than).append("')").toString());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.statsFileCount(tableLocation, fileIO));
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
        this.test("Paimon analyze: spark use table stats", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING, i INT, l LONG)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a', 1, 1)");
            this.spark().sql("INSERT INTO T VALUES ('2', 'aaa', 1, 2)");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS");
            org.apache.spark.sql.catalyst.plans.logical.Statistics stats = this.getScanStatistic("SELECT * FROM T");
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)((BigInt)stats.rowCount().get()).longValue());
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
        this.test("Paimon analyze: spark use col stats", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING, i INT, l LONG)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a', 1, 1)");
            this.spark().sql("INSERT INTO T VALUES ('2', 'aaa', 1, 2)");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR ALL COLUMNS");
            org.apache.spark.sql.catalyst.plans.logical.Statistics stats = this.getScanStatistic("SELECT * FROM T");
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)((BigInt)stats.rowCount().get()).longValue());
            org.junit.jupiter.api.Assertions.assertEquals((int)(this.gteqSpark3_4() ? 4 : 0), (int)stats.attributeStats().size());
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
        this.test("Paimon analyze: partition filter push down hit", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, name STRING, pt INT)\n                 |TBLPROPERTIES ('primary-key'='id, pt', 'bucket'='2')\n                 |PARTITIONED BY (pt)\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, 'a', 1), (2, 'b', 1), (3, 'c', 2), (4, 'd', 3)");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR ALL COLUMNS");
            ObjectRef sql = ObjectRef.create((Object)"SELECT * FROM T WHERE pt < 1");
            org.junit.jupiter.api.Assertions.assertEquals((long)(this.gteqSpark3_4() ? 0L : 4L), (long)((BigInt)this.getScanStatistic((String)sql.elem).rowCount().get()).longValue());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql((String)sql$1.elem), (Seq)Nil$.MODULE$);
            sql.elem = "SELECT id FROM T WHERE pt < 1";
            org.junit.jupiter.api.Assertions.assertEquals((long)(this.gteqSpark3_4() ? 0L : 4L), (long)((BigInt)this.getScanStatistic((String)sql.elem).rowCount().get()).longValue());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql((String)sql$1.elem), (Seq)Nil$.MODULE$);
            sql.elem = "SELECT * FROM T WHERE id < 1";
            org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)((BigInt)this.getScanStatistic((String)sql.elem).rowCount().get()).longValue());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql((String)sql$1.elem), (Seq)Nil$.MODULE$);
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
        this.test("Paimon analyze: partition filter push down hit with char/varchar", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"char(10)", (List)new .colon.colon((Object)"varchar(10)", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)partitionType -> {
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(174).append("\n                 |CREATE TABLE T (id INT, name STRING, pt ").append(partitionType).append(")\n                 |TBLPROPERTIES ('primary-key'='id, pt')\n                 |PARTITIONED BY (pt)\n                 |").toString())).stripMargin());
                $this.sql().apply((Object)"INSERT INTO T VALUES (1, 'a', '1'), (2, 'b', '1'), (3, 'c', '2'), (4, 'd', '3')");
                $this.sql().apply((Object)"ANALYZE TABLE T COMPUTE STATISTICS FOR ALL COLUMNS");
                String sqlText = "SELECT * FROM T WHERE pt < '1'";
                org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)((BigInt)$this.getScanStatistic(sqlText).rowCount().get()).longValue());
                sqlText = "SELECT id FROM T WHERE pt < '1'";
                org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)((BigInt)$this.getScanStatistic(sqlText).rowCount().get()).longValue());
            });
            return BoxedUnit.UNIT;
        }), new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
        this.test("Fix reported statistics does not do column pruning", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            long withColStat;
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                |CREATE TABLE T (c1 INT, c2 INT, c3 LONG, c4 STRING)\n                |USING PAIMON\n                |TBLPROPERTIES ('primary-key'='c1')\n                |")).stripMargin());
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS");
            org.apache.spark.sql.catalyst.plans.logical.Statistics wholeSize1 = this.getScanStatistic("SELECT * FROM T");
            long $org_scalatest_assert_macro_left = ((ScalaNumericAnyConversions)wholeSize1.rowCount().get()).toLong();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
            long $org_scalatest_assert_macro_left2 = wholeSize1.sizeInBytes().toLong();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 493));
            org.apache.spark.sql.catalyst.plans.logical.Statistics metadataSize1 = this.getScanStatistic("SELECT __paimon_row_index FROM T");
            long $org_scalatest_assert_macro_left3 = ((ScalaNumericAnyConversions)metadataSize1.rowCount().get()).toLong();
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 495));
            long $org_scalatest_assert_macro_left4 = metadataSize1.sizeInBytes().toLong();
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == (long)$org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
            this.spark().sql(new StringBuilder(36).append("INSERT INTO T VALUES (1, 1, 100, '").append(UUID.randomUUID().toString()).append("')").toString());
            this.spark().sql(new StringBuilder(36).append("INSERT INTO T VALUES (2, 2, 200, '").append(UUID.randomUUID().toString()).append("')").toString());
            this.spark().sql(new StringBuilder(36).append("INSERT INTO T VALUES (3, 3, 300, '").append(UUID.randomUUID().toString()).append("')").toString());
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS");
            long noColStat = this.checkStatistics$1();
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR ALL COLUMNS");
            long $org_scalatest_assert_macro_left5 = withColStat = this.checkStatistics$1();
            long $org_scalatest_assert_macro_right5 = noColStat;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529));
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
    }
}

