/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.partition.file.SuccessFile;
import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\tqR*\u0019:l!\u0006\u0014H/\u001b;j_:$uN\\3Qe>\u001cW\rZ;sKR+7\u000f\u001e\u0006\u0003\t\u0015\t\u0011\u0002\u001d:pG\u0016$WO]3\u000b\u0005\u00199\u0011!B:qCJ\\'B\u0001\u0005\n\u0003\u0019\u0001\u0018-[7p]*\u0011!bC\u0001\u0007CB\f7\r[3\u000b\u00031\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\b\u0011\u0005A\tR\"A\u0003\n\u0005I)!a\u0005)bS6|gn\u00159be.$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0004\u0001")
public class MarkPartitionDoneProcedureTest
extends PaimonSparkTestBase {
    public MarkPartitionDoneProcedureTest() {
        this.test("Paimon procedure: mark_partition_done test", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING, day STRING)\n                 |USING PAIMON\n                 |PARTITIONED BY (day)\n                 |TBLPROPERTIES (\n                 |'primary-key'='day,id',\n                 |'partition.mark-done-action'='success-file')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a', '2024-07-13')");
            this.spark().sql("INSERT INTO T VALUES ('2', 'b', '2024-07-14')");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true)}));
            this.checkAnswer((Function0 & java.io.Serializable & Serializable)() -> this.spark().sql("CALL paimon.sys.mark_partition_done(table => 'test.T', partitions => 'day=2024-07-13;day=2024-07-14')"), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
            FileStoreTable table = this.loadTable("T");
            Path successPath1 = new Path(table.location(), "day=2024-07-13/_SUCCESS");
            SuccessFile successFile1 = SuccessFile.safelyFromPath((FileIO)table.fileIO(), (Path)successPath1);
            Assertions.assertThat((Object)successFile1).isNotNull();
            Path successPath2 = new Path(table.location(), "day=2024-07-14/_SUCCESS");
            SuccessFile successFile2 = SuccessFile.safelyFromPath((FileIO)table.fileIO(), (Path)successPath2);
            return (ObjectAssert)Assertions.assertThat((Object)successFile2).isNotNull();
        }, new Position("MarkPartitionDoneProcedureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
    }
}

