/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.extensions;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.apache.paimon.spark.catalyst.plans.logical.PaimonCallArgument;
import org.apache.paimon.spark.catalyst.plans.logical.PaimonCallStatement;
import org.apache.paimon.spark.catalyst.plans.logical.PaimonNamedArgument;
import org.apache.paimon.spark.catalyst.plans.logical.PaimonPositionalArgument;
import org.apache.paimon.spark.extensions.PaimonSparkSessionExtensions;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.parser.extensions.PaimonParseException;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class CallStatementParserTest {
    private SparkSession spark = null;
    private ParserInterface parser = null;

    @BeforeEach
    public void startSparkSession() {
        Option optionalSession = SparkSession.getActiveSession().orElse(SparkSession::getDefaultSession);
        if (!optionalSession.isEmpty()) {
            ((SparkSession)optionalSession.get()).stop();
        }
        SparkSession.clearActiveSession();
        this.spark = SparkSession.builder().master("local[2]").config("spark.sql.extensions", PaimonSparkSessionExtensions.class.getName()).getOrCreate();
        this.parser = this.spark.sessionState().sqlParser();
    }

    @AfterEach
    public void stopSparkSession() {
        if (this.spark != null) {
            this.spark.stop();
            this.spark = null;
            this.parser = null;
        }
    }

    @Test
    public void testDelegateUnsupportedProcedure() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parser.parsePlan("CALL cat.d.t()")).isInstanceOf(ParseException.class)).satisfies(new ThrowingConsumer[]{exception -> {
            ParseException parseException = (ParseException)exception;
            Assertions.assertThat((String)parseException.getErrorClass()).isEqualTo("PARSE_SYNTAX_ERROR");
            Assertions.assertThat((String)((String)parseException.getMessageParameters().get("error"))).isEqualTo("'CALL'");
        }});
    }

    @Test
    public void testCallWithBackticks() throws ParseException {
        PaimonCallStatement call = (PaimonCallStatement)this.parser.parsePlan("CALL cat.`sys`.`rollback`()");
        Assertions.assertThat((List)JavaConverters.seqAsJavaList((Seq)call.name())).isEqualTo(Arrays.asList("cat", "sys", "rollback"));
        Assertions.assertThat((int)call.args().size()).isEqualTo(0);
    }

    @Test
    public void testCallWithNamedArguments() throws ParseException {
        PaimonCallStatement callStatement = (PaimonCallStatement)this.parser.parsePlan("CALL catalog.sys.rollback(arg1 => 1, arg2 => 'test', arg3 => true)");
        Assertions.assertThat((List)JavaConverters.seqAsJavaList((Seq)callStatement.name())).isEqualTo(Arrays.asList("catalog", "sys", "rollback"));
        Assertions.assertThat((int)callStatement.args().size()).isEqualTo(3);
        this.assertArgument(callStatement, 0, "arg1", 1, DataTypes.IntegerType);
        this.assertArgument(callStatement, 1, "arg2", "test", DataTypes.StringType);
        this.assertArgument(callStatement, 2, "arg3", true, DataTypes.BooleanType);
    }

    @Test
    public void testCallWithPositionalArguments() throws ParseException {
        PaimonCallStatement callStatement = (PaimonCallStatement)this.parser.parsePlan("CALL catalog.sys.rollback(1, '${spark.sql.extensions}', 2L, true, 3.0D, 4.0e1,500e-1BD, TIMESTAMP '2017-02-03T10:37:30.00Z')");
        Assertions.assertThat((List)JavaConverters.seqAsJavaList((Seq)callStatement.name())).isEqualTo(Arrays.asList("catalog", "sys", "rollback"));
        Assertions.assertThat((int)callStatement.args().size()).isEqualTo(8);
        this.assertArgument(callStatement, 0, 1, DataTypes.IntegerType);
        this.assertArgument(callStatement, 1, PaimonSparkSessionExtensions.class.getName(), DataTypes.StringType);
        this.assertArgument(callStatement, 2, 2L, DataTypes.LongType);
        this.assertArgument(callStatement, 3, true, DataTypes.BooleanType);
        this.assertArgument(callStatement, 4, 3.0, DataTypes.DoubleType);
        this.assertArgument(callStatement, 5, 40.0, DataTypes.DoubleType);
        this.assertArgument(callStatement, 6, new BigDecimal("500e-1"), (DataType)DataTypes.createDecimalType((int)3, (int)1));
        this.assertArgument(callStatement, 7, Timestamp.from(Instant.parse("2017-02-03T10:37:30.00Z")), DataTypes.TimestampType);
    }

    @Test
    public void testCallWithMixedArguments() throws ParseException {
        PaimonCallStatement callStatement = (PaimonCallStatement)this.parser.parsePlan("CALL catalog.sys.rollback(arg1 => 1, 'test')");
        Assertions.assertThat((List)JavaConverters.seqAsJavaList((Seq)callStatement.name())).isEqualTo(Arrays.asList("catalog", "sys", "rollback"));
        Assertions.assertThat((int)callStatement.args().size()).isEqualTo(2);
        this.assertArgument(callStatement, 0, "arg1", 1, DataTypes.IntegerType);
        this.assertArgument(callStatement, 1, "test", DataTypes.StringType);
    }

    @Test
    public void testCallWithParseException() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parser.parsePlan("CALL catalog.sys.rollback abc")).isInstanceOf(PaimonParseException.class)).hasMessageContaining("missing '(' at 'abc'");
    }

    private void assertArgument(PaimonCallStatement call, int index, Object expectedValue, DataType expectedType) {
        this.assertArgument(call, index, null, expectedValue, expectedType);
    }

    private void assertArgument(PaimonCallStatement callStatement, int index, String expectedName, Object expectedValue, DataType expectedType) {
        if (expectedName == null) {
            PaimonCallArgument callArgument = (PaimonCallArgument)callStatement.args().apply(index);
            this.assertCast(callArgument, PaimonPositionalArgument.class);
        } else {
            PaimonNamedArgument namedArgument = this.assertCast(callStatement.args().apply(index), PaimonNamedArgument.class);
            Assertions.assertThat((String)namedArgument.name()).isEqualTo(expectedName);
        }
        Assertions.assertThat((Object)((PaimonCallArgument)callStatement.args().apply(index)).expr()).isEqualTo((Object)Literal$.MODULE$.create(expectedValue, expectedType));
    }

    private <T> T assertCast(Object value, Class<T> expectedClass) {
        Assertions.assertThat((Object)value).isInstanceOf(expectedClass);
        return expectedClass.cast(value);
    }
}

