/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericMap;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.spark.SparkRow;
import org.apache.paimon.spark.SparkTypeTest;
import org.apache.paimon.spark.SparkTypeUtils;
import org.apache.paimon.spark.data.SparkInternalRow;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.CatalystTypeConverters;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class SparkInternalRowTest {
    @Test
    public void test() {
        TimeZone tz = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("Asia/Shanghai"));
        GenericRow rowData = GenericRow.of((Object[])new Object[]{1, BinaryString.fromString((String)"jingsong"), BinaryString.fromString((String)"apache"), BinaryString.fromString((String)"paimon"), 22.2, new GenericMap(Stream.of(new AbstractMap.SimpleEntry<BinaryString, GenericRow>(BinaryString.fromString((String)"key1"), GenericRow.of((Object[])new Object[]{1.2, 2.3})), new AbstractMap.SimpleEntry<BinaryString, GenericRow>(BinaryString.fromString((String)"key2"), GenericRow.of((Object[])new Object[]{2.4, 3.5}))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))), new GenericArray((Object[])new BinaryString[]{BinaryString.fromString((String)"v1"), BinaryString.fromString((String)"v5")}), new GenericArray((Object[])new Integer[]{10, 30}), true, (byte)22, (short)356, 23567222L, "varbinary_v".getBytes(StandardCharsets.UTF_8), Timestamp.fromLocalDateTime((LocalDateTime)LocalDateTime.parse("2007-12-03T10:15:30")), Timestamp.fromLocalDateTime((LocalDateTime)LocalDateTime.parse("2007-12-03T10:15:30")), DateTimeUtils.toInternal((LocalDate)LocalDate.parse("2022-05-02")), Decimal.fromBigDecimal((BigDecimal)BigDecimal.valueOf(0.21), (int)2, (int)2), Decimal.fromBigDecimal((BigDecimal)BigDecimal.valueOf(6.578212312301E10), (int)38, (int)2), Decimal.fromBigDecimal((BigDecimal)BigDecimal.valueOf(6.21231235E7), (int)10, (int)1)});
        Function1 sparkConverter = CatalystTypeConverters.createToScalaConverter((org.apache.spark.sql.types.DataType)CharVarcharUtils.replaceCharVarcharWithString((org.apache.spark.sql.types.DataType)SparkTypeUtils.fromPaimonType((DataType)SparkTypeTest.ALL_TYPES)));
        Row sparkRow = (Row)sparkConverter.apply((Object)SparkInternalRow.create((RowType)SparkTypeTest.ALL_TYPES).replace((InternalRow)rowData));
        String expected = "1,jingsong,apache,paimon,22.2,Map(key2 -> [2.4,3.5], key1 -> [1.2,2.3]),[v1, v5],[10, 30],true,22,356,23567222,[B@,2007-12-03 18:15:30.0,2007-12-03T10:15:30,2022-05-02,0.21,65782123123.01,62123123.5";
        Assertions.assertThat((String)this.sparkRowToString(sparkRow)).isEqualTo(expected);
        SparkRow sparkRowData = new SparkRow(SparkTypeTest.ALL_TYPES, sparkRow);
        sparkRow = (Row)sparkConverter.apply((Object)SparkInternalRow.create((RowType)SparkTypeTest.ALL_TYPES).replace((InternalRow)sparkRowData));
        Assertions.assertThat((String)this.sparkRowToString(sparkRow)).isEqualTo(expected);
        TimeZone.setDefault(tz);
    }

    private String sparkRowToString(Row row) {
        return JavaConverters.seqAsJavaList((Seq)row.toSeq()).stream().map(x -> x instanceof Seq ? JavaConverters.seqAsJavaList((Seq)((Seq)x)) : x).map(Object::toString).map(x -> x.startsWith("[B@") ? "[B@" : x).collect(Collectors.joining(","));
    }
}

