/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.io.FileNotFoundException;
import java.nio.file.Path;
import org.apache.paimon.hive.TestHiveMetastore;
import org.apache.paimon.spark.SparkCatalog;
import org.apache.paimon.spark.SparkGenericCatalog;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class SparkGenericCatalogWithHiveTest {
    private static TestHiveMetastore testHiveMetastore;

    @BeforeAll
    public static void startMetastore() {
        testHiveMetastore = new TestHiveMetastore();
        testHiveMetastore.start();
    }

    @AfterAll
    public static void closeMetastore() throws Exception {
        testHiveMetastore.stop();
    }

    @Test
    public void testBuildWithHive(@TempDir Path tempDir) {
        org.apache.paimon.fs.Path warehousePath = new org.apache.paimon.fs.Path("file:" + tempDir.toString());
        SparkSession spark = SparkSession.builder().config("spark.sql.warehouse.dir", warehousePath.toString()).config("spark.sql.catalogImplementation", "hive").config("spark.sql.catalog.spark_catalog", SparkGenericCatalog.class.getName()).master("local[2]").getOrCreate();
        spark.sql("CREATE DATABASE my_db");
        spark.sql("USE my_db");
        spark.sql("CREATE TABLE IF NOT EXISTS t1 (a INT, b INT, c STRING) USING paimon TBLPROPERTIES ('file.format'='avro')");
        Assertions.assertThat(spark.sql("SHOW NAMESPACES").collectAsList().stream().map(Object::toString)).containsExactlyInAnyOrder((Object[])new String[]{"[default]", "[my_db]"});
        Assertions.assertThat(spark.sql("SHOW TABLES").collectAsList().stream().map(s -> s.get(1)).map(Object::toString)).containsExactlyInAnyOrder((Object[])new String[]{"t1"});
        spark.close();
        SparkSession spark2 = SparkSession.builder().config("spark.sql.catalog.paimon.warehouse", warehousePath.toString()).config("spark.sql.catalogImplementation", "in-memory").config("spark.sql.catalog.paimon", SparkCatalog.class.getName()).master("local[2]").getOrCreate();
        spark2.sql("USE paimon");
        spark2.sql("USE my_db");
        Assertions.assertThat(spark2.sql("SHOW NAMESPACES").collectAsList().stream().map(Object::toString)).containsExactlyInAnyOrder((Object[])new String[]{"[default]", "[my_db]"});
        Assertions.assertThat(spark2.sql("SHOW TABLES").collectAsList().stream().map(s -> s.get(1)).map(Object::toString)).containsExactlyInAnyOrder((Object[])new String[]{"t1"});
    }

    @Test
    public void testHiveCatalogOptions(@TempDir Path tempDir) {
        org.apache.paimon.fs.Path warehousePath = new org.apache.paimon.fs.Path("file:" + tempDir.toString());
        SparkSession spark = SparkSession.builder().config("spark.sql.catalog.spark_catalog.hive-conf-dir", "nonExistentPath").config("spark.sql.warehouse.dir", warehousePath.toString()).config("spark.sql.catalogImplementation", "hive").config("spark.sql.catalog.spark_catalog", SparkGenericCatalog.class.getName()).master("local[2]").getOrCreate();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spark.sql("CREATE DATABASE my_db")).rootCause().isInstanceOf(FileNotFoundException.class)).hasMessageContaining("nonExistentPath");
        spark.close();
    }
}

