/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.spark.SparkFilterConverter;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.VarCharType;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SparkFilterConverterTest {
    @Test
    public void testAll() {
        RowType rowType = new RowType(Collections.singletonList(new DataField(0, "id", (DataType)new IntType())));
        SparkFilterConverter converter = new SparkFilterConverter(rowType);
        PredicateBuilder builder = new PredicateBuilder(rowType);
        String field = "id";
        IsNull isNull = IsNull.apply((String)field);
        Predicate expectedIsNull = builder.isNull(0);
        Predicate actualIsNull = converter.convert((Filter)isNull);
        Assertions.assertThat((Object)actualIsNull).isEqualTo((Object)expectedIsNull);
        IsNotNull isNotNull = IsNotNull.apply((String)field);
        Predicate expectedIsNotNull = builder.isNotNull(0);
        Predicate actualIsNotNull = converter.convert((Filter)isNotNull);
        Assertions.assertThat((Object)actualIsNotNull).isEqualTo((Object)expectedIsNotNull);
        LessThan lt = LessThan.apply((String)field, (Object)1);
        Predicate expectedLt = builder.lessThan(0, (Object)1);
        Predicate actualLt = converter.convert((Filter)lt);
        Assertions.assertThat((Object)actualLt).isEqualTo((Object)expectedLt);
        LessThan ltNull = LessThan.apply((String)field, null);
        Predicate expectedLtNull = builder.lessThan(0, null);
        Predicate actualLtNull = converter.convert((Filter)ltNull);
        Assertions.assertThat((Object)actualLtNull).isEqualTo((Object)expectedLtNull);
        LessThanOrEqual ltEq = LessThanOrEqual.apply((String)field, (Object)1);
        Predicate expectedLtEq = builder.lessOrEqual(0, (Object)1);
        Predicate actualLtEq = converter.convert((Filter)ltEq);
        Assertions.assertThat((Object)actualLtEq).isEqualTo((Object)expectedLtEq);
        LessThanOrEqual ltEqNull = LessThanOrEqual.apply((String)field, null);
        Predicate expectedLtEqNull = builder.lessOrEqual(0, null);
        Predicate actualLtEqNull = converter.convert((Filter)ltEqNull);
        Assertions.assertThat((Object)actualLtEqNull).isEqualTo((Object)expectedLtEqNull);
        GreaterThan gt = GreaterThan.apply((String)field, (Object)1);
        Predicate expectedGt = builder.greaterThan(0, (Object)1);
        Predicate actualGt = converter.convert((Filter)gt);
        Assertions.assertThat((Object)actualGt).isEqualTo((Object)expectedGt);
        GreaterThan gtNull = GreaterThan.apply((String)field, null);
        Predicate expectedGtNull = builder.greaterThan(0, null);
        Predicate actualGtNull = converter.convert((Filter)gtNull);
        Assertions.assertThat((Object)actualGtNull).isEqualTo((Object)expectedGtNull);
        GreaterThanOrEqual gtEq = GreaterThanOrEqual.apply((String)field, (Object)1);
        Predicate expectedGtEq = builder.greaterOrEqual(0, (Object)1);
        Predicate actualGtEq = converter.convert((Filter)gtEq);
        Assertions.assertThat((Object)actualGtEq).isEqualTo((Object)expectedGtEq);
        GreaterThanOrEqual gtEqNull = GreaterThanOrEqual.apply((String)field, null);
        Predicate expectedGtEqNull = builder.greaterOrEqual(0, null);
        Predicate actualGtEqNull = converter.convert((Filter)gtEqNull);
        Assertions.assertThat((Object)actualGtEqNull).isEqualTo((Object)expectedGtEqNull);
        EqualTo eq = EqualTo.apply((String)field, (Object)1);
        Predicate expectedEq = builder.equal(0, (Object)1);
        Predicate actualEq = converter.convert((Filter)eq);
        Assertions.assertThat((Object)actualEq).isEqualTo((Object)expectedEq);
        EqualTo eqNull = EqualTo.apply((String)field, null);
        Predicate expectedEqNull = builder.equal(0, null);
        Predicate actualEqNull = converter.convert((Filter)eqNull);
        Assertions.assertThat((Object)actualEqNull).isEqualTo((Object)expectedEqNull);
        EqualNullSafe eqSafe = EqualNullSafe.apply((String)field, (Object)1);
        Predicate expectedEqSafe = builder.equal(0, (Object)1);
        Predicate actualEqSafe = converter.convert((Filter)eqSafe);
        Assertions.assertThat((Object)actualEqSafe).isEqualTo((Object)expectedEqSafe);
        EqualNullSafe eqNullSafe = EqualNullSafe.apply((String)field, null);
        Predicate expectEqNullSafe = builder.isNull(0);
        Predicate actualEqNullSafe = converter.convert((Filter)eqNullSafe);
        Assertions.assertThat((Object)actualEqNullSafe).isEqualTo((Object)expectEqNullSafe);
        In in = In.apply((String)field, (Object[])new Object[]{1, null, 2});
        Predicate expectedIn = builder.in(0, Arrays.asList(1, null, 2));
        Predicate actualIn = converter.convert((Filter)in);
        Assertions.assertThat((Object)actualIn).isEqualTo((Object)expectedIn);
        Object[] literals = new Object[30];
        literals[0] = null;
        for (int i = 1; i < literals.length; ++i) {
            literals[i] = i * 100;
        }
        In largeIn = In.apply((String)field, (Object[])literals);
        Predicate expectedLargeIn = builder.in(0, Arrays.asList(literals));
        Predicate actualLargeIn = converter.convert((Filter)largeIn);
        Assertions.assertThat((Object)actualLargeIn).isEqualTo((Object)expectedLargeIn);
        RowType rowType01 = new RowType(Collections.singletonList(new DataField(0, "id", (DataType)new VarCharType())));
        SparkFilterConverter converter01 = new SparkFilterConverter(rowType01);
        StringEndsWith endsWith = StringEndsWith.apply((String)"id", (String)"abc");
        Predicate endsWithPre = converter01.convert((Filter)endsWith);
        GenericRow row = GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)"aabc")});
        GenericRow max = GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)"xasxwsa")});
        GenericRow min = GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)"aaaaa")});
        boolean test = endsWithPre.test((InternalRow)row);
        Object[] nullCount = new Integer[]{null};
        boolean test1 = endsWithPre.test(10L, (InternalRow)min, (InternalRow)max, (InternalArray)new GenericArray(nullCount));
        Assertions.assertThat((boolean)test).isEqualTo(true);
        Assertions.assertThat((boolean)test1).isEqualTo(true);
        StringContains stringContains = StringContains.apply((String)"id", (String)"aa");
        Predicate contains = converter01.convert((Filter)stringContains);
        Assertions.assertThat((boolean)contains.test((InternalRow)row)).isEqualTo(true);
        Assertions.assertThat((boolean)contains.test((InternalRow)max)).isEqualTo(false);
        Assertions.assertThat((boolean)contains.test((InternalRow)min)).isEqualTo(true);
    }

    @Test
    public void testTimestamp() {
        RowType rowType = new RowType(Collections.singletonList(new DataField(0, "x", (DataType)new TimestampType())));
        SparkFilterConverter converter = new SparkFilterConverter(rowType);
        PredicateBuilder builder = new PredicateBuilder(rowType);
        Timestamp timestamp = Timestamp.valueOf("2018-10-18 00:00:57.907");
        LocalDateTime localDateTime = LocalDateTime.parse("2018-10-18T00:00:57.907");
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        Predicate instantExpression = converter.convert((Filter)GreaterThan.apply((String)"x", (Object)instant));
        Predicate timestampExpression = converter.convert((Filter)GreaterThan.apply((String)"x", (Object)timestamp));
        Predicate rawExpression = builder.greaterThan(0, (Object)org.apache.paimon.data.Timestamp.fromLocalDateTime((LocalDateTime)localDateTime));
        Assertions.assertThat((Object)timestampExpression).isEqualTo((Object)rawExpression);
        Assertions.assertThat((Object)instantExpression).isEqualTo((Object)rawExpression);
    }

    @Test
    public void testDate() {
        RowType rowType = new RowType(Collections.singletonList(new DataField(0, "x", (DataType)new DateType())));
        SparkFilterConverter converter = new SparkFilterConverter(rowType);
        PredicateBuilder builder = new PredicateBuilder(rowType);
        LocalDate localDate = LocalDate.parse("2018-10-18");
        Date date = Date.valueOf(localDate);
        int epochDay = (int)localDate.toEpochDay();
        Predicate localDateExpression = converter.convert((Filter)GreaterThan.apply((String)"x", (Object)localDate));
        Predicate dateExpression = converter.convert((Filter)GreaterThan.apply((String)"x", (Object)date));
        Predicate rawExpression = builder.greaterThan(0, (Object)epochDay);
        Assertions.assertThat((Object)dateExpression).isEqualTo((Object)rawExpression);
        Assertions.assertThat((Object)localDateExpression).isEqualTo((Object)rawExpression);
    }

    @Test
    public void testIgnoreFailure() {
        ArrayList<DataField> dataFields = new ArrayList<DataField>();
        dataFields.add(new DataField(0, "id", (DataType)new IntType()));
        dataFields.add(new DataField(1, "name", (DataType)new VarCharType(Integer.MAX_VALUE)));
        RowType rowType = new RowType(dataFields);
        SparkFilterConverter converter = new SparkFilterConverter(rowType);
        Not not = Not.apply((Filter)StringStartsWith.apply((String)"name", (String)"paimon"));
        Assertions.assertThatThrownBy(() -> converter.convert((Filter)not, false)).hasMessageContaining("Not(StringStartsWith(name,paimon)) is unsupported.");
        Assertions.assertThat((Object)converter.convert((Filter)not, true)).isNull();
        Assertions.assertThat((Object)converter.convertIgnoreFailure((Filter)not)).isNull();
    }
}

