/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.SingletonSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.table.system.AggregationFieldsTable;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.ProjectedRow;

public class AllTableOptionsTable
implements ReadonlyTable {
    public static final String ALL_TABLE_OPTIONS = "all_table_options";
    private final FileIO fileIO;
    private final Map<String, Map<String, Path>> allTablePaths;

    public AllTableOptionsTable(FileIO fileIO, Map<String, Map<String, Path>> allTablePaths) {
        this.fileIO = fileIO;
        this.allTablePaths = allTablePaths;
    }

    @Override
    public String name() {
        return ALL_TABLE_OPTIONS;
    }

    @Override
    public RowType rowType() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(0, "database_name", new VarCharType(Integer.MAX_VALUE)));
        fields.add(new DataField(1, "table_name", new VarCharType(Integer.MAX_VALUE)));
        fields.add(new DataField(2, "key", new VarCharType(Integer.MAX_VALUE)));
        fields.add(new DataField(3, "value", new VarCharType(Integer.MAX_VALUE)));
        return new RowType(fields);
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList("table_name");
    }

    @Override
    public InnerTableScan newScan() {
        return new AllTableOptionsScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new AllTableOptionsRead(this.fileIO);
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new AllTableOptionsTable(this.fileIO, this.allTablePaths);
    }

    protected static Iterator<InternalRow> toRow(Map<String, Map<String, Map<String, String>>> option) {
        ArrayList<GenericRow> rows = new ArrayList<GenericRow>();
        for (Map.Entry<String, Map<String, Map<String, String>>> entry0 : option.entrySet()) {
            String database = entry0.getKey();
            for (Map.Entry<String, Map<String, String>> entry1 : entry0.getValue().entrySet()) {
                String tableName = entry1.getKey();
                for (Map.Entry<String, String> entry2 : entry1.getValue().entrySet()) {
                    String key = entry2.getKey();
                    String value = entry2.getValue();
                    rows.add(GenericRow.of(BinaryString.fromString(database), BinaryString.fromString(tableName), BinaryString.fromString(key), BinaryString.fromString(value)));
                }
            }
        }
        return rows.iterator();
    }

    protected static Map<String, Map<String, Map<String, String>>> options(FileIO fileIO, Map<String, Map<String, Path>> allTablePaths) {
        HashMap<String, Map<String, Map<String, String>>> allOptions = new HashMap<String, Map<String, Map<String, String>>>();
        for (Map.Entry<String, Map<String, Path>> entry0 : allTablePaths.entrySet()) {
            Map m0 = allOptions.computeIfAbsent(entry0.getKey(), k -> new HashMap());
            for (Map.Entry<String, Path> entry1 : entry0.getValue().entrySet()) {
                Map<String, String> options = new SchemaManager(fileIO, entry1.getValue()).latest().orElseThrow(() -> new RuntimeException("Table not exists.")).options();
                m0.put(entry1.getKey(), options);
            }
        }
        return allOptions;
    }

    private static class AllTableOptionsRead
    implements InnerTableRead {
        private final FileIO fileIO;
        private RowType readType;

        public AllTableOptionsRead(FileIO fileIO) {
            this.fileIO = fileIO;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withReadType(RowType readType) {
            this.readType = readType;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) {
            if (!(split instanceof AllTableSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            Map location = ((AllTableSplit)split).allTablePaths;
            Iterator<InternalRow> rows = AllTableOptionsTable.toRow(AllTableOptionsTable.options(this.fileIO, location));
            if (this.readType != null) {
                rows = Iterators.transform(rows, row -> ProjectedRow.from(this.readType, AggregationFieldsTable.TABLE_TYPE).replaceRow((InternalRow)row));
            }
            return new IteratorRecordReader<InternalRow>(rows);
        }
    }

    private static class AllTableSplit
    extends SingletonSplit {
        private static final long serialVersionUID = 1L;
        private final Map<String, Map<String, Path>> allTablePaths;

        private AllTableSplit(Map<String, Map<String, Path>> allTablePaths) {
            this.allTablePaths = allTablePaths;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllTableSplit that = (AllTableSplit)o;
            return Objects.equals(this.allTablePaths, that.allTablePaths);
        }

        public int hashCode() {
            return Objects.hash(this.allTablePaths);
        }
    }

    private class AllTableOptionsScan
    extends ReadOnceTableScan {
        private AllTableOptionsScan() {
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new AllTableSplit(AllTableOptionsTable.this.allTablePaths));
        }
    }
}

