/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataIncrement;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.IndexIncrement;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageImpl;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.InternalRowUtils;
import org.apache.paimon.utils.ObjectSerializer;
import org.apache.paimon.utils.SerializationUtils;

public class CommitMessageLegacyV2Serializer {
    private DataFileMetaLegacyV2Serializer dataFileSerializer;
    private IndexFileMetaLegacyV2Serializer indexEntrySerializer;

    public List<CommitMessage> deserializeList(DataInputView view) throws IOException {
        int length = view.readInt();
        ArrayList<CommitMessage> list = new ArrayList<CommitMessage>(length);
        for (int i = 0; i < length; ++i) {
            list.add(this.deserialize(view));
        }
        return list;
    }

    public CommitMessage deserialize(DataInputView view) throws IOException {
        if (this.dataFileSerializer == null) {
            this.dataFileSerializer = new DataFileMetaLegacyV2Serializer();
            this.indexEntrySerializer = new IndexFileMetaLegacyV2Serializer();
        }
        return new CommitMessageImpl(SerializationUtils.deserializeBinaryRow(view), view.readInt(), new DataIncrement(this.dataFileSerializer.deserializeList(view), Collections.emptyList(), this.dataFileSerializer.deserializeList(view)), new CompactIncrement(this.dataFileSerializer.deserializeList(view), this.dataFileSerializer.deserializeList(view), this.dataFileSerializer.deserializeList(view)), new IndexIncrement(this.indexEntrySerializer.deserializeList(view)));
    }

    private static RowType legacyDataFileSchema() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(0, "_FILE_NAME", SerializationUtils.newStringType(false)));
        fields.add(new DataField(1, "_FILE_SIZE", new BigIntType(false)));
        fields.add(new DataField(2, "_ROW_COUNT", new BigIntType(false)));
        fields.add(new DataField(3, "_MIN_KEY", SerializationUtils.newBytesType(false)));
        fields.add(new DataField(4, "_MAX_KEY", SerializationUtils.newBytesType(false)));
        fields.add(new DataField(5, "_KEY_STATS", SimpleStats.SCHEMA));
        fields.add(new DataField(6, "_VALUE_STATS", SimpleStats.SCHEMA));
        fields.add(new DataField(7, "_MIN_SEQUENCE_NUMBER", new BigIntType(false)));
        fields.add(new DataField(8, "_MAX_SEQUENCE_NUMBER", new BigIntType(false)));
        fields.add(new DataField(9, "_SCHEMA_ID", new BigIntType(false)));
        fields.add(new DataField(10, "_LEVEL", new IntType(false)));
        fields.add(new DataField(11, "_EXTRA_FILES", new ArrayType(false, SerializationUtils.newStringType(false))));
        fields.add(new DataField(12, "_CREATION_TIME", DataTypes.TIMESTAMP_MILLIS()));
        return new RowType(fields);
    }

    private static RowType legacyIndexFileSchema() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(0, "_INDEX_TYPE", SerializationUtils.newStringType(false)));
        fields.add(new DataField(1, "_FILE_NAME", SerializationUtils.newStringType(false)));
        fields.add(new DataField(2, "_FILE_SIZE", new BigIntType(false)));
        fields.add(new DataField(3, "_ROW_COUNT", new BigIntType(false)));
        return new RowType(fields);
    }

    private static class IndexFileMetaLegacyV2Serializer
    extends ObjectSerializer<IndexFileMeta> {
        public IndexFileMetaLegacyV2Serializer() {
            super(CommitMessageLegacyV2Serializer.legacyIndexFileSchema());
        }

        @Override
        public InternalRow toRow(IndexFileMeta record) {
            return GenericRow.of(BinaryString.fromString(record.indexType()), BinaryString.fromString(record.fileName()), record.fileSize(), record.rowCount());
        }

        @Override
        public IndexFileMeta fromRow(InternalRow row) {
            return new IndexFileMeta(row.getString(0).toString(), row.getString(1).toString(), row.getLong(2), row.getLong(3), null);
        }
    }

    private static class DataFileMetaLegacyV2Serializer
    extends ObjectSerializer<DataFileMeta> {
        private static final long serialVersionUID = 1L;

        public DataFileMetaLegacyV2Serializer() {
            super(CommitMessageLegacyV2Serializer.legacyDataFileSchema());
        }

        @Override
        public InternalRow toRow(DataFileMeta meta) {
            return GenericRow.of(BinaryString.fromString(meta.fileName()), meta.fileSize(), meta.rowCount(), SerializationUtils.serializeBinaryRow(meta.minKey()), SerializationUtils.serializeBinaryRow(meta.maxKey()), meta.keyStats().toRow(), meta.valueStats().toRow(), meta.minSequenceNumber(), meta.maxSequenceNumber(), meta.schemaId(), meta.level(), InternalRowUtils.toStringArrayData(meta.extraFiles()), meta.creationTime());
        }

        @Override
        public DataFileMeta fromRow(InternalRow row) {
            return new DataFileMeta(row.getString(0).toString(), row.getLong(1), row.getLong(2), SerializationUtils.deserializeBinaryRow(row.getBinary(3)), SerializationUtils.deserializeBinaryRow(row.getBinary(4)), SimpleStats.fromRow(row.getRow(5, 3)), SimpleStats.fromRow(row.getRow(6, 3)), row.getLong(7), row.getLong(8), row.getLong(9), row.getInt(10), InternalRowUtils.fromStringArrayData(row.getArray(11)), row.getTimestamp(12, 3), null, null, null, null, null);
        }
    }
}

