/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import org.apache.paimon.Snapshot;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.Preconditions;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class RollbackToWatermarkProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.required("watermark", DataTypes.LongType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.StringType, true, Metadata.empty())});

    private RollbackToWatermarkProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        Long watermark = args.getLong(1);
        return this.modifyPaimonTable(tableIdent, table -> {
            FileStoreTable fileStoreTable = (FileStoreTable)table;
            Snapshot snapshot = fileStoreTable.snapshotManager().earlierOrEqualWatermark(watermark);
            Preconditions.checkNotNull(snapshot, String.format("count not find snapshot earlier than %s", watermark));
            long snapshotId = snapshot.id();
            fileStoreTable.rollbackTo(snapshotId);
            InternalRow outputRow = this.newInternalRow(UTF8String.fromString((String)String.format("Success roll back to snapshot: %s .", snapshotId)));
            return new InternalRow[]{outputRow};
        });
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<RollbackToWatermarkProcedure>(){

            @Override
            public RollbackToWatermarkProcedure doBuild() {
                return new RollbackToWatermarkProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "RollbackToWatermarkProcedure";
    }
}

