/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.spark.catalog.WithPaimonCatalog;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.utils.StringUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class RepairProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("database_or_table", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.BooleanType, true, Metadata.empty())});

    protected RepairProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Catalog paimonCatalog = ((WithPaimonCatalog)this.tableCatalog()).paimonCatalog();
        String identifier = args.getString(0);
        try {
            if (StringUtils.isNullOrWhitespaceOnly(identifier)) {
                paimonCatalog.repairCatalog();
                return new InternalRow[]{this.newInternalRow(true)};
            }
            this.repairDatabasesOrTables(identifier, paimonCatalog);
        }
        catch (Exception e) {
            throw new RuntimeException("Call repair error", e);
        }
        return new InternalRow[]{this.newInternalRow(true)};
    }

    public void repairDatabasesOrTables(String databaseOrTables, Catalog paimonCatalog) throws Catalog.TableNotExistException {
        String[] databaseOrTableSplits;
        block4: for (String split : databaseOrTableSplits = databaseOrTables.split(",")) {
            String[] paths = split.split("\\.");
            switch (paths.length) {
                case 1: {
                    paimonCatalog.repairDatabase(paths[0]);
                    continue block4;
                }
                case 2: {
                    paimonCatalog.repairTable(Identifier.create(paths[0], paths[1]));
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Cannot get splits from '%s' to get database and table", split));
                }
            }
        }
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<RepairProcedure>(){

            @Override
            public RepairProcedure doBuild() {
                return new RepairProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "RepairProcedure";
    }
}

