/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.util.List;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.partition.actions.PartitionMarkDoneAction;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.ParameterUtils;
import org.apache.paimon.utils.PartitionPathUtils;
import org.apache.paimon.utils.Preconditions;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class MarkPartitionDoneProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.required("partitions", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.BooleanType, true, Metadata.empty())});

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    protected MarkPartitionDoneProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        String partitionStr = args.getString(1);
        String[] partitions = partitionStr.split(";");
        return this.modifyPaimonTable(tableIdent, table -> {
            Preconditions.checkArgument(table instanceof FileStoreTable, "Only FileStoreTable supports mark_partition_done procedure. The table type is '%s'.", table.getClass().getName());
            FileStoreTable fileStoreTable = (FileStoreTable)table;
            CoreOptions coreOptions = fileStoreTable.coreOptions();
            List<PartitionMarkDoneAction> actions = PartitionMarkDoneAction.createActions(fileStoreTable, coreOptions);
            List<String> partitionPaths = PartitionPathUtils.generatePartitionPaths(ParameterUtils.getPartitions(partitions), fileStoreTable.store().partitionType());
            MarkPartitionDoneProcedure.markDone(partitionPaths, actions);
            IOUtils.closeAllQuietly(actions);
            InternalRow outputRow = this.newInternalRow(true);
            return new InternalRow[]{outputRow};
        });
    }

    public static void markDone(List<String> partitions, List<PartitionMarkDoneAction> actions) {
        for (String partition : partitions) {
            try {
                for (PartitionMarkDoneAction action : actions) {
                    action.markDone(partition);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<MarkPartitionDoneProcedure>(){

            @Override
            public MarkPartitionDoneProcedure doBuild() {
                return new MarkPartitionDoneProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "MarkPartitionDoneProcedure";
    }
}

