/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import org.apache.paimon.operation.FileStoreCommit;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.table.FileStoreTable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class CompactManifestProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.BooleanType, true, Metadata.empty())});

    protected CompactManifestProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        FileStoreTable table = (FileStoreTable)this.loadSparkTable(tableIdent).getTable();
        try (FileStoreCommit commit = table.store().newCommit(table.coreOptions().createCommitUser()).ignoreEmptyCommit(false);){
            commit.compactManifest();
        }
        return new InternalRow[]{this.newInternalRow(true)};
    }

    @Override
    public String description() {
        return "This procedure execute compact action on paimon table.";
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<CompactManifestProcedure>(){

            @Override
            public CompactManifestProcedure doBuild() {
                return new CompactManifestProcedure(this.tableCatalog());
            }
        };
    }
}

