/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.catalog.functions;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableMap;
import org.apache.paimon.utils.Preconditions;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class PaimonFunctions {
    private static final Map<String, UnboundFunction> FUNCTIONS = ImmutableMap.of("bucket", new BucketFunction());
    private static final List<String> FUNCTION_NAMES = ImmutableList.copyOf(FUNCTIONS.keySet());

    public static List<String> names() {
        return FUNCTION_NAMES;
    }

    @Nullable
    public static UnboundFunction load(String name) {
        return FUNCTIONS.get(name);
    }

    public static class BucketFunction
    implements UnboundFunction {
        public BoundFunction bind(StructType inputType) {
            if (inputType.size() != 2) {
                throw new UnsupportedOperationException("Wrong number of inputs (expected numBuckets and value)");
            }
            StructField numBucket = inputType.fields()[0];
            final StructField bucketField = inputType.fields()[1];
            Preconditions.checkArgument(numBucket.dataType() == DataTypes.IntegerType, "bucket number field must be integer type");
            return new BoundFunction(){

                public DataType[] inputTypes() {
                    return new DataType[]{DataTypes.IntegerType, bucketField.dataType()};
                }

                public DataType resultType() {
                    return DataTypes.IntegerType;
                }

                public String name() {
                    return "bucket";
                }

                public String canonicalName() {
                    return "paimon.bucket(" + bucketField.dataType().catalogString() + ", int)";
                }
            };
        }

        public String description() {
            return this.name();
        }

        public String name() {
            return "bucket";
        }
    }
}

