/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.spark.data.SparkArrayData;
import org.apache.paimon.spark.data.SparkInternalRow;
import org.apache.paimon.spark.util.shim.TypeUtils;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.UTF8String;

public class DataConverter {
    public static Object fromPaimon(Object o, DataType type) {
        if (o == null) {
            return null;
        }
        switch (type.getTypeRoot()) {
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return DataConverter.fromPaimon((org.apache.paimon.data.Timestamp)o);
            }
            case CHAR: 
            case VARCHAR: {
                return DataConverter.fromPaimon((BinaryString)o);
            }
            case DECIMAL: {
                return DataConverter.fromPaimon((org.apache.paimon.data.Decimal)o);
            }
            case ARRAY: {
                return DataConverter.fromPaimon((InternalArray)o, (ArrayType)type);
            }
            case MAP: 
            case MULTISET: {
                return DataConverter.fromPaimon((InternalMap)o, type);
            }
            case ROW: {
                return DataConverter.fromPaimon((org.apache.paimon.data.InternalRow)o, (RowType)type);
            }
        }
        return o;
    }

    public static UTF8String fromPaimon(BinaryString string) {
        return UTF8String.fromBytes((byte[])string.toBytes());
    }

    public static Decimal fromPaimon(org.apache.paimon.data.Decimal decimal) {
        return Decimal.apply((BigDecimal)decimal.toBigDecimal());
    }

    public static InternalRow fromPaimon(org.apache.paimon.data.InternalRow row, RowType rowType) {
        return SparkInternalRow.create(rowType).replace(row);
    }

    public static long fromPaimon(org.apache.paimon.data.Timestamp timestamp) {
        if (TypeUtils.treatPaimonTimestampTypeAsSparkTimestampType()) {
            return DateTimeUtils.fromJavaTimestamp((Timestamp)timestamp.toSQLTimestamp());
        }
        return timestamp.toMicros();
    }

    public static ArrayData fromPaimon(InternalArray array, ArrayType arrayType) {
        return DataConverter.fromPaimonArrayElementType(array, arrayType.getElementType());
    }

    private static ArrayData fromPaimonArrayElementType(InternalArray array, DataType elementType) {
        return SparkArrayData.create(elementType).replace(array);
    }

    public static MapData fromPaimon(InternalMap map, DataType mapType) {
        DataType valueType;
        DataType keyType;
        if (mapType instanceof MapType) {
            keyType = ((MapType)mapType).getKeyType();
            valueType = ((MapType)mapType).getValueType();
        } else if (mapType instanceof MultisetType) {
            keyType = ((MultisetType)mapType).getElementType();
            valueType = new IntType();
        } else {
            throw new UnsupportedOperationException("Unsupported type: " + mapType);
        }
        return new ArrayBasedMapData(DataConverter.fromPaimonArrayElementType(map.keyArray(), keyType), DataConverter.fromPaimonArrayElementType(map.valueArray(), valueType));
    }
}

