/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;
import org.apache.paimon.format.parquet.reader.AbstractColumnReader;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnDescriptor;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageReadStore;
import org.apache.paimon.shade.org.apache.parquet.io.api.Binary;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveType;

public abstract class FixedLenBytesColumnReader<VECTOR extends WritableColumnVector>
extends AbstractColumnReader<VECTOR> {
    protected final int precision;

    public FixedLenBytesColumnReader(ColumnDescriptor descriptor, PageReadStore pageReadStore, int precision) throws IOException {
        super(descriptor, pageReadStore);
        this.checkTypeName(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY);
        this.precision = precision;
    }

    protected void skipDataBinary(int len) {
        this.skipDataBuffer(len);
    }

    protected Binary readDataBinary(int len) {
        ByteBuffer buffer = this.readDataBuffer(len);
        if (buffer.hasArray()) {
            return Binary.fromConstantByteArray(buffer.array(), buffer.arrayOffset() + buffer.position(), len);
        }
        byte[] bytes = new byte[len];
        buffer.get(bytes);
        return Binary.fromConstantByteArray(bytes);
    }
}

