/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.newreader;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.heap.CastedArrayColumnVector;
import org.apache.paimon.data.columnar.heap.CastedMapColumnVector;
import org.apache.paimon.data.columnar.heap.CastedRowColumnVector;
import org.apache.paimon.data.columnar.heap.HeapArrayVector;
import org.apache.paimon.data.columnar.heap.HeapMapVector;
import org.apache.paimon.data.columnar.heap.HeapRowVector;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;
import org.apache.paimon.format.parquet.newreader.ColumnarBatch;
import org.apache.paimon.format.parquet.newreader.ParquetColumnVector;
import org.apache.paimon.format.parquet.newreader.RowIndexGenerator;
import org.apache.paimon.format.parquet.newreader.VectorizedColumnReader;
import org.apache.paimon.format.parquet.reader.ParquetDecimalVector;
import org.apache.paimon.format.parquet.reader.ParquetTimestampVector;
import org.apache.paimon.format.parquet.type.ParquetField;
import org.apache.paimon.format.parquet.type.ParquetPrimitiveField;
import org.apache.paimon.fs.Path;
import org.apache.paimon.reader.FileRecordIterator;
import org.apache.paimon.reader.FileRecordReader;
import org.apache.paimon.shade.org.apache.parquet.VersionParser;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnDescriptor;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageReadStore;
import org.apache.paimon.shade.org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.paimon.shade.org.apache.parquet.schema.GroupType;
import org.apache.paimon.shade.org.apache.parquet.schema.MessageType;
import org.apache.paimon.shade.org.apache.parquet.schema.Type;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;

public class VectorizedParquetRecordReader
implements FileRecordReader<InternalRow> {
    private ParquetFileReader reader;
    private final int batchSize;
    private final long totalRowCount;
    private long totalCountLoadedSoFar = 0L;
    private long rowsReturned;
    private ParquetColumnVector[] columnVectors;
    private ColumnarBatch columnarBatch;
    private final Path filePath;
    private final MessageType fileSchema;
    private final List<ParquetField> fields;
    private final RowIndexGenerator rowIndexGenerator;
    private Set<ParquetField> missingColumns;
    private VersionParser.ParsedVersion writerVersion;

    public VectorizedParquetRecordReader(Path filePath, ParquetFileReader reader, MessageType fileSchema, List<ParquetField> fields, WritableColumnVector[] vectors, int batchSize) throws IOException {
        this.filePath = filePath;
        this.reader = reader;
        this.fileSchema = fileSchema;
        this.fields = fields;
        this.totalRowCount = reader.getFilteredRecordCount();
        this.batchSize = batchSize;
        this.rowIndexGenerator = new RowIndexGenerator();
        try {
            this.writerVersion = VersionParser.parse(reader.getFileMetaData().getCreatedBy());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkMissingColumns();
        this.initBatch(vectors);
    }

    private void initBatch(WritableColumnVector[] vectors) {
        this.columnarBatch = new ColumnarBatch(this.filePath, this.createVectorizedColumnBatch(this.fields.stream().map(ParquetField::getType).collect(Collectors.toList()), vectors));
        this.columnVectors = new ParquetColumnVector[this.fields.size()];
        for (int i = 0; i < this.columnVectors.length; ++i) {
            this.columnVectors[i] = new ParquetColumnVector(this.fields.get(i), vectors[i], this.batchSize, this.missingColumns, true);
        }
    }

    private ColumnVector[] createVectorizedColumnBatch(List<DataType> types, WritableColumnVector[] writableVectors) {
        ColumnVector[] vectors = new ColumnVector[writableVectors.length];
        block8: for (int i = 0; i < writableVectors.length; ++i) {
            switch (types.get(i).getTypeRoot()) {
                case DECIMAL: {
                    vectors[i] = new ParquetDecimalVector(writableVectors[i]);
                    continue block8;
                }
                case TIMESTAMP_WITHOUT_TIME_ZONE: 
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    vectors[i] = new ParquetTimestampVector(writableVectors[i]);
                    continue block8;
                }
                case ARRAY: {
                    vectors[i] = new CastedArrayColumnVector((HeapArrayVector)writableVectors[i], this.createVectorizedColumnBatch(Collections.singletonList(((ArrayType)types.get(i)).getElementType()), (WritableColumnVector[])Arrays.stream(writableVectors[i].getChildren()).map(WritableColumnVector.class::cast).toArray(WritableColumnVector[]::new)));
                    continue block8;
                }
                case MAP: {
                    MapType mapType = (MapType)types.get(i);
                    vectors[i] = new CastedMapColumnVector((HeapMapVector)writableVectors[i], this.createVectorizedColumnBatch(Arrays.asList(mapType.getKeyType(), mapType.getValueType()), (WritableColumnVector[])Arrays.stream(writableVectors[i].getChildren()).map(WritableColumnVector.class::cast).toArray(WritableColumnVector[]::new)));
                    continue block8;
                }
                case MULTISET: {
                    MultisetType multisetType = (MultisetType)types.get(i);
                    vectors[i] = new CastedMapColumnVector((HeapMapVector)writableVectors[i], this.createVectorizedColumnBatch(Arrays.asList(multisetType.getElementType(), multisetType.getElementType()), (WritableColumnVector[])Arrays.stream(writableVectors[i].getChildren()).map(WritableColumnVector.class::cast).toArray(WritableColumnVector[]::new)));
                    continue block8;
                }
                case ROW: {
                    RowType rowType = (RowType)types.get(i);
                    vectors[i] = new CastedRowColumnVector((HeapRowVector)writableVectors[i], this.createVectorizedColumnBatch(rowType.getFieldTypes(), (WritableColumnVector[])Arrays.stream(writableVectors[i].getChildren()).map(WritableColumnVector.class::cast).toArray(WritableColumnVector[]::new)));
                    continue block8;
                }
                default: {
                    vectors[i] = writableVectors[i];
                }
            }
        }
        return vectors;
    }

    private void checkMissingColumns() throws IOException {
        this.missingColumns = new HashSet<ParquetField>();
        for (ParquetField field : this.fields) {
            this.checkColumn(field);
        }
    }

    private void checkColumn(ParquetField field) throws IOException {
        Object[] path = field.path();
        if (this.containsPath(this.fileSchema, (String[])path, 0)) {
            ColumnDescriptor desc;
            ColumnDescriptor fd;
            if (field.isPrimitive() && !(fd = this.fileSchema.getColumnDescription((desc = ((ParquetPrimitiveField)field).getDescriptor()).getPath())).equals(desc)) {
                throw new IOException("Schema evolution not supported.");
            }
        } else {
            if (field.isRequired()) {
                throw new IOException("Required column is missing in data file. Col: " + Arrays.toString(path));
            }
            this.missingColumns.add(field);
        }
    }

    private boolean containsPath(Type parquetType, String[] path, int depth) {
        String fieldName;
        GroupType parquetGroupType;
        if (path.length == depth) {
            return true;
        }
        if (parquetType instanceof GroupType && (parquetGroupType = parquetType.asGroupType()).containsField(fieldName = path[depth])) {
            return this.containsPath(parquetGroupType.getType(fieldName), path, depth + 1);
        }
        return false;
    }

    public boolean nextBatch() throws IOException {
        if (this.rowsReturned >= this.totalRowCount) {
            return false;
        }
        for (ParquetColumnVector vector : this.columnVectors) {
            vector.reset();
        }
        this.columnarBatch.setNumRows(0);
        this.checkEndOfRowGroup();
        int num = (int)Math.min((long)this.batchSize, this.totalCountLoadedSoFar - this.rowsReturned);
        for (ParquetColumnVector cv : this.columnVectors) {
            for (ParquetColumnVector leafCv : cv.getLeaves()) {
                VectorizedColumnReader columnReader = leafCv.getColumnReader();
                if (columnReader == null) continue;
                columnReader.readBatch(num, leafCv.getColumn().getType(), leafCv.getValueVector(), leafCv.getRepetitionLevelVector(), leafCv.getDefinitionLevelVector());
            }
            cv.assemble();
        }
        this.rowsReturned += (long)num;
        this.columnarBatch.setNumRows(num);
        this.rowIndexGenerator.populateRowIndex(this.columnarBatch);
        return true;
    }

    private void checkEndOfRowGroup() throws IOException {
        if (this.rowsReturned != this.totalCountLoadedSoFar) {
            return;
        }
        PageReadStore pages = this.reader.readNextFilteredRowGroup();
        if (pages == null) {
            throw new IOException("expecting more rows but reached last block. Read " + this.rowsReturned + " out of " + this.totalRowCount);
        }
        this.rowIndexGenerator.initFromPageReadStore(pages);
        for (ParquetColumnVector cv : this.columnVectors) {
            this.initColumnReader(pages, cv);
        }
        this.totalCountLoadedSoFar += pages.getRowCount();
    }

    private void initColumnReader(PageReadStore pages, ParquetColumnVector cv) throws IOException {
        if (!this.missingColumns.contains(cv.getColumn())) {
            if (cv.getColumn().isPrimitive()) {
                ParquetField column = cv.getColumn();
                VectorizedColumnReader reader = new VectorizedColumnReader(((ParquetPrimitiveField)column).getDescriptor(), column.isRequired(), pages, this.writerVersion);
                cv.setColumnReader(reader);
            } else {
                for (ParquetColumnVector childCv : cv.getChildren()) {
                    this.initColumnReader(pages, childCv);
                }
            }
        }
    }

    @Override
    @Nullable
    public FileRecordIterator<InternalRow> readBatch() throws IOException {
        if (this.nextBatch()) {
            return this.columnarBatch.vectorizedRowIterator;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }
}

