/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.utils.JsonSerdeUtil;

@JsonIgnoreProperties(ignoreUnknown=true)
@Public
public class Snapshot {
    public static final long FIRST_SNAPSHOT_ID = 1L;
    public static final int TABLE_STORE_02_VERSION = 1;
    protected static final int CURRENT_VERSION = 3;
    protected static final String FIELD_VERSION = "version";
    protected static final String FIELD_ID = "id";
    protected static final String FIELD_SCHEMA_ID = "schemaId";
    protected static final String FIELD_BASE_MANIFEST_LIST = "baseManifestList";
    protected static final String FIELD_DELTA_MANIFEST_LIST = "deltaManifestList";
    protected static final String FIELD_CHANGELOG_MANIFEST_LIST = "changelogManifestList";
    protected static final String FIELD_INDEX_MANIFEST = "indexManifest";
    protected static final String FIELD_COMMIT_USER = "commitUser";
    protected static final String FIELD_COMMIT_IDENTIFIER = "commitIdentifier";
    protected static final String FIELD_COMMIT_KIND = "commitKind";
    protected static final String FIELD_TIME_MILLIS = "timeMillis";
    protected static final String FIELD_LOG_OFFSETS = "logOffsets";
    protected static final String FIELD_TOTAL_RECORD_COUNT = "totalRecordCount";
    protected static final String FIELD_DELTA_RECORD_COUNT = "deltaRecordCount";
    protected static final String FIELD_CHANGELOG_RECORD_COUNT = "changelogRecordCount";
    protected static final String FIELD_WATERMARK = "watermark";
    protected static final String FIELD_STATISTICS = "statistics";
    @JsonProperty(value="version")
    @Nullable
    protected final Integer version;
    @JsonProperty(value="id")
    protected final long id;
    @JsonProperty(value="schemaId")
    protected final long schemaId;
    @JsonProperty(value="baseManifestList")
    protected final String baseManifestList;
    @JsonProperty(value="deltaManifestList")
    protected final String deltaManifestList;
    @JsonProperty(value="changelogManifestList")
    @Nullable
    protected final String changelogManifestList;
    @JsonProperty(value="indexManifest")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final String indexManifest;
    @JsonProperty(value="commitUser")
    protected final String commitUser;
    @JsonProperty(value="commitIdentifier")
    protected final long commitIdentifier;
    @JsonProperty(value="commitKind")
    protected final CommitKind commitKind;
    @JsonProperty(value="timeMillis")
    protected final long timeMillis;
    @JsonProperty(value="logOffsets")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    protected final Map<Integer, Long> logOffsets;
    @JsonProperty(value="totalRecordCount")
    @Nullable
    protected final Long totalRecordCount;
    @JsonProperty(value="deltaRecordCount")
    @Nullable
    protected final Long deltaRecordCount;
    @JsonProperty(value="changelogRecordCount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    protected final Long changelogRecordCount;
    @JsonProperty(value="watermark")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    protected final Long watermark;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="statistics")
    @Nullable
    protected final String statistics;

    public Snapshot(long id, long schemaId, String baseManifestList, String deltaManifestList, @Nullable String changelogManifestList, @Nullable String indexManifest, String commitUser, long commitIdentifier, CommitKind commitKind, long timeMillis, Map<Integer, Long> logOffsets, @Nullable Long totalRecordCount, @Nullable Long deltaRecordCount, @Nullable Long changelogRecordCount, @Nullable Long watermark, @Nullable String statistics) {
        this(3, id, schemaId, baseManifestList, deltaManifestList, changelogManifestList, indexManifest, commitUser, commitIdentifier, commitKind, timeMillis, logOffsets, totalRecordCount, deltaRecordCount, changelogRecordCount, watermark, statistics);
    }

    @JsonCreator
    public Snapshot(@JsonProperty(value="version") @Nullable Integer version, @JsonProperty(value="id") long id, @JsonProperty(value="schemaId") long schemaId, @JsonProperty(value="baseManifestList") String baseManifestList, @JsonProperty(value="deltaManifestList") String deltaManifestList, @JsonProperty(value="changelogManifestList") @Nullable String changelogManifestList, @JsonProperty(value="indexManifest") @Nullable String indexManifest, @JsonProperty(value="commitUser") String commitUser, @JsonProperty(value="commitIdentifier") long commitIdentifier, @JsonProperty(value="commitKind") CommitKind commitKind, @JsonProperty(value="timeMillis") long timeMillis, @JsonProperty(value="logOffsets") @Nullable Map<Integer, Long> logOffsets, @JsonProperty(value="totalRecordCount") @Nullable Long totalRecordCount, @JsonProperty(value="deltaRecordCount") @Nullable Long deltaRecordCount, @JsonProperty(value="changelogRecordCount") @Nullable Long changelogRecordCount, @JsonProperty(value="watermark") @Nullable Long watermark, @JsonProperty(value="statistics") @Nullable String statistics) {
        this.version = version;
        this.id = id;
        this.schemaId = schemaId;
        this.baseManifestList = baseManifestList;
        this.deltaManifestList = deltaManifestList;
        this.changelogManifestList = changelogManifestList;
        this.indexManifest = indexManifest;
        this.commitUser = commitUser;
        this.commitIdentifier = commitIdentifier;
        this.commitKind = commitKind;
        this.timeMillis = timeMillis;
        this.logOffsets = logOffsets;
        this.totalRecordCount = totalRecordCount;
        this.deltaRecordCount = deltaRecordCount;
        this.changelogRecordCount = changelogRecordCount;
        this.watermark = watermark;
        this.statistics = statistics;
    }

    @JsonGetter(value="version")
    public int version() {
        return this.version == null ? 1 : this.version;
    }

    @JsonGetter(value="id")
    public long id() {
        return this.id;
    }

    @JsonGetter(value="schemaId")
    public long schemaId() {
        return this.schemaId;
    }

    @JsonGetter(value="baseManifestList")
    public String baseManifestList() {
        return this.baseManifestList;
    }

    @JsonGetter(value="deltaManifestList")
    public String deltaManifestList() {
        return this.deltaManifestList;
    }

    @JsonGetter(value="changelogManifestList")
    @Nullable
    public String changelogManifestList() {
        return this.changelogManifestList;
    }

    @JsonGetter(value="indexManifest")
    @Nullable
    public String indexManifest() {
        return this.indexManifest;
    }

    @JsonGetter(value="commitUser")
    public String commitUser() {
        return this.commitUser;
    }

    @JsonGetter(value="commitIdentifier")
    public long commitIdentifier() {
        return this.commitIdentifier;
    }

    @JsonGetter(value="commitKind")
    public CommitKind commitKind() {
        return this.commitKind;
    }

    @JsonGetter(value="timeMillis")
    public long timeMillis() {
        return this.timeMillis;
    }

    @JsonGetter(value="logOffsets")
    @Nullable
    public Map<Integer, Long> logOffsets() {
        return this.logOffsets;
    }

    @JsonGetter(value="totalRecordCount")
    @Nullable
    public Long totalRecordCount() {
        return this.totalRecordCount;
    }

    @JsonGetter(value="deltaRecordCount")
    @Nullable
    public Long deltaRecordCount() {
        return this.deltaRecordCount;
    }

    @JsonGetter(value="changelogRecordCount")
    @Nullable
    public Long changelogRecordCount() {
        return this.changelogRecordCount;
    }

    @JsonGetter(value="watermark")
    @Nullable
    public Long watermark() {
        return this.watermark;
    }

    @JsonGetter(value="statistics")
    @Nullable
    public String statistics() {
        return this.statistics;
    }

    public String toJson() {
        return JsonSerdeUtil.toJson(this);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.id, this.schemaId, this.baseManifestList, this.deltaManifestList, this.changelogManifestList, this.indexManifest, this.commitUser, this.commitIdentifier, this.commitKind, this.timeMillis, this.logOffsets, this.totalRecordCount, this.deltaRecordCount, this.changelogRecordCount, this.watermark});
    }

    public boolean equals(Object o) {
        if (!(o instanceof Snapshot)) {
            return false;
        }
        Snapshot that = (Snapshot)o;
        return Objects.equals(this.version, that.version) && this.id == that.id && this.schemaId == that.schemaId && Objects.equals(this.baseManifestList, that.baseManifestList) && Objects.equals(this.deltaManifestList, that.deltaManifestList) && Objects.equals(this.changelogManifestList, that.changelogManifestList) && Objects.equals(this.indexManifest, that.indexManifest) && Objects.equals(this.commitUser, that.commitUser) && this.commitIdentifier == that.commitIdentifier && this.commitKind == that.commitKind && this.timeMillis == that.timeMillis && Objects.equals(this.logOffsets, that.logOffsets) && Objects.equals(this.totalRecordCount, that.totalRecordCount) && Objects.equals(this.deltaRecordCount, that.deltaRecordCount) && Objects.equals(this.changelogRecordCount, that.changelogRecordCount) && Objects.equals(this.watermark, that.watermark);
    }

    public static Snapshot fromJson(String json) {
        return JsonSerdeUtil.fromJson(json, Snapshot.class);
    }

    public static Snapshot fromPath(FileIO fileIO, Path path) {
        try {
            return Snapshot.tryFromPath(fileIO, path);
        }
        catch (FileNotFoundException e) {
            String errorMessage = String.format("Snapshot file %s does not exist. It might have been expired by other jobs operating on this table. In this case, you can avoid concurrent modification issues by configuring write-only = true and use a dedicated compaction job, or configuring different expiration thresholds for different jobs.", path);
            throw new RuntimeException(errorMessage, e);
        }
    }

    public static Snapshot tryFromPath(FileIO fileIO, Path path) throws FileNotFoundException {
        try {
            return Snapshot.fromJson(fileIO.readFileUtf8(path));
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("Fails to read snapshot from path " + path, e);
        }
    }

    public static enum CommitKind {
        APPEND,
        COMPACT,
        OVERWRITE,
        ANALYZE;

    }
}

