/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.deletionvectors.DeletionVectorsMaintainer;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.FileReaderFactory;
import org.apache.paimon.io.KeyValueFileWriterFactory;
import org.apache.paimon.lookup.LookupStrategy;
import org.apache.paimon.mergetree.LookupLevels;
import org.apache.paimon.mergetree.MergeSorter;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.mergetree.compact.ChangelogMergeTreeRewriter;
import org.apache.paimon.mergetree.compact.ChangelogResult;
import org.apache.paimon.mergetree.compact.FirstRowMergeFunctionWrapper;
import org.apache.paimon.mergetree.compact.LookupChangelogMergeFunctionWrapper;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;
import org.apache.paimon.utils.FieldsComparator;
import org.apache.paimon.utils.UserDefinedSeqComparator;

public class LookupMergeTreeCompactRewriter<T>
extends ChangelogMergeTreeRewriter {
    private final LookupLevels<T> lookupLevels;
    private final MergeFunctionWrapperFactory<T> wrapperFactory;
    private final boolean noSequenceField;
    @Nullable
    private final DeletionVectorsMaintainer dvMaintainer;

    public LookupMergeTreeCompactRewriter(int maxLevel, CoreOptions.MergeEngine mergeEngine, LookupLevels<T> lookupLevels, FileReaderFactory<KeyValue> readerFactory, KeyValueFileWriterFactory writerFactory, Comparator<InternalRow> keyComparator, @Nullable FieldsComparator userDefinedSeqComparator, MergeFunctionFactory<KeyValue> mfFactory, MergeSorter mergeSorter, MergeFunctionWrapperFactory<T> wrapperFactory, boolean produceChangelog, @Nullable DeletionVectorsMaintainer dvMaintainer, CoreOptions options) {
        super(maxLevel, mergeEngine, readerFactory, writerFactory, keyComparator, userDefinedSeqComparator, mfFactory, mergeSorter, produceChangelog, dvMaintainer != null);
        this.dvMaintainer = dvMaintainer;
        this.lookupLevels = lookupLevels;
        this.wrapperFactory = wrapperFactory;
        this.noSequenceField = options.sequenceField().isEmpty();
    }

    @Override
    protected void notifyRewriteCompactBefore(List<DataFileMeta> files) {
        if (this.dvMaintainer != null) {
            files.forEach(file -> this.dvMaintainer.removeDeletionVectorOf(file.fileName()));
        }
    }

    @Override
    protected boolean rewriteChangelog(int outputLevel, boolean dropDelete, List<List<SortedRun>> sections) {
        return this.rewriteLookupChangelog(outputLevel, sections);
    }

    @Override
    protected ChangelogMergeTreeRewriter.UpgradeStrategy upgradeStrategy(int outputLevel, DataFileMeta file) {
        if (file.level() != 0) {
            return ChangelogMergeTreeRewriter.UpgradeStrategy.NO_CHANGELOG_NO_REWRITE;
        }
        if (this.dvMaintainer != null && file.deleteRowCount().map(cnt -> cnt > 0L).orElse(true).booleanValue()) {
            return ChangelogMergeTreeRewriter.UpgradeStrategy.CHANGELOG_WITH_REWRITE;
        }
        if (outputLevel == this.maxLevel) {
            return ChangelogMergeTreeRewriter.UpgradeStrategy.CHANGELOG_NO_REWRITE;
        }
        if (this.mergeEngine == CoreOptions.MergeEngine.DEDUPLICATE && this.noSequenceField) {
            return ChangelogMergeTreeRewriter.UpgradeStrategy.CHANGELOG_NO_REWRITE;
        }
        return ChangelogMergeTreeRewriter.UpgradeStrategy.CHANGELOG_WITH_REWRITE;
    }

    @Override
    protected MergeFunctionWrapper<ChangelogResult> createMergeWrapper(int outputLevel) {
        return this.wrapperFactory.create(this.mfFactory, outputLevel, this.lookupLevels, this.dvMaintainer);
    }

    @Override
    public void close() throws IOException {
        this.lookupLevels.close();
    }

    public static class FirstRowMergeFunctionWrapperFactory
    implements MergeFunctionWrapperFactory<Boolean> {
        @Override
        public MergeFunctionWrapper<ChangelogResult> create(MergeFunctionFactory<KeyValue> mfFactory, int outputLevel, LookupLevels<Boolean> lookupLevels, @Nullable DeletionVectorsMaintainer deletionVectorsMaintainer) {
            return new FirstRowMergeFunctionWrapper(mfFactory, key -> {
                try {
                    return lookupLevels.lookup((InternalRow)key, outputLevel + 1) != null;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }

    public static class LookupMergeFunctionWrapperFactory<T>
    implements MergeFunctionWrapperFactory<T> {
        @Nullable
        private final RecordEqualiser valueEqualiser;
        private final LookupStrategy lookupStrategy;
        @Nullable
        private final UserDefinedSeqComparator userDefinedSeqComparator;

        public LookupMergeFunctionWrapperFactory(@Nullable RecordEqualiser valueEqualiser, LookupStrategy lookupStrategy, @Nullable UserDefinedSeqComparator userDefinedSeqComparator) {
            this.valueEqualiser = valueEqualiser;
            this.lookupStrategy = lookupStrategy;
            this.userDefinedSeqComparator = userDefinedSeqComparator;
        }

        @Override
        public MergeFunctionWrapper<ChangelogResult> create(MergeFunctionFactory<KeyValue> mfFactory, int outputLevel, LookupLevels<T> lookupLevels, @Nullable DeletionVectorsMaintainer deletionVectorsMaintainer) {
            return new LookupChangelogMergeFunctionWrapper<Object>(mfFactory, key -> {
                try {
                    return lookupLevels.lookup((InternalRow)key, outputLevel + 1);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }, this.valueEqualiser, this.lookupStrategy, deletionVectorsMaintainer, this.userDefinedSeqComparator);
        }
    }

    public static interface MergeFunctionWrapperFactory<T> {
        public MergeFunctionWrapper<ChangelogResult> create(MergeFunctionFactory<KeyValue> var1, int var2, LookupLevels<T> var3, @Nullable DeletionVectorsMaintainer var4);
    }
}

