/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.mapred;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.paimon.hive.RowDataContainer;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.apache.paimon.table.sink.BatchTableWrite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PaimonRecordWriter
implements FileSinkOperator.RecordWriter,
RecordWriter<NullWritable, RowDataContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(PaimonRecordWriter.class);
    private static final Map<TaskAttemptID, Map<String, PaimonRecordWriter>> writers = Maps.newConcurrentMap();
    private BatchTableWrite batchTableWrite;

    public PaimonRecordWriter(BatchTableWrite batchTableWrite, TaskAttemptID taskAttemptID, String tableName) {
        this.batchTableWrite = batchTableWrite;
        writers.putIfAbsent(taskAttemptID, Maps.newConcurrentMap());
        writers.get(taskAttemptID).put(tableName, this);
    }

    static Map<String, PaimonRecordWriter> removeWriters(TaskAttemptID taskAttemptID) {
        return writers.remove(taskAttemptID);
    }

    static Map<String, PaimonRecordWriter> getWriters(TaskAttemptID taskAttemptID) {
        return writers.get(taskAttemptID);
    }

    public void write(Writable row) throws IOException {
        try {
            this.batchTableWrite.write(((RowDataContainer)row).get());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void write(NullWritable key, RowDataContainer value) throws IOException {
        this.write(value);
    }

    public void close(boolean abort) {
        if (abort) {
            try {
                this.batchTableWrite.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void close(Reporter reporter) {
        this.close(false);
    }

    public BatchTableWrite batchTableWrite() {
        return this.batchTableWrite;
    }
}

